import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ClouddeployTargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#annotations ClouddeployTarget#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Optional. Description of the `Target`. Max length is 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#description ClouddeployTarget#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#id ClouddeployTarget#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#labels ClouddeployTarget#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#location ClouddeployTarget#location}
    */
    readonly location: string;
    /**
    * Name of the `Target`. Format is [a-z][a-z0-9\-]{0,62}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#name ClouddeployTarget#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#project ClouddeployTarget#project}
    */
    readonly project?: string;
    /**
    * Optional. Whether or not the `Target` requires approval.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#require_approval ClouddeployTarget#require_approval}
    */
    readonly requireApproval?: boolean | cdktf.IResolvable;
    /**
    * anthos_cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#anthos_cluster ClouddeployTarget#anthos_cluster}
    */
    readonly anthosCluster?: ClouddeployTargetAnthosCluster;
    /**
    * execution_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#execution_configs ClouddeployTarget#execution_configs}
    */
    readonly executionConfigs?: ClouddeployTargetExecutionConfigs[] | cdktf.IResolvable;
    /**
    * gke block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#gke ClouddeployTarget#gke}
    */
    readonly gke?: ClouddeployTargetGke;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#timeouts ClouddeployTarget#timeouts}
    */
    readonly timeouts?: ClouddeployTargetTimeouts;
}
export interface ClouddeployTargetAnthosCluster {
    /**
    * Membership of the GKE Hub-registered cluster to which to apply the Skaffold configuration. Format is `projects/{project}/locations/{location}/memberships/{membership_name}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#membership ClouddeployTarget#membership}
    */
    readonly membership?: string;
}
export declare function clouddeployTargetAnthosClusterToTerraform(struct?: ClouddeployTargetAnthosClusterOutputReference | ClouddeployTargetAnthosCluster): any;
export declare class ClouddeployTargetAnthosClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClouddeployTargetAnthosCluster | undefined;
    set internalValue(value: ClouddeployTargetAnthosCluster | undefined);
    private _membership?;
    get membership(): string;
    set membership(value: string);
    resetMembership(): void;
    get membershipInput(): string | undefined;
}
export interface ClouddeployTargetExecutionConfigs {
    /**
    * Optional. Cloud Storage location in which to store execution outputs. This can either be a bucket ("gs://my-bucket") or a path within a bucket ("gs://my-bucket/my-dir"). If unspecified, a default bucket located in the same region will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#artifact_storage ClouddeployTarget#artifact_storage}
    */
    readonly artifactStorage?: string;
    /**
    * Optional. Execution timeout for a Cloud Build Execution. This must be between 10m and 24h in seconds format. If unspecified, a default timeout of 1h is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#execution_timeout ClouddeployTarget#execution_timeout}
    */
    readonly executionTimeout?: string;
    /**
    * Optional. Google service account to use for execution. If unspecified, the project execution service account (-compute@developer.gserviceaccount.com) is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#service_account ClouddeployTarget#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Required. Usages when this configuration should be applied.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#usages ClouddeployTarget#usages}
    */
    readonly usages: string[];
    /**
    * Optional. The resource name of the `WorkerPool`, with the format `projects/{project}/locations/{location}/workerPools/{worker_pool}`. If this optional field is unspecified, the default Cloud Build pool will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#worker_pool ClouddeployTarget#worker_pool}
    */
    readonly workerPool?: string;
}
export declare function clouddeployTargetExecutionConfigsToTerraform(struct?: ClouddeployTargetExecutionConfigs | cdktf.IResolvable): any;
export declare class ClouddeployTargetExecutionConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClouddeployTargetExecutionConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: ClouddeployTargetExecutionConfigs | cdktf.IResolvable | undefined);
    private _artifactStorage?;
    get artifactStorage(): string;
    set artifactStorage(value: string);
    resetArtifactStorage(): void;
    get artifactStorageInput(): string | undefined;
    private _executionTimeout?;
    get executionTimeout(): string;
    set executionTimeout(value: string);
    resetExecutionTimeout(): void;
    get executionTimeoutInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _usages?;
    get usages(): string[];
    set usages(value: string[]);
    get usagesInput(): string[] | undefined;
    private _workerPool?;
    get workerPool(): string;
    set workerPool(value: string);
    resetWorkerPool(): void;
    get workerPoolInput(): string | undefined;
}
export declare class ClouddeployTargetExecutionConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ClouddeployTargetExecutionConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClouddeployTargetExecutionConfigsOutputReference;
}
export interface ClouddeployTargetGke {
    /**
    * Information specifying a GKE Cluster. Format is `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#cluster ClouddeployTarget#cluster}
    */
    readonly cluster?: string;
    /**
    * Optional. If true, `cluster` is accessed using the private IP address of the control plane endpoint. Otherwise, the default IP address of the control plane endpoint is used. The default IP address is the private IP address for clusters with private control-plane endpoints and the public IP address otherwise. Only specify this option when `cluster` is a [private GKE cluster](https://cloud.google.com/kubernetes-engine/docs/concepts/private-cluster-concept).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#internal_ip ClouddeployTarget#internal_ip}
    */
    readonly internalIp?: boolean | cdktf.IResolvable;
}
export declare function clouddeployTargetGkeToTerraform(struct?: ClouddeployTargetGkeOutputReference | ClouddeployTargetGke): any;
export declare class ClouddeployTargetGkeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClouddeployTargetGke | undefined;
    set internalValue(value: ClouddeployTargetGke | undefined);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    resetCluster(): void;
    get clusterInput(): string | undefined;
    private _internalIp?;
    get internalIp(): boolean | cdktf.IResolvable;
    set internalIp(value: boolean | cdktf.IResolvable);
    resetInternalIp(): void;
    get internalIpInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ClouddeployTargetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#create ClouddeployTarget#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#delete ClouddeployTarget#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target#update ClouddeployTarget#update}
    */
    readonly update?: string;
}
export declare function clouddeployTargetTimeoutsToTerraform(struct?: ClouddeployTargetTimeoutsOutputReference | ClouddeployTargetTimeouts | cdktf.IResolvable): any;
export declare class ClouddeployTargetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClouddeployTargetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ClouddeployTargetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target google_clouddeploy_target}
*/
export declare class ClouddeployTarget extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_clouddeploy_target";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_target google_clouddeploy_target} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ClouddeployTargetConfig
    */
    constructor(scope: Construct, id: string, config: ClouddeployTargetConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _requireApproval?;
    get requireApproval(): boolean | cdktf.IResolvable;
    set requireApproval(value: boolean | cdktf.IResolvable);
    resetRequireApproval(): void;
    get requireApprovalInput(): boolean | cdktf.IResolvable | undefined;
    get targetId(): string;
    get uid(): string;
    get updateTime(): string;
    private _anthosCluster;
    get anthosCluster(): ClouddeployTargetAnthosClusterOutputReference;
    putAnthosCluster(value: ClouddeployTargetAnthosCluster): void;
    resetAnthosCluster(): void;
    get anthosClusterInput(): ClouddeployTargetAnthosCluster | undefined;
    private _executionConfigs;
    get executionConfigs(): ClouddeployTargetExecutionConfigsList;
    putExecutionConfigs(value: ClouddeployTargetExecutionConfigs[] | cdktf.IResolvable): void;
    resetExecutionConfigs(): void;
    get executionConfigsInput(): cdktf.IResolvable | ClouddeployTargetExecutionConfigs[] | undefined;
    private _gke;
    get gke(): ClouddeployTargetGkeOutputReference;
    putGke(value: ClouddeployTargetGke): void;
    resetGke(): void;
    get gkeInput(): ClouddeployTargetGke | undefined;
    private _timeouts;
    get timeouts(): ClouddeployTargetTimeoutsOutputReference;
    putTimeouts(value: ClouddeployTargetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ClouddeployTargetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
