import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComposerEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#id ComposerEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels for this environment. The labels map can contain no more than 64 entries. Entries of the labels map are UTF8 strings that comply with the following restrictions: Label keys must be between 1 and 63 characters long and must conform to the following regular expression: [a-z]([-a-z0-9]*[a-z0-9])?. Label values must be between 0 and 63 characters long and must conform to the regular expression ([a-z]([-a-z0-9]*[a-z0-9])?)?. No more than 64 labels can be associated with a given environment. Both keys and values must be <= 128 bytes in size.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#labels ComposerEnvironment#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#name ComposerEnvironment#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#project ComposerEnvironment#project}
    */
    readonly project?: string;
    /**
    * The location or Compute Engine region for the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#region ComposerEnvironment#region}
    */
    readonly region?: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#config ComposerEnvironment#config}
    */
    readonly config?: ComposerEnvironmentConfigA;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#timeouts ComposerEnvironment#timeouts}
    */
    readonly timeouts?: ComposerEnvironmentTimeouts;
}
export interface ComposerEnvironmentConfigDatabaseConfig {
    /**
    * Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#machine_type ComposerEnvironment#machine_type}
    */
    readonly machineType: string;
}
export declare function composerEnvironmentConfigDatabaseConfigToTerraform(struct?: ComposerEnvironmentConfigDatabaseConfigOutputReference | ComposerEnvironmentConfigDatabaseConfig): any;
export declare class ComposerEnvironmentConfigDatabaseConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigDatabaseConfig | undefined;
    set internalValue(value: ComposerEnvironmentConfigDatabaseConfig | undefined);
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
}
export interface ComposerEnvironmentConfigEncryptionConfig {
    /**
    * Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#kms_key_name ComposerEnvironment#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function composerEnvironmentConfigEncryptionConfigToTerraform(struct?: ComposerEnvironmentConfigEncryptionConfigOutputReference | ComposerEnvironmentConfigEncryptionConfig): any;
export declare class ComposerEnvironmentConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigEncryptionConfig | undefined;
    set internalValue(value: ComposerEnvironmentConfigEncryptionConfig | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface ComposerEnvironmentConfigMaintenanceWindow {
    /**
    * Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end-time must be in the future, relative to 'start_time'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#end_time ComposerEnvironment#end_time}
    */
    readonly endTime: string;
    /**
    * Maintenance window recurrence. Format is a subset of RFC-5545 (https://tools.ietf.org/html/rfc5545) 'RRULE'. The only allowed values for 'FREQ' field are 'FREQ=DAILY' and 'FREQ=WEEKLY;BYDAY=...'. Example values: 'FREQ=WEEKLY;BYDAY=TU,WE', 'FREQ=DAILY'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#recurrence ComposerEnvironment#recurrence}
    */
    readonly recurrence: string;
    /**
    * Start time of the first recurrence of the maintenance window.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#start_time ComposerEnvironment#start_time}
    */
    readonly startTime: string;
}
export declare function composerEnvironmentConfigMaintenanceWindowToTerraform(struct?: ComposerEnvironmentConfigMaintenanceWindowOutputReference | ComposerEnvironmentConfigMaintenanceWindow): any;
export declare class ComposerEnvironmentConfigMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigMaintenanceWindow | undefined;
    set internalValue(value: ComposerEnvironmentConfigMaintenanceWindow | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    get endTimeInput(): string | undefined;
    private _recurrence?;
    get recurrence(): string;
    set recurrence(value: string);
    get recurrenceInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface ComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks {
    /**
    * cidr_block must be specified in CIDR notation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cidr_block ComposerEnvironment#cidr_block}
    */
    readonly cidrBlock: string;
    /**
    * display_name is a field for users to identify CIDR blocks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#display_name ComposerEnvironment#display_name}
    */
    readonly displayName?: string;
}
export declare function composerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocksToTerraform(struct?: ComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable): any;
export declare class ComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable | undefined;
    set internalValue(value: ComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks | cdktf.IResolvable | undefined);
    private _cidrBlock?;
    get cidrBlock(): string;
    set cidrBlock(value: string);
    get cidrBlockInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
}
export declare class ComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocksOutputReference;
}
export interface ComposerEnvironmentConfigMasterAuthorizedNetworksConfig {
    /**
    * Whether or not master authorized networks is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#enabled ComposerEnvironment#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * cidr_blocks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cidr_blocks ComposerEnvironment#cidr_blocks}
    */
    readonly cidrBlocks?: ComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks[] | cdktf.IResolvable;
}
export declare function composerEnvironmentConfigMasterAuthorizedNetworksConfigToTerraform(struct?: ComposerEnvironmentConfigMasterAuthorizedNetworksConfigOutputReference | ComposerEnvironmentConfigMasterAuthorizedNetworksConfig): any;
export declare class ComposerEnvironmentConfigMasterAuthorizedNetworksConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigMasterAuthorizedNetworksConfig | undefined;
    set internalValue(value: ComposerEnvironmentConfigMasterAuthorizedNetworksConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cidrBlocks;
    get cidrBlocks(): ComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocksList;
    putCidrBlocks(value: ComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks[] | cdktf.IResolvable): void;
    resetCidrBlocks(): void;
    get cidrBlocksInput(): cdktf.IResolvable | ComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks[] | undefined;
}
export interface ComposerEnvironmentConfigNodeConfigIpAllocationPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cluster_ipv4_cidr_block ComposerEnvironment#cluster_ipv4_cidr_block}
    */
    readonly clusterIpv4CidrBlock?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cluster_secondary_range_name ComposerEnvironment#cluster_secondary_range_name}
    */
    readonly clusterSecondaryRangeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#services_ipv4_cidr_block ComposerEnvironment#services_ipv4_cidr_block}
    */
    readonly servicesIpv4CidrBlock?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#services_secondary_range_name ComposerEnvironment#services_secondary_range_name}
    */
    readonly servicesSecondaryRangeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#use_ip_aliases ComposerEnvironment#use_ip_aliases}
    */
    readonly useIpAliases?: boolean | cdktf.IResolvable;
}
export declare function composerEnvironmentConfigNodeConfigIpAllocationPolicyToTerraform(struct?: ComposerEnvironmentConfigNodeConfigIpAllocationPolicy | cdktf.IResolvable): any;
export declare class ComposerEnvironmentConfigNodeConfigIpAllocationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComposerEnvironmentConfigNodeConfigIpAllocationPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: ComposerEnvironmentConfigNodeConfigIpAllocationPolicy | cdktf.IResolvable | undefined);
    private _clusterIpv4CidrBlock?;
    get clusterIpv4CidrBlock(): string;
    set clusterIpv4CidrBlock(value: string);
    resetClusterIpv4CidrBlock(): void;
    get clusterIpv4CidrBlockInput(): string | undefined;
    private _clusterSecondaryRangeName?;
    get clusterSecondaryRangeName(): string;
    set clusterSecondaryRangeName(value: string);
    resetClusterSecondaryRangeName(): void;
    get clusterSecondaryRangeNameInput(): string | undefined;
    private _servicesIpv4CidrBlock?;
    get servicesIpv4CidrBlock(): string;
    set servicesIpv4CidrBlock(value: string);
    resetServicesIpv4CidrBlock(): void;
    get servicesIpv4CidrBlockInput(): string | undefined;
    private _servicesSecondaryRangeName?;
    get servicesSecondaryRangeName(): string;
    set servicesSecondaryRangeName(value: string);
    resetServicesSecondaryRangeName(): void;
    get servicesSecondaryRangeNameInput(): string | undefined;
    private _useIpAliases?;
    get useIpAliases(): boolean | cdktf.IResolvable;
    set useIpAliases(value: boolean | cdktf.IResolvable);
    resetUseIpAliases(): void;
    get useIpAliasesInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComposerEnvironmentConfigNodeConfigIpAllocationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComposerEnvironmentConfigNodeConfigIpAllocationPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComposerEnvironmentConfigNodeConfigIpAllocationPolicyOutputReference;
}
export interface ComposerEnvironmentConfigNodeConfig {
    /**
    * The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#disk_size_gb ComposerEnvironment#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Deploys 'ip-masq-agent' daemon set in the GKE cluster and defines nonMasqueradeCIDRs equals to pod IP range so IP masquerading is used for all destination addresses, except between pods traffic. See: https://cloud.google.com/kubernetes-engine/docs/how-to/ip-masquerade-agent
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#enable_ip_masq_agent ComposerEnvironment#enable_ip_masq_agent}
    */
    readonly enableIpMasqAgent?: boolean | cdktf.IResolvable;
    /**
    * Configuration for controlling how IPs are allocated in the GKE cluster. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#ip_allocation_policy ComposerEnvironment#ip_allocation_policy}
    */
    readonly ipAllocationPolicy?: ComposerEnvironmentConfigNodeConfigIpAllocationPolicy[] | cdktf.IResolvable;
    /**
    * The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#machine_type ComposerEnvironment#machine_type}
    */
    readonly machineType?: string;
    /**
    * The Compute Engine machine type used for cluster instances, specified as a name or relative resource name. For example: "projects/{project}/zones/{zone}/machineTypes/{machineType}". Must belong to the enclosing environment's project and region/zone. The network must belong to the environment's project. If unspecified, the "default" network ID in the environment's project is used. If a Custom Subnet Network is provided, subnetwork must also be provided.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#network ComposerEnvironment#network}
    */
    readonly network?: string;
    /**
    * The set of Google API scopes to be made available on all node VMs. Cannot be updated. If empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#oauth_scopes ComposerEnvironment#oauth_scopes}
    */
    readonly oauthScopes?: string[];
    /**
    * The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated. If given, note that the service account must have roles/composer.worker for any GCP resources created under the Cloud Composer Environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#service_account ComposerEnvironment#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * The Compute Engine subnetwork to be used for machine communications, , specified as a self-link, relative resource name (e.g. "projects/{project}/regions/{region}/subnetworks/{subnetwork}"), or by name. If subnetwork is provided, network must also be provided and the subnetwork must belong to the enclosing environment's project and region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#subnetwork ComposerEnvironment#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with RFC1035. Cannot be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#tags ComposerEnvironment#tags}
    */
    readonly tags?: string[];
    /**
    * The Compute Engine zone in which to deploy the VMs running the Apache Airflow software, specified as the zone name or relative resource name (e.g. "projects/{project}/zones/{zone}"). Must belong to the enclosing environment's project and region. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#zone ComposerEnvironment#zone}
    */
    readonly zone?: string;
}
export declare function composerEnvironmentConfigNodeConfigToTerraform(struct?: ComposerEnvironmentConfigNodeConfigOutputReference | ComposerEnvironmentConfigNodeConfig): any;
export declare class ComposerEnvironmentConfigNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigNodeConfig | undefined;
    set internalValue(value: ComposerEnvironmentConfigNodeConfig | undefined);
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _enableIpMasqAgent?;
    get enableIpMasqAgent(): boolean | cdktf.IResolvable;
    set enableIpMasqAgent(value: boolean | cdktf.IResolvable);
    resetEnableIpMasqAgent(): void;
    get enableIpMasqAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _ipAllocationPolicy;
    get ipAllocationPolicy(): ComposerEnvironmentConfigNodeConfigIpAllocationPolicyList;
    putIpAllocationPolicy(value: ComposerEnvironmentConfigNodeConfigIpAllocationPolicy[] | cdktf.IResolvable): void;
    resetIpAllocationPolicy(): void;
    get ipAllocationPolicyInput(): cdktf.IResolvable | ComposerEnvironmentConfigNodeConfigIpAllocationPolicy[] | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
}
export interface ComposerEnvironmentConfigPrivateEnvironmentConfig {
    /**
    * When specified, the environment will use Private Service Connect instead of VPC peerings to connect to Cloud SQL in the Tenant Project, and the PSC endpoint in the Customer Project will use an IP address from this subnetwork. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cloud_composer_connection_subnetwork ComposerEnvironment#cloud_composer_connection_subnetwork}
    */
    readonly cloudComposerConnectionSubnetwork?: string;
    /**
    * The CIDR block from which IP range for Cloud Composer Network in tenant project will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cloud_composer_network_ipv4_cidr_block ComposerEnvironment#cloud_composer_network_ipv4_cidr_block}
    */
    readonly cloudComposerNetworkIpv4CidrBlock?: string;
    /**
    * The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from web_server_ipv4_cidr_block.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cloud_sql_ipv4_cidr_block ComposerEnvironment#cloud_sql_ipv4_cidr_block}
    */
    readonly cloudSqlIpv4CidrBlock?: string;
    /**
    * If true, access to the public endpoint of the GKE cluster is denied. If this field is set to true, ip_allocation_policy.use_ip_aliases must be set to true for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#enable_private_endpoint ComposerEnvironment#enable_private_endpoint}
    */
    readonly enablePrivateEndpoint?: boolean | cdktf.IResolvable;
    /**
    * When enabled, IPs from public (non-RFC1918) ranges can be used for ip_allocation_policy.cluster_ipv4_cidr_block and ip_allocation_policy.service_ipv4_cidr_block.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#enable_privately_used_public_ips ComposerEnvironment#enable_privately_used_public_ips}
    */
    readonly enablePrivatelyUsedPublicIps?: boolean | cdktf.IResolvable;
    /**
    * The IP range in CIDR notation to use for the hosted master network. This range is used for assigning internal IP addresses to the cluster master or set of masters and to the internal load balancer virtual IP. This range must not overlap with any other ranges in use within the cluster's network. If left blank, the default value of '172.16.0.0/28' is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#master_ipv4_cidr_block ComposerEnvironment#master_ipv4_cidr_block}
    */
    readonly masterIpv4CidrBlock?: string;
    /**
    * The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#web_server_ipv4_cidr_block ComposerEnvironment#web_server_ipv4_cidr_block}
    */
    readonly webServerIpv4CidrBlock?: string;
}
export declare function composerEnvironmentConfigPrivateEnvironmentConfigToTerraform(struct?: ComposerEnvironmentConfigPrivateEnvironmentConfigOutputReference | ComposerEnvironmentConfigPrivateEnvironmentConfig): any;
export declare class ComposerEnvironmentConfigPrivateEnvironmentConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigPrivateEnvironmentConfig | undefined;
    set internalValue(value: ComposerEnvironmentConfigPrivateEnvironmentConfig | undefined);
    private _cloudComposerConnectionSubnetwork?;
    get cloudComposerConnectionSubnetwork(): string;
    set cloudComposerConnectionSubnetwork(value: string);
    resetCloudComposerConnectionSubnetwork(): void;
    get cloudComposerConnectionSubnetworkInput(): string | undefined;
    private _cloudComposerNetworkIpv4CidrBlock?;
    get cloudComposerNetworkIpv4CidrBlock(): string;
    set cloudComposerNetworkIpv4CidrBlock(value: string);
    resetCloudComposerNetworkIpv4CidrBlock(): void;
    get cloudComposerNetworkIpv4CidrBlockInput(): string | undefined;
    private _cloudSqlIpv4CidrBlock?;
    get cloudSqlIpv4CidrBlock(): string;
    set cloudSqlIpv4CidrBlock(value: string);
    resetCloudSqlIpv4CidrBlock(): void;
    get cloudSqlIpv4CidrBlockInput(): string | undefined;
    private _enablePrivateEndpoint?;
    get enablePrivateEndpoint(): boolean | cdktf.IResolvable;
    set enablePrivateEndpoint(value: boolean | cdktf.IResolvable);
    resetEnablePrivateEndpoint(): void;
    get enablePrivateEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePrivatelyUsedPublicIps?;
    get enablePrivatelyUsedPublicIps(): boolean | cdktf.IResolvable;
    set enablePrivatelyUsedPublicIps(value: boolean | cdktf.IResolvable);
    resetEnablePrivatelyUsedPublicIps(): void;
    get enablePrivatelyUsedPublicIpsInput(): boolean | cdktf.IResolvable | undefined;
    private _masterIpv4CidrBlock?;
    get masterIpv4CidrBlock(): string;
    set masterIpv4CidrBlock(value: string);
    resetMasterIpv4CidrBlock(): void;
    get masterIpv4CidrBlockInput(): string | undefined;
    private _webServerIpv4CidrBlock?;
    get webServerIpv4CidrBlock(): string;
    set webServerIpv4CidrBlock(value: string);
    resetWebServerIpv4CidrBlock(): void;
    get webServerIpv4CidrBlockInput(): string | undefined;
}
export interface ComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfig {
    /**
    * When enabled, Cloud Composer periodically saves snapshots of your environment to a Cloud Storage bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#enabled ComposerEnvironment#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Snapshot schedule, in the unix-cron format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#snapshot_creation_schedule ComposerEnvironment#snapshot_creation_schedule}
    */
    readonly snapshotCreationSchedule?: string;
    /**
    * the URI of a bucket folder where to save the snapshot.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#snapshot_location ComposerEnvironment#snapshot_location}
    */
    readonly snapshotLocation?: string;
    /**
    * A time zone for the schedule. This value is a time offset and does not take into account daylight saving time changes. Valid values are from UTC-12 to UTC+12. Examples: UTC, UTC-01, UTC+03.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#time_zone ComposerEnvironment#time_zone}
    */
    readonly timeZone?: string;
}
export declare function composerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigToTerraform(struct?: ComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigOutputReference | ComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfig): any;
export declare class ComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfig | undefined;
    set internalValue(value: ComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _snapshotCreationSchedule?;
    get snapshotCreationSchedule(): string;
    set snapshotCreationSchedule(value: string);
    resetSnapshotCreationSchedule(): void;
    get snapshotCreationScheduleInput(): string | undefined;
    private _snapshotLocation?;
    get snapshotLocation(): string;
    set snapshotLocation(value: string);
    resetSnapshotLocation(): void;
    get snapshotLocationInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
}
export interface ComposerEnvironmentConfigRecoveryConfig {
    /**
    * scheduled_snapshots_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#scheduled_snapshots_config ComposerEnvironment#scheduled_snapshots_config}
    */
    readonly scheduledSnapshotsConfig?: ComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfig;
}
export declare function composerEnvironmentConfigRecoveryConfigToTerraform(struct?: ComposerEnvironmentConfigRecoveryConfigOutputReference | ComposerEnvironmentConfigRecoveryConfig): any;
export declare class ComposerEnvironmentConfigRecoveryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigRecoveryConfig | undefined;
    set internalValue(value: ComposerEnvironmentConfigRecoveryConfig | undefined);
    private _scheduledSnapshotsConfig;
    get scheduledSnapshotsConfig(): ComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigOutputReference;
    putScheduledSnapshotsConfig(value: ComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfig): void;
    resetScheduledSnapshotsConfig(): void;
    get scheduledSnapshotsConfigInput(): ComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfig | undefined;
}
export interface ComposerEnvironmentConfigSoftwareConfig {
    /**
    * Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and cannot contain "=" or ";". Section and property names cannot contain characters: "." Apache Airflow configuration property names must be written in snake_case. Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are blacklisted, and cannot be overridden.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#airflow_config_overrides ComposerEnvironment#airflow_config_overrides}
    */
    readonly airflowConfigOverrides?: {
        [key: string]: string;
    };
    /**
    * Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression [a-zA-Z_][a-zA-Z0-9_]*. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+), and they cannot match any of the following reserved names: AIRFLOW_HOME C_FORCE_ROOT CONTAINER_NAME DAGS_FOLDER GCP_PROJECT GCS_BUCKET GKE_CLUSTER_NAME SQL_DATABASE SQL_INSTANCE SQL_PASSWORD SQL_PROJECT SQL_REGION SQL_USER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#env_variables ComposerEnvironment#env_variables}
    */
    readonly envVariables?: {
        [key: string]: string;
    };
    /**
    * The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression composer-([0-9]+(\.[0-9]+\.[0-9]+(-preview\.[0-9]+)?)?|latest)-airflow-([0-9]+(\.[0-9]+(\.[0-9]+)?)?). The Cloud Composer portion of the image version is a full semantic version, or an alias in the form of major version number or 'latest'. The Apache Airflow portion of the image version is a full semantic version that points to one of the supported Apache Airflow versions, or an alias in the form of only major or major.minor versions specified. See documentation for more details and version list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#image_version ComposerEnvironment#image_version}
    */
    readonly imageVersion?: string;
    /**
    * Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name (e.g. "numpy"). Values are the lowercase extras and version specifier (e.g. "==1.12.0", "[devel,gcp_api]", "[devel]>=1.8.2, <1.9.2"). To specify a package without pinning it to a version specifier, use the empty string as the value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#pypi_packages ComposerEnvironment#pypi_packages}
    */
    readonly pypiPackages?: {
        [key: string]: string;
    };
    /**
    * The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*. Environments in newer versions always use Python major version 3.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#python_version ComposerEnvironment#python_version}
    */
    readonly pythonVersion?: string;
    /**
    * The number of schedulers for Airflow. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-2.*.*.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#scheduler_count ComposerEnvironment#scheduler_count}
    */
    readonly schedulerCount?: number;
}
export declare function composerEnvironmentConfigSoftwareConfigToTerraform(struct?: ComposerEnvironmentConfigSoftwareConfigOutputReference | ComposerEnvironmentConfigSoftwareConfig): any;
export declare class ComposerEnvironmentConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigSoftwareConfig | undefined;
    set internalValue(value: ComposerEnvironmentConfigSoftwareConfig | undefined);
    private _airflowConfigOverrides?;
    get airflowConfigOverrides(): {
        [key: string]: string;
    };
    set airflowConfigOverrides(value: {
        [key: string]: string;
    });
    resetAirflowConfigOverrides(): void;
    get airflowConfigOverridesInput(): {
        [key: string]: string;
    } | undefined;
    private _envVariables?;
    get envVariables(): {
        [key: string]: string;
    };
    set envVariables(value: {
        [key: string]: string;
    });
    resetEnvVariables(): void;
    get envVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _imageVersion?;
    get imageVersion(): string;
    set imageVersion(value: string);
    resetImageVersion(): void;
    get imageVersionInput(): string | undefined;
    private _pypiPackages?;
    get pypiPackages(): {
        [key: string]: string;
    };
    set pypiPackages(value: {
        [key: string]: string;
    });
    resetPypiPackages(): void;
    get pypiPackagesInput(): {
        [key: string]: string;
    } | undefined;
    private _pythonVersion?;
    get pythonVersion(): string;
    set pythonVersion(value: string);
    resetPythonVersion(): void;
    get pythonVersionInput(): string | undefined;
    private _schedulerCount?;
    get schedulerCount(): number;
    set schedulerCount(value: number);
    resetSchedulerCount(): void;
    get schedulerCountInput(): number | undefined;
}
export interface ComposerEnvironmentConfigWebServerConfig {
    /**
    * Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#machine_type ComposerEnvironment#machine_type}
    */
    readonly machineType: string;
}
export declare function composerEnvironmentConfigWebServerConfigToTerraform(struct?: ComposerEnvironmentConfigWebServerConfigOutputReference | ComposerEnvironmentConfigWebServerConfig): any;
export declare class ComposerEnvironmentConfigWebServerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigWebServerConfig | undefined;
    set internalValue(value: ComposerEnvironmentConfigWebServerConfig | undefined);
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
}
export interface ComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange {
    /**
    * A description of this ip range.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#description ComposerEnvironment#description}
    */
    readonly description?: string;
    /**
    * IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: 192.168.1.1 or 192.168.0.0/16 or 2001:db8::/32 or 2001:0db8:0000:0042:0000:8a2e:0370:7334. IP range prefixes should be properly truncated. For example, 1.2.3.4/24 should be truncated to 1.2.3.0/24. Similarly, for IPv6, 2001:db8::1/32 should be truncated to 2001:db8::/32.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#value ComposerEnvironment#value}
    */
    readonly value: string;
}
export declare function composerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeToTerraform(struct?: ComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange | cdktf.IResolvable): any;
export declare class ComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange | cdktf.IResolvable | undefined;
    set internalValue(value: ComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeOutputReference;
}
export interface ComposerEnvironmentConfigWebServerNetworkAccessControl {
    /**
    * allowed_ip_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#allowed_ip_range ComposerEnvironment#allowed_ip_range}
    */
    readonly allowedIpRange?: ComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange[] | cdktf.IResolvable;
}
export declare function composerEnvironmentConfigWebServerNetworkAccessControlToTerraform(struct?: ComposerEnvironmentConfigWebServerNetworkAccessControlOutputReference | ComposerEnvironmentConfigWebServerNetworkAccessControl): any;
export declare class ComposerEnvironmentConfigWebServerNetworkAccessControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigWebServerNetworkAccessControl | undefined;
    set internalValue(value: ComposerEnvironmentConfigWebServerNetworkAccessControl | undefined);
    private _allowedIpRange;
    get allowedIpRange(): ComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeList;
    putAllowedIpRange(value: ComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange[] | cdktf.IResolvable): void;
    resetAllowedIpRange(): void;
    get allowedIpRangeInput(): cdktf.IResolvable | ComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange[] | undefined;
}
export interface ComposerEnvironmentConfigWorkloadsConfigScheduler {
    /**
    * The number of schedulers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#count ComposerEnvironment#count}
    */
    readonly count?: number;
    /**
    * CPU request and limit for a single Airflow scheduler replica
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cpu ComposerEnvironment#cpu}
    */
    readonly cpu?: number;
    /**
    * Memory (GB) request and limit for a single Airflow scheduler replica.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#memory_gb ComposerEnvironment#memory_gb}
    */
    readonly memoryGb?: number;
    /**
    * Storage (GB) request and limit for a single Airflow scheduler replica.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#storage_gb ComposerEnvironment#storage_gb}
    */
    readonly storageGb?: number;
}
export declare function composerEnvironmentConfigWorkloadsConfigSchedulerToTerraform(struct?: ComposerEnvironmentConfigWorkloadsConfigSchedulerOutputReference | ComposerEnvironmentConfigWorkloadsConfigScheduler): any;
export declare class ComposerEnvironmentConfigWorkloadsConfigSchedulerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigWorkloadsConfigScheduler | undefined;
    set internalValue(value: ComposerEnvironmentConfigWorkloadsConfigScheduler | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    resetCpu(): void;
    get cpuInput(): number | undefined;
    private _memoryGb?;
    get memoryGb(): number;
    set memoryGb(value: number);
    resetMemoryGb(): void;
    get memoryGbInput(): number | undefined;
    private _storageGb?;
    get storageGb(): number;
    set storageGb(value: number);
    resetStorageGb(): void;
    get storageGbInput(): number | undefined;
}
export interface ComposerEnvironmentConfigWorkloadsConfigWebServer {
    /**
    * CPU request and limit for Airflow web server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cpu ComposerEnvironment#cpu}
    */
    readonly cpu?: number;
    /**
    * Memory (GB) request and limit for Airflow web server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#memory_gb ComposerEnvironment#memory_gb}
    */
    readonly memoryGb?: number;
    /**
    * Storage (GB) request and limit for Airflow web server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#storage_gb ComposerEnvironment#storage_gb}
    */
    readonly storageGb?: number;
}
export declare function composerEnvironmentConfigWorkloadsConfigWebServerToTerraform(struct?: ComposerEnvironmentConfigWorkloadsConfigWebServerOutputReference | ComposerEnvironmentConfigWorkloadsConfigWebServer): any;
export declare class ComposerEnvironmentConfigWorkloadsConfigWebServerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigWorkloadsConfigWebServer | undefined;
    set internalValue(value: ComposerEnvironmentConfigWorkloadsConfigWebServer | undefined);
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    resetCpu(): void;
    get cpuInput(): number | undefined;
    private _memoryGb?;
    get memoryGb(): number;
    set memoryGb(value: number);
    resetMemoryGb(): void;
    get memoryGbInput(): number | undefined;
    private _storageGb?;
    get storageGb(): number;
    set storageGb(value: number);
    resetStorageGb(): void;
    get storageGbInput(): number | undefined;
}
export interface ComposerEnvironmentConfigWorkloadsConfigWorker {
    /**
    * CPU request and limit for a single Airflow worker replica.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#cpu ComposerEnvironment#cpu}
    */
    readonly cpu?: number;
    /**
    * Maximum number of workers for autoscaling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#max_count ComposerEnvironment#max_count}
    */
    readonly maxCount?: number;
    /**
    * Memory (GB) request and limit for a single Airflow worker replica.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#memory_gb ComposerEnvironment#memory_gb}
    */
    readonly memoryGb?: number;
    /**
    * Minimum number of workers for autoscaling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#min_count ComposerEnvironment#min_count}
    */
    readonly minCount?: number;
    /**
    * Storage (GB) request and limit for a single Airflow worker replica.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#storage_gb ComposerEnvironment#storage_gb}
    */
    readonly storageGb?: number;
}
export declare function composerEnvironmentConfigWorkloadsConfigWorkerToTerraform(struct?: ComposerEnvironmentConfigWorkloadsConfigWorkerOutputReference | ComposerEnvironmentConfigWorkloadsConfigWorker): any;
export declare class ComposerEnvironmentConfigWorkloadsConfigWorkerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigWorkloadsConfigWorker | undefined;
    set internalValue(value: ComposerEnvironmentConfigWorkloadsConfigWorker | undefined);
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    resetCpu(): void;
    get cpuInput(): number | undefined;
    private _maxCount?;
    get maxCount(): number;
    set maxCount(value: number);
    resetMaxCount(): void;
    get maxCountInput(): number | undefined;
    private _memoryGb?;
    get memoryGb(): number;
    set memoryGb(value: number);
    resetMemoryGb(): void;
    get memoryGbInput(): number | undefined;
    private _minCount?;
    get minCount(): number;
    set minCount(value: number);
    resetMinCount(): void;
    get minCountInput(): number | undefined;
    private _storageGb?;
    get storageGb(): number;
    set storageGb(value: number);
    resetStorageGb(): void;
    get storageGbInput(): number | undefined;
}
export interface ComposerEnvironmentConfigWorkloadsConfig {
    /**
    * scheduler block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#scheduler ComposerEnvironment#scheduler}
    */
    readonly scheduler?: ComposerEnvironmentConfigWorkloadsConfigScheduler;
    /**
    * web_server block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#web_server ComposerEnvironment#web_server}
    */
    readonly webServer?: ComposerEnvironmentConfigWorkloadsConfigWebServer;
    /**
    * worker block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#worker ComposerEnvironment#worker}
    */
    readonly worker?: ComposerEnvironmentConfigWorkloadsConfigWorker;
}
export declare function composerEnvironmentConfigWorkloadsConfigToTerraform(struct?: ComposerEnvironmentConfigWorkloadsConfigOutputReference | ComposerEnvironmentConfigWorkloadsConfig): any;
export declare class ComposerEnvironmentConfigWorkloadsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigWorkloadsConfig | undefined;
    set internalValue(value: ComposerEnvironmentConfigWorkloadsConfig | undefined);
    private _scheduler;
    get scheduler(): ComposerEnvironmentConfigWorkloadsConfigSchedulerOutputReference;
    putScheduler(value: ComposerEnvironmentConfigWorkloadsConfigScheduler): void;
    resetScheduler(): void;
    get schedulerInput(): ComposerEnvironmentConfigWorkloadsConfigScheduler | undefined;
    private _webServer;
    get webServer(): ComposerEnvironmentConfigWorkloadsConfigWebServerOutputReference;
    putWebServer(value: ComposerEnvironmentConfigWorkloadsConfigWebServer): void;
    resetWebServer(): void;
    get webServerInput(): ComposerEnvironmentConfigWorkloadsConfigWebServer | undefined;
    private _worker;
    get worker(): ComposerEnvironmentConfigWorkloadsConfigWorkerOutputReference;
    putWorker(value: ComposerEnvironmentConfigWorkloadsConfigWorker): void;
    resetWorker(): void;
    get workerInput(): ComposerEnvironmentConfigWorkloadsConfigWorker | undefined;
}
export interface ComposerEnvironmentConfigA {
    /**
    * The size of the Cloud Composer environment. This field is supported for Cloud Composer environments in versions composer-2.*.*-airflow-*.*.* and newer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#environment_size ComposerEnvironment#environment_size}
    */
    readonly environmentSize?: string;
    /**
    * The number of nodes in the Kubernetes Engine cluster that will be used to run this environment. This field is supported for Cloud Composer environments in versions composer-1.*.*-airflow-*.*.*.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#node_count ComposerEnvironment#node_count}
    */
    readonly nodeCount?: number;
    /**
    * database_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#database_config ComposerEnvironment#database_config}
    */
    readonly databaseConfig?: ComposerEnvironmentConfigDatabaseConfig;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#encryption_config ComposerEnvironment#encryption_config}
    */
    readonly encryptionConfig?: ComposerEnvironmentConfigEncryptionConfig;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#maintenance_window ComposerEnvironment#maintenance_window}
    */
    readonly maintenanceWindow?: ComposerEnvironmentConfigMaintenanceWindow;
    /**
    * master_authorized_networks_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#master_authorized_networks_config ComposerEnvironment#master_authorized_networks_config}
    */
    readonly masterAuthorizedNetworksConfig?: ComposerEnvironmentConfigMasterAuthorizedNetworksConfig;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#node_config ComposerEnvironment#node_config}
    */
    readonly nodeConfig?: ComposerEnvironmentConfigNodeConfig;
    /**
    * private_environment_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#private_environment_config ComposerEnvironment#private_environment_config}
    */
    readonly privateEnvironmentConfig?: ComposerEnvironmentConfigPrivateEnvironmentConfig;
    /**
    * recovery_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#recovery_config ComposerEnvironment#recovery_config}
    */
    readonly recoveryConfig?: ComposerEnvironmentConfigRecoveryConfig;
    /**
    * software_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#software_config ComposerEnvironment#software_config}
    */
    readonly softwareConfig?: ComposerEnvironmentConfigSoftwareConfig;
    /**
    * web_server_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#web_server_config ComposerEnvironment#web_server_config}
    */
    readonly webServerConfig?: ComposerEnvironmentConfigWebServerConfig;
    /**
    * web_server_network_access_control block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#web_server_network_access_control ComposerEnvironment#web_server_network_access_control}
    */
    readonly webServerNetworkAccessControl?: ComposerEnvironmentConfigWebServerNetworkAccessControl;
    /**
    * workloads_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#workloads_config ComposerEnvironment#workloads_config}
    */
    readonly workloadsConfig?: ComposerEnvironmentConfigWorkloadsConfig;
}
export declare function composerEnvironmentConfigAToTerraform(struct?: ComposerEnvironmentConfigAOutputReference | ComposerEnvironmentConfigA): any;
export declare class ComposerEnvironmentConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentConfigA | undefined;
    set internalValue(value: ComposerEnvironmentConfigA | undefined);
    get airflowUri(): string;
    get dagGcsPrefix(): string;
    private _environmentSize?;
    get environmentSize(): string;
    set environmentSize(value: string);
    resetEnvironmentSize(): void;
    get environmentSizeInput(): string | undefined;
    get gkeCluster(): string;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _databaseConfig;
    get databaseConfig(): ComposerEnvironmentConfigDatabaseConfigOutputReference;
    putDatabaseConfig(value: ComposerEnvironmentConfigDatabaseConfig): void;
    resetDatabaseConfig(): void;
    get databaseConfigInput(): ComposerEnvironmentConfigDatabaseConfig | undefined;
    private _encryptionConfig;
    get encryptionConfig(): ComposerEnvironmentConfigEncryptionConfigOutputReference;
    putEncryptionConfig(value: ComposerEnvironmentConfigEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): ComposerEnvironmentConfigEncryptionConfig | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): ComposerEnvironmentConfigMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: ComposerEnvironmentConfigMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): ComposerEnvironmentConfigMaintenanceWindow | undefined;
    private _masterAuthorizedNetworksConfig;
    get masterAuthorizedNetworksConfig(): ComposerEnvironmentConfigMasterAuthorizedNetworksConfigOutputReference;
    putMasterAuthorizedNetworksConfig(value: ComposerEnvironmentConfigMasterAuthorizedNetworksConfig): void;
    resetMasterAuthorizedNetworksConfig(): void;
    get masterAuthorizedNetworksConfigInput(): ComposerEnvironmentConfigMasterAuthorizedNetworksConfig | undefined;
    private _nodeConfig;
    get nodeConfig(): ComposerEnvironmentConfigNodeConfigOutputReference;
    putNodeConfig(value: ComposerEnvironmentConfigNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): ComposerEnvironmentConfigNodeConfig | undefined;
    private _privateEnvironmentConfig;
    get privateEnvironmentConfig(): ComposerEnvironmentConfigPrivateEnvironmentConfigOutputReference;
    putPrivateEnvironmentConfig(value: ComposerEnvironmentConfigPrivateEnvironmentConfig): void;
    resetPrivateEnvironmentConfig(): void;
    get privateEnvironmentConfigInput(): ComposerEnvironmentConfigPrivateEnvironmentConfig | undefined;
    private _recoveryConfig;
    get recoveryConfig(): ComposerEnvironmentConfigRecoveryConfigOutputReference;
    putRecoveryConfig(value: ComposerEnvironmentConfigRecoveryConfig): void;
    resetRecoveryConfig(): void;
    get recoveryConfigInput(): ComposerEnvironmentConfigRecoveryConfig | undefined;
    private _softwareConfig;
    get softwareConfig(): ComposerEnvironmentConfigSoftwareConfigOutputReference;
    putSoftwareConfig(value: ComposerEnvironmentConfigSoftwareConfig): void;
    resetSoftwareConfig(): void;
    get softwareConfigInput(): ComposerEnvironmentConfigSoftwareConfig | undefined;
    private _webServerConfig;
    get webServerConfig(): ComposerEnvironmentConfigWebServerConfigOutputReference;
    putWebServerConfig(value: ComposerEnvironmentConfigWebServerConfig): void;
    resetWebServerConfig(): void;
    get webServerConfigInput(): ComposerEnvironmentConfigWebServerConfig | undefined;
    private _webServerNetworkAccessControl;
    get webServerNetworkAccessControl(): ComposerEnvironmentConfigWebServerNetworkAccessControlOutputReference;
    putWebServerNetworkAccessControl(value: ComposerEnvironmentConfigWebServerNetworkAccessControl): void;
    resetWebServerNetworkAccessControl(): void;
    get webServerNetworkAccessControlInput(): ComposerEnvironmentConfigWebServerNetworkAccessControl | undefined;
    private _workloadsConfig;
    get workloadsConfig(): ComposerEnvironmentConfigWorkloadsConfigOutputReference;
    putWorkloadsConfig(value: ComposerEnvironmentConfigWorkloadsConfig): void;
    resetWorkloadsConfig(): void;
    get workloadsConfigInput(): ComposerEnvironmentConfigWorkloadsConfig | undefined;
}
export interface ComposerEnvironmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#create ComposerEnvironment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#delete ComposerEnvironment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/composer_environment#update ComposerEnvironment#update}
    */
    readonly update?: string;
}
export declare function composerEnvironmentTimeoutsToTerraform(struct?: ComposerEnvironmentTimeoutsOutputReference | ComposerEnvironmentTimeouts | cdktf.IResolvable): any;
export declare class ComposerEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComposerEnvironmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComposerEnvironmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/composer_environment google_composer_environment}
*/
export declare class ComposerEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_composer_environment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/composer_environment google_composer_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComposerEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: ComposerEnvironmentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _config;
    get config(): ComposerEnvironmentConfigAOutputReference;
    putConfig(value: ComposerEnvironmentConfigA): void;
    resetConfig(): void;
    get configInput(): ComposerEnvironmentConfigA | undefined;
    private _timeouts;
    get timeouts(): ComposerEnvironmentTimeoutsOutputReference;
    putTimeouts(value: ComposerEnvironmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComposerEnvironmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
