import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeAddressConfig extends cdktf.TerraformMetaArguments {
    /**
    * The static external IP address represented by this resource. Only
  IPv4 is supported. An address may only be specified for INTERNAL
  address types. The IP address must be inside the specified subnetwork,
  if any. Set by the API if undefined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#address ComputeAddress#address}
    */
    readonly address?: string;
    /**
    * The type of address to reserve.
  Note: if you set this argument's value as 'INTERNAL' you need to leave the 'network_tier' argument unset in that resource block. Default value: "EXTERNAL" Possible values: ["INTERNAL", "EXTERNAL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#address_type ComputeAddress#address_type}
    */
    readonly addressType?: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#description ComputeAddress#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#id ComputeAddress#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. The name must be 1-63 characters long, and
  comply with RFC1035. Specifically, the name must be 1-63 characters
  long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
  which means the first character must be a lowercase letter, and all
  following characters must be a dash, lowercase letter, or digit,
  except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#name ComputeAddress#name}
    */
    readonly name: string;
    /**
    * The URL of the network in which to reserve the address. This field
  can only be used with INTERNAL type with the VPC_PEERING and
  IPSEC_INTERCONNECT purposes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#network ComputeAddress#network}
    */
    readonly network?: string;
    /**
    * The networking tier used for configuring this address. If this field is not
  specified, it is assumed to be PREMIUM.
  This argument should not be used when configuring Internal addresses, because [network tier cannot be set for internal traffic; it's always Premium](https://cloud.google.com/network-tiers/docs/overview). Possible values: ["PREMIUM", "STANDARD"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#network_tier ComputeAddress#network_tier}
    */
    readonly networkTier?: string;
    /**
    * The prefix length if the resource represents an IP range.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#prefix_length ComputeAddress#prefix_length}
    */
    readonly prefixLength?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#project ComputeAddress#project}
    */
    readonly project?: string;
    /**
    * The purpose of this resource, which can be one of the following values.
  
  * GCE_ENDPOINT for addresses that are used by VM instances, alias IP
  ranges, load balancers, and similar resources.
  
  * SHARED_LOADBALANCER_VIP for an address that can be used by multiple
  internal load balancers.
  
  * VPC_PEERING for addresses that are reserved for VPC peer networks.
  
  * IPSEC_INTERCONNECT for addresses created from a private IP range that
  are reserved for a VLAN attachment in an HA VPN over Cloud Interconnect
  configuration. These addresses are regional resources.
  
  * PRIVATE_SERVICE_CONNECT for a private network address that is used to
  configure Private Service Connect. Only global internal addresses can use
  this purpose.
  
  
  This should only be set when using an Internal address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#purpose ComputeAddress#purpose}
    */
    readonly purpose?: string;
    /**
    * The Region in which the created address should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#region ComputeAddress#region}
    */
    readonly region?: string;
    /**
    * The URL of the subnetwork in which to reserve the address. If an IP
  address is specified, it must be within the subnetwork's IP range.
  This field can only be used with INTERNAL type with
  GCE_ENDPOINT/DNS_RESOLVER purposes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#subnetwork ComputeAddress#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#timeouts ComputeAddress#timeouts}
    */
    readonly timeouts?: ComputeAddressTimeouts;
}
export interface ComputeAddressTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#create ComputeAddress#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address#delete ComputeAddress#delete}
    */
    readonly delete?: string;
}
export declare function computeAddressTimeoutsToTerraform(struct?: ComputeAddressTimeoutsOutputReference | ComputeAddressTimeouts | cdktf.IResolvable): any;
export declare class ComputeAddressTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeAddressTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeAddressTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_address google_compute_address}
*/
export declare class ComputeAddress extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_address";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_address google_compute_address} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeAddressConfig
    */
    constructor(scope: Construct, id: string, config: ComputeAddressConfig);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _addressType?;
    get addressType(): string;
    set addressType(value: string);
    resetAddressType(): void;
    get addressTypeInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    resetNetworkTier(): void;
    get networkTierInput(): string | undefined;
    private _prefixLength?;
    get prefixLength(): number;
    set prefixLength(value: number);
    resetPrefixLength(): void;
    get prefixLengthInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _purpose?;
    get purpose(): string;
    set purpose(value: string);
    resetPurpose(): void;
    get purposeInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    get users(): string[];
    private _timeouts;
    get timeouts(): ComputeAddressTimeoutsOutputReference;
    putTimeouts(value: ComputeAddressTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeAddressTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
