import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeAutoscalerConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#description ComputeAutoscaler#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#id ComputeAutoscaler#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. The name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#name ComputeAutoscaler#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#project ComputeAutoscaler#project}
    */
    readonly project?: string;
    /**
    * URL of the managed instance group that this autoscaler will scale.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#target ComputeAutoscaler#target}
    */
    readonly target: string;
    /**
    * URL of the zone where the instance group resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#zone ComputeAutoscaler#zone}
    */
    readonly zone?: string;
    /**
    * autoscaling_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#autoscaling_policy ComputeAutoscaler#autoscaling_policy}
    */
    readonly autoscalingPolicy: ComputeAutoscalerAutoscalingPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#timeouts ComputeAutoscaler#timeouts}
    */
    readonly timeouts?: ComputeAutoscalerTimeouts;
}
export interface ComputeAutoscalerAutoscalingPolicyCpuUtilization {
    /**
    * Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are:
  
  - NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics.
  
  - OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#predictive_method ComputeAutoscaler#predictive_method}
    */
    readonly predictiveMethod?: string;
    /**
    * The target CPU utilization that the autoscaler should maintain.
  Must be a float value in the range (0, 1]. If not specified, the
  default is 0.6.
  
  If the CPU level is below the target utilization, the autoscaler
  scales down the number of instances until it reaches the minimum
  number of instances you specified or until the average CPU of
  your instances reaches the target utilization.
  
  If the average CPU is above the target utilization, the autoscaler
  scales up until it reaches the maximum number of instances you
  specified or until the average utilization reaches the target
  utilization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#target ComputeAutoscaler#target}
    */
    readonly target: number;
}
export declare function computeAutoscalerAutoscalingPolicyCpuUtilizationToTerraform(struct?: ComputeAutoscalerAutoscalingPolicyCpuUtilizationOutputReference | ComputeAutoscalerAutoscalingPolicyCpuUtilization): any;
export declare class ComputeAutoscalerAutoscalingPolicyCpuUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeAutoscalerAutoscalingPolicyCpuUtilization | undefined;
    set internalValue(value: ComputeAutoscalerAutoscalingPolicyCpuUtilization | undefined);
    private _predictiveMethod?;
    get predictiveMethod(): string;
    set predictiveMethod(value: string);
    resetPredictiveMethod(): void;
    get predictiveMethodInput(): string | undefined;
    private _target?;
    get target(): number;
    set target(value: number);
    get targetInput(): number | undefined;
}
export interface ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization {
    /**
    * Fraction of backend capacity utilization (set in HTTP(s) load
  balancing configuration) that autoscaler should maintain. Must
  be a positive float value. If not defined, the default is 0.8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#target ComputeAutoscaler#target}
    */
    readonly target: number;
}
export declare function computeAutoscalerAutoscalingPolicyLoadBalancingUtilizationToTerraform(struct?: ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference | ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization): any;
export declare class ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined;
    set internalValue(value: ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined);
    private _target?;
    get target(): number;
    set target(value: number);
    get targetInput(): number | undefined;
}
export interface ComputeAutoscalerAutoscalingPolicyMetric {
    /**
    * The identifier (type) of the Stackdriver Monitoring metric.
  The metric cannot have negative values.
  
  The metric must have a value type of INT64 or DOUBLE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#name ComputeAutoscaler#name}
    */
    readonly name: string;
    /**
    * The target value of the metric that autoscaler should
  maintain. This must be a positive value. A utilization
  metric scales number of virtual machines handling requests
  to increase or decrease proportionally to the metric.
  
  For example, a good metric to use as a utilizationTarget is
  www.googleapis.com/compute/instance/network/received_bytes_count.
  The autoscaler will work to keep this value constant for each
  of the instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#target ComputeAutoscaler#target}
    */
    readonly target?: number;
    /**
    * Defines how target utilization value is expressed for a
  Stackdriver Monitoring metric. Possible values: ["GAUGE", "DELTA_PER_SECOND", "DELTA_PER_MINUTE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#type ComputeAutoscaler#type}
    */
    readonly type?: string;
}
export declare function computeAutoscalerAutoscalingPolicyMetricToTerraform(struct?: ComputeAutoscalerAutoscalingPolicyMetric | cdktf.IResolvable): any;
export declare class ComputeAutoscalerAutoscalingPolicyMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeAutoscalerAutoscalingPolicyMetric | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeAutoscalerAutoscalingPolicyMetric | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _target?;
    get target(): number;
    set target(value: number);
    resetTarget(): void;
    get targetInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class ComputeAutoscalerAutoscalingPolicyMetricList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeAutoscalerAutoscalingPolicyMetric[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeAutoscalerAutoscalingPolicyMetricOutputReference;
}
export interface ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas {
    /**
    * Specifies a fixed number of VM instances. This must be a positive
  integer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#fixed ComputeAutoscaler#fixed}
    */
    readonly fixed?: number;
    /**
    * Specifies a percentage of instances between 0 to 100%, inclusive.
  For example, specify 80 for 80%.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#percent ComputeAutoscaler#percent}
    */
    readonly percent?: number;
}
export declare function computeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasToTerraform(struct?: ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference | ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas): any;
export declare class ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined;
    set internalValue(value: ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined);
    private _fixed?;
    get fixed(): number;
    set fixed(value: number);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface ComputeAutoscalerAutoscalingPolicyScaleInControl {
    /**
    * How long back autoscaling should look when computing recommendations
  to include directives regarding slower scale down, as described above.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#time_window_sec ComputeAutoscaler#time_window_sec}
    */
    readonly timeWindowSec?: number;
    /**
    * max_scaled_in_replicas block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#max_scaled_in_replicas ComputeAutoscaler#max_scaled_in_replicas}
    */
    readonly maxScaledInReplicas?: ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas;
}
export declare function computeAutoscalerAutoscalingPolicyScaleInControlToTerraform(struct?: ComputeAutoscalerAutoscalingPolicyScaleInControlOutputReference | ComputeAutoscalerAutoscalingPolicyScaleInControl): any;
export declare class ComputeAutoscalerAutoscalingPolicyScaleInControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeAutoscalerAutoscalingPolicyScaleInControl | undefined;
    set internalValue(value: ComputeAutoscalerAutoscalingPolicyScaleInControl | undefined);
    private _timeWindowSec?;
    get timeWindowSec(): number;
    set timeWindowSec(value: number);
    resetTimeWindowSec(): void;
    get timeWindowSecInput(): number | undefined;
    private _maxScaledInReplicas;
    get maxScaledInReplicas(): ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference;
    putMaxScaledInReplicas(value: ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas): void;
    resetMaxScaledInReplicas(): void;
    get maxScaledInReplicasInput(): ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined;
}
export interface ComputeAutoscalerAutoscalingPolicyScalingSchedules {
    /**
    * A description of a scaling schedule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#description ComputeAutoscaler#description}
    */
    readonly description?: string;
    /**
    * A boolean value that specifies if a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#disabled ComputeAutoscaler#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The duration of time intervals (in seconds) for which this scaling schedule will be running. The minimum allowed value is 300.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#duration_sec ComputeAutoscaler#duration_sec}
    */
    readonly durationSec: number;
    /**
    * Minimum number of VM instances that autoscaler will recommend in time intervals starting according to schedule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#min_required_replicas ComputeAutoscaler#min_required_replicas}
    */
    readonly minRequiredReplicas: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#name ComputeAutoscaler#name}
    */
    readonly name: string;
    /**
    * The start timestamps of time intervals when this scaling schedule should provide a scaling signal. This field uses the extended cron format (with an optional year field).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#schedule ComputeAutoscaler#schedule}
    */
    readonly schedule: string;
    /**
    * The time zone to be used when interpreting the schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#time_zone ComputeAutoscaler#time_zone}
    */
    readonly timeZone?: string;
}
export declare function computeAutoscalerAutoscalingPolicyScalingSchedulesToTerraform(struct?: ComputeAutoscalerAutoscalingPolicyScalingSchedules | cdktf.IResolvable): any;
export declare class ComputeAutoscalerAutoscalingPolicyScalingSchedulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeAutoscalerAutoscalingPolicyScalingSchedules | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeAutoscalerAutoscalingPolicyScalingSchedules | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _durationSec?;
    get durationSec(): number;
    set durationSec(value: number);
    get durationSecInput(): number | undefined;
    private _minRequiredReplicas?;
    get minRequiredReplicas(): number;
    set minRequiredReplicas(value: number);
    get minRequiredReplicasInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    get scheduleInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
}
export declare class ComputeAutoscalerAutoscalingPolicyScalingSchedulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeAutoscalerAutoscalingPolicyScalingSchedules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeAutoscalerAutoscalingPolicyScalingSchedulesOutputReference;
}
export interface ComputeAutoscalerAutoscalingPolicy {
    /**
    * The number of seconds that the autoscaler should wait before it
  starts collecting information from a new instance. This prevents
  the autoscaler from collecting information when the instance is
  initializing, during which the collected usage would not be
  reliable. The default time autoscaler waits is 60 seconds.
  
  Virtual machine initialization times might vary because of
  numerous factors. We recommend that you test how long an
  instance may take to initialize. To do this, create an instance
  and time the startup process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#cooldown_period ComputeAutoscaler#cooldown_period}
    */
    readonly cooldownPeriod?: number;
    /**
    * The maximum number of instances that the autoscaler can scale up
  to. This is required when creating or updating an autoscaler. The
  maximum number of replicas should not be lower than minimal number
  of replicas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#max_replicas ComputeAutoscaler#max_replicas}
    */
    readonly maxReplicas: number;
    /**
    * The minimum number of replicas that the autoscaler can scale down
  to. This cannot be less than 0. If not provided, autoscaler will
  choose a default value depending on maximum number of instances
  allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#min_replicas ComputeAutoscaler#min_replicas}
    */
    readonly minReplicas: number;
    /**
    * Defines operating mode for this policy. Default value: "ON" Possible values: ["OFF", "ONLY_UP", "ON"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#mode ComputeAutoscaler#mode}
    */
    readonly mode?: string;
    /**
    * cpu_utilization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#cpu_utilization ComputeAutoscaler#cpu_utilization}
    */
    readonly cpuUtilization?: ComputeAutoscalerAutoscalingPolicyCpuUtilization;
    /**
    * load_balancing_utilization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#load_balancing_utilization ComputeAutoscaler#load_balancing_utilization}
    */
    readonly loadBalancingUtilization?: ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#metric ComputeAutoscaler#metric}
    */
    readonly metric?: ComputeAutoscalerAutoscalingPolicyMetric[] | cdktf.IResolvable;
    /**
    * scale_in_control block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#scale_in_control ComputeAutoscaler#scale_in_control}
    */
    readonly scaleInControl?: ComputeAutoscalerAutoscalingPolicyScaleInControl;
    /**
    * scaling_schedules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#scaling_schedules ComputeAutoscaler#scaling_schedules}
    */
    readonly scalingSchedules?: ComputeAutoscalerAutoscalingPolicyScalingSchedules[] | cdktf.IResolvable;
}
export declare function computeAutoscalerAutoscalingPolicyToTerraform(struct?: ComputeAutoscalerAutoscalingPolicyOutputReference | ComputeAutoscalerAutoscalingPolicy): any;
export declare class ComputeAutoscalerAutoscalingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeAutoscalerAutoscalingPolicy | undefined;
    set internalValue(value: ComputeAutoscalerAutoscalingPolicy | undefined);
    private _cooldownPeriod?;
    get cooldownPeriod(): number;
    set cooldownPeriod(value: number);
    resetCooldownPeriod(): void;
    get cooldownPeriodInput(): number | undefined;
    private _maxReplicas?;
    get maxReplicas(): number;
    set maxReplicas(value: number);
    get maxReplicasInput(): number | undefined;
    private _minReplicas?;
    get minReplicas(): number;
    set minReplicas(value: number);
    get minReplicasInput(): number | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _cpuUtilization;
    get cpuUtilization(): ComputeAutoscalerAutoscalingPolicyCpuUtilizationOutputReference;
    putCpuUtilization(value: ComputeAutoscalerAutoscalingPolicyCpuUtilization): void;
    resetCpuUtilization(): void;
    get cpuUtilizationInput(): ComputeAutoscalerAutoscalingPolicyCpuUtilization | undefined;
    private _loadBalancingUtilization;
    get loadBalancingUtilization(): ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference;
    putLoadBalancingUtilization(value: ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization): void;
    resetLoadBalancingUtilization(): void;
    get loadBalancingUtilizationInput(): ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined;
    private _metric;
    get metric(): ComputeAutoscalerAutoscalingPolicyMetricList;
    putMetric(value: ComputeAutoscalerAutoscalingPolicyMetric[] | cdktf.IResolvable): void;
    resetMetric(): void;
    get metricInput(): cdktf.IResolvable | ComputeAutoscalerAutoscalingPolicyMetric[] | undefined;
    private _scaleInControl;
    get scaleInControl(): ComputeAutoscalerAutoscalingPolicyScaleInControlOutputReference;
    putScaleInControl(value: ComputeAutoscalerAutoscalingPolicyScaleInControl): void;
    resetScaleInControl(): void;
    get scaleInControlInput(): ComputeAutoscalerAutoscalingPolicyScaleInControl | undefined;
    private _scalingSchedules;
    get scalingSchedules(): ComputeAutoscalerAutoscalingPolicyScalingSchedulesList;
    putScalingSchedules(value: ComputeAutoscalerAutoscalingPolicyScalingSchedules[] | cdktf.IResolvable): void;
    resetScalingSchedules(): void;
    get scalingSchedulesInput(): cdktf.IResolvable | ComputeAutoscalerAutoscalingPolicyScalingSchedules[] | undefined;
}
export interface ComputeAutoscalerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#create ComputeAutoscaler#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#delete ComputeAutoscaler#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler#update ComputeAutoscaler#update}
    */
    readonly update?: string;
}
export declare function computeAutoscalerTimeoutsToTerraform(struct?: ComputeAutoscalerTimeoutsOutputReference | ComputeAutoscalerTimeouts | cdktf.IResolvable): any;
export declare class ComputeAutoscalerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeAutoscalerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeAutoscalerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler google_compute_autoscaler}
*/
export declare class ComputeAutoscaler extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_autoscaler";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler google_compute_autoscaler} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeAutoscalerConfig
    */
    constructor(scope: Construct, id: string, config: ComputeAutoscalerConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _autoscalingPolicy;
    get autoscalingPolicy(): ComputeAutoscalerAutoscalingPolicyOutputReference;
    putAutoscalingPolicy(value: ComputeAutoscalerAutoscalingPolicy): void;
    get autoscalingPolicyInput(): ComputeAutoscalerAutoscalingPolicy | undefined;
    private _timeouts;
    get timeouts(): ComputeAutoscalerTimeoutsOutputReference;
    putTimeouts(value: ComputeAutoscalerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeAutoscalerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
