"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComputeHealthCheck = exports.ComputeHealthCheckTimeoutsOutputReference = exports.computeHealthCheckTimeoutsToTerraform = exports.ComputeHealthCheckTcpHealthCheckOutputReference = exports.computeHealthCheckTcpHealthCheckToTerraform = exports.ComputeHealthCheckSslHealthCheckOutputReference = exports.computeHealthCheckSslHealthCheckToTerraform = exports.ComputeHealthCheckLogConfigOutputReference = exports.computeHealthCheckLogConfigToTerraform = exports.ComputeHealthCheckHttpsHealthCheckOutputReference = exports.computeHealthCheckHttpsHealthCheckToTerraform = exports.ComputeHealthCheckHttpHealthCheckOutputReference = exports.computeHealthCheckHttpHealthCheckToTerraform = exports.ComputeHealthCheckHttp2HealthCheckOutputReference = exports.computeHealthCheckHttp2HealthCheckToTerraform = exports.ComputeHealthCheckGrpcHealthCheckOutputReference = exports.computeHealthCheckGrpcHealthCheckToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function computeHealthCheckGrpcHealthCheckToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        grpc_service_name: cdktf.stringToTerraform(struct.grpcServiceName),
        port: cdktf.numberToTerraform(struct.port),
        port_name: cdktf.stringToTerraform(struct.portName),
        port_specification: cdktf.stringToTerraform(struct.portSpecification),
    };
}
exports.computeHealthCheckGrpcHealthCheckToTerraform = computeHealthCheckGrpcHealthCheckToTerraform;
class ComputeHealthCheckGrpcHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._grpcServiceName !== undefined) {
            hasAnyValues = true;
            internalValueResult.grpcServiceName = this._grpcServiceName;
        }
        if (this._port !== undefined) {
            hasAnyValues = true;
            internalValueResult.port = this._port;
        }
        if (this._portName !== undefined) {
            hasAnyValues = true;
            internalValueResult.portName = this._portName;
        }
        if (this._portSpecification !== undefined) {
            hasAnyValues = true;
            internalValueResult.portSpecification = this._portSpecification;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._grpcServiceName = undefined;
            this._port = undefined;
            this._portName = undefined;
            this._portSpecification = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._grpcServiceName = value.grpcServiceName;
            this._port = value.port;
            this._portName = value.portName;
            this._portSpecification = value.portSpecification;
        }
    }
    get grpcServiceName() {
        return this.getStringAttribute('grpc_service_name');
    }
    set grpcServiceName(value) {
        this._grpcServiceName = value;
    }
    resetGrpcServiceName() {
        this._grpcServiceName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get grpcServiceNameInput() {
        return this._grpcServiceName;
    }
    get port() {
        return this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get portName() {
        return this.getStringAttribute('port_name');
    }
    set portName(value) {
        this._portName = value;
    }
    resetPortName() {
        this._portName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portNameInput() {
        return this._portName;
    }
    get portSpecification() {
        return this.getStringAttribute('port_specification');
    }
    set portSpecification(value) {
        this._portSpecification = value;
    }
    resetPortSpecification() {
        this._portSpecification = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portSpecificationInput() {
        return this._portSpecification;
    }
}
exports.ComputeHealthCheckGrpcHealthCheckOutputReference = ComputeHealthCheckGrpcHealthCheckOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ComputeHealthCheckGrpcHealthCheckOutputReference[_a] = { fqn: "@cdktf/provider-google.computeHealthCheck.ComputeHealthCheckGrpcHealthCheckOutputReference", version: "5.0.15" };
function computeHealthCheckHttp2HealthCheckToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        host: cdktf.stringToTerraform(struct.host),
        port: cdktf.numberToTerraform(struct.port),
        port_name: cdktf.stringToTerraform(struct.portName),
        port_specification: cdktf.stringToTerraform(struct.portSpecification),
        proxy_header: cdktf.stringToTerraform(struct.proxyHeader),
        request_path: cdktf.stringToTerraform(struct.requestPath),
        response: cdktf.stringToTerraform(struct.response),
    };
}
exports.computeHealthCheckHttp2HealthCheckToTerraform = computeHealthCheckHttp2HealthCheckToTerraform;
class ComputeHealthCheckHttp2HealthCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._host !== undefined) {
            hasAnyValues = true;
            internalValueResult.host = this._host;
        }
        if (this._port !== undefined) {
            hasAnyValues = true;
            internalValueResult.port = this._port;
        }
        if (this._portName !== undefined) {
            hasAnyValues = true;
            internalValueResult.portName = this._portName;
        }
        if (this._portSpecification !== undefined) {
            hasAnyValues = true;
            internalValueResult.portSpecification = this._portSpecification;
        }
        if (this._proxyHeader !== undefined) {
            hasAnyValues = true;
            internalValueResult.proxyHeader = this._proxyHeader;
        }
        if (this._requestPath !== undefined) {
            hasAnyValues = true;
            internalValueResult.requestPath = this._requestPath;
        }
        if (this._response !== undefined) {
            hasAnyValues = true;
            internalValueResult.response = this._response;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._host = undefined;
            this._port = undefined;
            this._portName = undefined;
            this._portSpecification = undefined;
            this._proxyHeader = undefined;
            this._requestPath = undefined;
            this._response = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._host = value.host;
            this._port = value.port;
            this._portName = value.portName;
            this._portSpecification = value.portSpecification;
            this._proxyHeader = value.proxyHeader;
            this._requestPath = value.requestPath;
            this._response = value.response;
        }
    }
    get host() {
        return this.getStringAttribute('host');
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get port() {
        return this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get portName() {
        return this.getStringAttribute('port_name');
    }
    set portName(value) {
        this._portName = value;
    }
    resetPortName() {
        this._portName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portNameInput() {
        return this._portName;
    }
    get portSpecification() {
        return this.getStringAttribute('port_specification');
    }
    set portSpecification(value) {
        this._portSpecification = value;
    }
    resetPortSpecification() {
        this._portSpecification = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portSpecificationInput() {
        return this._portSpecification;
    }
    get proxyHeader() {
        return this.getStringAttribute('proxy_header');
    }
    set proxyHeader(value) {
        this._proxyHeader = value;
    }
    resetProxyHeader() {
        this._proxyHeader = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proxyHeaderInput() {
        return this._proxyHeader;
    }
    get requestPath() {
        return this.getStringAttribute('request_path');
    }
    set requestPath(value) {
        this._requestPath = value;
    }
    resetRequestPath() {
        this._requestPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestPathInput() {
        return this._requestPath;
    }
    get response() {
        return this.getStringAttribute('response');
    }
    set response(value) {
        this._response = value;
    }
    resetResponse() {
        this._response = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get responseInput() {
        return this._response;
    }
}
exports.ComputeHealthCheckHttp2HealthCheckOutputReference = ComputeHealthCheckHttp2HealthCheckOutputReference;
_b = JSII_RTTI_SYMBOL_1;
ComputeHealthCheckHttp2HealthCheckOutputReference[_b] = { fqn: "@cdktf/provider-google.computeHealthCheck.ComputeHealthCheckHttp2HealthCheckOutputReference", version: "5.0.15" };
function computeHealthCheckHttpHealthCheckToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        host: cdktf.stringToTerraform(struct.host),
        port: cdktf.numberToTerraform(struct.port),
        port_name: cdktf.stringToTerraform(struct.portName),
        port_specification: cdktf.stringToTerraform(struct.portSpecification),
        proxy_header: cdktf.stringToTerraform(struct.proxyHeader),
        request_path: cdktf.stringToTerraform(struct.requestPath),
        response: cdktf.stringToTerraform(struct.response),
    };
}
exports.computeHealthCheckHttpHealthCheckToTerraform = computeHealthCheckHttpHealthCheckToTerraform;
class ComputeHealthCheckHttpHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._host !== undefined) {
            hasAnyValues = true;
            internalValueResult.host = this._host;
        }
        if (this._port !== undefined) {
            hasAnyValues = true;
            internalValueResult.port = this._port;
        }
        if (this._portName !== undefined) {
            hasAnyValues = true;
            internalValueResult.portName = this._portName;
        }
        if (this._portSpecification !== undefined) {
            hasAnyValues = true;
            internalValueResult.portSpecification = this._portSpecification;
        }
        if (this._proxyHeader !== undefined) {
            hasAnyValues = true;
            internalValueResult.proxyHeader = this._proxyHeader;
        }
        if (this._requestPath !== undefined) {
            hasAnyValues = true;
            internalValueResult.requestPath = this._requestPath;
        }
        if (this._response !== undefined) {
            hasAnyValues = true;
            internalValueResult.response = this._response;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._host = undefined;
            this._port = undefined;
            this._portName = undefined;
            this._portSpecification = undefined;
            this._proxyHeader = undefined;
            this._requestPath = undefined;
            this._response = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._host = value.host;
            this._port = value.port;
            this._portName = value.portName;
            this._portSpecification = value.portSpecification;
            this._proxyHeader = value.proxyHeader;
            this._requestPath = value.requestPath;
            this._response = value.response;
        }
    }
    get host() {
        return this.getStringAttribute('host');
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get port() {
        return this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get portName() {
        return this.getStringAttribute('port_name');
    }
    set portName(value) {
        this._portName = value;
    }
    resetPortName() {
        this._portName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portNameInput() {
        return this._portName;
    }
    get portSpecification() {
        return this.getStringAttribute('port_specification');
    }
    set portSpecification(value) {
        this._portSpecification = value;
    }
    resetPortSpecification() {
        this._portSpecification = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portSpecificationInput() {
        return this._portSpecification;
    }
    get proxyHeader() {
        return this.getStringAttribute('proxy_header');
    }
    set proxyHeader(value) {
        this._proxyHeader = value;
    }
    resetProxyHeader() {
        this._proxyHeader = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proxyHeaderInput() {
        return this._proxyHeader;
    }
    get requestPath() {
        return this.getStringAttribute('request_path');
    }
    set requestPath(value) {
        this._requestPath = value;
    }
    resetRequestPath() {
        this._requestPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestPathInput() {
        return this._requestPath;
    }
    get response() {
        return this.getStringAttribute('response');
    }
    set response(value) {
        this._response = value;
    }
    resetResponse() {
        this._response = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get responseInput() {
        return this._response;
    }
}
exports.ComputeHealthCheckHttpHealthCheckOutputReference = ComputeHealthCheckHttpHealthCheckOutputReference;
_c = JSII_RTTI_SYMBOL_1;
ComputeHealthCheckHttpHealthCheckOutputReference[_c] = { fqn: "@cdktf/provider-google.computeHealthCheck.ComputeHealthCheckHttpHealthCheckOutputReference", version: "5.0.15" };
function computeHealthCheckHttpsHealthCheckToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        host: cdktf.stringToTerraform(struct.host),
        port: cdktf.numberToTerraform(struct.port),
        port_name: cdktf.stringToTerraform(struct.portName),
        port_specification: cdktf.stringToTerraform(struct.portSpecification),
        proxy_header: cdktf.stringToTerraform(struct.proxyHeader),
        request_path: cdktf.stringToTerraform(struct.requestPath),
        response: cdktf.stringToTerraform(struct.response),
    };
}
exports.computeHealthCheckHttpsHealthCheckToTerraform = computeHealthCheckHttpsHealthCheckToTerraform;
class ComputeHealthCheckHttpsHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._host !== undefined) {
            hasAnyValues = true;
            internalValueResult.host = this._host;
        }
        if (this._port !== undefined) {
            hasAnyValues = true;
            internalValueResult.port = this._port;
        }
        if (this._portName !== undefined) {
            hasAnyValues = true;
            internalValueResult.portName = this._portName;
        }
        if (this._portSpecification !== undefined) {
            hasAnyValues = true;
            internalValueResult.portSpecification = this._portSpecification;
        }
        if (this._proxyHeader !== undefined) {
            hasAnyValues = true;
            internalValueResult.proxyHeader = this._proxyHeader;
        }
        if (this._requestPath !== undefined) {
            hasAnyValues = true;
            internalValueResult.requestPath = this._requestPath;
        }
        if (this._response !== undefined) {
            hasAnyValues = true;
            internalValueResult.response = this._response;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._host = undefined;
            this._port = undefined;
            this._portName = undefined;
            this._portSpecification = undefined;
            this._proxyHeader = undefined;
            this._requestPath = undefined;
            this._response = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._host = value.host;
            this._port = value.port;
            this._portName = value.portName;
            this._portSpecification = value.portSpecification;
            this._proxyHeader = value.proxyHeader;
            this._requestPath = value.requestPath;
            this._response = value.response;
        }
    }
    get host() {
        return this.getStringAttribute('host');
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get port() {
        return this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get portName() {
        return this.getStringAttribute('port_name');
    }
    set portName(value) {
        this._portName = value;
    }
    resetPortName() {
        this._portName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portNameInput() {
        return this._portName;
    }
    get portSpecification() {
        return this.getStringAttribute('port_specification');
    }
    set portSpecification(value) {
        this._portSpecification = value;
    }
    resetPortSpecification() {
        this._portSpecification = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portSpecificationInput() {
        return this._portSpecification;
    }
    get proxyHeader() {
        return this.getStringAttribute('proxy_header');
    }
    set proxyHeader(value) {
        this._proxyHeader = value;
    }
    resetProxyHeader() {
        this._proxyHeader = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proxyHeaderInput() {
        return this._proxyHeader;
    }
    get requestPath() {
        return this.getStringAttribute('request_path');
    }
    set requestPath(value) {
        this._requestPath = value;
    }
    resetRequestPath() {
        this._requestPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestPathInput() {
        return this._requestPath;
    }
    get response() {
        return this.getStringAttribute('response');
    }
    set response(value) {
        this._response = value;
    }
    resetResponse() {
        this._response = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get responseInput() {
        return this._response;
    }
}
exports.ComputeHealthCheckHttpsHealthCheckOutputReference = ComputeHealthCheckHttpsHealthCheckOutputReference;
_d = JSII_RTTI_SYMBOL_1;
ComputeHealthCheckHttpsHealthCheckOutputReference[_d] = { fqn: "@cdktf/provider-google.computeHealthCheck.ComputeHealthCheckHttpsHealthCheckOutputReference", version: "5.0.15" };
function computeHealthCheckLogConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enable: cdktf.booleanToTerraform(struct.enable),
    };
}
exports.computeHealthCheckLogConfigToTerraform = computeHealthCheckLogConfigToTerraform;
class ComputeHealthCheckLogConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._enable !== undefined) {
            hasAnyValues = true;
            internalValueResult.enable = this._enable;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._enable = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._enable = value.enable;
        }
    }
    get enable() {
        return this.getBooleanAttribute('enable');
    }
    set enable(value) {
        this._enable = value;
    }
    resetEnable() {
        this._enable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableInput() {
        return this._enable;
    }
}
exports.ComputeHealthCheckLogConfigOutputReference = ComputeHealthCheckLogConfigOutputReference;
_e = JSII_RTTI_SYMBOL_1;
ComputeHealthCheckLogConfigOutputReference[_e] = { fqn: "@cdktf/provider-google.computeHealthCheck.ComputeHealthCheckLogConfigOutputReference", version: "5.0.15" };
function computeHealthCheckSslHealthCheckToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        port: cdktf.numberToTerraform(struct.port),
        port_name: cdktf.stringToTerraform(struct.portName),
        port_specification: cdktf.stringToTerraform(struct.portSpecification),
        proxy_header: cdktf.stringToTerraform(struct.proxyHeader),
        request: cdktf.stringToTerraform(struct.request),
        response: cdktf.stringToTerraform(struct.response),
    };
}
exports.computeHealthCheckSslHealthCheckToTerraform = computeHealthCheckSslHealthCheckToTerraform;
class ComputeHealthCheckSslHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._port !== undefined) {
            hasAnyValues = true;
            internalValueResult.port = this._port;
        }
        if (this._portName !== undefined) {
            hasAnyValues = true;
            internalValueResult.portName = this._portName;
        }
        if (this._portSpecification !== undefined) {
            hasAnyValues = true;
            internalValueResult.portSpecification = this._portSpecification;
        }
        if (this._proxyHeader !== undefined) {
            hasAnyValues = true;
            internalValueResult.proxyHeader = this._proxyHeader;
        }
        if (this._request !== undefined) {
            hasAnyValues = true;
            internalValueResult.request = this._request;
        }
        if (this._response !== undefined) {
            hasAnyValues = true;
            internalValueResult.response = this._response;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._port = undefined;
            this._portName = undefined;
            this._portSpecification = undefined;
            this._proxyHeader = undefined;
            this._request = undefined;
            this._response = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._port = value.port;
            this._portName = value.portName;
            this._portSpecification = value.portSpecification;
            this._proxyHeader = value.proxyHeader;
            this._request = value.request;
            this._response = value.response;
        }
    }
    get port() {
        return this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get portName() {
        return this.getStringAttribute('port_name');
    }
    set portName(value) {
        this._portName = value;
    }
    resetPortName() {
        this._portName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portNameInput() {
        return this._portName;
    }
    get portSpecification() {
        return this.getStringAttribute('port_specification');
    }
    set portSpecification(value) {
        this._portSpecification = value;
    }
    resetPortSpecification() {
        this._portSpecification = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portSpecificationInput() {
        return this._portSpecification;
    }
    get proxyHeader() {
        return this.getStringAttribute('proxy_header');
    }
    set proxyHeader(value) {
        this._proxyHeader = value;
    }
    resetProxyHeader() {
        this._proxyHeader = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proxyHeaderInput() {
        return this._proxyHeader;
    }
    get request() {
        return this.getStringAttribute('request');
    }
    set request(value) {
        this._request = value;
    }
    resetRequest() {
        this._request = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestInput() {
        return this._request;
    }
    get response() {
        return this.getStringAttribute('response');
    }
    set response(value) {
        this._response = value;
    }
    resetResponse() {
        this._response = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get responseInput() {
        return this._response;
    }
}
exports.ComputeHealthCheckSslHealthCheckOutputReference = ComputeHealthCheckSslHealthCheckOutputReference;
_f = JSII_RTTI_SYMBOL_1;
ComputeHealthCheckSslHealthCheckOutputReference[_f] = { fqn: "@cdktf/provider-google.computeHealthCheck.ComputeHealthCheckSslHealthCheckOutputReference", version: "5.0.15" };
function computeHealthCheckTcpHealthCheckToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        port: cdktf.numberToTerraform(struct.port),
        port_name: cdktf.stringToTerraform(struct.portName),
        port_specification: cdktf.stringToTerraform(struct.portSpecification),
        proxy_header: cdktf.stringToTerraform(struct.proxyHeader),
        request: cdktf.stringToTerraform(struct.request),
        response: cdktf.stringToTerraform(struct.response),
    };
}
exports.computeHealthCheckTcpHealthCheckToTerraform = computeHealthCheckTcpHealthCheckToTerraform;
class ComputeHealthCheckTcpHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._port !== undefined) {
            hasAnyValues = true;
            internalValueResult.port = this._port;
        }
        if (this._portName !== undefined) {
            hasAnyValues = true;
            internalValueResult.portName = this._portName;
        }
        if (this._portSpecification !== undefined) {
            hasAnyValues = true;
            internalValueResult.portSpecification = this._portSpecification;
        }
        if (this._proxyHeader !== undefined) {
            hasAnyValues = true;
            internalValueResult.proxyHeader = this._proxyHeader;
        }
        if (this._request !== undefined) {
            hasAnyValues = true;
            internalValueResult.request = this._request;
        }
        if (this._response !== undefined) {
            hasAnyValues = true;
            internalValueResult.response = this._response;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._port = undefined;
            this._portName = undefined;
            this._portSpecification = undefined;
            this._proxyHeader = undefined;
            this._request = undefined;
            this._response = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._port = value.port;
            this._portName = value.portName;
            this._portSpecification = value.portSpecification;
            this._proxyHeader = value.proxyHeader;
            this._request = value.request;
            this._response = value.response;
        }
    }
    get port() {
        return this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get portName() {
        return this.getStringAttribute('port_name');
    }
    set portName(value) {
        this._portName = value;
    }
    resetPortName() {
        this._portName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portNameInput() {
        return this._portName;
    }
    get portSpecification() {
        return this.getStringAttribute('port_specification');
    }
    set portSpecification(value) {
        this._portSpecification = value;
    }
    resetPortSpecification() {
        this._portSpecification = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portSpecificationInput() {
        return this._portSpecification;
    }
    get proxyHeader() {
        return this.getStringAttribute('proxy_header');
    }
    set proxyHeader(value) {
        this._proxyHeader = value;
    }
    resetProxyHeader() {
        this._proxyHeader = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get proxyHeaderInput() {
        return this._proxyHeader;
    }
    get request() {
        return this.getStringAttribute('request');
    }
    set request(value) {
        this._request = value;
    }
    resetRequest() {
        this._request = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestInput() {
        return this._request;
    }
    get response() {
        return this.getStringAttribute('response');
    }
    set response(value) {
        this._response = value;
    }
    resetResponse() {
        this._response = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get responseInput() {
        return this._response;
    }
}
exports.ComputeHealthCheckTcpHealthCheckOutputReference = ComputeHealthCheckTcpHealthCheckOutputReference;
_g = JSII_RTTI_SYMBOL_1;
ComputeHealthCheckTcpHealthCheckOutputReference[_g] = { fqn: "@cdktf/provider-google.computeHealthCheck.ComputeHealthCheckTcpHealthCheckOutputReference", version: "5.0.15" };
function computeHealthCheckTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.computeHealthCheckTimeoutsToTerraform = computeHealthCheckTimeoutsToTerraform;
class ComputeHealthCheckTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.ComputeHealthCheckTimeoutsOutputReference = ComputeHealthCheckTimeoutsOutputReference;
_h = JSII_RTTI_SYMBOL_1;
ComputeHealthCheckTimeoutsOutputReference[_h] = { fqn: "@cdktf/provider-google.computeHealthCheck.ComputeHealthCheckTimeoutsOutputReference", version: "5.0.15" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_health_check google_compute_health_check}
*/
class ComputeHealthCheck extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_health_check google_compute_health_check} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeHealthCheckConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_compute_health_check',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '4.61.0',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // grpc_health_check - computed: false, optional: true, required: false
        this._grpcHealthCheck = new ComputeHealthCheckGrpcHealthCheckOutputReference(this, "grpc_health_check");
        // http2_health_check - computed: false, optional: true, required: false
        this._http2HealthCheck = new ComputeHealthCheckHttp2HealthCheckOutputReference(this, "http2_health_check");
        // http_health_check - computed: false, optional: true, required: false
        this._httpHealthCheck = new ComputeHealthCheckHttpHealthCheckOutputReference(this, "http_health_check");
        // https_health_check - computed: false, optional: true, required: false
        this._httpsHealthCheck = new ComputeHealthCheckHttpsHealthCheckOutputReference(this, "https_health_check");
        // log_config - computed: false, optional: true, required: false
        this._logConfig = new ComputeHealthCheckLogConfigOutputReference(this, "log_config");
        // ssl_health_check - computed: false, optional: true, required: false
        this._sslHealthCheck = new ComputeHealthCheckSslHealthCheckOutputReference(this, "ssl_health_check");
        // tcp_health_check - computed: false, optional: true, required: false
        this._tcpHealthCheck = new ComputeHealthCheckTcpHealthCheckOutputReference(this, "tcp_health_check");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new ComputeHealthCheckTimeoutsOutputReference(this, "timeouts");
        this._checkIntervalSec = config.checkIntervalSec;
        this._description = config.description;
        this._healthyThreshold = config.healthyThreshold;
        this._id = config.id;
        this._name = config.name;
        this._project = config.project;
        this._timeoutSec = config.timeoutSec;
        this._unhealthyThreshold = config.unhealthyThreshold;
        this._grpcHealthCheck.internalValue = config.grpcHealthCheck;
        this._http2HealthCheck.internalValue = config.http2HealthCheck;
        this._httpHealthCheck.internalValue = config.httpHealthCheck;
        this._httpsHealthCheck.internalValue = config.httpsHealthCheck;
        this._logConfig.internalValue = config.logConfig;
        this._sslHealthCheck.internalValue = config.sslHealthCheck;
        this._tcpHealthCheck.internalValue = config.tcpHealthCheck;
        this._timeouts.internalValue = config.timeouts;
    }
    get checkIntervalSec() {
        return this.getNumberAttribute('check_interval_sec');
    }
    set checkIntervalSec(value) {
        this._checkIntervalSec = value;
    }
    resetCheckIntervalSec() {
        this._checkIntervalSec = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get checkIntervalSecInput() {
        return this._checkIntervalSec;
    }
    // creation_timestamp - computed: true, optional: false, required: false
    get creationTimestamp() {
        return this.getStringAttribute('creation_timestamp');
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get healthyThreshold() {
        return this.getNumberAttribute('healthy_threshold');
    }
    set healthyThreshold(value) {
        this._healthyThreshold = value;
    }
    resetHealthyThreshold() {
        this._healthyThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get healthyThresholdInput() {
        return this._healthyThreshold;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    // self_link - computed: true, optional: false, required: false
    get selfLink() {
        return this.getStringAttribute('self_link');
    }
    get timeoutSec() {
        return this.getNumberAttribute('timeout_sec');
    }
    set timeoutSec(value) {
        this._timeoutSec = value;
    }
    resetTimeoutSec() {
        this._timeoutSec = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutSecInput() {
        return this._timeoutSec;
    }
    // type - computed: true, optional: false, required: false
    get type() {
        return this.getStringAttribute('type');
    }
    get unhealthyThreshold() {
        return this.getNumberAttribute('unhealthy_threshold');
    }
    set unhealthyThreshold(value) {
        this._unhealthyThreshold = value;
    }
    resetUnhealthyThreshold() {
        this._unhealthyThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get unhealthyThresholdInput() {
        return this._unhealthyThreshold;
    }
    get grpcHealthCheck() {
        return this._grpcHealthCheck;
    }
    putGrpcHealthCheck(value) {
        this._grpcHealthCheck.internalValue = value;
    }
    resetGrpcHealthCheck() {
        this._grpcHealthCheck.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get grpcHealthCheckInput() {
        return this._grpcHealthCheck.internalValue;
    }
    get http2HealthCheck() {
        return this._http2HealthCheck;
    }
    putHttp2HealthCheck(value) {
        this._http2HealthCheck.internalValue = value;
    }
    resetHttp2HealthCheck() {
        this._http2HealthCheck.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get http2HealthCheckInput() {
        return this._http2HealthCheck.internalValue;
    }
    get httpHealthCheck() {
        return this._httpHealthCheck;
    }
    putHttpHealthCheck(value) {
        this._httpHealthCheck.internalValue = value;
    }
    resetHttpHealthCheck() {
        this._httpHealthCheck.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get httpHealthCheckInput() {
        return this._httpHealthCheck.internalValue;
    }
    get httpsHealthCheck() {
        return this._httpsHealthCheck;
    }
    putHttpsHealthCheck(value) {
        this._httpsHealthCheck.internalValue = value;
    }
    resetHttpsHealthCheck() {
        this._httpsHealthCheck.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get httpsHealthCheckInput() {
        return this._httpsHealthCheck.internalValue;
    }
    get logConfig() {
        return this._logConfig;
    }
    putLogConfig(value) {
        this._logConfig.internalValue = value;
    }
    resetLogConfig() {
        this._logConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get logConfigInput() {
        return this._logConfig.internalValue;
    }
    get sslHealthCheck() {
        return this._sslHealthCheck;
    }
    putSslHealthCheck(value) {
        this._sslHealthCheck.internalValue = value;
    }
    resetSslHealthCheck() {
        this._sslHealthCheck.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sslHealthCheckInput() {
        return this._sslHealthCheck.internalValue;
    }
    get tcpHealthCheck() {
        return this._tcpHealthCheck;
    }
    putTcpHealthCheck(value) {
        this._tcpHealthCheck.internalValue = value;
    }
    resetTcpHealthCheck() {
        this._tcpHealthCheck.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tcpHealthCheckInput() {
        return this._tcpHealthCheck.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            check_interval_sec: cdktf.numberToTerraform(this._checkIntervalSec),
            description: cdktf.stringToTerraform(this._description),
            healthy_threshold: cdktf.numberToTerraform(this._healthyThreshold),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            project: cdktf.stringToTerraform(this._project),
            timeout_sec: cdktf.numberToTerraform(this._timeoutSec),
            unhealthy_threshold: cdktf.numberToTerraform(this._unhealthyThreshold),
            grpc_health_check: computeHealthCheckGrpcHealthCheckToTerraform(this._grpcHealthCheck.internalValue),
            http2_health_check: computeHealthCheckHttp2HealthCheckToTerraform(this._http2HealthCheck.internalValue),
            http_health_check: computeHealthCheckHttpHealthCheckToTerraform(this._httpHealthCheck.internalValue),
            https_health_check: computeHealthCheckHttpsHealthCheckToTerraform(this._httpsHealthCheck.internalValue),
            log_config: computeHealthCheckLogConfigToTerraform(this._logConfig.internalValue),
            ssl_health_check: computeHealthCheckSslHealthCheckToTerraform(this._sslHealthCheck.internalValue),
            tcp_health_check: computeHealthCheckTcpHealthCheckToTerraform(this._tcpHealthCheck.internalValue),
            timeouts: computeHealthCheckTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.ComputeHealthCheck = ComputeHealthCheck;
_j = JSII_RTTI_SYMBOL_1;
ComputeHealthCheck[_j] = { fqn: "@cdktf/provider-google.computeHealthCheck.ComputeHealthCheck", version: "5.0.15" };
// =================
// STATIC PROPERTIES
// =================
ComputeHealthCheck.tfResourceType = "google_compute_health_check";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvY29tcHV0ZS1oZWFsdGgtY2hlY2svaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFJQSwrQkFBK0I7QUFnSy9CLFNBQWdCLDRDQUE0QyxDQUFDLE1BQTZGO0lBQ3hKLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxlQUFlLENBQUM7UUFDbkUsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsSUFBSSxDQUFDO1FBQzNDLFNBQVMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFFBQVEsQ0FBQztRQUNwRCxrQkFBa0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLGlCQUFpQixDQUFDO0tBQ3ZFLENBQUE7QUFDSCxDQUFDO0FBWEQsb0dBV0M7QUFFRCxNQUFhLGdEQUFpRCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR3ZGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxnQkFBZ0IsS0FBSyxTQUFTLEVBQUU7WUFDdkMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1NBQzdEO1FBQ0QsSUFBSSxJQUFJLENBQUMsS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUM1QixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1NBQ3ZDO1FBQ0QsSUFBSSxJQUFJLENBQUMsU0FBUyxLQUFLLFNBQVMsRUFBRTtZQUNoQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDO1NBQy9DO1FBQ0QsSUFBSSxJQUFJLENBQUMsa0JBQWtCLEtBQUssU0FBUyxFQUFFO1lBQ3pDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1NBQ2pFO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQW9EO1FBQzNFLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsU0FBUyxDQUFDO1lBQ2xDLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO1lBQ3ZCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO1lBQzNCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7U0FDckM7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1lBQzlDLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztZQUN4QixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7WUFDaEMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztTQUNuRDtJQUNILENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBQ0QsSUFBVyxlQUFlLENBQUMsS0FBYTtRQUN0QyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO0lBQ2hDLENBQUM7SUFDTSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFNBQVMsQ0FBQztJQUNwQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBQy9CLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFhO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO0lBQzdCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBQ0QsSUFBVyxpQkFBaUIsQ0FBQyxLQUFhO1FBQ3hDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUNNLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO0lBQ3RDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQzs7QUFoSEgsNEdBaUhDOzs7QUFtRUQsU0FBZ0IsNkNBQTZDLENBQUMsTUFBK0Y7SUFDM0osSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxJQUFJLENBQUM7UUFDM0MsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsSUFBSSxDQUFDO1FBQzNDLFNBQVMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFFBQVEsQ0FBQztRQUNwRCxrQkFBa0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLGlCQUFpQixDQUFDO1FBQ3RFLFlBQVksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFdBQVcsQ0FBQztRQUMxRCxZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxXQUFXLENBQUM7UUFDMUQsUUFBUSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsUUFBUSxDQUFDO0tBQ3BELENBQUE7QUFDSCxDQUFDO0FBZEQsc0dBY0M7QUFFRCxNQUFhLGlEQUFrRCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR3hGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQzVCLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUM7U0FDdkM7UUFDRCxJQUFJLElBQUksQ0FBQyxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQzVCLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUM7U0FDdkM7UUFDRCxJQUFJLElBQUksQ0FBQyxTQUFTLEtBQUssU0FBUyxFQUFFO1lBQ2hDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUM7U0FDL0M7UUFDRCxJQUFJLElBQUksQ0FBQyxrQkFBa0IsS0FBSyxTQUFTLEVBQUU7WUFDekMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUM7U0FDakU7UUFDRCxJQUFJLElBQUksQ0FBQyxZQUFZLEtBQUssU0FBUyxFQUFFO1lBQ25DLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUM7U0FDckQ7UUFDRCxJQUFJLElBQUksQ0FBQyxZQUFZLEtBQUssU0FBUyxFQUFFO1lBQ25DLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUM7U0FDckQ7UUFDRCxJQUFJLElBQUksQ0FBQyxTQUFTLEtBQUssU0FBUyxFQUFFO1lBQ2hDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUM7U0FDL0M7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBcUQ7UUFDNUUsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO1lBQ3ZCLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO1lBQ3ZCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO1lBQzNCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7WUFDcEMsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7WUFDOUIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7WUFDOUIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7U0FDNUI7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztZQUN4QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7WUFDeEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1lBQ2hDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUM7WUFDbEQsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1lBQ3RDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztZQUN0QyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7U0FDakM7SUFDSCxDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNNLFNBQVM7UUFDZCxJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztJQUN6QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFDTSxTQUFTO1FBQ2QsSUFBSSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7SUFDekIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUNELElBQVcsUUFBUSxDQUFDLEtBQWE7UUFDL0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7SUFDN0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFJRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFDRCxJQUFXLGlCQUFpQixDQUFDLEtBQWE7UUFDeEMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBQ00sc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7SUFDdEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFhO1FBQ2xDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7SUFDaEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBYTtRQUNsQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBQ00sZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUNELElBQVcsUUFBUSxDQUFDLEtBQWE7UUFDL0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7SUFDN0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7O0FBbExILDhHQW1MQzs7O0FBbUVELFNBQWdCLDRDQUE0QyxDQUFDLE1BQTZGO0lBQ3hKLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsSUFBSSxDQUFDO1FBQzNDLElBQUksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLElBQUksQ0FBQztRQUMzQyxTQUFTLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxRQUFRLENBQUM7UUFDcEQsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxpQkFBaUIsQ0FBQztRQUN0RSxZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxXQUFXLENBQUM7UUFDMUQsWUFBWSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsV0FBVyxDQUFDO1FBQzFELFFBQVEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFFBQVEsQ0FBQztLQUNwRCxDQUFBO0FBQ0gsQ0FBQztBQWRELG9HQWNDO0FBRUQsTUFBYSxnREFBaUQsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUd2Rjs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVBqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVE5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUM1QixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1NBQ3ZDO1FBQ0QsSUFBSSxJQUFJLENBQUMsS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUM1QixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1NBQ3ZDO1FBQ0QsSUFBSSxJQUFJLENBQUMsU0FBUyxLQUFLLFNBQVMsRUFBRTtZQUNoQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDO1NBQy9DO1FBQ0QsSUFBSSxJQUFJLENBQUMsa0JBQWtCLEtBQUssU0FBUyxFQUFFO1lBQ3pDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1NBQ2pFO1FBQ0QsSUFBSSxJQUFJLENBQUMsWUFBWSxLQUFLLFNBQVMsRUFBRTtZQUNuQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDO1NBQ3JEO1FBQ0QsSUFBSSxJQUFJLENBQUMsWUFBWSxLQUFLLFNBQVMsRUFBRTtZQUNuQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDO1NBQ3JEO1FBQ0QsSUFBSSxJQUFJLENBQUMsU0FBUyxLQUFLLFNBQVMsRUFBRTtZQUNoQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDO1NBQy9DO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQW9EO1FBQzNFLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztZQUN2QixJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztZQUN2QixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztZQUMzQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO1lBQ3BDLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO1lBQzlCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO1lBQzlCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO1NBQzVCO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7WUFDeEIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1lBQ3hCLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztZQUNoQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1lBQ2xELElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztZQUN0QyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7WUFDdEMsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1NBQ2pDO0lBQ0gsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFDTSxTQUFTO1FBQ2QsSUFBSSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7SUFDekIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFhO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO0lBQzdCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBQ0QsSUFBVyxpQkFBaUIsQ0FBQyxLQUFhO1FBQ3hDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUNNLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO0lBQ3RDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBYTtRQUNsQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBQ00sZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFhO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO0lBQzdCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDOztBQWxMSCw0R0FtTEM7OztBQW1FRCxTQUFnQiw2Q0FBNkMsQ0FBQyxNQUErRjtJQUMzSixJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLElBQUksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLElBQUksQ0FBQztRQUMzQyxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxJQUFJLENBQUM7UUFDM0MsU0FBUyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsUUFBUSxDQUFDO1FBQ3BELGtCQUFrQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsaUJBQWlCLENBQUM7UUFDdEUsWUFBWSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsV0FBVyxDQUFDO1FBQzFELFlBQVksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFdBQVcsQ0FBQztRQUMxRCxRQUFRLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxRQUFRLENBQUM7S0FDcEQsQ0FBQTtBQUNILENBQUM7QUFkRCxzR0FjQztBQUVELE1BQWEsaURBQWtELFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHeEY7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDNUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQztTQUN2QztRQUNELElBQUksSUFBSSxDQUFDLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDNUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQztTQUN2QztRQUNELElBQUksSUFBSSxDQUFDLFNBQVMsS0FBSyxTQUFTLEVBQUU7WUFDaEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztTQUMvQztRQUNELElBQUksSUFBSSxDQUFDLGtCQUFrQixLQUFLLFNBQVMsRUFBRTtZQUN6QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztTQUNqRTtRQUNELElBQUksSUFBSSxDQUFDLFlBQVksS0FBSyxTQUFTLEVBQUU7WUFDbkMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztTQUNyRDtRQUNELElBQUksSUFBSSxDQUFDLFlBQVksS0FBSyxTQUFTLEVBQUU7WUFDbkMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztTQUNyRDtRQUNELElBQUksSUFBSSxDQUFDLFNBQVMsS0FBSyxTQUFTLEVBQUU7WUFDaEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztTQUMvQztRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUFxRDtRQUM1RSxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7WUFDdkIsSUFBSSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7WUFDdkIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7WUFDM0IsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFNBQVMsQ0FBQztZQUNwQyxJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztZQUM5QixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztZQUM5QixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztTQUM1QjthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1lBQ3hCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztZQUN4QixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7WUFDaEMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztZQUNsRCxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7WUFDdEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1lBQ3RDLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztTQUNqQztJQUNILENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNNLFNBQVM7UUFDZCxJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztJQUN6QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBYTtRQUMvQixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUlELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBYTtRQUN4QyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO0lBQ2xDLENBQUM7SUFDTSxzQkFBc0I7UUFDM0IsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFNBQVMsQ0FBQztJQUN0QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsc0JBQXNCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDO0lBQ2pDLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFhO1FBQ2xDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7SUFDaEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBYTtRQUMvQixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQzs7QUFsTEgsOEdBbUxDOzs7QUFXRCxTQUFnQixzQ0FBc0MsQ0FBQyxNQUFpRjtJQUN0SSxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLE1BQU0sRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLE1BQU0sQ0FBQztLQUNqRCxDQUFBO0FBQ0gsQ0FBQztBQVJELHdGQVFDO0FBRUQsTUFBYSwwQ0FBMkMsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUdqRjs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVBqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVE5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsT0FBTyxLQUFLLFNBQVMsRUFBRTtZQUM5QixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1NBQzNDO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQThDO1FBQ3JFLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztTQUMxQjthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1NBQzdCO0lBQ0gsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFrQztRQUNsRCxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQzs7QUE5Q0gsZ0dBK0NDOzs7QUE2REQsU0FBZ0IsMkNBQTJDLENBQUMsTUFBMkY7SUFDckosSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxJQUFJLENBQUM7UUFDM0MsU0FBUyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsUUFBUSxDQUFDO1FBQ3BELGtCQUFrQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsaUJBQWlCLENBQUM7UUFDdEUsWUFBWSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsV0FBVyxDQUFDO1FBQzFELE9BQU8sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE9BQU8sQ0FBQztRQUNqRCxRQUFRLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxRQUFRLENBQUM7S0FDcEQsQ0FBQTtBQUNILENBQUM7QUFiRCxrR0FhQztBQUVELE1BQWEsK0NBQWdELFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHdEY7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDNUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQztTQUN2QztRQUNELElBQUksSUFBSSxDQUFDLFNBQVMsS0FBSyxTQUFTLEVBQUU7WUFDaEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztTQUMvQztRQUNELElBQUksSUFBSSxDQUFDLGtCQUFrQixLQUFLLFNBQVMsRUFBRTtZQUN6QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztTQUNqRTtRQUNELElBQUksSUFBSSxDQUFDLFlBQVksS0FBSyxTQUFTLEVBQUU7WUFDbkMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztTQUNyRDtRQUNELElBQUksSUFBSSxDQUFDLFFBQVEsS0FBSyxTQUFTLEVBQUU7WUFDL0IsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQztTQUM3QztRQUNELElBQUksSUFBSSxDQUFDLFNBQVMsS0FBSyxTQUFTLEVBQUU7WUFDaEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztTQUMvQztRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUFtRDtRQUMxRSxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7WUFDdkIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7WUFDM0IsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFNBQVMsQ0FBQztZQUNwQyxJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztZQUM5QixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztZQUMxQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztTQUM1QjthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1lBQ3hCLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztZQUNoQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1lBQ2xELElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztZQUN0QyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7WUFDOUIsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1NBQ2pDO0lBQ0gsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFDTSxTQUFTO1FBQ2QsSUFBSSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7SUFDekIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUNELElBQVcsUUFBUSxDQUFDLEtBQWE7UUFDL0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7SUFDN0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFJRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFDRCxJQUFXLGlCQUFpQixDQUFDLEtBQWE7UUFDeEMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBQ00sc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7SUFDdEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFhO1FBQ2xDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7SUFDaEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBYTtRQUM5QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBQ00sWUFBWTtRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztJQUM1QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBYTtRQUMvQixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQzs7QUE1SkgsMEdBNkpDOzs7QUE2REQsU0FBZ0IsMkNBQTJDLENBQUMsTUFBMkY7SUFDckosSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxJQUFJLENBQUM7UUFDM0MsU0FBUyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsUUFBUSxDQUFDO1FBQ3BELGtCQUFrQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsaUJBQWlCLENBQUM7UUFDdEUsWUFBWSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsV0FBVyxDQUFDO1FBQzFELE9BQU8sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE9BQU8sQ0FBQztRQUNqRCxRQUFRLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxRQUFRLENBQUM7S0FDcEQsQ0FBQTtBQUNILENBQUM7QUFiRCxrR0FhQztBQUVELE1BQWEsK0NBQWdELFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHdEY7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDNUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQztTQUN2QztRQUNELElBQUksSUFBSSxDQUFDLFNBQVMsS0FBSyxTQUFTLEVBQUU7WUFDaEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztTQUMvQztRQUNELElBQUksSUFBSSxDQUFDLGtCQUFrQixLQUFLLFNBQVMsRUFBRTtZQUN6QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztTQUNqRTtRQUNELElBQUksSUFBSSxDQUFDLFlBQVksS0FBSyxTQUFTLEVBQUU7WUFDbkMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztTQUNyRDtRQUNELElBQUksSUFBSSxDQUFDLFFBQVEsS0FBSyxTQUFTLEVBQUU7WUFDL0IsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQztTQUM3QztRQUNELElBQUksSUFBSSxDQUFDLFNBQVMsS0FBSyxTQUFTLEVBQUU7WUFDaEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztTQUMvQztRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUFtRDtRQUMxRSxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7WUFDdkIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7WUFDM0IsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFNBQVMsQ0FBQztZQUNwQyxJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztZQUM5QixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztZQUMxQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztTQUM1QjthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO1lBQ3hCLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztZQUNoQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1lBQ2xELElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztZQUN0QyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7WUFDOUIsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1NBQ2pDO0lBQ0gsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFDTSxTQUFTO1FBQ2QsSUFBSSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7SUFDekIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUNELElBQVcsUUFBUSxDQUFDLEtBQWE7UUFDL0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7SUFDN0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFJRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFDRCxJQUFXLGlCQUFpQixDQUFDLEtBQWE7UUFDeEMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBQ00sc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7SUFDdEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFhO1FBQ2xDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7SUFDaEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBYTtRQUM5QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBQ00sWUFBWTtRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztJQUM1QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBYTtRQUMvQixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQzs7QUE1SkgsMEdBNkpDOzs7QUFnQkQsU0FBZ0IscUNBQXFDLENBQUMsTUFBbUc7SUFDdkosSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxNQUFNLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxNQUFNLENBQUM7UUFDL0MsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsTUFBTSxDQUFDO1FBQy9DLE1BQU0sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE1BQU0sQ0FBQztLQUNoRCxDQUFBO0FBQ0gsQ0FBQztBQVZELHNGQVVDO0FBRUQsTUFBYSx5Q0FBMEMsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUloRjs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVJqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVM5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksSUFBSSxDQUFDLGVBQWUsRUFBRTtZQUN4QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7U0FDN0I7UUFDRCxJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUFpRTtRQUN4RixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7WUFDakMsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7WUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7WUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7U0FDMUI7YUFDSSxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQy9DLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO1NBQzlCO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztZQUNqQyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7WUFDNUIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1lBQzVCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztTQUM3QjtJQUNILENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBYTtRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7O0FBcEdILDhGQXFHQzs7O0FBRUQ7O0VBRUU7QUFDRixNQUFhLGtCQUFtQixTQUFRLEtBQUssQ0FBQyxpQkFBaUI7SUFPN0QsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQ7Ozs7OztNQU1FO0lBQ0YsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBZ0M7UUFDL0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSw2QkFBNkI7WUFDcEQsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxRQUFRO2dCQUN0QixlQUFlLEVBQUUsUUFBUTtnQkFDekIseUJBQXlCLEVBQUUsUUFBUTthQUNwQztZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixZQUFZLEVBQUUsTUFBTSxDQUFDLFlBQVk7WUFDakMsVUFBVSxFQUFFLE1BQU0sQ0FBQyxVQUFVO1lBQzdCLE9BQU8sRUFBRSxNQUFNLENBQUMsT0FBTztTQUN4QixDQUFDLENBQUM7UUFtS0wsdUVBQXVFO1FBQy9ELHFCQUFnQixHQUFHLElBQUksZ0RBQWdELENBQUMsSUFBSSxFQUFFLG1CQUFtQixDQUFDLENBQUM7UUFlM0csd0VBQXdFO1FBQ2hFLHNCQUFpQixHQUFHLElBQUksaURBQWlELENBQUMsSUFBSSxFQUFFLG9CQUFvQixDQUFDLENBQUM7UUFlOUcsdUVBQXVFO1FBQy9ELHFCQUFnQixHQUFHLElBQUksZ0RBQWdELENBQUMsSUFBSSxFQUFFLG1CQUFtQixDQUFDLENBQUM7UUFlM0csd0VBQXdFO1FBQ2hFLHNCQUFpQixHQUFHLElBQUksaURBQWlELENBQUMsSUFBSSxFQUFFLG9CQUFvQixDQUFDLENBQUM7UUFlOUcsZ0VBQWdFO1FBQ3hELGVBQVUsR0FBRyxJQUFJLDBDQUEwQyxDQUFDLElBQUksRUFBRSxZQUFZLENBQUMsQ0FBQztRQWV4RixzRUFBc0U7UUFDOUQsb0JBQWUsR0FBRyxJQUFJLCtDQUErQyxDQUFDLElBQUksRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO1FBZXhHLHNFQUFzRTtRQUM5RCxvQkFBZSxHQUFHLElBQUksK0NBQStDLENBQUMsSUFBSSxFQUFFLGtCQUFrQixDQUFDLENBQUM7UUFleEcsOERBQThEO1FBQ3RELGNBQVMsR0FBRyxJQUFJLHlDQUF5QyxDQUFDLElBQUksRUFBRSxVQUFVLENBQUMsQ0FBQztRQW5SbEYsSUFBSSxDQUFDLGlCQUFpQixHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqRCxJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLGlCQUFpQixHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqRCxJQUFJLENBQUMsR0FBRyxHQUFHLE1BQU0sQ0FBQyxFQUFFLENBQUM7UUFDckIsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7UUFDckMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQztRQUNyRCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxlQUFlLENBQUM7UUFDN0QsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsZ0JBQWdCLENBQUM7UUFDL0QsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsZUFBZSxDQUFDO1FBQzdELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQy9ELElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxTQUFTLENBQUM7UUFDakQsSUFBSSxDQUFDLGVBQWUsQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUMzRCxJQUFJLENBQUMsZUFBZSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsY0FBYyxDQUFDO1FBQzNELElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7SUFDakQsQ0FBQztJQVFELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBYTtRQUN2QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO0lBQ2pDLENBQUM7SUFDTSxxQkFBcUI7UUFDMUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFNBQVMsQ0FBQztJQUNyQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFFRCx3RUFBd0U7SUFDeEUsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFhO1FBQ2xDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7SUFDaEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBYTtRQUN2QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO0lBQ2pDLENBQUM7SUFDTSxxQkFBcUI7UUFDMUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFNBQVMsQ0FBQztJQUNyQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFJRCxJQUFXLEVBQUU7UUFDWCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBQ0QsSUFBVyxFQUFFLENBQUMsS0FBYTtRQUN6QixJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQztJQUNuQixDQUFDO0lBQ00sT0FBTztRQUNaLElBQUksQ0FBQyxHQUFHLEdBQUcsU0FBUyxDQUFDO0lBQ3ZCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEdBQUcsQ0FBQztJQUNsQixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFJRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUNELElBQVcsT0FBTyxDQUFDLEtBQWE7UUFDOUIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxTQUFTLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFFRCwrREFBK0Q7SUFDL0QsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUNELElBQVcsVUFBVSxDQUFDLEtBQWE7UUFDakMsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7SUFDM0IsQ0FBQztJQUNNLGVBQWU7UUFDcEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxTQUFTLENBQUM7SUFDL0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7SUFFRCwwREFBMEQ7SUFDMUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUlELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEQsQ0FBQztJQUNELElBQVcsa0JBQWtCLENBQUMsS0FBYTtRQUN6QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO0lBQ25DLENBQUM7SUFDTSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLG1CQUFtQixHQUFHLFNBQVMsQ0FBQztJQUN2QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ2xDLENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUNNLGtCQUFrQixDQUFDLEtBQXdDO1FBQ2hFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzlDLENBQUM7SUFDTSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDbEQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLENBQUM7SUFDN0MsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFDTSxtQkFBbUIsQ0FBQyxLQUF5QztRQUNsRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUMvQyxDQUFDO0lBQ00scUJBQXFCO1FBQzFCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ25ELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxDQUFDO0lBQzlDLENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUNNLGtCQUFrQixDQUFDLEtBQXdDO1FBQ2hFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzlDLENBQUM7SUFDTSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDbEQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLENBQUM7SUFDN0MsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFDTSxtQkFBbUIsQ0FBQyxLQUF5QztRQUNsRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUMvQyxDQUFDO0lBQ00scUJBQXFCO1FBQzFCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ25ELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxDQUFDO0lBQzlDLENBQUM7SUFJRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFDTSxZQUFZLENBQUMsS0FBa0M7UUFDcEQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQ3hDLENBQUM7SUFDTSxjQUFjO1FBQ25CLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUM1QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDO0lBQ3ZDLENBQUM7SUFJRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFDTSxpQkFBaUIsQ0FBQyxLQUF1QztRQUM5RCxJQUFJLENBQUMsZUFBZSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDN0MsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDakQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUMsYUFBYSxDQUFDO0lBQzVDLENBQUM7SUFJRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFDTSxpQkFBaUIsQ0FBQyxLQUF1QztRQUM5RCxJQUFJLENBQUMsZUFBZSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDN0MsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDakQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUMsYUFBYSxDQUFDO0lBQzVDLENBQUM7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFDTSxXQUFXLENBQUMsS0FBaUM7UUFDbEQsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQ3ZDLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUMzQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDO0lBQ3RDLENBQUM7SUFFRCxZQUFZO0lBQ1osWUFBWTtJQUNaLFlBQVk7SUFFRixvQkFBb0I7UUFDNUIsT0FBTztZQUNMLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUM7WUFDbkUsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO1lBQ3ZELGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUM7WUFDbEUsRUFBRSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO1lBQ3JDLElBQUksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUN6QyxPQUFPLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7WUFDL0MsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3RELG1CQUFtQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUM7WUFDdEUsaUJBQWlCLEVBQUUsNENBQTRDLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGFBQWEsQ0FBQztZQUNwRyxrQkFBa0IsRUFBRSw2Q0FBNkMsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxDQUFDO1lBQ3ZHLGlCQUFpQixFQUFFLDRDQUE0QyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLENBQUM7WUFDcEcsa0JBQWtCLEVBQUUsNkNBQTZDLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsQ0FBQztZQUN2RyxVQUFVLEVBQUUsc0NBQXNDLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7WUFDakYsZ0JBQWdCLEVBQUUsMkNBQTJDLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxhQUFhLENBQUM7WUFDakcsZ0JBQWdCLEVBQUUsMkNBQTJDLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxhQUFhLENBQUM7WUFDakcsUUFBUSxFQUFFLHFDQUFxQyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDO1NBQzlFLENBQUM7SUFDSixDQUFDOztBQTNWSCxnREE0VkM7OztBQTFWQyxvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNHLGlDQUFjLEdBQUcsNkJBQTZCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2tcbi8vIGdlbmVyYXRlZCBmcm9tIHRlcnJhZm9ybSByZXNvdXJjZSBzY2hlbWFcblxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBjZGt0ZiBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBDb21wdXRlSGVhbHRoQ2hlY2tDb25maWcgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1NZXRhQXJndW1lbnRzIHtcbiAgLyoqXG4gICogSG93IG9mdGVuIChpbiBzZWNvbmRzKSB0byBzZW5kIGEgaGVhbHRoIGNoZWNrLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyA1XG5zZWNvbmRzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI2NoZWNrX2ludGVydmFsX3NlYyBDb21wdXRlSGVhbHRoQ2hlY2sjY2hlY2tfaW50ZXJ2YWxfc2VjfVxuICAqL1xuICByZWFkb25seSBjaGVja0ludGVydmFsU2VjPzogbnVtYmVyO1xuICAvKipcbiAgKiBBbiBvcHRpb25hbCBkZXNjcmlwdGlvbiBvZiB0aGlzIHJlc291cmNlLiBQcm92aWRlIHRoaXMgcHJvcGVydHkgd2hlblxueW91IGNyZWF0ZSB0aGUgcmVzb3VyY2UuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjZGVzY3JpcHRpb24gQ29tcHV0ZUhlYWx0aENoZWNrI2Rlc2NyaXB0aW9ufVxuICAqL1xuICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcbiAgLyoqXG4gICogQSBzby1mYXIgdW5oZWFsdGh5IGluc3RhbmNlIHdpbGwgYmUgbWFya2VkIGhlYWx0aHkgYWZ0ZXIgdGhpcyBtYW55XG5jb25zZWN1dGl2ZSBzdWNjZXNzZXMuIFRoZSBkZWZhdWx0IHZhbHVlIGlzIDIuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjaGVhbHRoeV90aHJlc2hvbGQgQ29tcHV0ZUhlYWx0aENoZWNrI2hlYWx0aHlfdGhyZXNob2xkfVxuICAqL1xuICByZWFkb25seSBoZWFsdGh5VGhyZXNob2xkPzogbnVtYmVyO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNpZCBDb21wdXRlSGVhbHRoQ2hlY2sjaWR9XG4gICpcbiAgKiBQbGVhc2UgYmUgYXdhcmUgdGhhdCB0aGUgaWQgZmllbGQgaXMgYXV0b21hdGljYWxseSBhZGRlZCB0byBhbGwgcmVzb3VyY2VzIGluIFRlcnJhZm9ybSBwcm92aWRlcnMgdXNpbmcgYSBUZXJyYWZvcm0gcHJvdmlkZXIgU0RLIHZlcnNpb24gYmVsb3cgMi5cbiAgKiBJZiB5b3UgZXhwZXJpZW5jZSBwcm9ibGVtcyBzZXR0aW5nIHRoaXMgdmFsdWUgaXQgbWlnaHQgbm90IGJlIHNldHRhYmxlLiBQbGVhc2UgdGFrZSBhIGxvb2sgYXQgdGhlIHByb3ZpZGVyIGRvY3VtZW50YXRpb24gdG8gZW5zdXJlIGl0IHNob3VsZCBiZSBzZXR0YWJsZS5cbiAgKi9cbiAgcmVhZG9ubHkgaWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIE5hbWUgb2YgdGhlIHJlc291cmNlLiBQcm92aWRlZCBieSB0aGUgY2xpZW50IHdoZW4gdGhlIHJlc291cmNlIGlzXG5jcmVhdGVkLiBUaGUgbmFtZSBtdXN0IGJlIDEtNjMgY2hhcmFjdGVycyBsb25nLCBhbmQgY29tcGx5IHdpdGhcblJGQzEwMzUuICBTcGVjaWZpY2FsbHksIHRoZSBuYW1lIG11c3QgYmUgMS02MyBjaGFyYWN0ZXJzIGxvbmcgYW5kXG5tYXRjaCB0aGUgcmVndWxhciBleHByZXNzaW9uICdbYS16XShbLWEtejAtOV0qW2EtejAtOV0pPycgd2hpY2ggbWVhbnNcbnRoZSBmaXJzdCBjaGFyYWN0ZXIgbXVzdCBiZSBhIGxvd2VyY2FzZSBsZXR0ZXIsIGFuZCBhbGwgZm9sbG93aW5nXG5jaGFyYWN0ZXJzIG11c3QgYmUgYSBkYXNoLCBsb3dlcmNhc2UgbGV0dGVyLCBvciBkaWdpdCwgZXhjZXB0IHRoZVxubGFzdCBjaGFyYWN0ZXIsIHdoaWNoIGNhbm5vdCBiZSBhIGRhc2guXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjbmFtZSBDb21wdXRlSGVhbHRoQ2hlY2sjbmFtZX1cbiAgKi9cbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNwcm9qZWN0IENvbXB1dGVIZWFsdGhDaGVjayNwcm9qZWN0fVxuICAqL1xuICByZWFkb25seSBwcm9qZWN0Pzogc3RyaW5nO1xuICAvKipcbiAgKiBIb3cgbG9uZyAoaW4gc2Vjb25kcykgdG8gd2FpdCBiZWZvcmUgY2xhaW1pbmcgZmFpbHVyZS5cblRoZSBkZWZhdWx0IHZhbHVlIGlzIDUgc2Vjb25kcy4gIEl0IGlzIGludmFsaWQgZm9yIHRpbWVvdXRTZWMgdG8gaGF2ZVxuZ3JlYXRlciB2YWx1ZSB0aGFuIGNoZWNrSW50ZXJ2YWxTZWMuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjdGltZW91dF9zZWMgQ29tcHV0ZUhlYWx0aENoZWNrI3RpbWVvdXRfc2VjfVxuICAqL1xuICByZWFkb25seSB0aW1lb3V0U2VjPzogbnVtYmVyO1xuICAvKipcbiAgKiBBIHNvLWZhciBoZWFsdGh5IGluc3RhbmNlIHdpbGwgYmUgbWFya2VkIHVuaGVhbHRoeSBhZnRlciB0aGlzIG1hbnlcbmNvbnNlY3V0aXZlIGZhaWx1cmVzLiBUaGUgZGVmYXVsdCB2YWx1ZSBpcyAyLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3VuaGVhbHRoeV90aHJlc2hvbGQgQ29tcHV0ZUhlYWx0aENoZWNrI3VuaGVhbHRoeV90aHJlc2hvbGR9XG4gICovXG4gIHJlYWRvbmx5IHVuaGVhbHRoeVRocmVzaG9sZD86IG51bWJlcjtcbiAgLyoqXG4gICogZ3JwY19oZWFsdGhfY2hlY2sgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNncnBjX2hlYWx0aF9jaGVjayBDb21wdXRlSGVhbHRoQ2hlY2sjZ3JwY19oZWFsdGhfY2hlY2t9XG4gICovXG4gIHJlYWRvbmx5IGdycGNIZWFsdGhDaGVjaz86IENvbXB1dGVIZWFsdGhDaGVja0dycGNIZWFsdGhDaGVjaztcbiAgLyoqXG4gICogaHR0cDJfaGVhbHRoX2NoZWNrIGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjaHR0cDJfaGVhbHRoX2NoZWNrIENvbXB1dGVIZWFsdGhDaGVjayNodHRwMl9oZWFsdGhfY2hlY2t9XG4gICovXG4gIHJlYWRvbmx5IGh0dHAySGVhbHRoQ2hlY2s/OiBDb21wdXRlSGVhbHRoQ2hlY2tIdHRwMkhlYWx0aENoZWNrO1xuICAvKipcbiAgKiBodHRwX2hlYWx0aF9jaGVjayBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI2h0dHBfaGVhbHRoX2NoZWNrIENvbXB1dGVIZWFsdGhDaGVjayNodHRwX2hlYWx0aF9jaGVja31cbiAgKi9cbiAgcmVhZG9ubHkgaHR0cEhlYWx0aENoZWNrPzogQ29tcHV0ZUhlYWx0aENoZWNrSHR0cEhlYWx0aENoZWNrO1xuICAvKipcbiAgKiBodHRwc19oZWFsdGhfY2hlY2sgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNodHRwc19oZWFsdGhfY2hlY2sgQ29tcHV0ZUhlYWx0aENoZWNrI2h0dHBzX2hlYWx0aF9jaGVja31cbiAgKi9cbiAgcmVhZG9ubHkgaHR0cHNIZWFsdGhDaGVjaz86IENvbXB1dGVIZWFsdGhDaGVja0h0dHBzSGVhbHRoQ2hlY2s7XG4gIC8qKlxuICAqIGxvZ19jb25maWcgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNsb2dfY29uZmlnIENvbXB1dGVIZWFsdGhDaGVjayNsb2dfY29uZmlnfVxuICAqL1xuICByZWFkb25seSBsb2dDb25maWc/OiBDb21wdXRlSGVhbHRoQ2hlY2tMb2dDb25maWc7XG4gIC8qKlxuICAqIHNzbF9oZWFsdGhfY2hlY2sgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNzc2xfaGVhbHRoX2NoZWNrIENvbXB1dGVIZWFsdGhDaGVjayNzc2xfaGVhbHRoX2NoZWNrfVxuICAqL1xuICByZWFkb25seSBzc2xIZWFsdGhDaGVjaz86IENvbXB1dGVIZWFsdGhDaGVja1NzbEhlYWx0aENoZWNrO1xuICAvKipcbiAgKiB0Y3BfaGVhbHRoX2NoZWNrIGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjdGNwX2hlYWx0aF9jaGVjayBDb21wdXRlSGVhbHRoQ2hlY2sjdGNwX2hlYWx0aF9jaGVja31cbiAgKi9cbiAgcmVhZG9ubHkgdGNwSGVhbHRoQ2hlY2s/OiBDb21wdXRlSGVhbHRoQ2hlY2tUY3BIZWFsdGhDaGVjaztcbiAgLyoqXG4gICogdGltZW91dHMgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayN0aW1lb3V0cyBDb21wdXRlSGVhbHRoQ2hlY2sjdGltZW91dHN9XG4gICovXG4gIHJlYWRvbmx5IHRpbWVvdXRzPzogQ29tcHV0ZUhlYWx0aENoZWNrVGltZW91dHM7XG59XG5leHBvcnQgaW50ZXJmYWNlIENvbXB1dGVIZWFsdGhDaGVja0dycGNIZWFsdGhDaGVjayB7XG4gIC8qKlxuICAqIFRoZSBnUlBDIHNlcnZpY2UgbmFtZSBmb3IgdGhlIGhlYWx0aCBjaGVjay5cblRoZSB2YWx1ZSBvZiBncnBjU2VydmljZU5hbWUgaGFzIHRoZSBmb2xsb3dpbmcgbWVhbmluZ3MgYnkgY29udmVudGlvbjpcbiAgLSBFbXB0eSBzZXJ2aWNlTmFtZSBtZWFucyB0aGUgb3ZlcmFsbCBzdGF0dXMgb2YgYWxsIHNlcnZpY2VzIGF0IHRoZSBiYWNrZW5kLlxuICAtIE5vbi1lbXB0eSBzZXJ2aWNlTmFtZSBtZWFucyB0aGUgaGVhbHRoIG9mIHRoYXQgZ1JQQyBzZXJ2aWNlLCBhcyBkZWZpbmVkIGJ5IHRoZSBvd25lciBvZiB0aGUgc2VydmljZS5cblRoZSBncnBjU2VydmljZU5hbWUgY2FuIG9ubHkgYmUgQVNDSUkuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjZ3JwY19zZXJ2aWNlX25hbWUgQ29tcHV0ZUhlYWx0aENoZWNrI2dycGNfc2VydmljZV9uYW1lfVxuICAqL1xuICByZWFkb25seSBncnBjU2VydmljZU5hbWU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBwb3J0IG51bWJlciBmb3IgdGhlIGhlYWx0aCBjaGVjayByZXF1ZXN0LlxuTXVzdCBiZSBzcGVjaWZpZWQgaWYgcG9ydE5hbWUgYW5kIHBvcnRTcGVjaWZpY2F0aW9uIGFyZSBub3Qgc2V0XG5vciBpZiBwb3J0X3NwZWNpZmljYXRpb24gaXMgVVNFX0ZJWEVEX1BPUlQuIFZhbGlkIHZhbHVlcyBhcmUgMSB0aHJvdWdoIDY1NTM1LlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3BvcnQgQ29tcHV0ZUhlYWx0aENoZWNrI3BvcnR9XG4gICovXG4gIHJlYWRvbmx5IHBvcnQ/OiBudW1iZXI7XG4gIC8qKlxuICAqIFBvcnQgbmFtZSBhcyBkZWZpbmVkIGluIEluc3RhbmNlR3JvdXAjTmFtZWRQb3J0I25hbWUuIElmIGJvdGggcG9ydCBhbmRcbnBvcnRfbmFtZSBhcmUgZGVmaW5lZCwgcG9ydCB0YWtlcyBwcmVjZWRlbmNlLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3BvcnRfbmFtZSBDb21wdXRlSGVhbHRoQ2hlY2sjcG9ydF9uYW1lfVxuICAqL1xuICByZWFkb25seSBwb3J0TmFtZT86IHN0cmluZztcbiAgLyoqXG4gICogU3BlY2lmaWVzIGhvdyBwb3J0IGlzIHNlbGVjdGVkIGZvciBoZWFsdGggY2hlY2tpbmcsIGNhbiBiZSBvbmUgb2YgdGhlXG5mb2xsb3dpbmcgdmFsdWVzOlxuXG4gICogJ1VTRV9GSVhFRF9QT1JUJzogVGhlIHBvcnQgbnVtYmVyIGluICdwb3J0JyBpcyB1c2VkIGZvciBoZWFsdGggY2hlY2tpbmcuXG5cbiAgKiAnVVNFX05BTUVEX1BPUlQnOiBUaGUgJ3BvcnROYW1lJyBpcyB1c2VkIGZvciBoZWFsdGggY2hlY2tpbmcuXG5cbiAgKiAnVVNFX1NFUlZJTkdfUE9SVCc6IEZvciBOZXR3b3JrRW5kcG9pbnRHcm91cCwgdGhlIHBvcnQgc3BlY2lmaWVkIGZvciBlYWNoXG4gIG5ldHdvcmsgZW5kcG9pbnQgaXMgdXNlZCBmb3IgaGVhbHRoIGNoZWNraW5nLiBGb3Igb3RoZXIgYmFja2VuZHMsIHRoZVxuICBwb3J0IG9yIG5hbWVkIHBvcnQgc3BlY2lmaWVkIGluIHRoZSBCYWNrZW5kIFNlcnZpY2UgaXMgdXNlZCBmb3IgaGVhbHRoXG4gIGNoZWNraW5nLlxuXG5JZiBub3Qgc3BlY2lmaWVkLCBnUlBDIGhlYWx0aCBjaGVjayBmb2xsb3dzIGJlaGF2aW9yIHNwZWNpZmllZCBpbiAncG9ydCcgYW5kXG4ncG9ydE5hbWUnIGZpZWxkcy4gUG9zc2libGUgdmFsdWVzOiBbXCJVU0VfRklYRURfUE9SVFwiLCBcIlVTRV9OQU1FRF9QT1JUXCIsIFwiVVNFX1NFUlZJTkdfUE9SVFwiXVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3BvcnRfc3BlY2lmaWNhdGlvbiBDb21wdXRlSGVhbHRoQ2hlY2sjcG9ydF9zcGVjaWZpY2F0aW9ufVxuICAqL1xuICByZWFkb25seSBwb3J0U3BlY2lmaWNhdGlvbj86IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNvbXB1dGVIZWFsdGhDaGVja0dycGNIZWFsdGhDaGVja1RvVGVycmFmb3JtKHN0cnVjdD86IENvbXB1dGVIZWFsdGhDaGVja0dycGNIZWFsdGhDaGVja091dHB1dFJlZmVyZW5jZSB8IENvbXB1dGVIZWFsdGhDaGVja0dycGNIZWFsdGhDaGVjayk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBncnBjX3NlcnZpY2VfbmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5ncnBjU2VydmljZU5hbWUpLFxuICAgIHBvcnQ6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEucG9ydCksXG4gICAgcG9ydF9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnBvcnROYW1lKSxcbiAgICBwb3J0X3NwZWNpZmljYXRpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEucG9ydFNwZWNpZmljYXRpb24pLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBDb21wdXRlSGVhbHRoQ2hlY2tHcnBjSGVhbHRoQ2hlY2tPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IENvbXB1dGVIZWFsdGhDaGVja0dycGNIZWFsdGhDaGVjayB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fZ3JwY1NlcnZpY2VOYW1lICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmdycGNTZXJ2aWNlTmFtZSA9IHRoaXMuX2dycGNTZXJ2aWNlTmFtZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3BvcnQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucG9ydCA9IHRoaXMuX3BvcnQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl9wb3J0TmFtZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wb3J0TmFtZSA9IHRoaXMuX3BvcnROYW1lO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcG9ydFNwZWNpZmljYXRpb24gIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucG9ydFNwZWNpZmljYXRpb24gPSB0aGlzLl9wb3J0U3BlY2lmaWNhdGlvbjtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IENvbXB1dGVIZWFsdGhDaGVja0dycGNIZWFsdGhDaGVjayB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX2dycGNTZXJ2aWNlTmFtZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3BvcnQgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9wb3J0TmFtZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9ncnBjU2VydmljZU5hbWUgPSB2YWx1ZS5ncnBjU2VydmljZU5hbWU7XG4gICAgICB0aGlzLl9wb3J0ID0gdmFsdWUucG9ydDtcbiAgICAgIHRoaXMuX3BvcnROYW1lID0gdmFsdWUucG9ydE5hbWU7XG4gICAgICB0aGlzLl9wb3J0U3BlY2lmaWNhdGlvbiA9IHZhbHVlLnBvcnRTcGVjaWZpY2F0aW9uO1xuICAgIH1cbiAgfVxuXG4gIC8vIGdycGNfc2VydmljZV9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2dycGNTZXJ2aWNlTmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZ3JwY1NlcnZpY2VOYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZ3JwY19zZXJ2aWNlX25hbWUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGdycGNTZXJ2aWNlTmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZ3JwY1NlcnZpY2VOYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0R3JwY1NlcnZpY2VOYW1lKCkge1xuICAgIHRoaXMuX2dycGNTZXJ2aWNlTmFtZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZ3JwY1NlcnZpY2VOYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2dycGNTZXJ2aWNlTmFtZTtcbiAgfVxuXG4gIC8vIHBvcnQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcG9ydD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgcG9ydCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ3BvcnQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHBvcnQodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX3BvcnQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQb3J0KCkge1xuICAgIHRoaXMuX3BvcnQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBvcnRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcG9ydDtcbiAgfVxuXG4gIC8vIHBvcnRfbmFtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wb3J0TmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcG9ydE5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdwb3J0X25hbWUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHBvcnROYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9wb3J0TmFtZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFBvcnROYW1lKCkge1xuICAgIHRoaXMuX3BvcnROYW1lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwb3J0TmFtZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wb3J0TmFtZTtcbiAgfVxuXG4gIC8vIHBvcnRfc3BlY2lmaWNhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wb3J0U3BlY2lmaWNhdGlvbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcG9ydFNwZWNpZmljYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdwb3J0X3NwZWNpZmljYXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IHBvcnRTcGVjaWZpY2F0aW9uKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9wb3J0U3BlY2lmaWNhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFBvcnRTcGVjaWZpY2F0aW9uKCkge1xuICAgIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwb3J0U3BlY2lmaWNhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wb3J0U3BlY2lmaWNhdGlvbjtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBDb21wdXRlSGVhbHRoQ2hlY2tIdHRwMkhlYWx0aENoZWNrIHtcbiAgLyoqXG4gICogVGhlIHZhbHVlIG9mIHRoZSBob3N0IGhlYWRlciBpbiB0aGUgSFRUUDIgaGVhbHRoIGNoZWNrIHJlcXVlc3QuXG5JZiBsZWZ0IGVtcHR5IChkZWZhdWx0IHZhbHVlKSwgdGhlIHB1YmxpYyBJUCBvbiBiZWhhbGYgb2Ygd2hpY2ggdGhpcyBoZWFsdGhcbmNoZWNrIGlzIHBlcmZvcm1lZCB3aWxsIGJlIHVzZWQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjaG9zdCBDb21wdXRlSGVhbHRoQ2hlY2sjaG9zdH1cbiAgKi9cbiAgcmVhZG9ubHkgaG9zdD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIFRDUCBwb3J0IG51bWJlciBmb3IgdGhlIEhUVFAyIGhlYWx0aCBjaGVjayByZXF1ZXN0LlxuVGhlIGRlZmF1bHQgdmFsdWUgaXMgNDQzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3BvcnQgQ29tcHV0ZUhlYWx0aENoZWNrI3BvcnR9XG4gICovXG4gIHJlYWRvbmx5IHBvcnQ/OiBudW1iZXI7XG4gIC8qKlxuICAqIFBvcnQgbmFtZSBhcyBkZWZpbmVkIGluIEluc3RhbmNlR3JvdXAjTmFtZWRQb3J0I25hbWUuIElmIGJvdGggcG9ydCBhbmRcbnBvcnRfbmFtZSBhcmUgZGVmaW5lZCwgcG9ydCB0YWtlcyBwcmVjZWRlbmNlLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3BvcnRfbmFtZSBDb21wdXRlSGVhbHRoQ2hlY2sjcG9ydF9uYW1lfVxuICAqL1xuICByZWFkb25seSBwb3J0TmFtZT86IHN0cmluZztcbiAgLyoqXG4gICogU3BlY2lmaWVzIGhvdyBwb3J0IGlzIHNlbGVjdGVkIGZvciBoZWFsdGggY2hlY2tpbmcsIGNhbiBiZSBvbmUgb2YgdGhlXG5mb2xsb3dpbmcgdmFsdWVzOlxuXG4gICogJ1VTRV9GSVhFRF9QT1JUJzogVGhlIHBvcnQgbnVtYmVyIGluICdwb3J0JyBpcyB1c2VkIGZvciBoZWFsdGggY2hlY2tpbmcuXG5cbiAgKiAnVVNFX05BTUVEX1BPUlQnOiBUaGUgJ3BvcnROYW1lJyBpcyB1c2VkIGZvciBoZWFsdGggY2hlY2tpbmcuXG5cbiAgKiAnVVNFX1NFUlZJTkdfUE9SVCc6IEZvciBOZXR3b3JrRW5kcG9pbnRHcm91cCwgdGhlIHBvcnQgc3BlY2lmaWVkIGZvciBlYWNoXG4gIG5ldHdvcmsgZW5kcG9pbnQgaXMgdXNlZCBmb3IgaGVhbHRoIGNoZWNraW5nLiBGb3Igb3RoZXIgYmFja2VuZHMsIHRoZVxuICBwb3J0IG9yIG5hbWVkIHBvcnQgc3BlY2lmaWVkIGluIHRoZSBCYWNrZW5kIFNlcnZpY2UgaXMgdXNlZCBmb3IgaGVhbHRoXG4gIGNoZWNraW5nLlxuXG5JZiBub3Qgc3BlY2lmaWVkLCBIVFRQMiBoZWFsdGggY2hlY2sgZm9sbG93cyBiZWhhdmlvciBzcGVjaWZpZWQgaW4gJ3BvcnQnIGFuZFxuJ3BvcnROYW1lJyBmaWVsZHMuIFBvc3NpYmxlIHZhbHVlczogW1wiVVNFX0ZJWEVEX1BPUlRcIiwgXCJVU0VfTkFNRURfUE9SVFwiLCBcIlVTRV9TRVJWSU5HX1BPUlRcIl1cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNwb3J0X3NwZWNpZmljYXRpb24gQ29tcHV0ZUhlYWx0aENoZWNrI3BvcnRfc3BlY2lmaWNhdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgcG9ydFNwZWNpZmljYXRpb24/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFNwZWNpZmllcyB0aGUgdHlwZSBvZiBwcm94eSBoZWFkZXIgdG8gYXBwZW5kIGJlZm9yZSBzZW5kaW5nIGRhdGEgdG8gdGhlXG5iYWNrZW5kLiBEZWZhdWx0IHZhbHVlOiBcIk5PTkVcIiBQb3NzaWJsZSB2YWx1ZXM6IFtcIk5PTkVcIiwgXCJQUk9YWV9WMVwiXVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3Byb3h5X2hlYWRlciBDb21wdXRlSGVhbHRoQ2hlY2sjcHJveHlfaGVhZGVyfVxuICAqL1xuICByZWFkb25seSBwcm94eUhlYWRlcj86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIHJlcXVlc3QgcGF0aCBvZiB0aGUgSFRUUDIgaGVhbHRoIGNoZWNrIHJlcXVlc3QuXG5UaGUgZGVmYXVsdCB2YWx1ZSBpcyAvLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3JlcXVlc3RfcGF0aCBDb21wdXRlSGVhbHRoQ2hlY2sjcmVxdWVzdF9wYXRofVxuICAqL1xuICByZWFkb25seSByZXF1ZXN0UGF0aD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIGJ5dGVzIHRvIG1hdGNoIGFnYWluc3QgdGhlIGJlZ2lubmluZyBvZiB0aGUgcmVzcG9uc2UgZGF0YS4gSWYgbGVmdCBlbXB0eVxuKHRoZSBkZWZhdWx0IHZhbHVlKSwgYW55IHJlc3BvbnNlIHdpbGwgaW5kaWNhdGUgaGVhbHRoLiBUaGUgcmVzcG9uc2UgZGF0YVxuY2FuIG9ubHkgYmUgQVNDSUkuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjcmVzcG9uc2UgQ29tcHV0ZUhlYWx0aENoZWNrI3Jlc3BvbnNlfVxuICAqL1xuICByZWFkb25seSByZXNwb25zZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNvbXB1dGVIZWFsdGhDaGVja0h0dHAySGVhbHRoQ2hlY2tUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBDb21wdXRlSGVhbHRoQ2hlY2tIdHRwMkhlYWx0aENoZWNrT3V0cHV0UmVmZXJlbmNlIHwgQ29tcHV0ZUhlYWx0aENoZWNrSHR0cDJIZWFsdGhDaGVjayk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBob3N0OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLmhvc3QpLFxuICAgIHBvcnQ6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEucG9ydCksXG4gICAgcG9ydF9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnBvcnROYW1lKSxcbiAgICBwb3J0X3NwZWNpZmljYXRpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEucG9ydFNwZWNpZmljYXRpb24pLFxuICAgIHByb3h5X2hlYWRlcjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5wcm94eUhlYWRlciksXG4gICAgcmVxdWVzdF9wYXRoOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnJlcXVlc3RQYXRoKSxcbiAgICByZXNwb25zZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5yZXNwb25zZSksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIENvbXB1dGVIZWFsdGhDaGVja0h0dHAySGVhbHRoQ2hlY2tPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IENvbXB1dGVIZWFsdGhDaGVja0h0dHAySGVhbHRoQ2hlY2sgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2hvc3QgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuaG9zdCA9IHRoaXMuX2hvc3Q7XG4gICAgfVxuICAgIGlmICh0aGlzLl9wb3J0ICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnBvcnQgPSB0aGlzLl9wb3J0O1xuICAgIH1cbiAgICBpZiAodGhpcy5fcG9ydE5hbWUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucG9ydE5hbWUgPSB0aGlzLl9wb3J0TmFtZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnBvcnRTcGVjaWZpY2F0aW9uID0gdGhpcy5fcG9ydFNwZWNpZmljYXRpb247XG4gICAgfVxuICAgIGlmICh0aGlzLl9wcm94eUhlYWRlciAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wcm94eUhlYWRlciA9IHRoaXMuX3Byb3h5SGVhZGVyO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcmVxdWVzdFBhdGggIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucmVxdWVzdFBhdGggPSB0aGlzLl9yZXF1ZXN0UGF0aDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3Jlc3BvbnNlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnJlc3BvbnNlID0gdGhpcy5fcmVzcG9uc2U7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBDb21wdXRlSGVhbHRoQ2hlY2tIdHRwMkhlYWx0aENoZWNrIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5faG9zdCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3BvcnQgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9wb3J0TmFtZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fcHJveHlIZWFkZXIgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9yZXF1ZXN0UGF0aCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3Jlc3BvbnNlID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9ob3N0ID0gdmFsdWUuaG9zdDtcbiAgICAgIHRoaXMuX3BvcnQgPSB2YWx1ZS5wb3J0O1xuICAgICAgdGhpcy5fcG9ydE5hbWUgPSB2YWx1ZS5wb3J0TmFtZTtcbiAgICAgIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uID0gdmFsdWUucG9ydFNwZWNpZmljYXRpb247XG4gICAgICB0aGlzLl9wcm94eUhlYWRlciA9IHZhbHVlLnByb3h5SGVhZGVyO1xuICAgICAgdGhpcy5fcmVxdWVzdFBhdGggPSB2YWx1ZS5yZXF1ZXN0UGF0aDtcbiAgICAgIHRoaXMuX3Jlc3BvbnNlID0gdmFsdWUucmVzcG9uc2U7XG4gICAgfVxuICB9XG5cbiAgLy8gaG9zdCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9ob3N0Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBob3N0KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaG9zdCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaG9zdCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5faG9zdCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEhvc3QoKSB7XG4gICAgdGhpcy5faG9zdCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaG9zdElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9ob3N0O1xuICB9XG5cbiAgLy8gcG9ydCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wb3J0PzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBwb3J0KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgncG9ydCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fcG9ydCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFBvcnQoKSB7XG4gICAgdGhpcy5fcG9ydCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcG9ydElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wb3J0O1xuICB9XG5cbiAgLy8gcG9ydF9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3BvcnROYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwb3J0TmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3BvcnRfbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydE5hbWUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3BvcnROYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UG9ydE5hbWUoKSB7XG4gICAgdGhpcy5fcG9ydE5hbWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBvcnROYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BvcnROYW1lO1xuICB9XG5cbiAgLy8gcG9ydF9zcGVjaWZpY2F0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3BvcnRTcGVjaWZpY2F0aW9uPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwb3J0U3BlY2lmaWNhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3BvcnRfc3BlY2lmaWNhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydFNwZWNpZmljYXRpb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UG9ydFNwZWNpZmljYXRpb24oKSB7XG4gICAgdGhpcy5fcG9ydFNwZWNpZmljYXRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBvcnRTcGVjaWZpY2F0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uO1xuICB9XG5cbiAgLy8gcHJveHlfaGVhZGVyIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Byb3h5SGVhZGVyPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwcm94eUhlYWRlcigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3Byb3h5X2hlYWRlcicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcHJveHlIZWFkZXIodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3Byb3h5SGVhZGVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UHJveHlIZWFkZXIoKSB7XG4gICAgdGhpcy5fcHJveHlIZWFkZXIgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHByb3h5SGVhZGVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Byb3h5SGVhZGVyO1xuICB9XG5cbiAgLy8gcmVxdWVzdF9wYXRoIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlcXVlc3RQYXRoPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCByZXF1ZXN0UGF0aCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3JlcXVlc3RfcGF0aCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVxdWVzdFBhdGgodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3JlcXVlc3RQYXRoID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVxdWVzdFBhdGgoKSB7XG4gICAgdGhpcy5fcmVxdWVzdFBhdGggPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJlcXVlc3RQYXRoSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlcXVlc3RQYXRoO1xuICB9XG5cbiAgLy8gcmVzcG9uc2UgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVzcG9uc2U/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHJlc3BvbnNlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncmVzcG9uc2UnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlc3BvbnNlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9yZXNwb25zZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJlc3BvbnNlKCkge1xuICAgIHRoaXMuX3Jlc3BvbnNlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXNwb25zZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZXNwb25zZTtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBDb21wdXRlSGVhbHRoQ2hlY2tIdHRwSGVhbHRoQ2hlY2sge1xuICAvKipcbiAgKiBUaGUgdmFsdWUgb2YgdGhlIGhvc3QgaGVhZGVyIGluIHRoZSBIVFRQIGhlYWx0aCBjaGVjayByZXF1ZXN0LlxuSWYgbGVmdCBlbXB0eSAoZGVmYXVsdCB2YWx1ZSksIHRoZSBwdWJsaWMgSVAgb24gYmVoYWxmIG9mIHdoaWNoIHRoaXMgaGVhbHRoXG5jaGVjayBpcyBwZXJmb3JtZWQgd2lsbCBiZSB1c2VkLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI2hvc3QgQ29tcHV0ZUhlYWx0aENoZWNrI2hvc3R9XG4gICovXG4gIHJlYWRvbmx5IGhvc3Q/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBUQ1AgcG9ydCBudW1iZXIgZm9yIHRoZSBIVFRQIGhlYWx0aCBjaGVjayByZXF1ZXN0LlxuVGhlIGRlZmF1bHQgdmFsdWUgaXMgODAuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjcG9ydCBDb21wdXRlSGVhbHRoQ2hlY2sjcG9ydH1cbiAgKi9cbiAgcmVhZG9ubHkgcG9ydD86IG51bWJlcjtcbiAgLyoqXG4gICogUG9ydCBuYW1lIGFzIGRlZmluZWQgaW4gSW5zdGFuY2VHcm91cCNOYW1lZFBvcnQjbmFtZS4gSWYgYm90aCBwb3J0IGFuZFxucG9ydF9uYW1lIGFyZSBkZWZpbmVkLCBwb3J0IHRha2VzIHByZWNlZGVuY2UuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjcG9ydF9uYW1lIENvbXB1dGVIZWFsdGhDaGVjayNwb3J0X25hbWV9XG4gICovXG4gIHJlYWRvbmx5IHBvcnROYW1lPzogc3RyaW5nO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgaG93IHBvcnQgaXMgc2VsZWN0ZWQgZm9yIGhlYWx0aCBjaGVja2luZywgY2FuIGJlIG9uZSBvZiB0aGVcbmZvbGxvd2luZyB2YWx1ZXM6XG5cbiAgKiAnVVNFX0ZJWEVEX1BPUlQnOiBUaGUgcG9ydCBudW1iZXIgaW4gJ3BvcnQnIGlzIHVzZWQgZm9yIGhlYWx0aCBjaGVja2luZy5cblxuICAqICdVU0VfTkFNRURfUE9SVCc6IFRoZSAncG9ydE5hbWUnIGlzIHVzZWQgZm9yIGhlYWx0aCBjaGVja2luZy5cblxuICAqICdVU0VfU0VSVklOR19QT1JUJzogRm9yIE5ldHdvcmtFbmRwb2ludEdyb3VwLCB0aGUgcG9ydCBzcGVjaWZpZWQgZm9yIGVhY2hcbiAgbmV0d29yayBlbmRwb2ludCBpcyB1c2VkIGZvciBoZWFsdGggY2hlY2tpbmcuIEZvciBvdGhlciBiYWNrZW5kcywgdGhlXG4gIHBvcnQgb3IgbmFtZWQgcG9ydCBzcGVjaWZpZWQgaW4gdGhlIEJhY2tlbmQgU2VydmljZSBpcyB1c2VkIGZvciBoZWFsdGhcbiAgY2hlY2tpbmcuXG5cbklmIG5vdCBzcGVjaWZpZWQsIEhUVFAgaGVhbHRoIGNoZWNrIGZvbGxvd3MgYmVoYXZpb3Igc3BlY2lmaWVkIGluICdwb3J0JyBhbmRcbidwb3J0TmFtZScgZmllbGRzLiBQb3NzaWJsZSB2YWx1ZXM6IFtcIlVTRV9GSVhFRF9QT1JUXCIsIFwiVVNFX05BTUVEX1BPUlRcIiwgXCJVU0VfU0VSVklOR19QT1JUXCJdXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjcG9ydF9zcGVjaWZpY2F0aW9uIENvbXB1dGVIZWFsdGhDaGVjayNwb3J0X3NwZWNpZmljYXRpb259XG4gICovXG4gIHJlYWRvbmx5IHBvcnRTcGVjaWZpY2F0aW9uPzogc3RyaW5nO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIHR5cGUgb2YgcHJveHkgaGVhZGVyIHRvIGFwcGVuZCBiZWZvcmUgc2VuZGluZyBkYXRhIHRvIHRoZVxuYmFja2VuZC4gRGVmYXVsdCB2YWx1ZTogXCJOT05FXCIgUG9zc2libGUgdmFsdWVzOiBbXCJOT05FXCIsIFwiUFJPWFlfVjFcIl1cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNwcm94eV9oZWFkZXIgQ29tcHV0ZUhlYWx0aENoZWNrI3Byb3h5X2hlYWRlcn1cbiAgKi9cbiAgcmVhZG9ubHkgcHJveHlIZWFkZXI/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSByZXF1ZXN0IHBhdGggb2YgdGhlIEhUVFAgaGVhbHRoIGNoZWNrIHJlcXVlc3QuXG5UaGUgZGVmYXVsdCB2YWx1ZSBpcyAvLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3JlcXVlc3RfcGF0aCBDb21wdXRlSGVhbHRoQ2hlY2sjcmVxdWVzdF9wYXRofVxuICAqL1xuICByZWFkb25seSByZXF1ZXN0UGF0aD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIGJ5dGVzIHRvIG1hdGNoIGFnYWluc3QgdGhlIGJlZ2lubmluZyBvZiB0aGUgcmVzcG9uc2UgZGF0YS4gSWYgbGVmdCBlbXB0eVxuKHRoZSBkZWZhdWx0IHZhbHVlKSwgYW55IHJlc3BvbnNlIHdpbGwgaW5kaWNhdGUgaGVhbHRoLiBUaGUgcmVzcG9uc2UgZGF0YVxuY2FuIG9ubHkgYmUgQVNDSUkuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjcmVzcG9uc2UgQ29tcHV0ZUhlYWx0aENoZWNrI3Jlc3BvbnNlfVxuICAqL1xuICByZWFkb25seSByZXNwb25zZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNvbXB1dGVIZWFsdGhDaGVja0h0dHBIZWFsdGhDaGVja1RvVGVycmFmb3JtKHN0cnVjdD86IENvbXB1dGVIZWFsdGhDaGVja0h0dHBIZWFsdGhDaGVja091dHB1dFJlZmVyZW5jZSB8IENvbXB1dGVIZWFsdGhDaGVja0h0dHBIZWFsdGhDaGVjayk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBob3N0OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLmhvc3QpLFxuICAgIHBvcnQ6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEucG9ydCksXG4gICAgcG9ydF9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnBvcnROYW1lKSxcbiAgICBwb3J0X3NwZWNpZmljYXRpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEucG9ydFNwZWNpZmljYXRpb24pLFxuICAgIHByb3h5X2hlYWRlcjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5wcm94eUhlYWRlciksXG4gICAgcmVxdWVzdF9wYXRoOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnJlcXVlc3RQYXRoKSxcbiAgICByZXNwb25zZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5yZXNwb25zZSksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIENvbXB1dGVIZWFsdGhDaGVja0h0dHBIZWFsdGhDaGVja091dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBmYWxzZSwgMCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogQ29tcHV0ZUhlYWx0aENoZWNrSHR0cEhlYWx0aENoZWNrIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9ob3N0ICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0Lmhvc3QgPSB0aGlzLl9ob3N0O1xuICAgIH1cbiAgICBpZiAodGhpcy5fcG9ydCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wb3J0ID0gdGhpcy5fcG9ydDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3BvcnROYW1lICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnBvcnROYW1lID0gdGhpcy5fcG9ydE5hbWU7XG4gICAgfVxuICAgIGlmICh0aGlzLl9wb3J0U3BlY2lmaWNhdGlvbiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wb3J0U3BlY2lmaWNhdGlvbiA9IHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcHJveHlIZWFkZXIgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucHJveHlIZWFkZXIgPSB0aGlzLl9wcm94eUhlYWRlcjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3JlcXVlc3RQYXRoICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnJlcXVlc3RQYXRoID0gdGhpcy5fcmVxdWVzdFBhdGg7XG4gICAgfVxuICAgIGlmICh0aGlzLl9yZXNwb25zZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5yZXNwb25zZSA9IHRoaXMuX3Jlc3BvbnNlO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogQ29tcHV0ZUhlYWx0aENoZWNrSHR0cEhlYWx0aENoZWNrIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5faG9zdCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3BvcnQgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9wb3J0TmFtZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fcHJveHlIZWFkZXIgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9yZXF1ZXN0UGF0aCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3Jlc3BvbnNlID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9ob3N0ID0gdmFsdWUuaG9zdDtcbiAgICAgIHRoaXMuX3BvcnQgPSB2YWx1ZS5wb3J0O1xuICAgICAgdGhpcy5fcG9ydE5hbWUgPSB2YWx1ZS5wb3J0TmFtZTtcbiAgICAgIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uID0gdmFsdWUucG9ydFNwZWNpZmljYXRpb247XG4gICAgICB0aGlzLl9wcm94eUhlYWRlciA9IHZhbHVlLnByb3h5SGVhZGVyO1xuICAgICAgdGhpcy5fcmVxdWVzdFBhdGggPSB2YWx1ZS5yZXF1ZXN0UGF0aDtcbiAgICAgIHRoaXMuX3Jlc3BvbnNlID0gdmFsdWUucmVzcG9uc2U7XG4gICAgfVxuICB9XG5cbiAgLy8gaG9zdCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9ob3N0Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBob3N0KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaG9zdCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaG9zdCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5faG9zdCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEhvc3QoKSB7XG4gICAgdGhpcy5faG9zdCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaG9zdElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9ob3N0O1xuICB9XG5cbiAgLy8gcG9ydCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wb3J0PzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBwb3J0KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgncG9ydCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fcG9ydCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFBvcnQoKSB7XG4gICAgdGhpcy5fcG9ydCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcG9ydElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wb3J0O1xuICB9XG5cbiAgLy8gcG9ydF9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3BvcnROYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwb3J0TmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3BvcnRfbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydE5hbWUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3BvcnROYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UG9ydE5hbWUoKSB7XG4gICAgdGhpcy5fcG9ydE5hbWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBvcnROYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BvcnROYW1lO1xuICB9XG5cbiAgLy8gcG9ydF9zcGVjaWZpY2F0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3BvcnRTcGVjaWZpY2F0aW9uPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwb3J0U3BlY2lmaWNhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3BvcnRfc3BlY2lmaWNhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydFNwZWNpZmljYXRpb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UG9ydFNwZWNpZmljYXRpb24oKSB7XG4gICAgdGhpcy5fcG9ydFNwZWNpZmljYXRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBvcnRTcGVjaWZpY2F0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uO1xuICB9XG5cbiAgLy8gcHJveHlfaGVhZGVyIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Byb3h5SGVhZGVyPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwcm94eUhlYWRlcigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3Byb3h5X2hlYWRlcicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcHJveHlIZWFkZXIodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3Byb3h5SGVhZGVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UHJveHlIZWFkZXIoKSB7XG4gICAgdGhpcy5fcHJveHlIZWFkZXIgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHByb3h5SGVhZGVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Byb3h5SGVhZGVyO1xuICB9XG5cbiAgLy8gcmVxdWVzdF9wYXRoIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlcXVlc3RQYXRoPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCByZXF1ZXN0UGF0aCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3JlcXVlc3RfcGF0aCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVxdWVzdFBhdGgodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3JlcXVlc3RQYXRoID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVxdWVzdFBhdGgoKSB7XG4gICAgdGhpcy5fcmVxdWVzdFBhdGggPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJlcXVlc3RQYXRoSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlcXVlc3RQYXRoO1xuICB9XG5cbiAgLy8gcmVzcG9uc2UgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVzcG9uc2U/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHJlc3BvbnNlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncmVzcG9uc2UnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlc3BvbnNlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9yZXNwb25zZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJlc3BvbnNlKCkge1xuICAgIHRoaXMuX3Jlc3BvbnNlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXNwb25zZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZXNwb25zZTtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBDb21wdXRlSGVhbHRoQ2hlY2tIdHRwc0hlYWx0aENoZWNrIHtcbiAgLyoqXG4gICogVGhlIHZhbHVlIG9mIHRoZSBob3N0IGhlYWRlciBpbiB0aGUgSFRUUFMgaGVhbHRoIGNoZWNrIHJlcXVlc3QuXG5JZiBsZWZ0IGVtcHR5IChkZWZhdWx0IHZhbHVlKSwgdGhlIHB1YmxpYyBJUCBvbiBiZWhhbGYgb2Ygd2hpY2ggdGhpcyBoZWFsdGhcbmNoZWNrIGlzIHBlcmZvcm1lZCB3aWxsIGJlIHVzZWQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjaG9zdCBDb21wdXRlSGVhbHRoQ2hlY2sjaG9zdH1cbiAgKi9cbiAgcmVhZG9ubHkgaG9zdD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIFRDUCBwb3J0IG51bWJlciBmb3IgdGhlIEhUVFBTIGhlYWx0aCBjaGVjayByZXF1ZXN0LlxuVGhlIGRlZmF1bHQgdmFsdWUgaXMgNDQzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3BvcnQgQ29tcHV0ZUhlYWx0aENoZWNrI3BvcnR9XG4gICovXG4gIHJlYWRvbmx5IHBvcnQ/OiBudW1iZXI7XG4gIC8qKlxuICAqIFBvcnQgbmFtZSBhcyBkZWZpbmVkIGluIEluc3RhbmNlR3JvdXAjTmFtZWRQb3J0I25hbWUuIElmIGJvdGggcG9ydCBhbmRcbnBvcnRfbmFtZSBhcmUgZGVmaW5lZCwgcG9ydCB0YWtlcyBwcmVjZWRlbmNlLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3BvcnRfbmFtZSBDb21wdXRlSGVhbHRoQ2hlY2sjcG9ydF9uYW1lfVxuICAqL1xuICByZWFkb25seSBwb3J0TmFtZT86IHN0cmluZztcbiAgLyoqXG4gICogU3BlY2lmaWVzIGhvdyBwb3J0IGlzIHNlbGVjdGVkIGZvciBoZWFsdGggY2hlY2tpbmcsIGNhbiBiZSBvbmUgb2YgdGhlXG5mb2xsb3dpbmcgdmFsdWVzOlxuXG4gICogJ1VTRV9GSVhFRF9QT1JUJzogVGhlIHBvcnQgbnVtYmVyIGluICdwb3J0JyBpcyB1c2VkIGZvciBoZWFsdGggY2hlY2tpbmcuXG5cbiAgKiAnVVNFX05BTUVEX1BPUlQnOiBUaGUgJ3BvcnROYW1lJyBpcyB1c2VkIGZvciBoZWFsdGggY2hlY2tpbmcuXG5cbiAgKiAnVVNFX1NFUlZJTkdfUE9SVCc6IEZvciBOZXR3b3JrRW5kcG9pbnRHcm91cCwgdGhlIHBvcnQgc3BlY2lmaWVkIGZvciBlYWNoXG4gIG5ldHdvcmsgZW5kcG9pbnQgaXMgdXNlZCBmb3IgaGVhbHRoIGNoZWNraW5nLiBGb3Igb3RoZXIgYmFja2VuZHMsIHRoZVxuICBwb3J0IG9yIG5hbWVkIHBvcnQgc3BlY2lmaWVkIGluIHRoZSBCYWNrZW5kIFNlcnZpY2UgaXMgdXNlZCBmb3IgaGVhbHRoXG4gIGNoZWNraW5nLlxuXG5JZiBub3Qgc3BlY2lmaWVkLCBIVFRQUyBoZWFsdGggY2hlY2sgZm9sbG93cyBiZWhhdmlvciBzcGVjaWZpZWQgaW4gJ3BvcnQnIGFuZFxuJ3BvcnROYW1lJyBmaWVsZHMuIFBvc3NpYmxlIHZhbHVlczogW1wiVVNFX0ZJWEVEX1BPUlRcIiwgXCJVU0VfTkFNRURfUE9SVFwiLCBcIlVTRV9TRVJWSU5HX1BPUlRcIl1cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNwb3J0X3NwZWNpZmljYXRpb24gQ29tcHV0ZUhlYWx0aENoZWNrI3BvcnRfc3BlY2lmaWNhdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgcG9ydFNwZWNpZmljYXRpb24/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFNwZWNpZmllcyB0aGUgdHlwZSBvZiBwcm94eSBoZWFkZXIgdG8gYXBwZW5kIGJlZm9yZSBzZW5kaW5nIGRhdGEgdG8gdGhlXG5iYWNrZW5kLiBEZWZhdWx0IHZhbHVlOiBcIk5PTkVcIiBQb3NzaWJsZSB2YWx1ZXM6IFtcIk5PTkVcIiwgXCJQUk9YWV9WMVwiXVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3Byb3h5X2hlYWRlciBDb21wdXRlSGVhbHRoQ2hlY2sjcHJveHlfaGVhZGVyfVxuICAqL1xuICByZWFkb25seSBwcm94eUhlYWRlcj86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIHJlcXVlc3QgcGF0aCBvZiB0aGUgSFRUUFMgaGVhbHRoIGNoZWNrIHJlcXVlc3QuXG5UaGUgZGVmYXVsdCB2YWx1ZSBpcyAvLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3JlcXVlc3RfcGF0aCBDb21wdXRlSGVhbHRoQ2hlY2sjcmVxdWVzdF9wYXRofVxuICAqL1xuICByZWFkb25seSByZXF1ZXN0UGF0aD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIGJ5dGVzIHRvIG1hdGNoIGFnYWluc3QgdGhlIGJlZ2lubmluZyBvZiB0aGUgcmVzcG9uc2UgZGF0YS4gSWYgbGVmdCBlbXB0eVxuKHRoZSBkZWZhdWx0IHZhbHVlKSwgYW55IHJlc3BvbnNlIHdpbGwgaW5kaWNhdGUgaGVhbHRoLiBUaGUgcmVzcG9uc2UgZGF0YVxuY2FuIG9ubHkgYmUgQVNDSUkuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjcmVzcG9uc2UgQ29tcHV0ZUhlYWx0aENoZWNrI3Jlc3BvbnNlfVxuICAqL1xuICByZWFkb25seSByZXNwb25zZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNvbXB1dGVIZWFsdGhDaGVja0h0dHBzSGVhbHRoQ2hlY2tUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBDb21wdXRlSGVhbHRoQ2hlY2tIdHRwc0hlYWx0aENoZWNrT3V0cHV0UmVmZXJlbmNlIHwgQ29tcHV0ZUhlYWx0aENoZWNrSHR0cHNIZWFsdGhDaGVjayk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBob3N0OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLmhvc3QpLFxuICAgIHBvcnQ6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEucG9ydCksXG4gICAgcG9ydF9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnBvcnROYW1lKSxcbiAgICBwb3J0X3NwZWNpZmljYXRpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEucG9ydFNwZWNpZmljYXRpb24pLFxuICAgIHByb3h5X2hlYWRlcjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5wcm94eUhlYWRlciksXG4gICAgcmVxdWVzdF9wYXRoOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnJlcXVlc3RQYXRoKSxcbiAgICByZXNwb25zZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5yZXNwb25zZSksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIENvbXB1dGVIZWFsdGhDaGVja0h0dHBzSGVhbHRoQ2hlY2tPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IENvbXB1dGVIZWFsdGhDaGVja0h0dHBzSGVhbHRoQ2hlY2sgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2hvc3QgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuaG9zdCA9IHRoaXMuX2hvc3Q7XG4gICAgfVxuICAgIGlmICh0aGlzLl9wb3J0ICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnBvcnQgPSB0aGlzLl9wb3J0O1xuICAgIH1cbiAgICBpZiAodGhpcy5fcG9ydE5hbWUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucG9ydE5hbWUgPSB0aGlzLl9wb3J0TmFtZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnBvcnRTcGVjaWZpY2F0aW9uID0gdGhpcy5fcG9ydFNwZWNpZmljYXRpb247XG4gICAgfVxuICAgIGlmICh0aGlzLl9wcm94eUhlYWRlciAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wcm94eUhlYWRlciA9IHRoaXMuX3Byb3h5SGVhZGVyO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcmVxdWVzdFBhdGggIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucmVxdWVzdFBhdGggPSB0aGlzLl9yZXF1ZXN0UGF0aDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3Jlc3BvbnNlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnJlc3BvbnNlID0gdGhpcy5fcmVzcG9uc2U7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBDb21wdXRlSGVhbHRoQ2hlY2tIdHRwc0hlYWx0aENoZWNrIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5faG9zdCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3BvcnQgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9wb3J0TmFtZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fcHJveHlIZWFkZXIgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9yZXF1ZXN0UGF0aCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3Jlc3BvbnNlID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9ob3N0ID0gdmFsdWUuaG9zdDtcbiAgICAgIHRoaXMuX3BvcnQgPSB2YWx1ZS5wb3J0O1xuICAgICAgdGhpcy5fcG9ydE5hbWUgPSB2YWx1ZS5wb3J0TmFtZTtcbiAgICAgIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uID0gdmFsdWUucG9ydFNwZWNpZmljYXRpb247XG4gICAgICB0aGlzLl9wcm94eUhlYWRlciA9IHZhbHVlLnByb3h5SGVhZGVyO1xuICAgICAgdGhpcy5fcmVxdWVzdFBhdGggPSB2YWx1ZS5yZXF1ZXN0UGF0aDtcbiAgICAgIHRoaXMuX3Jlc3BvbnNlID0gdmFsdWUucmVzcG9uc2U7XG4gICAgfVxuICB9XG5cbiAgLy8gaG9zdCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9ob3N0Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBob3N0KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaG9zdCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaG9zdCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5faG9zdCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEhvc3QoKSB7XG4gICAgdGhpcy5faG9zdCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaG9zdElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9ob3N0O1xuICB9XG5cbiAgLy8gcG9ydCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wb3J0PzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBwb3J0KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgncG9ydCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fcG9ydCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFBvcnQoKSB7XG4gICAgdGhpcy5fcG9ydCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcG9ydElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wb3J0O1xuICB9XG5cbiAgLy8gcG9ydF9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3BvcnROYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwb3J0TmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3BvcnRfbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydE5hbWUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3BvcnROYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UG9ydE5hbWUoKSB7XG4gICAgdGhpcy5fcG9ydE5hbWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBvcnROYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BvcnROYW1lO1xuICB9XG5cbiAgLy8gcG9ydF9zcGVjaWZpY2F0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3BvcnRTcGVjaWZpY2F0aW9uPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwb3J0U3BlY2lmaWNhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3BvcnRfc3BlY2lmaWNhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydFNwZWNpZmljYXRpb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UG9ydFNwZWNpZmljYXRpb24oKSB7XG4gICAgdGhpcy5fcG9ydFNwZWNpZmljYXRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBvcnRTcGVjaWZpY2F0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uO1xuICB9XG5cbiAgLy8gcHJveHlfaGVhZGVyIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Byb3h5SGVhZGVyPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwcm94eUhlYWRlcigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3Byb3h5X2hlYWRlcicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcHJveHlIZWFkZXIodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3Byb3h5SGVhZGVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UHJveHlIZWFkZXIoKSB7XG4gICAgdGhpcy5fcHJveHlIZWFkZXIgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHByb3h5SGVhZGVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Byb3h5SGVhZGVyO1xuICB9XG5cbiAgLy8gcmVxdWVzdF9wYXRoIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlcXVlc3RQYXRoPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCByZXF1ZXN0UGF0aCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3JlcXVlc3RfcGF0aCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVxdWVzdFBhdGgodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3JlcXVlc3RQYXRoID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVxdWVzdFBhdGgoKSB7XG4gICAgdGhpcy5fcmVxdWVzdFBhdGggPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJlcXVlc3RQYXRoSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlcXVlc3RQYXRoO1xuICB9XG5cbiAgLy8gcmVzcG9uc2UgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVzcG9uc2U/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHJlc3BvbnNlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncmVzcG9uc2UnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlc3BvbnNlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9yZXNwb25zZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJlc3BvbnNlKCkge1xuICAgIHRoaXMuX3Jlc3BvbnNlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXNwb25zZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZXNwb25zZTtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBDb21wdXRlSGVhbHRoQ2hlY2tMb2dDb25maWcge1xuICAvKipcbiAgKiBJbmRpY2F0ZXMgd2hldGhlciBvciBub3QgdG8gZXhwb3J0IGxvZ3MuIFRoaXMgaXMgZmFsc2UgYnkgZGVmYXVsdCxcbndoaWNoIG1lYW5zIG5vIGhlYWx0aCBjaGVjayBsb2dnaW5nIHdpbGwgYmUgZG9uZS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNlbmFibGUgQ29tcHV0ZUhlYWx0aENoZWNrI2VuYWJsZX1cbiAgKi9cbiAgcmVhZG9ubHkgZW5hYmxlPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gY29tcHV0ZUhlYWx0aENoZWNrTG9nQ29uZmlnVG9UZXJyYWZvcm0oc3RydWN0PzogQ29tcHV0ZUhlYWx0aENoZWNrTG9nQ29uZmlnT3V0cHV0UmVmZXJlbmNlIHwgQ29tcHV0ZUhlYWx0aENoZWNrTG9nQ29uZmlnKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGVuYWJsZTogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuZW5hYmxlKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgQ29tcHV0ZUhlYWx0aENoZWNrTG9nQ29uZmlnT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBDb21wdXRlSGVhbHRoQ2hlY2tMb2dDb25maWcgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2VuYWJsZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5lbmFibGUgPSB0aGlzLl9lbmFibGU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBDb21wdXRlSGVhbHRoQ2hlY2tMb2dDb25maWcgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9lbmFibGUgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2VuYWJsZSA9IHZhbHVlLmVuYWJsZTtcbiAgICB9XG4gIH1cblxuICAvLyBlbmFibGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZW5hYmxlPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBlbmFibGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnZW5hYmxlJyk7XG4gIH1cbiAgcHVibGljIHNldCBlbmFibGUodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2VuYWJsZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEVuYWJsZSgpIHtcbiAgICB0aGlzLl9lbmFibGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGVuYWJsZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9lbmFibGU7XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgQ29tcHV0ZUhlYWx0aENoZWNrU3NsSGVhbHRoQ2hlY2sge1xuICAvKipcbiAgKiBUaGUgVENQIHBvcnQgbnVtYmVyIGZvciB0aGUgU1NMIGhlYWx0aCBjaGVjayByZXF1ZXN0LlxuVGhlIGRlZmF1bHQgdmFsdWUgaXMgNDQzLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3BvcnQgQ29tcHV0ZUhlYWx0aENoZWNrI3BvcnR9XG4gICovXG4gIHJlYWRvbmx5IHBvcnQ/OiBudW1iZXI7XG4gIC8qKlxuICAqIFBvcnQgbmFtZSBhcyBkZWZpbmVkIGluIEluc3RhbmNlR3JvdXAjTmFtZWRQb3J0I25hbWUuIElmIGJvdGggcG9ydCBhbmRcbnBvcnRfbmFtZSBhcmUgZGVmaW5lZCwgcG9ydCB0YWtlcyBwcmVjZWRlbmNlLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3BvcnRfbmFtZSBDb21wdXRlSGVhbHRoQ2hlY2sjcG9ydF9uYW1lfVxuICAqL1xuICByZWFkb25seSBwb3J0TmFtZT86IHN0cmluZztcbiAgLyoqXG4gICogU3BlY2lmaWVzIGhvdyBwb3J0IGlzIHNlbGVjdGVkIGZvciBoZWFsdGggY2hlY2tpbmcsIGNhbiBiZSBvbmUgb2YgdGhlXG5mb2xsb3dpbmcgdmFsdWVzOlxuXG4gICogJ1VTRV9GSVhFRF9QT1JUJzogVGhlIHBvcnQgbnVtYmVyIGluICdwb3J0JyBpcyB1c2VkIGZvciBoZWFsdGggY2hlY2tpbmcuXG5cbiAgKiAnVVNFX05BTUVEX1BPUlQnOiBUaGUgJ3BvcnROYW1lJyBpcyB1c2VkIGZvciBoZWFsdGggY2hlY2tpbmcuXG5cbiAgKiAnVVNFX1NFUlZJTkdfUE9SVCc6IEZvciBOZXR3b3JrRW5kcG9pbnRHcm91cCwgdGhlIHBvcnQgc3BlY2lmaWVkIGZvciBlYWNoXG4gIG5ldHdvcmsgZW5kcG9pbnQgaXMgdXNlZCBmb3IgaGVhbHRoIGNoZWNraW5nLiBGb3Igb3RoZXIgYmFja2VuZHMsIHRoZVxuICBwb3J0IG9yIG5hbWVkIHBvcnQgc3BlY2lmaWVkIGluIHRoZSBCYWNrZW5kIFNlcnZpY2UgaXMgdXNlZCBmb3IgaGVhbHRoXG4gIGNoZWNraW5nLlxuXG5JZiBub3Qgc3BlY2lmaWVkLCBTU0wgaGVhbHRoIGNoZWNrIGZvbGxvd3MgYmVoYXZpb3Igc3BlY2lmaWVkIGluICdwb3J0JyBhbmRcbidwb3J0TmFtZScgZmllbGRzLiBQb3NzaWJsZSB2YWx1ZXM6IFtcIlVTRV9GSVhFRF9QT1JUXCIsIFwiVVNFX05BTUVEX1BPUlRcIiwgXCJVU0VfU0VSVklOR19QT1JUXCJdXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjcG9ydF9zcGVjaWZpY2F0aW9uIENvbXB1dGVIZWFsdGhDaGVjayNwb3J0X3NwZWNpZmljYXRpb259XG4gICovXG4gIHJlYWRvbmx5IHBvcnRTcGVjaWZpY2F0aW9uPzogc3RyaW5nO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIHR5cGUgb2YgcHJveHkgaGVhZGVyIHRvIGFwcGVuZCBiZWZvcmUgc2VuZGluZyBkYXRhIHRvIHRoZVxuYmFja2VuZC4gRGVmYXVsdCB2YWx1ZTogXCJOT05FXCIgUG9zc2libGUgdmFsdWVzOiBbXCJOT05FXCIsIFwiUFJPWFlfVjFcIl1cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNwcm94eV9oZWFkZXIgQ29tcHV0ZUhlYWx0aENoZWNrI3Byb3h5X2hlYWRlcn1cbiAgKi9cbiAgcmVhZG9ubHkgcHJveHlIZWFkZXI/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBhcHBsaWNhdGlvbiBkYXRhIHRvIHNlbmQgb25jZSB0aGUgU1NMIGNvbm5lY3Rpb24gaGFzIGJlZW5cbmVzdGFibGlzaGVkIChkZWZhdWx0IHZhbHVlIGlzIGVtcHR5KS4gSWYgYm90aCByZXF1ZXN0IGFuZCByZXNwb25zZSBhcmVcbmVtcHR5LCB0aGUgY29ubmVjdGlvbiBlc3RhYmxpc2htZW50IGFsb25lIHdpbGwgaW5kaWNhdGUgaGVhbHRoLiBUaGUgcmVxdWVzdFxuZGF0YSBjYW4gb25seSBiZSBBU0NJSS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNyZXF1ZXN0IENvbXB1dGVIZWFsdGhDaGVjayNyZXF1ZXN0fVxuICAqL1xuICByZWFkb25seSByZXF1ZXN0Pzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgYnl0ZXMgdG8gbWF0Y2ggYWdhaW5zdCB0aGUgYmVnaW5uaW5nIG9mIHRoZSByZXNwb25zZSBkYXRhLiBJZiBsZWZ0IGVtcHR5XG4odGhlIGRlZmF1bHQgdmFsdWUpLCBhbnkgcmVzcG9uc2Ugd2lsbCBpbmRpY2F0ZSBoZWFsdGguIFRoZSByZXNwb25zZSBkYXRhXG5jYW4gb25seSBiZSBBU0NJSS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNyZXNwb25zZSBDb21wdXRlSGVhbHRoQ2hlY2sjcmVzcG9uc2V9XG4gICovXG4gIHJlYWRvbmx5IHJlc3BvbnNlPzogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gY29tcHV0ZUhlYWx0aENoZWNrU3NsSGVhbHRoQ2hlY2tUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBDb21wdXRlSGVhbHRoQ2hlY2tTc2xIZWFsdGhDaGVja091dHB1dFJlZmVyZW5jZSB8IENvbXB1dGVIZWFsdGhDaGVja1NzbEhlYWx0aENoZWNrKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIHBvcnQ6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEucG9ydCksXG4gICAgcG9ydF9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnBvcnROYW1lKSxcbiAgICBwb3J0X3NwZWNpZmljYXRpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEucG9ydFNwZWNpZmljYXRpb24pLFxuICAgIHByb3h5X2hlYWRlcjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5wcm94eUhlYWRlciksXG4gICAgcmVxdWVzdDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5yZXF1ZXN0KSxcbiAgICByZXNwb25zZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5yZXNwb25zZSksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIENvbXB1dGVIZWFsdGhDaGVja1NzbEhlYWx0aENoZWNrT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBDb21wdXRlSGVhbHRoQ2hlY2tTc2xIZWFsdGhDaGVjayB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fcG9ydCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wb3J0ID0gdGhpcy5fcG9ydDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3BvcnROYW1lICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnBvcnROYW1lID0gdGhpcy5fcG9ydE5hbWU7XG4gICAgfVxuICAgIGlmICh0aGlzLl9wb3J0U3BlY2lmaWNhdGlvbiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wb3J0U3BlY2lmaWNhdGlvbiA9IHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcHJveHlIZWFkZXIgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucHJveHlIZWFkZXIgPSB0aGlzLl9wcm94eUhlYWRlcjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3JlcXVlc3QgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucmVxdWVzdCA9IHRoaXMuX3JlcXVlc3Q7XG4gICAgfVxuICAgIGlmICh0aGlzLl9yZXNwb25zZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5yZXNwb25zZSA9IHRoaXMuX3Jlc3BvbnNlO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogQ29tcHV0ZUhlYWx0aENoZWNrU3NsSGVhbHRoQ2hlY2sgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9wb3J0ID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fcG9ydE5hbWUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9wb3J0U3BlY2lmaWNhdGlvbiA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3Byb3h5SGVhZGVyID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fcmVxdWVzdCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3Jlc3BvbnNlID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9wb3J0ID0gdmFsdWUucG9ydDtcbiAgICAgIHRoaXMuX3BvcnROYW1lID0gdmFsdWUucG9ydE5hbWU7XG4gICAgICB0aGlzLl9wb3J0U3BlY2lmaWNhdGlvbiA9IHZhbHVlLnBvcnRTcGVjaWZpY2F0aW9uO1xuICAgICAgdGhpcy5fcHJveHlIZWFkZXIgPSB2YWx1ZS5wcm94eUhlYWRlcjtcbiAgICAgIHRoaXMuX3JlcXVlc3QgPSB2YWx1ZS5yZXF1ZXN0O1xuICAgICAgdGhpcy5fcmVzcG9uc2UgPSB2YWx1ZS5yZXNwb25zZTtcbiAgICB9XG4gIH1cblxuICAvLyBwb3J0IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3BvcnQ/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHBvcnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdwb3J0Jyk7XG4gIH1cbiAgcHVibGljIHNldCBwb3J0KHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9wb3J0ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UG9ydCgpIHtcbiAgICB0aGlzLl9wb3J0ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwb3J0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BvcnQ7XG4gIH1cblxuICAvLyBwb3J0X25hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcG9ydE5hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHBvcnROYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncG9ydF9uYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBwb3J0TmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcG9ydE5hbWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQb3J0TmFtZSgpIHtcbiAgICB0aGlzLl9wb3J0TmFtZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcG9ydE5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcG9ydE5hbWU7XG4gIH1cblxuICAvLyBwb3J0X3NwZWNpZmljYXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcG9ydFNwZWNpZmljYXRpb24/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHBvcnRTcGVjaWZpY2F0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncG9ydF9zcGVjaWZpY2F0aW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCBwb3J0U3BlY2lmaWNhdGlvbih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcG9ydFNwZWNpZmljYXRpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQb3J0U3BlY2lmaWNhdGlvbigpIHtcbiAgICB0aGlzLl9wb3J0U3BlY2lmaWNhdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcG9ydFNwZWNpZmljYXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcG9ydFNwZWNpZmljYXRpb247XG4gIH1cblxuICAvLyBwcm94eV9oZWFkZXIgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcHJveHlIZWFkZXI/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHByb3h5SGVhZGVyKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncHJveHlfaGVhZGVyJyk7XG4gIH1cbiAgcHVibGljIHNldCBwcm94eUhlYWRlcih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcHJveHlIZWFkZXIgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQcm94eUhlYWRlcigpIHtcbiAgICB0aGlzLl9wcm94eUhlYWRlciA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHJveHlIZWFkZXJJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcHJveHlIZWFkZXI7XG4gIH1cblxuICAvLyByZXF1ZXN0IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlcXVlc3Q/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHJlcXVlc3QoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdyZXF1ZXN0Jyk7XG4gIH1cbiAgcHVibGljIHNldCByZXF1ZXN0KHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9yZXF1ZXN0ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVxdWVzdCgpIHtcbiAgICB0aGlzLl9yZXF1ZXN0ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXF1ZXN0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlcXVlc3Q7XG4gIH1cblxuICAvLyByZXNwb25zZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9yZXNwb25zZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcmVzcG9uc2UoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdyZXNwb25zZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVzcG9uc2UodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3Jlc3BvbnNlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVzcG9uc2UoKSB7XG4gICAgdGhpcy5fcmVzcG9uc2UgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJlc3BvbnNlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Jlc3BvbnNlO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIENvbXB1dGVIZWFsdGhDaGVja1RjcEhlYWx0aENoZWNrIHtcbiAgLyoqXG4gICogVGhlIFRDUCBwb3J0IG51bWJlciBmb3IgdGhlIFRDUCBoZWFsdGggY2hlY2sgcmVxdWVzdC5cblRoZSBkZWZhdWx0IHZhbHVlIGlzIDQ0My5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNwb3J0IENvbXB1dGVIZWFsdGhDaGVjayNwb3J0fVxuICAqL1xuICByZWFkb25seSBwb3J0PzogbnVtYmVyO1xuICAvKipcbiAgKiBQb3J0IG5hbWUgYXMgZGVmaW5lZCBpbiBJbnN0YW5jZUdyb3VwI05hbWVkUG9ydCNuYW1lLiBJZiBib3RoIHBvcnQgYW5kXG5wb3J0X25hbWUgYXJlIGRlZmluZWQsIHBvcnQgdGFrZXMgcHJlY2VkZW5jZS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayNwb3J0X25hbWUgQ29tcHV0ZUhlYWx0aENoZWNrI3BvcnRfbmFtZX1cbiAgKi9cbiAgcmVhZG9ubHkgcG9ydE5hbWU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFNwZWNpZmllcyBob3cgcG9ydCBpcyBzZWxlY3RlZCBmb3IgaGVhbHRoIGNoZWNraW5nLCBjYW4gYmUgb25lIG9mIHRoZVxuZm9sbG93aW5nIHZhbHVlczpcblxuICAqICdVU0VfRklYRURfUE9SVCc6IFRoZSBwb3J0IG51bWJlciBpbiAncG9ydCcgaXMgdXNlZCBmb3IgaGVhbHRoIGNoZWNraW5nLlxuXG4gICogJ1VTRV9OQU1FRF9QT1JUJzogVGhlICdwb3J0TmFtZScgaXMgdXNlZCBmb3IgaGVhbHRoIGNoZWNraW5nLlxuXG4gICogJ1VTRV9TRVJWSU5HX1BPUlQnOiBGb3IgTmV0d29ya0VuZHBvaW50R3JvdXAsIHRoZSBwb3J0IHNwZWNpZmllZCBmb3IgZWFjaFxuICBuZXR3b3JrIGVuZHBvaW50IGlzIHVzZWQgZm9yIGhlYWx0aCBjaGVja2luZy4gRm9yIG90aGVyIGJhY2tlbmRzLCB0aGVcbiAgcG9ydCBvciBuYW1lZCBwb3J0IHNwZWNpZmllZCBpbiB0aGUgQmFja2VuZCBTZXJ2aWNlIGlzIHVzZWQgZm9yIGhlYWx0aFxuICBjaGVja2luZy5cblxuSWYgbm90IHNwZWNpZmllZCwgVENQIGhlYWx0aCBjaGVjayBmb2xsb3dzIGJlaGF2aW9yIHNwZWNpZmllZCBpbiAncG9ydCcgYW5kXG4ncG9ydE5hbWUnIGZpZWxkcy4gUG9zc2libGUgdmFsdWVzOiBbXCJVU0VfRklYRURfUE9SVFwiLCBcIlVTRV9OQU1FRF9QT1JUXCIsIFwiVVNFX1NFUlZJTkdfUE9SVFwiXVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3BvcnRfc3BlY2lmaWNhdGlvbiBDb21wdXRlSGVhbHRoQ2hlY2sjcG9ydF9zcGVjaWZpY2F0aW9ufVxuICAqL1xuICByZWFkb25seSBwb3J0U3BlY2lmaWNhdGlvbj86IHN0cmluZztcbiAgLyoqXG4gICogU3BlY2lmaWVzIHRoZSB0eXBlIG9mIHByb3h5IGhlYWRlciB0byBhcHBlbmQgYmVmb3JlIHNlbmRpbmcgZGF0YSB0byB0aGVcbmJhY2tlbmQuIERlZmF1bHQgdmFsdWU6IFwiTk9ORVwiIFBvc3NpYmxlIHZhbHVlczogW1wiTk9ORVwiLCBcIlBST1hZX1YxXCJdXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjcHJveHlfaGVhZGVyIENvbXB1dGVIZWFsdGhDaGVjayNwcm94eV9oZWFkZXJ9XG4gICovXG4gIHJlYWRvbmx5IHByb3h5SGVhZGVyPzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgYXBwbGljYXRpb24gZGF0YSB0byBzZW5kIG9uY2UgdGhlIFRDUCBjb25uZWN0aW9uIGhhcyBiZWVuXG5lc3RhYmxpc2hlZCAoZGVmYXVsdCB2YWx1ZSBpcyBlbXB0eSkuIElmIGJvdGggcmVxdWVzdCBhbmQgcmVzcG9uc2UgYXJlXG5lbXB0eSwgdGhlIGNvbm5lY3Rpb24gZXN0YWJsaXNobWVudCBhbG9uZSB3aWxsIGluZGljYXRlIGhlYWx0aC4gVGhlIHJlcXVlc3RcbmRhdGEgY2FuIG9ubHkgYmUgQVNDSUkuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjcmVxdWVzdCBDb21wdXRlSGVhbHRoQ2hlY2sjcmVxdWVzdH1cbiAgKi9cbiAgcmVhZG9ubHkgcmVxdWVzdD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIGJ5dGVzIHRvIG1hdGNoIGFnYWluc3QgdGhlIGJlZ2lubmluZyBvZiB0aGUgcmVzcG9uc2UgZGF0YS4gSWYgbGVmdCBlbXB0eVxuKHRoZSBkZWZhdWx0IHZhbHVlKSwgYW55IHJlc3BvbnNlIHdpbGwgaW5kaWNhdGUgaGVhbHRoLiBUaGUgcmVzcG9uc2UgZGF0YVxuY2FuIG9ubHkgYmUgQVNDSUkuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sjcmVzcG9uc2UgQ29tcHV0ZUhlYWx0aENoZWNrI3Jlc3BvbnNlfVxuICAqL1xuICByZWFkb25seSByZXNwb25zZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNvbXB1dGVIZWFsdGhDaGVja1RjcEhlYWx0aENoZWNrVG9UZXJyYWZvcm0oc3RydWN0PzogQ29tcHV0ZUhlYWx0aENoZWNrVGNwSGVhbHRoQ2hlY2tPdXRwdXRSZWZlcmVuY2UgfCBDb21wdXRlSGVhbHRoQ2hlY2tUY3BIZWFsdGhDaGVjayk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBwb3J0OiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLnBvcnQpLFxuICAgIHBvcnRfbmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5wb3J0TmFtZSksXG4gICAgcG9ydF9zcGVjaWZpY2F0aW9uOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnBvcnRTcGVjaWZpY2F0aW9uKSxcbiAgICBwcm94eV9oZWFkZXI6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEucHJveHlIZWFkZXIpLFxuICAgIHJlcXVlc3Q6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEucmVxdWVzdCksXG4gICAgcmVzcG9uc2U6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEucmVzcG9uc2UpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBDb21wdXRlSGVhbHRoQ2hlY2tUY3BIZWFsdGhDaGVja091dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBmYWxzZSwgMCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogQ29tcHV0ZUhlYWx0aENoZWNrVGNwSGVhbHRoQ2hlY2sgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX3BvcnQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucG9ydCA9IHRoaXMuX3BvcnQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl9wb3J0TmFtZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wb3J0TmFtZSA9IHRoaXMuX3BvcnROYW1lO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcG9ydFNwZWNpZmljYXRpb24gIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucG9ydFNwZWNpZmljYXRpb24gPSB0aGlzLl9wb3J0U3BlY2lmaWNhdGlvbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3Byb3h5SGVhZGVyICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnByb3h5SGVhZGVyID0gdGhpcy5fcHJveHlIZWFkZXI7XG4gICAgfVxuICAgIGlmICh0aGlzLl9yZXF1ZXN0ICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnJlcXVlc3QgPSB0aGlzLl9yZXF1ZXN0O1xuICAgIH1cbiAgICBpZiAodGhpcy5fcmVzcG9uc2UgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucmVzcG9uc2UgPSB0aGlzLl9yZXNwb25zZTtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IENvbXB1dGVIZWFsdGhDaGVja1RjcEhlYWx0aENoZWNrIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5fcG9ydCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3BvcnROYW1lID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fcG9ydFNwZWNpZmljYXRpb24gPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9wcm94eUhlYWRlciA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3JlcXVlc3QgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9yZXNwb25zZSA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5fcG9ydCA9IHZhbHVlLnBvcnQ7XG4gICAgICB0aGlzLl9wb3J0TmFtZSA9IHZhbHVlLnBvcnROYW1lO1xuICAgICAgdGhpcy5fcG9ydFNwZWNpZmljYXRpb24gPSB2YWx1ZS5wb3J0U3BlY2lmaWNhdGlvbjtcbiAgICAgIHRoaXMuX3Byb3h5SGVhZGVyID0gdmFsdWUucHJveHlIZWFkZXI7XG4gICAgICB0aGlzLl9yZXF1ZXN0ID0gdmFsdWUucmVxdWVzdDtcbiAgICAgIHRoaXMuX3Jlc3BvbnNlID0gdmFsdWUucmVzcG9uc2U7XG4gICAgfVxuICB9XG5cbiAgLy8gcG9ydCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wb3J0PzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBwb3J0KCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgncG9ydCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fcG9ydCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFBvcnQoKSB7XG4gICAgdGhpcy5fcG9ydCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcG9ydElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wb3J0O1xuICB9XG5cbiAgLy8gcG9ydF9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3BvcnROYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwb3J0TmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3BvcnRfbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydE5hbWUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3BvcnROYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UG9ydE5hbWUoKSB7XG4gICAgdGhpcy5fcG9ydE5hbWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBvcnROYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BvcnROYW1lO1xuICB9XG5cbiAgLy8gcG9ydF9zcGVjaWZpY2F0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3BvcnRTcGVjaWZpY2F0aW9uPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwb3J0U3BlY2lmaWNhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3BvcnRfc3BlY2lmaWNhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcG9ydFNwZWNpZmljYXRpb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UG9ydFNwZWNpZmljYXRpb24oKSB7XG4gICAgdGhpcy5fcG9ydFNwZWNpZmljYXRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBvcnRTcGVjaWZpY2F0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BvcnRTcGVjaWZpY2F0aW9uO1xuICB9XG5cbiAgLy8gcHJveHlfaGVhZGVyIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Byb3h5SGVhZGVyPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwcm94eUhlYWRlcigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3Byb3h5X2hlYWRlcicpO1xuICB9XG4gIHB1YmxpYyBzZXQgcHJveHlIZWFkZXIodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3Byb3h5SGVhZGVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UHJveHlIZWFkZXIoKSB7XG4gICAgdGhpcy5fcHJveHlIZWFkZXIgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHByb3h5SGVhZGVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Byb3h5SGVhZGVyO1xuICB9XG5cbiAgLy8gcmVxdWVzdCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9yZXF1ZXN0Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCByZXF1ZXN0KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncmVxdWVzdCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVxdWVzdCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcmVxdWVzdCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJlcXVlc3QoKSB7XG4gICAgdGhpcy5fcmVxdWVzdCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcmVxdWVzdElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZXF1ZXN0O1xuICB9XG5cbiAgLy8gcmVzcG9uc2UgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcmVzcG9uc2U/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHJlc3BvbnNlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncmVzcG9uc2UnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJlc3BvbnNlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9yZXNwb25zZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJlc3BvbnNlKCkge1xuICAgIHRoaXMuX3Jlc3BvbnNlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZXNwb25zZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZXNwb25zZTtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBDb21wdXRlSGVhbHRoQ2hlY2tUaW1lb3V0cyB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI2NyZWF0ZSBDb21wdXRlSGVhbHRoQ2hlY2sjY3JlYXRlfVxuICAqL1xuICByZWFkb25seSBjcmVhdGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI2RlbGV0ZSBDb21wdXRlSGVhbHRoQ2hlY2sjZGVsZXRlfVxuICAqL1xuICByZWFkb25seSBkZWxldGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2NvbXB1dGVfaGVhbHRoX2NoZWNrI3VwZGF0ZSBDb21wdXRlSGVhbHRoQ2hlY2sjdXBkYXRlfVxuICAqL1xuICByZWFkb25seSB1cGRhdGU/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBjb21wdXRlSGVhbHRoQ2hlY2tUaW1lb3V0c1RvVGVycmFmb3JtKHN0cnVjdD86IENvbXB1dGVIZWFsdGhDaGVja1RpbWVvdXRzT3V0cHV0UmVmZXJlbmNlIHwgQ29tcHV0ZUhlYWx0aENoZWNrVGltZW91dHMgfCBjZGt0Zi5JUmVzb2x2YWJsZSk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBjcmVhdGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuY3JlYXRlKSxcbiAgICBkZWxldGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuZGVsZXRlKSxcbiAgICB1cGRhdGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEudXBkYXRlKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgQ29tcHV0ZUhlYWx0aENoZWNrVGltZW91dHNPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gIHByaXZhdGUgcmVzb2x2YWJsZVZhbHVlPzogY2RrdGYuSVJlc29sdmFibGU7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IENvbXB1dGVIZWFsdGhDaGVja1RpbWVvdXRzIHwgY2RrdGYuSVJlc29sdmFibGUgfCB1bmRlZmluZWQge1xuICAgIGlmICh0aGlzLnJlc29sdmFibGVWYWx1ZSkge1xuICAgICAgcmV0dXJuIHRoaXMucmVzb2x2YWJsZVZhbHVlO1xuICAgIH1cbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9jcmVhdGUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuY3JlYXRlID0gdGhpcy5fY3JlYXRlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fZGVsZXRlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmRlbGV0ZSA9IHRoaXMuX2RlbGV0ZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3VwZGF0ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC51cGRhdGUgPSB0aGlzLl91cGRhdGU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBDb21wdXRlSGVhbHRoQ2hlY2tUaW1lb3V0cyB8IGNka3RmLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5yZXNvbHZhYmxlVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9jcmVhdGUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9kZWxldGUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl91cGRhdGUgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2UgaWYgKGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUodmFsdWUpKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMucmVzb2x2YWJsZVZhbHVlID0gdmFsdWU7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMucmVzb2x2YWJsZVZhbHVlID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fY3JlYXRlID0gdmFsdWUuY3JlYXRlO1xuICAgICAgdGhpcy5fZGVsZXRlID0gdmFsdWUuZGVsZXRlO1xuICAgICAgdGhpcy5fdXBkYXRlID0gdmFsdWUudXBkYXRlO1xuICAgIH1cbiAgfVxuXG4gIC8vIGNyZWF0ZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jcmVhdGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGNyZWF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NyZWF0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgY3JlYXRlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9jcmVhdGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDcmVhdGUoKSB7XG4gICAgdGhpcy5fY3JlYXRlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjcmVhdGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY3JlYXRlO1xuICB9XG5cbiAgLy8gZGVsZXRlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlbGV0ZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZGVsZXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGVsZXRlJyk7XG4gIH1cbiAgcHVibGljIHNldCBkZWxldGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2RlbGV0ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERlbGV0ZSgpIHtcbiAgICB0aGlzLl9kZWxldGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlbGV0ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZWxldGU7XG4gIH1cblxuICAvLyB1cGRhdGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdXBkYXRlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB1cGRhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd1cGRhdGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHVwZGF0ZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdXBkYXRlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VXBkYXRlKCkge1xuICAgIHRoaXMuX3VwZGF0ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdXBkYXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3VwZGF0ZTtcbiAgfVxufVxuXG4vKipcbiogUmVwcmVzZW50cyBhIHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvY29tcHV0ZV9oZWFsdGhfY2hlY2sgZ29vZ2xlX2NvbXB1dGVfaGVhbHRoX2NoZWNrfVxuKi9cbmV4cG9ydCBjbGFzcyBDb21wdXRlSGVhbHRoQ2hlY2sgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgLy8gU1RBVElDIFBST1BFUlRJRVNcbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSB0ZlJlc291cmNlVHlwZSA9IFwiZ29vZ2xlX2NvbXB1dGVfaGVhbHRoX2NoZWNrXCI7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICAvKipcbiAgKiBDcmVhdGUgYSBuZXcge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9jb21wdXRlX2hlYWx0aF9jaGVjayBnb29nbGVfY29tcHV0ZV9oZWFsdGhfY2hlY2t9IFJlc291cmNlXG4gICpcbiAgKiBAcGFyYW0gc2NvcGUgVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdFxuICAqIEBwYXJhbSBpZCBUaGUgc2NvcGVkIGNvbnN0cnVjdCBJRC4gTXVzdCBiZSB1bmlxdWUgYW1vbmdzdCBzaWJsaW5ncyBpbiB0aGUgc2FtZSBzY29wZVxuICAqIEBwYXJhbSBvcHRpb25zIENvbXB1dGVIZWFsdGhDaGVja0NvbmZpZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBDb21wdXRlSGVhbHRoQ2hlY2tDb25maWcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHRlcnJhZm9ybVJlc291cmNlVHlwZTogJ2dvb2dsZV9jb21wdXRlX2hlYWx0aF9jaGVjaycsXG4gICAgICB0ZXJyYWZvcm1HZW5lcmF0b3JNZXRhZGF0YToge1xuICAgICAgICBwcm92aWRlck5hbWU6ICdnb29nbGUnLFxuICAgICAgICBwcm92aWRlclZlcnNpb246ICc0LjYxLjAnLFxuICAgICAgICBwcm92aWRlclZlcnNpb25Db25zdHJhaW50OiAnfj4gNC4wJ1xuICAgICAgfSxcbiAgICAgIHByb3ZpZGVyOiBjb25maWcucHJvdmlkZXIsXG4gICAgICBkZXBlbmRzT246IGNvbmZpZy5kZXBlbmRzT24sXG4gICAgICBjb3VudDogY29uZmlnLmNvdW50LFxuICAgICAgbGlmZWN5Y2xlOiBjb25maWcubGlmZWN5Y2xlLFxuICAgICAgcHJvdmlzaW9uZXJzOiBjb25maWcucHJvdmlzaW9uZXJzLFxuICAgICAgY29ubmVjdGlvbjogY29uZmlnLmNvbm5lY3Rpb24sXG4gICAgICBmb3JFYWNoOiBjb25maWcuZm9yRWFjaFxuICAgIH0pO1xuICAgIHRoaXMuX2NoZWNrSW50ZXJ2YWxTZWMgPSBjb25maWcuY2hlY2tJbnRlcnZhbFNlYztcbiAgICB0aGlzLl9kZXNjcmlwdGlvbiA9IGNvbmZpZy5kZXNjcmlwdGlvbjtcbiAgICB0aGlzLl9oZWFsdGh5VGhyZXNob2xkID0gY29uZmlnLmhlYWx0aHlUaHJlc2hvbGQ7XG4gICAgdGhpcy5faWQgPSBjb25maWcuaWQ7XG4gICAgdGhpcy5fbmFtZSA9IGNvbmZpZy5uYW1lO1xuICAgIHRoaXMuX3Byb2plY3QgPSBjb25maWcucHJvamVjdDtcbiAgICB0aGlzLl90aW1lb3V0U2VjID0gY29uZmlnLnRpbWVvdXRTZWM7XG4gICAgdGhpcy5fdW5oZWFsdGh5VGhyZXNob2xkID0gY29uZmlnLnVuaGVhbHRoeVRocmVzaG9sZDtcbiAgICB0aGlzLl9ncnBjSGVhbHRoQ2hlY2suaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy5ncnBjSGVhbHRoQ2hlY2s7XG4gICAgdGhpcy5faHR0cDJIZWFsdGhDaGVjay5pbnRlcm5hbFZhbHVlID0gY29uZmlnLmh0dHAySGVhbHRoQ2hlY2s7XG4gICAgdGhpcy5faHR0cEhlYWx0aENoZWNrLmludGVybmFsVmFsdWUgPSBjb25maWcuaHR0cEhlYWx0aENoZWNrO1xuICAgIHRoaXMuX2h0dHBzSGVhbHRoQ2hlY2suaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy5odHRwc0hlYWx0aENoZWNrO1xuICAgIHRoaXMuX2xvZ0NvbmZpZy5pbnRlcm5hbFZhbHVlID0gY29uZmlnLmxvZ0NvbmZpZztcbiAgICB0aGlzLl9zc2xIZWFsdGhDaGVjay5pbnRlcm5hbFZhbHVlID0gY29uZmlnLnNzbEhlYWx0aENoZWNrO1xuICAgIHRoaXMuX3RjcEhlYWx0aENoZWNrLmludGVybmFsVmFsdWUgPSBjb25maWcudGNwSGVhbHRoQ2hlY2s7XG4gICAgdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy50aW1lb3V0cztcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gY2hlY2tfaW50ZXJ2YWxfc2VjIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NoZWNrSW50ZXJ2YWxTZWM/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGNoZWNrSW50ZXJ2YWxTZWMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdjaGVja19pbnRlcnZhbF9zZWMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNoZWNrSW50ZXJ2YWxTZWModmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2NoZWNrSW50ZXJ2YWxTZWMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDaGVja0ludGVydmFsU2VjKCkge1xuICAgIHRoaXMuX2NoZWNrSW50ZXJ2YWxTZWMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNoZWNrSW50ZXJ2YWxTZWNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2hlY2tJbnRlcnZhbFNlYztcbiAgfVxuXG4gIC8vIGNyZWF0aW9uX3RpbWVzdGFtcCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IGNyZWF0aW9uVGltZXN0YW1wKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnY3JlYXRpb25fdGltZXN0YW1wJyk7XG4gIH1cblxuICAvLyBkZXNjcmlwdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZXNjcmlwdGlvbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZGVzY3JpcHRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdkZXNjcmlwdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVzY3JpcHRpb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2Rlc2NyaXB0aW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGVzY3JpcHRpb24oKSB7XG4gICAgdGhpcy5fZGVzY3JpcHRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlc2NyaXB0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Rlc2NyaXB0aW9uO1xuICB9XG5cbiAgLy8gaGVhbHRoeV90aHJlc2hvbGQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaGVhbHRoeVRocmVzaG9sZD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgaGVhbHRoeVRocmVzaG9sZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ2hlYWx0aHlfdGhyZXNob2xkJyk7XG4gIH1cbiAgcHVibGljIHNldCBoZWFsdGh5VGhyZXNob2xkKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9oZWFsdGh5VGhyZXNob2xkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SGVhbHRoeVRocmVzaG9sZCgpIHtcbiAgICB0aGlzLl9oZWFsdGh5VGhyZXNob2xkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBoZWFsdGh5VGhyZXNob2xkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2hlYWx0aHlUaHJlc2hvbGQ7XG4gIH1cblxuICAvLyBpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBpZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5faWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJZCgpIHtcbiAgICB0aGlzLl9pZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWQ7XG4gIH1cblxuICAvLyBuYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX25hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCduYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBuYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9uYW1lID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbmFtZTtcbiAgfVxuXG4gIC8vIHByb2plY3QgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wcm9qZWN0Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwcm9qZWN0KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncHJvamVjdCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcHJvamVjdCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcHJvamVjdCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFByb2plY3QoKSB7XG4gICAgdGhpcy5fcHJvamVjdCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHJvamVjdElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wcm9qZWN0O1xuICB9XG5cbiAgLy8gc2VsZl9saW5rIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgc2VsZkxpbmsoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzZWxmX2xpbmsnKTtcbiAgfVxuXG4gIC8vIHRpbWVvdXRfc2VjIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3RpbWVvdXRTZWM/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHRpbWVvdXRTZWMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCd0aW1lb3V0X3NlYycpO1xuICB9XG4gIHB1YmxpYyBzZXQgdGltZW91dFNlYyh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fdGltZW91dFNlYyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRpbWVvdXRTZWMoKSB7XG4gICAgdGhpcy5fdGltZW91dFNlYyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdGltZW91dFNlY0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90aW1lb3V0U2VjO1xuICB9XG5cbiAgLy8gdHlwZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IHR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd0eXBlJyk7XG4gIH1cblxuICAvLyB1bmhlYWx0aHlfdGhyZXNob2xkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3VuaGVhbHRoeVRocmVzaG9sZD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgdW5oZWFsdGh5VGhyZXNob2xkKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgndW5oZWFsdGh5X3RocmVzaG9sZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgdW5oZWFsdGh5VGhyZXNob2xkKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl91bmhlYWx0aHlUaHJlc2hvbGQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVbmhlYWx0aHlUaHJlc2hvbGQoKSB7XG4gICAgdGhpcy5fdW5oZWFsdGh5VGhyZXNob2xkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1bmhlYWx0aHlUaHJlc2hvbGRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdW5oZWFsdGh5VGhyZXNob2xkO1xuICB9XG5cbiAgLy8gZ3JwY19oZWFsdGhfY2hlY2sgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZ3JwY0hlYWx0aENoZWNrID0gbmV3IENvbXB1dGVIZWFsdGhDaGVja0dycGNIZWFsdGhDaGVja091dHB1dFJlZmVyZW5jZSh0aGlzLCBcImdycGNfaGVhbHRoX2NoZWNrXCIpO1xuICBwdWJsaWMgZ2V0IGdycGNIZWFsdGhDaGVjaygpIHtcbiAgICByZXR1cm4gdGhpcy5fZ3JwY0hlYWx0aENoZWNrO1xuICB9XG4gIHB1YmxpYyBwdXRHcnBjSGVhbHRoQ2hlY2sodmFsdWU6IENvbXB1dGVIZWFsdGhDaGVja0dycGNIZWFsdGhDaGVjaykge1xuICAgIHRoaXMuX2dycGNIZWFsdGhDaGVjay5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0R3JwY0hlYWx0aENoZWNrKCkge1xuICAgIHRoaXMuX2dycGNIZWFsdGhDaGVjay5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBncnBjSGVhbHRoQ2hlY2tJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZ3JwY0hlYWx0aENoZWNrLmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyBodHRwMl9oZWFsdGhfY2hlY2sgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaHR0cDJIZWFsdGhDaGVjayA9IG5ldyBDb21wdXRlSGVhbHRoQ2hlY2tIdHRwMkhlYWx0aENoZWNrT3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwiaHR0cDJfaGVhbHRoX2NoZWNrXCIpO1xuICBwdWJsaWMgZ2V0IGh0dHAySGVhbHRoQ2hlY2soKSB7XG4gICAgcmV0dXJuIHRoaXMuX2h0dHAySGVhbHRoQ2hlY2s7XG4gIH1cbiAgcHVibGljIHB1dEh0dHAySGVhbHRoQ2hlY2sodmFsdWU6IENvbXB1dGVIZWFsdGhDaGVja0h0dHAySGVhbHRoQ2hlY2spIHtcbiAgICB0aGlzLl9odHRwMkhlYWx0aENoZWNrLmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRIdHRwMkhlYWx0aENoZWNrKCkge1xuICAgIHRoaXMuX2h0dHAySGVhbHRoQ2hlY2suaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaHR0cDJIZWFsdGhDaGVja0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9odHRwMkhlYWx0aENoZWNrLmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyBodHRwX2hlYWx0aF9jaGVjayAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9odHRwSGVhbHRoQ2hlY2sgPSBuZXcgQ29tcHV0ZUhlYWx0aENoZWNrSHR0cEhlYWx0aENoZWNrT3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwiaHR0cF9oZWFsdGhfY2hlY2tcIik7XG4gIHB1YmxpYyBnZXQgaHR0cEhlYWx0aENoZWNrKCkge1xuICAgIHJldHVybiB0aGlzLl9odHRwSGVhbHRoQ2hlY2s7XG4gIH1cbiAgcHVibGljIHB1dEh0dHBIZWFsdGhDaGVjayh2YWx1ZTogQ29tcHV0ZUhlYWx0aENoZWNrSHR0cEhlYWx0aENoZWNrKSB7XG4gICAgdGhpcy5faHR0cEhlYWx0aENoZWNrLmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRIdHRwSGVhbHRoQ2hlY2soKSB7XG4gICAgdGhpcy5faHR0cEhlYWx0aENoZWNrLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGh0dHBIZWFsdGhDaGVja0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9odHRwSGVhbHRoQ2hlY2suaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vIGh0dHBzX2hlYWx0aF9jaGVjayAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9odHRwc0hlYWx0aENoZWNrID0gbmV3IENvbXB1dGVIZWFsdGhDaGVja0h0dHBzSGVhbHRoQ2hlY2tPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJodHRwc19oZWFsdGhfY2hlY2tcIik7XG4gIHB1YmxpYyBnZXQgaHR0cHNIZWFsdGhDaGVjaygpIHtcbiAgICByZXR1cm4gdGhpcy5faHR0cHNIZWFsdGhDaGVjaztcbiAgfVxuICBwdWJsaWMgcHV0SHR0cHNIZWFsdGhDaGVjayh2YWx1ZTogQ29tcHV0ZUhlYWx0aENoZWNrSHR0cHNIZWFsdGhDaGVjaykge1xuICAgIHRoaXMuX2h0dHBzSGVhbHRoQ2hlY2suaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEh0dHBzSGVhbHRoQ2hlY2soKSB7XG4gICAgdGhpcy5faHR0cHNIZWFsdGhDaGVjay5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBodHRwc0hlYWx0aENoZWNrSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2h0dHBzSGVhbHRoQ2hlY2suaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vIGxvZ19jb25maWcgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbG9nQ29uZmlnID0gbmV3IENvbXB1dGVIZWFsdGhDaGVja0xvZ0NvbmZpZ091dHB1dFJlZmVyZW5jZSh0aGlzLCBcImxvZ19jb25maWdcIik7XG4gIHB1YmxpYyBnZXQgbG9nQ29uZmlnKCkge1xuICAgIHJldHVybiB0aGlzLl9sb2dDb25maWc7XG4gIH1cbiAgcHVibGljIHB1dExvZ0NvbmZpZyh2YWx1ZTogQ29tcHV0ZUhlYWx0aENoZWNrTG9nQ29uZmlnKSB7XG4gICAgdGhpcy5fbG9nQ29uZmlnLmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRMb2dDb25maWcoKSB7XG4gICAgdGhpcy5fbG9nQ29uZmlnLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGxvZ0NvbmZpZ0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9sb2dDb25maWcuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vIHNzbF9oZWFsdGhfY2hlY2sgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc3NsSGVhbHRoQ2hlY2sgPSBuZXcgQ29tcHV0ZUhlYWx0aENoZWNrU3NsSGVhbHRoQ2hlY2tPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJzc2xfaGVhbHRoX2NoZWNrXCIpO1xuICBwdWJsaWMgZ2V0IHNzbEhlYWx0aENoZWNrKCkge1xuICAgIHJldHVybiB0aGlzLl9zc2xIZWFsdGhDaGVjaztcbiAgfVxuICBwdWJsaWMgcHV0U3NsSGVhbHRoQ2hlY2sodmFsdWU6IENvbXB1dGVIZWFsdGhDaGVja1NzbEhlYWx0aENoZWNrKSB7XG4gICAgdGhpcy5fc3NsSGVhbHRoQ2hlY2suaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNzbEhlYWx0aENoZWNrKCkge1xuICAgIHRoaXMuX3NzbEhlYWx0aENoZWNrLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHNzbEhlYWx0aENoZWNrSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NzbEhlYWx0aENoZWNrLmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyB0Y3BfaGVhbHRoX2NoZWNrIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3RjcEhlYWx0aENoZWNrID0gbmV3IENvbXB1dGVIZWFsdGhDaGVja1RjcEhlYWx0aENoZWNrT3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwidGNwX2hlYWx0aF9jaGVja1wiKTtcbiAgcHVibGljIGdldCB0Y3BIZWFsdGhDaGVjaygpIHtcbiAgICByZXR1cm4gdGhpcy5fdGNwSGVhbHRoQ2hlY2s7XG4gIH1cbiAgcHVibGljIHB1dFRjcEhlYWx0aENoZWNrKHZhbHVlOiBDb21wdXRlSGVhbHRoQ2hlY2tUY3BIZWFsdGhDaGVjaykge1xuICAgIHRoaXMuX3RjcEhlYWx0aENoZWNrLmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUY3BIZWFsdGhDaGVjaygpIHtcbiAgICB0aGlzLl90Y3BIZWFsdGhDaGVjay5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0Y3BIZWFsdGhDaGVja0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90Y3BIZWFsdGhDaGVjay5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gdGltZW91dHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdGltZW91dHMgPSBuZXcgQ29tcHV0ZUhlYWx0aENoZWNrVGltZW91dHNPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJ0aW1lb3V0c1wiKTtcbiAgcHVibGljIGdldCB0aW1lb3V0cygpIHtcbiAgICByZXR1cm4gdGhpcy5fdGltZW91dHM7XG4gIH1cbiAgcHVibGljIHB1dFRpbWVvdXRzKHZhbHVlOiBDb21wdXRlSGVhbHRoQ2hlY2tUaW1lb3V0cykge1xuICAgIHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUaW1lb3V0cygpIHtcbiAgICB0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0aW1lb3V0c0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gPT09PT09PT09XG4gIC8vIFNZTlRIRVNJU1xuICAvLyA9PT09PT09PT1cblxuICBwcm90ZWN0ZWQgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICBjaGVja19pbnRlcnZhbF9zZWM6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX2NoZWNrSW50ZXJ2YWxTZWMpLFxuICAgICAgZGVzY3JpcHRpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2Rlc2NyaXB0aW9uKSxcbiAgICAgIGhlYWx0aHlfdGhyZXNob2xkOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9oZWFsdGh5VGhyZXNob2xkKSxcbiAgICAgIGlkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9pZCksXG4gICAgICBuYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9uYW1lKSxcbiAgICAgIHByb2plY3Q6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3Byb2plY3QpLFxuICAgICAgdGltZW91dF9zZWM6IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHRoaXMuX3RpbWVvdXRTZWMpLFxuICAgICAgdW5oZWFsdGh5X3RocmVzaG9sZDogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fdW5oZWFsdGh5VGhyZXNob2xkKSxcbiAgICAgIGdycGNfaGVhbHRoX2NoZWNrOiBjb21wdXRlSGVhbHRoQ2hlY2tHcnBjSGVhbHRoQ2hlY2tUb1RlcnJhZm9ybSh0aGlzLl9ncnBjSGVhbHRoQ2hlY2suaW50ZXJuYWxWYWx1ZSksXG4gICAgICBodHRwMl9oZWFsdGhfY2hlY2s6IGNvbXB1dGVIZWFsdGhDaGVja0h0dHAySGVhbHRoQ2hlY2tUb1RlcnJhZm9ybSh0aGlzLl9odHRwMkhlYWx0aENoZWNrLmludGVybmFsVmFsdWUpLFxuICAgICAgaHR0cF9oZWFsdGhfY2hlY2s6IGNvbXB1dGVIZWFsdGhDaGVja0h0dHBIZWFsdGhDaGVja1RvVGVycmFmb3JtKHRoaXMuX2h0dHBIZWFsdGhDaGVjay5pbnRlcm5hbFZhbHVlKSxcbiAgICAgIGh0dHBzX2hlYWx0aF9jaGVjazogY29tcHV0ZUhlYWx0aENoZWNrSHR0cHNIZWFsdGhDaGVja1RvVGVycmFmb3JtKHRoaXMuX2h0dHBzSGVhbHRoQ2hlY2suaW50ZXJuYWxWYWx1ZSksXG4gICAgICBsb2dfY29uZmlnOiBjb21wdXRlSGVhbHRoQ2hlY2tMb2dDb25maWdUb1RlcnJhZm9ybSh0aGlzLl9sb2dDb25maWcuaW50ZXJuYWxWYWx1ZSksXG4gICAgICBzc2xfaGVhbHRoX2NoZWNrOiBjb21wdXRlSGVhbHRoQ2hlY2tTc2xIZWFsdGhDaGVja1RvVGVycmFmb3JtKHRoaXMuX3NzbEhlYWx0aENoZWNrLmludGVybmFsVmFsdWUpLFxuICAgICAgdGNwX2hlYWx0aF9jaGVjazogY29tcHV0ZUhlYWx0aENoZWNrVGNwSGVhbHRoQ2hlY2tUb1RlcnJhZm9ybSh0aGlzLl90Y3BIZWFsdGhDaGVjay5pbnRlcm5hbFZhbHVlKSxcbiAgICAgIHRpbWVvdXRzOiBjb21wdXRlSGVhbHRoQ2hlY2tUaW1lb3V0c1RvVGVycmFmb3JtKHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWUpLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==