import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNetworkFirewallPolicyAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The target that the firewall policy is attached to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_association#attachment_target ComputeNetworkFirewallPolicyAssociation#attachment_target}
    */
    readonly attachmentTarget: string;
    /**
    * The firewall policy ID of the association.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_association#firewall_policy ComputeNetworkFirewallPolicyAssociation#firewall_policy}
    */
    readonly firewallPolicy: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_association#id ComputeNetworkFirewallPolicyAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name for an association.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_association#name ComputeNetworkFirewallPolicyAssociation#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_association#project ComputeNetworkFirewallPolicyAssociation#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_association#timeouts ComputeNetworkFirewallPolicyAssociation#timeouts}
    */
    readonly timeouts?: ComputeNetworkFirewallPolicyAssociationTimeouts;
}
export interface ComputeNetworkFirewallPolicyAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_association#create ComputeNetworkFirewallPolicyAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_association#delete ComputeNetworkFirewallPolicyAssociation#delete}
    */
    readonly delete?: string;
}
export declare function computeNetworkFirewallPolicyAssociationTimeoutsToTerraform(struct?: ComputeNetworkFirewallPolicyAssociationTimeoutsOutputReference | ComputeNetworkFirewallPolicyAssociationTimeouts | cdktf.IResolvable): any;
export declare class ComputeNetworkFirewallPolicyAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNetworkFirewallPolicyAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeNetworkFirewallPolicyAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_association google_compute_network_firewall_policy_association}
*/
export declare class ComputeNetworkFirewallPolicyAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_network_firewall_policy_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_association google_compute_network_firewall_policy_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeNetworkFirewallPolicyAssociationConfig
    */
    constructor(scope: Construct, id: string, config: ComputeNetworkFirewallPolicyAssociationConfig);
    private _attachmentTarget?;
    get attachmentTarget(): string;
    set attachmentTarget(value: string);
    get attachmentTargetInput(): string | undefined;
    private _firewallPolicy?;
    get firewallPolicy(): string;
    set firewallPolicy(value: string);
    get firewallPolicyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get shortName(): string;
    private _timeouts;
    get timeouts(): ComputeNetworkFirewallPolicyAssociationTimeoutsOutputReference;
    putTimeouts(value: ComputeNetworkFirewallPolicyAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeNetworkFirewallPolicyAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
