import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNetworkFirewallPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Action to perform when the client connection triggers the rule. Can currently be either "allow" or "deny()" where valid values for status are 403, 404, and 502.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#action ComputeNetworkFirewallPolicyRule#action}
    */
    readonly action: string;
    /**
    * An optional description for this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#description ComputeNetworkFirewallPolicyRule#description}
    */
    readonly description?: string;
    /**
    * The direction in which this rule applies. Possible values: INGRESS, EGRESS
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#direction ComputeNetworkFirewallPolicyRule#direction}
    */
    readonly direction: string;
    /**
    * Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#disabled ComputeNetworkFirewallPolicyRule#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#enable_logging ComputeNetworkFirewallPolicyRule#enable_logging}
    */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
    * The firewall policy of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#firewall_policy ComputeNetworkFirewallPolicyRule#firewall_policy}
    */
    readonly firewallPolicy: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#id ComputeNetworkFirewallPolicyRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#priority ComputeNetworkFirewallPolicyRule#priority}
    */
    readonly priority: number;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#project ComputeNetworkFirewallPolicyRule#project}
    */
    readonly project?: string;
    /**
    * An optional name for the rule. This field is not a unique identifier and can be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#rule_name ComputeNetworkFirewallPolicyRule#rule_name}
    */
    readonly ruleName?: string;
    /**
    * A list of service accounts indicating the sets of instances that are applied with this rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#target_service_accounts ComputeNetworkFirewallPolicyRule#target_service_accounts}
    */
    readonly targetServiceAccounts?: string[];
    /**
    * match block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#match ComputeNetworkFirewallPolicyRule#match}
    */
    readonly match: ComputeNetworkFirewallPolicyRuleMatch;
    /**
    * target_secure_tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#target_secure_tags ComputeNetworkFirewallPolicyRule#target_secure_tags}
    */
    readonly targetSecureTags?: ComputeNetworkFirewallPolicyRuleTargetSecureTags[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#timeouts ComputeNetworkFirewallPolicyRule#timeouts}
    */
    readonly timeouts?: ComputeNetworkFirewallPolicyRuleTimeouts;
}
export interface ComputeNetworkFirewallPolicyRuleMatchLayer4Configs {
    /**
    * The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (`tcp`, `udp`, `icmp`, `esp`, `ah`, `ipip`, `sctp`), or the IP protocol number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#ip_protocol ComputeNetworkFirewallPolicyRule#ip_protocol}
    */
    readonly ipProtocol: string;
    /**
    * An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ``.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#ports ComputeNetworkFirewallPolicyRule#ports}
    */
    readonly ports?: string[];
}
export declare function computeNetworkFirewallPolicyRuleMatchLayer4ConfigsToTerraform(struct?: ComputeNetworkFirewallPolicyRuleMatchLayer4Configs | cdktf.IResolvable): any;
export declare class ComputeNetworkFirewallPolicyRuleMatchLayer4ConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeNetworkFirewallPolicyRuleMatchLayer4Configs | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeNetworkFirewallPolicyRuleMatchLayer4Configs | cdktf.IResolvable | undefined);
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    get ipProtocolInput(): string | undefined;
    private _ports?;
    get ports(): string[];
    set ports(value: string[]);
    resetPorts(): void;
    get portsInput(): string[] | undefined;
}
export declare class ComputeNetworkFirewallPolicyRuleMatchLayer4ConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeNetworkFirewallPolicyRuleMatchLayer4Configs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeNetworkFirewallPolicyRuleMatchLayer4ConfigsOutputReference;
}
export interface ComputeNetworkFirewallPolicyRuleMatchSrcSecureTags {
    /**
    * Name of the secure tag, created with TagManager's TagValue API. @pattern tagValues/[0-9]+
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#name ComputeNetworkFirewallPolicyRule#name}
    */
    readonly name: string;
}
export declare function computeNetworkFirewallPolicyRuleMatchSrcSecureTagsToTerraform(struct?: ComputeNetworkFirewallPolicyRuleMatchSrcSecureTags | cdktf.IResolvable): any;
export declare class ComputeNetworkFirewallPolicyRuleMatchSrcSecureTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeNetworkFirewallPolicyRuleMatchSrcSecureTags | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeNetworkFirewallPolicyRuleMatchSrcSecureTags | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get state(): string;
}
export declare class ComputeNetworkFirewallPolicyRuleMatchSrcSecureTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeNetworkFirewallPolicyRuleMatchSrcSecureTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeNetworkFirewallPolicyRuleMatchSrcSecureTagsOutputReference;
}
export interface ComputeNetworkFirewallPolicyRuleMatch {
    /**
    * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#dest_ip_ranges ComputeNetworkFirewallPolicyRule#dest_ip_ranges}
    */
    readonly destIpRanges?: string[];
    /**
    * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#src_ip_ranges ComputeNetworkFirewallPolicyRule#src_ip_ranges}
    */
    readonly srcIpRanges?: string[];
    /**
    * layer4_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#layer4_configs ComputeNetworkFirewallPolicyRule#layer4_configs}
    */
    readonly layer4Configs: ComputeNetworkFirewallPolicyRuleMatchLayer4Configs[] | cdktf.IResolvable;
    /**
    * src_secure_tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#src_secure_tags ComputeNetworkFirewallPolicyRule#src_secure_tags}
    */
    readonly srcSecureTags?: ComputeNetworkFirewallPolicyRuleMatchSrcSecureTags[] | cdktf.IResolvable;
}
export declare function computeNetworkFirewallPolicyRuleMatchToTerraform(struct?: ComputeNetworkFirewallPolicyRuleMatchOutputReference | ComputeNetworkFirewallPolicyRuleMatch): any;
export declare class ComputeNetworkFirewallPolicyRuleMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNetworkFirewallPolicyRuleMatch | undefined;
    set internalValue(value: ComputeNetworkFirewallPolicyRuleMatch | undefined);
    private _destIpRanges?;
    get destIpRanges(): string[];
    set destIpRanges(value: string[]);
    resetDestIpRanges(): void;
    get destIpRangesInput(): string[] | undefined;
    private _srcIpRanges?;
    get srcIpRanges(): string[];
    set srcIpRanges(value: string[]);
    resetSrcIpRanges(): void;
    get srcIpRangesInput(): string[] | undefined;
    private _layer4Configs;
    get layer4Configs(): ComputeNetworkFirewallPolicyRuleMatchLayer4ConfigsList;
    putLayer4Configs(value: ComputeNetworkFirewallPolicyRuleMatchLayer4Configs[] | cdktf.IResolvable): void;
    get layer4ConfigsInput(): cdktf.IResolvable | ComputeNetworkFirewallPolicyRuleMatchLayer4Configs[] | undefined;
    private _srcSecureTags;
    get srcSecureTags(): ComputeNetworkFirewallPolicyRuleMatchSrcSecureTagsList;
    putSrcSecureTags(value: ComputeNetworkFirewallPolicyRuleMatchSrcSecureTags[] | cdktf.IResolvable): void;
    resetSrcSecureTags(): void;
    get srcSecureTagsInput(): cdktf.IResolvable | ComputeNetworkFirewallPolicyRuleMatchSrcSecureTags[] | undefined;
}
export interface ComputeNetworkFirewallPolicyRuleTargetSecureTags {
    /**
    * Name of the secure tag, created with TagManager's TagValue API. @pattern tagValues/[0-9]+
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#name ComputeNetworkFirewallPolicyRule#name}
    */
    readonly name: string;
}
export declare function computeNetworkFirewallPolicyRuleTargetSecureTagsToTerraform(struct?: ComputeNetworkFirewallPolicyRuleTargetSecureTags | cdktf.IResolvable): any;
export declare class ComputeNetworkFirewallPolicyRuleTargetSecureTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeNetworkFirewallPolicyRuleTargetSecureTags | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeNetworkFirewallPolicyRuleTargetSecureTags | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get state(): string;
}
export declare class ComputeNetworkFirewallPolicyRuleTargetSecureTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeNetworkFirewallPolicyRuleTargetSecureTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeNetworkFirewallPolicyRuleTargetSecureTagsOutputReference;
}
export interface ComputeNetworkFirewallPolicyRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#create ComputeNetworkFirewallPolicyRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#delete ComputeNetworkFirewallPolicyRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule#update ComputeNetworkFirewallPolicyRule#update}
    */
    readonly update?: string;
}
export declare function computeNetworkFirewallPolicyRuleTimeoutsToTerraform(struct?: ComputeNetworkFirewallPolicyRuleTimeoutsOutputReference | ComputeNetworkFirewallPolicyRuleTimeouts | cdktf.IResolvable): any;
export declare class ComputeNetworkFirewallPolicyRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNetworkFirewallPolicyRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeNetworkFirewallPolicyRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule google_compute_network_firewall_policy_rule}
*/
export declare class ComputeNetworkFirewallPolicyRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_network_firewall_policy_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_firewall_policy_rule google_compute_network_firewall_policy_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeNetworkFirewallPolicyRuleConfig
    */
    constructor(scope: Construct, id: string, config: ComputeNetworkFirewallPolicyRuleConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    get enableLogging(): boolean | cdktf.IResolvable;
    set enableLogging(value: boolean | cdktf.IResolvable);
    resetEnableLogging(): void;
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallPolicy?;
    get firewallPolicy(): string;
    set firewallPolicy(value: string);
    get firewallPolicyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kind(): string;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _ruleName?;
    get ruleName(): string;
    set ruleName(value: string);
    resetRuleName(): void;
    get ruleNameInput(): string | undefined;
    get ruleTupleCount(): number;
    private _targetServiceAccounts?;
    get targetServiceAccounts(): string[];
    set targetServiceAccounts(value: string[]);
    resetTargetServiceAccounts(): void;
    get targetServiceAccountsInput(): string[] | undefined;
    private _match;
    get match(): ComputeNetworkFirewallPolicyRuleMatchOutputReference;
    putMatch(value: ComputeNetworkFirewallPolicyRuleMatch): void;
    get matchInput(): ComputeNetworkFirewallPolicyRuleMatch | undefined;
    private _targetSecureTags;
    get targetSecureTags(): ComputeNetworkFirewallPolicyRuleTargetSecureTagsList;
    putTargetSecureTags(value: ComputeNetworkFirewallPolicyRuleTargetSecureTags[] | cdktf.IResolvable): void;
    resetTargetSecureTags(): void;
    get targetSecureTagsInput(): cdktf.IResolvable | ComputeNetworkFirewallPolicyRuleTargetSecureTags[] | undefined;
    private _timeouts;
    get timeouts(): ComputeNetworkFirewallPolicyRuleTimeoutsOutputReference;
    putTimeouts(value: ComputeNetworkFirewallPolicyRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeNetworkFirewallPolicyRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
