import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputePacketMirroringConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of the rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#description ComputePacketMirroring#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#id ComputePacketMirroring#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the packet mirroring rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#name ComputePacketMirroring#name}
    */
    readonly name: string;
    /**
    * Since only one rule can be active at a time, priority is
  used to break ties in the case of two rules that apply to
  the same instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#priority ComputePacketMirroring#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#project ComputePacketMirroring#project}
    */
    readonly project?: string;
    /**
    * The Region in which the created address should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#region ComputePacketMirroring#region}
    */
    readonly region?: string;
    /**
    * collector_ilb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#collector_ilb ComputePacketMirroring#collector_ilb}
    */
    readonly collectorIlb: ComputePacketMirroringCollectorIlb;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#filter ComputePacketMirroring#filter}
    */
    readonly filter?: ComputePacketMirroringFilter;
    /**
    * mirrored_resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#mirrored_resources ComputePacketMirroring#mirrored_resources}
    */
    readonly mirroredResources: ComputePacketMirroringMirroredResources;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#network ComputePacketMirroring#network}
    */
    readonly network: ComputePacketMirroringNetwork;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#timeouts ComputePacketMirroring#timeouts}
    */
    readonly timeouts?: ComputePacketMirroringTimeouts;
}
export interface ComputePacketMirroringCollectorIlb {
    /**
    * The URL of the forwarding rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#url ComputePacketMirroring#url}
    */
    readonly url: string;
}
export declare function computePacketMirroringCollectorIlbToTerraform(struct?: ComputePacketMirroringCollectorIlbOutputReference | ComputePacketMirroringCollectorIlb): any;
export declare class ComputePacketMirroringCollectorIlbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputePacketMirroringCollectorIlb | undefined;
    set internalValue(value: ComputePacketMirroringCollectorIlb | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface ComputePacketMirroringFilter {
    /**
    * IP CIDR ranges that apply as a filter on the source (ingress) or
  destination (egress) IP in the IP header. Only IPv4 is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#cidr_ranges ComputePacketMirroring#cidr_ranges}
    */
    readonly cidrRanges?: string[];
    /**
    * Direction of traffic to mirror. Default value: "BOTH" Possible values: ["INGRESS", "EGRESS", "BOTH"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#direction ComputePacketMirroring#direction}
    */
    readonly direction?: string;
    /**
    * Possible IP protocols including tcp, udp, icmp and esp
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#ip_protocols ComputePacketMirroring#ip_protocols}
    */
    readonly ipProtocols?: string[];
}
export declare function computePacketMirroringFilterToTerraform(struct?: ComputePacketMirroringFilterOutputReference | ComputePacketMirroringFilter): any;
export declare class ComputePacketMirroringFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputePacketMirroringFilter | undefined;
    set internalValue(value: ComputePacketMirroringFilter | undefined);
    private _cidrRanges?;
    get cidrRanges(): string[];
    set cidrRanges(value: string[]);
    resetCidrRanges(): void;
    get cidrRangesInput(): string[] | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _ipProtocols?;
    get ipProtocols(): string[];
    set ipProtocols(value: string[]);
    resetIpProtocols(): void;
    get ipProtocolsInput(): string[] | undefined;
}
export interface ComputePacketMirroringMirroredResourcesInstances {
    /**
    * The URL of the instances where this rule should be active.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#url ComputePacketMirroring#url}
    */
    readonly url: string;
}
export declare function computePacketMirroringMirroredResourcesInstancesToTerraform(struct?: ComputePacketMirroringMirroredResourcesInstances | cdktf.IResolvable): any;
export declare class ComputePacketMirroringMirroredResourcesInstancesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputePacketMirroringMirroredResourcesInstances | cdktf.IResolvable | undefined;
    set internalValue(value: ComputePacketMirroringMirroredResourcesInstances | cdktf.IResolvable | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export declare class ComputePacketMirroringMirroredResourcesInstancesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputePacketMirroringMirroredResourcesInstances[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputePacketMirroringMirroredResourcesInstancesOutputReference;
}
export interface ComputePacketMirroringMirroredResourcesSubnetworks {
    /**
    * The URL of the subnetwork where this rule should be active.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#url ComputePacketMirroring#url}
    */
    readonly url: string;
}
export declare function computePacketMirroringMirroredResourcesSubnetworksToTerraform(struct?: ComputePacketMirroringMirroredResourcesSubnetworks | cdktf.IResolvable): any;
export declare class ComputePacketMirroringMirroredResourcesSubnetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputePacketMirroringMirroredResourcesSubnetworks | cdktf.IResolvable | undefined;
    set internalValue(value: ComputePacketMirroringMirroredResourcesSubnetworks | cdktf.IResolvable | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export declare class ComputePacketMirroringMirroredResourcesSubnetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputePacketMirroringMirroredResourcesSubnetworks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputePacketMirroringMirroredResourcesSubnetworksOutputReference;
}
export interface ComputePacketMirroringMirroredResources {
    /**
    * All instances with these tags will be mirrored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#tags ComputePacketMirroring#tags}
    */
    readonly tags?: string[];
    /**
    * instances block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#instances ComputePacketMirroring#instances}
    */
    readonly instances?: ComputePacketMirroringMirroredResourcesInstances[] | cdktf.IResolvable;
    /**
    * subnetworks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#subnetworks ComputePacketMirroring#subnetworks}
    */
    readonly subnetworks?: ComputePacketMirroringMirroredResourcesSubnetworks[] | cdktf.IResolvable;
}
export declare function computePacketMirroringMirroredResourcesToTerraform(struct?: ComputePacketMirroringMirroredResourcesOutputReference | ComputePacketMirroringMirroredResources): any;
export declare class ComputePacketMirroringMirroredResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputePacketMirroringMirroredResources | undefined;
    set internalValue(value: ComputePacketMirroringMirroredResources | undefined);
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _instances;
    get instances(): ComputePacketMirroringMirroredResourcesInstancesList;
    putInstances(value: ComputePacketMirroringMirroredResourcesInstances[] | cdktf.IResolvable): void;
    resetInstances(): void;
    get instancesInput(): cdktf.IResolvable | ComputePacketMirroringMirroredResourcesInstances[] | undefined;
    private _subnetworks;
    get subnetworks(): ComputePacketMirroringMirroredResourcesSubnetworksList;
    putSubnetworks(value: ComputePacketMirroringMirroredResourcesSubnetworks[] | cdktf.IResolvable): void;
    resetSubnetworks(): void;
    get subnetworksInput(): cdktf.IResolvable | ComputePacketMirroringMirroredResourcesSubnetworks[] | undefined;
}
export interface ComputePacketMirroringNetwork {
    /**
    * The full self_link URL of the network where this rule is active.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#url ComputePacketMirroring#url}
    */
    readonly url: string;
}
export declare function computePacketMirroringNetworkToTerraform(struct?: ComputePacketMirroringNetworkOutputReference | ComputePacketMirroringNetwork): any;
export declare class ComputePacketMirroringNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputePacketMirroringNetwork | undefined;
    set internalValue(value: ComputePacketMirroringNetwork | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface ComputePacketMirroringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#create ComputePacketMirroring#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#delete ComputePacketMirroring#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring#update ComputePacketMirroring#update}
    */
    readonly update?: string;
}
export declare function computePacketMirroringTimeoutsToTerraform(struct?: ComputePacketMirroringTimeoutsOutputReference | ComputePacketMirroringTimeouts | cdktf.IResolvable): any;
export declare class ComputePacketMirroringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputePacketMirroringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputePacketMirroringTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring google_compute_packet_mirroring}
*/
export declare class ComputePacketMirroring extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_packet_mirroring";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring google_compute_packet_mirroring} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputePacketMirroringConfig
    */
    constructor(scope: Construct, id: string, config: ComputePacketMirroringConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _collectorIlb;
    get collectorIlb(): ComputePacketMirroringCollectorIlbOutputReference;
    putCollectorIlb(value: ComputePacketMirroringCollectorIlb): void;
    get collectorIlbInput(): ComputePacketMirroringCollectorIlb | undefined;
    private _filter;
    get filter(): ComputePacketMirroringFilterOutputReference;
    putFilter(value: ComputePacketMirroringFilter): void;
    resetFilter(): void;
    get filterInput(): ComputePacketMirroringFilter | undefined;
    private _mirroredResources;
    get mirroredResources(): ComputePacketMirroringMirroredResourcesOutputReference;
    putMirroredResources(value: ComputePacketMirroringMirroredResources): void;
    get mirroredResourcesInput(): ComputePacketMirroringMirroredResources | undefined;
    private _network;
    get network(): ComputePacketMirroringNetworkOutputReference;
    putNetwork(value: ComputePacketMirroringNetwork): void;
    get networkInput(): ComputePacketMirroringNetwork | undefined;
    private _timeouts;
    get timeouts(): ComputePacketMirroringTimeoutsOutputReference;
    putTimeouts(value: ComputePacketMirroringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputePacketMirroringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
