import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
    * How often (in seconds) to send a health check. The default value is 5
  seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#check_interval_sec ComputeRegionHealthCheck#check_interval_sec}
    */
    readonly checkIntervalSec?: number;
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#description ComputeRegionHealthCheck#description}
    */
    readonly description?: string;
    /**
    * A so-far unhealthy instance will be marked healthy after this many
  consecutive successes. The default value is 2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#healthy_threshold ComputeRegionHealthCheck#healthy_threshold}
    */
    readonly healthyThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#id ComputeRegionHealthCheck#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035.  Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the
  last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#name ComputeRegionHealthCheck#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#project ComputeRegionHealthCheck#project}
    */
    readonly project?: string;
    /**
    * The Region in which the created health check should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#region ComputeRegionHealthCheck#region}
    */
    readonly region?: string;
    /**
    * How long (in seconds) to wait before claiming failure.
  The default value is 5 seconds.  It is invalid for timeoutSec to have
  greater value than checkIntervalSec.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#timeout_sec ComputeRegionHealthCheck#timeout_sec}
    */
    readonly timeoutSec?: number;
    /**
    * A so-far healthy instance will be marked unhealthy after this many
  consecutive failures. The default value is 2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#unhealthy_threshold ComputeRegionHealthCheck#unhealthy_threshold}
    */
    readonly unhealthyThreshold?: number;
    /**
    * grpc_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#grpc_health_check ComputeRegionHealthCheck#grpc_health_check}
    */
    readonly grpcHealthCheck?: ComputeRegionHealthCheckGrpcHealthCheck;
    /**
    * http2_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#http2_health_check ComputeRegionHealthCheck#http2_health_check}
    */
    readonly http2HealthCheck?: ComputeRegionHealthCheckHttp2HealthCheck;
    /**
    * http_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#http_health_check ComputeRegionHealthCheck#http_health_check}
    */
    readonly httpHealthCheck?: ComputeRegionHealthCheckHttpHealthCheck;
    /**
    * https_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#https_health_check ComputeRegionHealthCheck#https_health_check}
    */
    readonly httpsHealthCheck?: ComputeRegionHealthCheckHttpsHealthCheck;
    /**
    * log_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#log_config ComputeRegionHealthCheck#log_config}
    */
    readonly logConfig?: ComputeRegionHealthCheckLogConfig;
    /**
    * ssl_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#ssl_health_check ComputeRegionHealthCheck#ssl_health_check}
    */
    readonly sslHealthCheck?: ComputeRegionHealthCheckSslHealthCheck;
    /**
    * tcp_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#tcp_health_check ComputeRegionHealthCheck#tcp_health_check}
    */
    readonly tcpHealthCheck?: ComputeRegionHealthCheckTcpHealthCheck;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#timeouts ComputeRegionHealthCheck#timeouts}
    */
    readonly timeouts?: ComputeRegionHealthCheckTimeouts;
}
export interface ComputeRegionHealthCheckGrpcHealthCheck {
    /**
    * The gRPC service name for the health check.
  The value of grpcServiceName has the following meanings by convention:
  
  * Empty serviceName means the overall status of all services at the backend.
  * Non-empty serviceName means the health of that gRPC service, as defined by the owner of the service.
  
  The grpcServiceName can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#grpc_service_name ComputeRegionHealthCheck#grpc_service_name}
    */
    readonly grpcServiceName?: string;
    /**
    * The port number for the health check request.
  Must be specified if portName and portSpecification are not set
  or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port ComputeRegionHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port_name ComputeRegionHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, gRPC health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port_specification ComputeRegionHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
}
export declare function computeRegionHealthCheckGrpcHealthCheckToTerraform(struct?: ComputeRegionHealthCheckGrpcHealthCheckOutputReference | ComputeRegionHealthCheckGrpcHealthCheck): any;
export declare class ComputeRegionHealthCheckGrpcHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionHealthCheckGrpcHealthCheck | undefined;
    set internalValue(value: ComputeRegionHealthCheckGrpcHealthCheck | undefined);
    private _grpcServiceName?;
    get grpcServiceName(): string;
    set grpcServiceName(value: string);
    resetGrpcServiceName(): void;
    get grpcServiceNameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
}
export interface ComputeRegionHealthCheckHttp2HealthCheck {
    /**
    * The value of the host header in the HTTP2 health check request.
  If left empty (default value), the public IP on behalf of which this health
  check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#host ComputeRegionHealthCheck#host}
    */
    readonly host?: string;
    /**
    * The TCP port number for the HTTP2 health check request.
  The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port ComputeRegionHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port_name ComputeRegionHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, HTTP2 health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port_specification ComputeRegionHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#proxy_header ComputeRegionHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The request path of the HTTP2 health check request.
  The default value is /.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#request_path ComputeRegionHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#response ComputeRegionHealthCheck#response}
    */
    readonly response?: string;
}
export declare function computeRegionHealthCheckHttp2HealthCheckToTerraform(struct?: ComputeRegionHealthCheckHttp2HealthCheckOutputReference | ComputeRegionHealthCheckHttp2HealthCheck): any;
export declare class ComputeRegionHealthCheckHttp2HealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionHealthCheckHttp2HealthCheck | undefined;
    set internalValue(value: ComputeRegionHealthCheckHttp2HealthCheck | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeRegionHealthCheckHttpHealthCheck {
    /**
    * The value of the host header in the HTTP health check request.
  If left empty (default value), the public IP on behalf of which this health
  check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#host ComputeRegionHealthCheck#host}
    */
    readonly host?: string;
    /**
    * The TCP port number for the HTTP health check request.
  The default value is 80.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port ComputeRegionHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port_name ComputeRegionHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, HTTP health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port_specification ComputeRegionHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#proxy_header ComputeRegionHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The request path of the HTTP health check request.
  The default value is /.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#request_path ComputeRegionHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#response ComputeRegionHealthCheck#response}
    */
    readonly response?: string;
}
export declare function computeRegionHealthCheckHttpHealthCheckToTerraform(struct?: ComputeRegionHealthCheckHttpHealthCheckOutputReference | ComputeRegionHealthCheckHttpHealthCheck): any;
export declare class ComputeRegionHealthCheckHttpHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionHealthCheckHttpHealthCheck | undefined;
    set internalValue(value: ComputeRegionHealthCheckHttpHealthCheck | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeRegionHealthCheckHttpsHealthCheck {
    /**
    * The value of the host header in the HTTPS health check request.
  If left empty (default value), the public IP on behalf of which this health
  check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#host ComputeRegionHealthCheck#host}
    */
    readonly host?: string;
    /**
    * The TCP port number for the HTTPS health check request.
  The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port ComputeRegionHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port_name ComputeRegionHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, HTTPS health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port_specification ComputeRegionHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#proxy_header ComputeRegionHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The request path of the HTTPS health check request.
  The default value is /.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#request_path ComputeRegionHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#response ComputeRegionHealthCheck#response}
    */
    readonly response?: string;
}
export declare function computeRegionHealthCheckHttpsHealthCheckToTerraform(struct?: ComputeRegionHealthCheckHttpsHealthCheckOutputReference | ComputeRegionHealthCheckHttpsHealthCheck): any;
export declare class ComputeRegionHealthCheckHttpsHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionHealthCheckHttpsHealthCheck | undefined;
    set internalValue(value: ComputeRegionHealthCheckHttpsHealthCheck | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeRegionHealthCheckLogConfig {
    /**
    * Indicates whether or not to export logs. This is false by default,
  which means no health check logging will be done.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#enable ComputeRegionHealthCheck#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
}
export declare function computeRegionHealthCheckLogConfigToTerraform(struct?: ComputeRegionHealthCheckLogConfigOutputReference | ComputeRegionHealthCheckLogConfig): any;
export declare class ComputeRegionHealthCheckLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionHealthCheckLogConfig | undefined;
    set internalValue(value: ComputeRegionHealthCheckLogConfig | undefined);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeRegionHealthCheckSslHealthCheck {
    /**
    * The TCP port number for the SSL health check request.
  The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port ComputeRegionHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port_name ComputeRegionHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, SSL health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port_specification ComputeRegionHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#proxy_header ComputeRegionHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The application data to send once the SSL connection has been
  established (default value is empty). If both request and response are
  empty, the connection establishment alone will indicate health. The request
  data can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#request ComputeRegionHealthCheck#request}
    */
    readonly request?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#response ComputeRegionHealthCheck#response}
    */
    readonly response?: string;
}
export declare function computeRegionHealthCheckSslHealthCheckToTerraform(struct?: ComputeRegionHealthCheckSslHealthCheckOutputReference | ComputeRegionHealthCheckSslHealthCheck): any;
export declare class ComputeRegionHealthCheckSslHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionHealthCheckSslHealthCheck | undefined;
    set internalValue(value: ComputeRegionHealthCheckSslHealthCheck | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _request?;
    get request(): string;
    set request(value: string);
    resetRequest(): void;
    get requestInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeRegionHealthCheckTcpHealthCheck {
    /**
    * The TCP port number for the TCP health check request.
  The default value is 80.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port ComputeRegionHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port_name ComputeRegionHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, TCP health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#port_specification ComputeRegionHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#proxy_header ComputeRegionHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The application data to send once the TCP connection has been
  established (default value is empty). If both request and response are
  empty, the connection establishment alone will indicate health. The request
  data can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#request ComputeRegionHealthCheck#request}
    */
    readonly request?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#response ComputeRegionHealthCheck#response}
    */
    readonly response?: string;
}
export declare function computeRegionHealthCheckTcpHealthCheckToTerraform(struct?: ComputeRegionHealthCheckTcpHealthCheckOutputReference | ComputeRegionHealthCheckTcpHealthCheck): any;
export declare class ComputeRegionHealthCheckTcpHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionHealthCheckTcpHealthCheck | undefined;
    set internalValue(value: ComputeRegionHealthCheckTcpHealthCheck | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _request?;
    get request(): string;
    set request(value: string);
    resetRequest(): void;
    get requestInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeRegionHealthCheckTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#create ComputeRegionHealthCheck#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#delete ComputeRegionHealthCheck#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check#update ComputeRegionHealthCheck#update}
    */
    readonly update?: string;
}
export declare function computeRegionHealthCheckTimeoutsToTerraform(struct?: ComputeRegionHealthCheckTimeoutsOutputReference | ComputeRegionHealthCheckTimeouts | cdktf.IResolvable): any;
export declare class ComputeRegionHealthCheckTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionHealthCheckTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionHealthCheckTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check google_compute_region_health_check}
*/
export declare class ComputeRegionHealthCheck extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_health_check";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check google_compute_region_health_check} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeRegionHealthCheckConfig
    */
    constructor(scope: Construct, id: string, config: ComputeRegionHealthCheckConfig);
    private _checkIntervalSec?;
    get checkIntervalSec(): number;
    set checkIntervalSec(value: number);
    resetCheckIntervalSec(): void;
    get checkIntervalSecInput(): number | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _healthyThreshold?;
    get healthyThreshold(): number;
    set healthyThreshold(value: number);
    resetHealthyThreshold(): void;
    get healthyThresholdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _timeoutSec?;
    get timeoutSec(): number;
    set timeoutSec(value: number);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
    get type(): string;
    private _unhealthyThreshold?;
    get unhealthyThreshold(): number;
    set unhealthyThreshold(value: number);
    resetUnhealthyThreshold(): void;
    get unhealthyThresholdInput(): number | undefined;
    private _grpcHealthCheck;
    get grpcHealthCheck(): ComputeRegionHealthCheckGrpcHealthCheckOutputReference;
    putGrpcHealthCheck(value: ComputeRegionHealthCheckGrpcHealthCheck): void;
    resetGrpcHealthCheck(): void;
    get grpcHealthCheckInput(): ComputeRegionHealthCheckGrpcHealthCheck | undefined;
    private _http2HealthCheck;
    get http2HealthCheck(): ComputeRegionHealthCheckHttp2HealthCheckOutputReference;
    putHttp2HealthCheck(value: ComputeRegionHealthCheckHttp2HealthCheck): void;
    resetHttp2HealthCheck(): void;
    get http2HealthCheckInput(): ComputeRegionHealthCheckHttp2HealthCheck | undefined;
    private _httpHealthCheck;
    get httpHealthCheck(): ComputeRegionHealthCheckHttpHealthCheckOutputReference;
    putHttpHealthCheck(value: ComputeRegionHealthCheckHttpHealthCheck): void;
    resetHttpHealthCheck(): void;
    get httpHealthCheckInput(): ComputeRegionHealthCheckHttpHealthCheck | undefined;
    private _httpsHealthCheck;
    get httpsHealthCheck(): ComputeRegionHealthCheckHttpsHealthCheckOutputReference;
    putHttpsHealthCheck(value: ComputeRegionHealthCheckHttpsHealthCheck): void;
    resetHttpsHealthCheck(): void;
    get httpsHealthCheckInput(): ComputeRegionHealthCheckHttpsHealthCheck | undefined;
    private _logConfig;
    get logConfig(): ComputeRegionHealthCheckLogConfigOutputReference;
    putLogConfig(value: ComputeRegionHealthCheckLogConfig): void;
    resetLogConfig(): void;
    get logConfigInput(): ComputeRegionHealthCheckLogConfig | undefined;
    private _sslHealthCheck;
    get sslHealthCheck(): ComputeRegionHealthCheckSslHealthCheckOutputReference;
    putSslHealthCheck(value: ComputeRegionHealthCheckSslHealthCheck): void;
    resetSslHealthCheck(): void;
    get sslHealthCheckInput(): ComputeRegionHealthCheckSslHealthCheck | undefined;
    private _tcpHealthCheck;
    get tcpHealthCheck(): ComputeRegionHealthCheckTcpHealthCheckOutputReference;
    putTcpHealthCheck(value: ComputeRegionHealthCheckTcpHealthCheck): void;
    resetTcpHealthCheck(): void;
    get tcpHealthCheckInput(): ComputeRegionHealthCheckTcpHealthCheck | undefined;
    private _timeouts;
    get timeouts(): ComputeRegionHealthCheckTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionHealthCheckTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeRegionHealthCheckTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
