import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionNetworkFirewallPolicyAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The target that the firewall policy is attached to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_firewall_policy_association#attachment_target ComputeRegionNetworkFirewallPolicyAssociation#attachment_target}
    */
    readonly attachmentTarget: string;
    /**
    * The firewall policy ID of the association.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_firewall_policy_association#firewall_policy ComputeRegionNetworkFirewallPolicyAssociation#firewall_policy}
    */
    readonly firewallPolicy: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_firewall_policy_association#id ComputeRegionNetworkFirewallPolicyAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name for an association.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_firewall_policy_association#name ComputeRegionNetworkFirewallPolicyAssociation#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_firewall_policy_association#project ComputeRegionNetworkFirewallPolicyAssociation#project}
    */
    readonly project?: string;
    /**
    * The location of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_firewall_policy_association#region ComputeRegionNetworkFirewallPolicyAssociation#region}
    */
    readonly region?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_firewall_policy_association#timeouts ComputeRegionNetworkFirewallPolicyAssociation#timeouts}
    */
    readonly timeouts?: ComputeRegionNetworkFirewallPolicyAssociationTimeouts;
}
export interface ComputeRegionNetworkFirewallPolicyAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_firewall_policy_association#create ComputeRegionNetworkFirewallPolicyAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_firewall_policy_association#delete ComputeRegionNetworkFirewallPolicyAssociation#delete}
    */
    readonly delete?: string;
}
export declare function computeRegionNetworkFirewallPolicyAssociationTimeoutsToTerraform(struct?: ComputeRegionNetworkFirewallPolicyAssociationTimeoutsOutputReference | ComputeRegionNetworkFirewallPolicyAssociationTimeouts | cdktf.IResolvable): any;
export declare class ComputeRegionNetworkFirewallPolicyAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionNetworkFirewallPolicyAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionNetworkFirewallPolicyAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_firewall_policy_association google_compute_region_network_firewall_policy_association}
*/
export declare class ComputeRegionNetworkFirewallPolicyAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_network_firewall_policy_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_firewall_policy_association google_compute_region_network_firewall_policy_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeRegionNetworkFirewallPolicyAssociationConfig
    */
    constructor(scope: Construct, id: string, config: ComputeRegionNetworkFirewallPolicyAssociationConfig);
    private _attachmentTarget?;
    get attachmentTarget(): string;
    set attachmentTarget(value: string);
    get attachmentTargetInput(): string | undefined;
    private _firewallPolicy?;
    get firewallPolicy(): string;
    set firewallPolicy(value: string);
    get firewallPolicyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get shortName(): string;
    private _timeouts;
    get timeouts(): ComputeRegionNetworkFirewallPolicyAssociationTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionNetworkFirewallPolicyAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeRegionNetworkFirewallPolicyAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
