import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionUrlMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * The full or partial URL of the defaultService resource to which traffic is directed if
  none of the hostRules match. If defaultRouteAction is additionally specified, advanced
  routing actions like URL Rewrites, etc. take effect prior to sending the request to the
  backend. However, if defaultService is specified, defaultRouteAction cannot contain any
  weightedBackendServices. Conversely, if routeAction specifies any
  weightedBackendServices, service must not be specified.  Only one of defaultService,
  defaultUrlRedirect or defaultRouteAction.weightedBackendService must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#default_service ComputeRegionUrlMap#default_service}
    */
    readonly defaultService?: string;
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#description ComputeRegionUrlMap#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#id ComputeRegionUrlMap#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#name ComputeRegionUrlMap#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#project ComputeRegionUrlMap#project}
    */
    readonly project?: string;
    /**
    * The Region in which the url map should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#region ComputeRegionUrlMap#region}
    */
    readonly region?: string;
    /**
    * default_route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#default_route_action ComputeRegionUrlMap#default_route_action}
    */
    readonly defaultRouteAction?: ComputeRegionUrlMapDefaultRouteAction;
    /**
    * default_url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#default_url_redirect ComputeRegionUrlMap#default_url_redirect}
    */
    readonly defaultUrlRedirect?: ComputeRegionUrlMapDefaultUrlRedirect;
    /**
    * host_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#host_rule ComputeRegionUrlMap#host_rule}
    */
    readonly hostRule?: ComputeRegionUrlMapHostRule[] | cdktf.IResolvable;
    /**
    * path_matcher block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#path_matcher ComputeRegionUrlMap#path_matcher}
    */
    readonly pathMatcher?: ComputeRegionUrlMapPathMatcher[] | cdktf.IResolvable;
    /**
    * test block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#test ComputeRegionUrlMap#test}
    */
    readonly test?: ComputeRegionUrlMapTest[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#timeouts ComputeRegionUrlMap#timeouts}
    */
    readonly timeouts?: ComputeRegionUrlMapTimeouts;
}
export interface ComputeRegionUrlMapDefaultRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This field translates to the Access-Control-Allow-Credentials header.
  Default is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_credentials ComputeRegionUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_headers ComputeRegionUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_methods ComputeRegionUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regualar expression patterns that match allowed origins. For regular expression grammar
  please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_origin_regexes ComputeRegionUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests.
  An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_origins ComputeRegionUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, the setting specifies the CORS policy is disabled. The default value of false, which indicates that the CORS policy is in effect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#disabled ComputeRegionUrlMap#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#expose_headers ComputeRegionUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long results of a preflight request can be cached in seconds.
  This translates to the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#max_age ComputeRegionUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function computeRegionUrlMapDefaultRouteActionCorsPolicyToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionCorsPolicyOutputReference | ComputeRegionUrlMapDefaultRouteActionCorsPolicy): any;
export declare class ComputeRegionUrlMapDefaultRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionCorsPolicy | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request.
  The value must be between 200 and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#http_status ComputeRegionUrlMap#http_status}
    */
    readonly httpStatus?: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
  The value must be between 0.0 and 100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#percentage ComputeRegionUrlMap#percentage}
    */
    readonly percentage?: number;
}
export declare function computeRegionUrlMapDefaultRouteActionFaultInjectionPolicyAbortToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyAbortOutputReference | ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyAbort): any;
export declare class ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are
  represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#nanos ComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#seconds ComputeRegionUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function computeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
  The value must be between 0.0 and 100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#percentage ComputeRegionUrlMap#percentage}
    */
    readonly percentage?: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#fixed_delay ComputeRegionUrlMap#fixed_delay}
    */
    readonly fixedDelay?: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function computeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayOutputReference | ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelay): any;
export declare class ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    resetFixedDelay(): void;
    get fixedDelayInput(): ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#abort ComputeRegionUrlMap#abort}
    */
    readonly abort?: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#delay ComputeRegionUrlMap#delay}
    */
    readonly delay?: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelay;
}
export declare function computeRegionUrlMapDefaultRouteActionFaultInjectionPolicyToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyOutputReference | ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicy): any;
export declare class ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface ComputeRegionUrlMapDefaultRouteActionRequestMirrorPolicy {
    /**
    * The full or partial URL to the RegionBackendService resource being mirrored to.
  The backend service configured for a mirroring policy must reference backends that are of the same type as the original backend service matched in the URL map.
  Serverless NEG backends are not currently supported as a mirrored backend service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#backend_service ComputeRegionUrlMap#backend_service}
    */
    readonly backendService?: string;
}
export declare function computeRegionUrlMapDefaultRouteActionRequestMirrorPolicyToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionRequestMirrorPolicyOutputReference | ComputeRegionUrlMapDefaultRouteActionRequestMirrorPolicy): any;
export declare class ComputeRegionUrlMapDefaultRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    resetBackendService(): void;
    get backendServiceInput(): string | undefined;
}
export interface ComputeRegionUrlMapDefaultRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are
  represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#nanos ComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#seconds ComputeRegionUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function computeRegionUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference | ComputeRegionUrlMapDefaultRouteActionRetryPolicyPerTryTimeout): any;
export declare class ComputeRegionUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeRegionUrlMapDefaultRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#num_retries ComputeRegionUrlMap#num_retries}
    */
    readonly numRetries?: number;
    /**
    * Specifies one or more conditions when this retry policy applies.
  Valid values are listed below. Only the following codes are supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true: cancelled, deadline-exceeded, internal, resource-exhausted, unavailable.
    - 5xx : retry is attempted if the instance or endpoint responds with any 5xx response code, or if the instance or endpoint does not respond at all. For example, disconnects, reset, read timeout, connection failure, and refused streams.
    - gateway-error : Similar to 5xx, but only applies to response codes 502, 503 or 504.
    - connect-failure : a retry is attempted on failures connecting to the instance or endpoint. For example, connection timeouts.
    - retriable-4xx : a retry is attempted if the instance or endpoint responds with a 4xx response code. The only error that you can retry is error code 409.
    - refused-stream : a retry is attempted if the instance or endpoint resets the stream with a REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
    - cancelled : a retry is attempted if the gRPC status code in the response header is set to cancelled.
    - deadline-exceeded : a retry is attempted if the gRPC status code in the response header is set to deadline-exceeded.
    - internal :  a retry is attempted if the gRPC status code in the response header is set to internal.
    - resource-exhausted : a retry is attempted if the gRPC status code in the response header is set to resource-exhausted.
    - unavailable : a retry is attempted if the gRPC status code in the response header is set to unavailable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#retry_conditions ComputeRegionUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#per_try_timeout ComputeRegionUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: ComputeRegionUrlMapDefaultRouteActionRetryPolicyPerTryTimeout;
}
export declare function computeRegionUrlMapDefaultRouteActionRetryPolicyToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionRetryPolicyOutputReference | ComputeRegionUrlMapDefaultRouteActionRetryPolicy): any;
export declare class ComputeRegionUrlMapDefaultRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionRetryPolicy | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): ComputeRegionUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: ComputeRegionUrlMapDefaultRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): ComputeRegionUrlMapDefaultRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface ComputeRegionUrlMapDefaultRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#nanos ComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#seconds ComputeRegionUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function computeRegionUrlMapDefaultRouteActionTimeoutToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionTimeoutOutputReference | ComputeRegionUrlMapDefaultRouteActionTimeout): any;
export declare class ComputeRegionUrlMapDefaultRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionTimeout | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeRegionUrlMapDefaultRouteActionUrlRewrite {
    /**
    * Before forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite.
  The value must be from 1 to 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#host_rewrite ComputeRegionUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Before forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite.
  The value must be from 1 to 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#path_prefix_rewrite ComputeRegionUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function computeRegionUrlMapDefaultRouteActionUrlRewriteToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionUrlRewriteOutputReference | ComputeRegionUrlMapDefaultRouteActionUrlRewrite): any;
export declare class ComputeRegionUrlMapDefaultRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionUrlRewrite | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_name ComputeRegionUrlMap#header_name}
    */
    readonly headerName?: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_value ComputeRegionUrlMap#header_value}
    */
    readonly headerValue?: string;
    /**
    * If false, headerValue is appended to any values that already exist for the header. If true, headerValue is set for the header, discarding any values that were set for that header.
  The default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#replace ComputeRegionUrlMap#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function computeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    resetHeaderValue(): void;
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    resetReplace(): void;
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_name ComputeRegionUrlMap#header_name}
    */
    readonly headerName?: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_value ComputeRegionUrlMap#header_value}
    */
    readonly headerValue?: string;
    /**
    * If false, headerValue is appended to any values that already exist for the header. If true, headerValue is set for the header, discarding any values that were set for that header.
  The default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#replace ComputeRegionUrlMap#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function computeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    resetHeaderValue(): void;
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    resetReplace(): void;
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#request_headers_to_remove ComputeRegionUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response before sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#response_headers_to_remove ComputeRegionUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#request_headers_to_add ComputeRegionUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#response_headers_to_add ComputeRegionUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function computeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference | ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction): any;
export declare class ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeRegionUrlMapDefaultRouteActionWeightedBackendServices {
    /**
    * The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#backend_service ComputeRegionUrlMap#backend_service}
    */
    readonly backendService?: string;
    /**
    * Specifies the fraction of traffic sent to a backend service, computed as weight / (sum of all weightedBackendService weights in routeAction) .
  The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backend service, subsequent requests are sent to the same backend service as determined by the backend service's session affinity policy.
  The value must be from 0 to 1000.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#weight ComputeRegionUrlMap#weight}
    */
    readonly weight?: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_action ComputeRegionUrlMap#header_action}
    */
    readonly headerAction?: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction;
}
export declare function computeRegionUrlMapDefaultRouteActionWeightedBackendServicesToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapDefaultRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    resetBackendService(): void;
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesOutputReference;
}
export interface ComputeRegionUrlMapDefaultRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#cors_policy ComputeRegionUrlMap#cors_policy}
    */
    readonly corsPolicy?: ComputeRegionUrlMapDefaultRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#fault_injection_policy ComputeRegionUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#request_mirror_policy ComputeRegionUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: ComputeRegionUrlMapDefaultRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#retry_policy ComputeRegionUrlMap#retry_policy}
    */
    readonly retryPolicy?: ComputeRegionUrlMapDefaultRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#timeout ComputeRegionUrlMap#timeout}
    */
    readonly timeout?: ComputeRegionUrlMapDefaultRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#url_rewrite ComputeRegionUrlMap#url_rewrite}
    */
    readonly urlRewrite?: ComputeRegionUrlMapDefaultRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#weighted_backend_services ComputeRegionUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function computeRegionUrlMapDefaultRouteActionToTerraform(struct?: ComputeRegionUrlMapDefaultRouteActionOutputReference | ComputeRegionUrlMapDefaultRouteAction): any;
export declare class ComputeRegionUrlMapDefaultRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultRouteAction | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): ComputeRegionUrlMapDefaultRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: ComputeRegionUrlMapDefaultRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): ComputeRegionUrlMapDefaultRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): ComputeRegionUrlMapDefaultRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): ComputeRegionUrlMapDefaultRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: ComputeRegionUrlMapDefaultRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): ComputeRegionUrlMapDefaultRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): ComputeRegionUrlMapDefaultRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: ComputeRegionUrlMapDefaultRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): ComputeRegionUrlMapDefaultRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): ComputeRegionUrlMapDefaultRouteActionTimeoutOutputReference;
    putTimeout(value: ComputeRegionUrlMapDefaultRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): ComputeRegionUrlMapDefaultRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): ComputeRegionUrlMapDefaultRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: ComputeRegionUrlMapDefaultRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): ComputeRegionUrlMapDefaultRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): ComputeRegionUrlMapDefaultRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: ComputeRegionUrlMapDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | ComputeRegionUrlMapDefaultRouteActionWeightedBackendServices[] | undefined;
}
export interface ComputeRegionUrlMapDefaultUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one that was
  supplied in the request. The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#host_redirect ComputeRegionUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https. If set to
  false, the URL scheme of the redirected request will remain the same as that of the
  request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
  true for TargetHttpsProxy is not permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#https_redirect ComputeRegionUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one that was
  supplied in the request. pathRedirect cannot be supplied together with
  prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
  original request will be used for the redirect. The value must be between 1 and 1024
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#path_redirect ComputeRegionUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch,
  retaining the remaining portion of the URL before redirecting the request.
  prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
  neither. If neither is supplied, the path of the original request will be used for
  the redirect. The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#prefix_redirect ComputeRegionUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#redirect_response_code ComputeRegionUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed prior
  to redirecting the request. If set to false, the query portion of the original URL is
  retained.
   This field is required to ensure an empty block is not set. The normal default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#strip_query ComputeRegionUrlMap#strip_query}
    */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare function computeRegionUrlMapDefaultUrlRedirectToTerraform(struct?: ComputeRegionUrlMapDefaultUrlRedirectOutputReference | ComputeRegionUrlMapDefaultUrlRedirect): any;
export declare class ComputeRegionUrlMapDefaultUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapDefaultUrlRedirect | undefined;
    set internalValue(value: ComputeRegionUrlMapDefaultUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeRegionUrlMapHostRule {
    /**
    * An optional description of this HostRule. Provide this property
  when you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#description ComputeRegionUrlMap#description}
    */
    readonly description?: string;
    /**
    * The list of host patterns to match. They must be valid
  hostnames, except * will match any string of ([a-z0-9-.]*). In
  that case, * must be the first character and must be followed in
  the pattern by either - or ..
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#hosts ComputeRegionUrlMap#hosts}
    */
    readonly hosts: string[];
    /**
    * The name of the PathMatcher to use to match the path portion of
  the URL if the hostRule matches the URL's host portion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#path_matcher ComputeRegionUrlMap#path_matcher}
    */
    readonly pathMatcher: string;
}
export declare function computeRegionUrlMapHostRuleToTerraform(struct?: ComputeRegionUrlMapHostRule | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapHostRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapHostRule | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapHostRule | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    get hostsInput(): string[] | undefined;
    private _pathMatcher?;
    get pathMatcher(): string;
    set pathMatcher(value: string);
    get pathMatcherInput(): string | undefined;
}
export declare class ComputeRegionUrlMapHostRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapHostRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapHostRuleOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherDefaultUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one that was
  supplied in the request. The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#host_redirect ComputeRegionUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https. If set to
  false, the URL scheme of the redirected request will remain the same as that of the
  request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
  true for TargetHttpsProxy is not permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#https_redirect ComputeRegionUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one that was
  supplied in the request. pathRedirect cannot be supplied together with
  prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
  original request will be used for the redirect. The value must be between 1 and 1024
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#path_redirect ComputeRegionUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch,
  retaining the remaining portion of the URL before redirecting the request.
  prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
  neither. If neither is supplied, the path of the original request will be used for
  the redirect. The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#prefix_redirect ComputeRegionUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#redirect_response_code ComputeRegionUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed prior
  to redirecting the request. If set to false, the query portion of the original URL is
  retained.
   This field is required to ensure an empty block is not set. The normal default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#strip_query ComputeRegionUrlMap#strip_query}
    */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherDefaultUrlRedirectToTerraform(struct?: ComputeRegionUrlMapPathMatcherDefaultUrlRedirectOutputReference | ComputeRegionUrlMapPathMatcherDefaultUrlRedirect): any;
export declare class ComputeRegionUrlMapPathMatcherDefaultUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherDefaultUrlRedirect | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherDefaultUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the
  actual request can include user credentials. This translates to the Access-
  Control-Allow-Credentials header. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_credentials ComputeRegionUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_headers ComputeRegionUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_methods ComputeRegionUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins. For
  regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_origin_regexes ComputeRegionUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests. An
  origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_origins ComputeRegionUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#disabled ComputeRegionUrlMap#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#expose_headers ComputeRegionUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long the results of a preflight request can be cached. This
  translates to the content for the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#max_age ComputeRegionUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicyToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference | ComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request. The value must be between 200
  and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#http_status ComputeRegionUrlMap#http_status}
    */
    readonly httpStatus: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be
  aborted as part of fault injection. The value must be between 0.0 and 100.0
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#percentage ComputeRegionUrlMap#percentage}
    */
    readonly percentage: number;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference | ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#nanos ComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#seconds ComputeRegionUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will
  be introduced as part of fault injection. The value must be between 0.0 and
  100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#percentage ComputeRegionUrlMap#percentage}
    */
    readonly percentage: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#fixed_delay ComputeRegionUrlMap#fixed_delay}
    */
    readonly fixedDelay: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference | ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    get fixedDelayInput(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#abort ComputeRegionUrlMap#abort}
    */
    readonly abort?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#delay ComputeRegionUrlMap#delay}
    */
    readonly delay?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference | ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy {
    /**
    * The RegionBackendService resource being mirrored to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#backend_service ComputeRegionUrlMap#backend_service}
    */
    readonly backendService: string;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference | ComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#nanos ComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#seconds ComputeRegionUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference | ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#num_retries ComputeRegionUrlMap#num_retries}
    */
    readonly numRetries?: number;
    /**
    * Specifies one or more conditions when this retry rule applies. Valid values are:
  
  - 5xx: Loadbalancer will attempt a retry if the backend service responds with
  any 5xx response code, or if the backend service does not respond at all,
  example: disconnects, reset, read timeout, connection failure, and refused
  streams.
  - gateway-error: Similar to 5xx, but only applies to response codes
  502, 503 or 504.
  - connect-failure: Loadbalancer will retry on failures
  connecting to backend services, for example due to connection timeouts.
  - retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
  Currently the only retriable error supported is 409.
  - refused-stream: Loadbalancer will retry if the backend service resets the stream with a
  REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
  - cancelled: Loadbalancer will retry if the gRPC status code in the response
  header is set to cancelled
  - deadline-exceeded: Loadbalancer will retry if the
  gRPC status code in the response header is set to deadline-exceeded
  - resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
  header is set to resource-exhausted
  - unavailable: Loadbalancer will retry if
  the gRPC status code in the response header is set to unavailable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#retry_conditions ComputeRegionUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#per_try_timeout ComputeRegionUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference | ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#nanos ComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#seconds ComputeRegionUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionTimeoutToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference | ComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected service, the request's host
  header is replaced with contents of hostRewrite. The value must be between 1 and
  255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#host_rewrite ComputeRegionUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected backend service, the matching
  portion of the request's path is replaced by pathPrefixRewrite. The value must
  be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#path_prefix_rewrite ComputeRegionUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewriteToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference | ComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_name ComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_value ComputeRegionUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#replace ComputeRegionUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_name ComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_value ComputeRegionUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#replace ComputeRegionUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#request_headers_to_remove ComputeRegionUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#response_headers_to_remove ComputeRegionUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#request_headers_to_add ComputeRegionUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#response_headers_to_add ComputeRegionUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference | ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices {
    /**
    * The default RegionBackendService resource. Before
  forwarding the request to backendService, the loadbalancer applies any relevant
  headerActions specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#backend_service ComputeRegionUrlMap#backend_service}
    */
    readonly backendService: string;
    /**
    * Specifies the fraction of traffic sent to backendService, computed as weight /
  (sum of all weightedBackendService weights in routeAction) . The selection of a
  backend service is determined only for new traffic. Once a user's request has
  been directed to a backendService, subsequent requests will be sent to the same
  backendService as determined by the BackendService's session affinity policy.
  The value must be between 0 and 1000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#weight ComputeRegionUrlMap#weight}
    */
    readonly weight: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_action ComputeRegionUrlMap#header_action}
    */
    readonly headerAction?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#cors_policy ComputeRegionUrlMap#cors_policy}
    */
    readonly corsPolicy?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#fault_injection_policy ComputeRegionUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#request_mirror_policy ComputeRegionUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#retry_policy ComputeRegionUrlMap#retry_policy}
    */
    readonly retryPolicy?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#timeout ComputeRegionUrlMap#timeout}
    */
    readonly timeout?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#url_rewrite ComputeRegionUrlMap#url_rewrite}
    */
    readonly urlRewrite?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#weighted_backend_services ComputeRegionUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherPathRuleRouteActionToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleRouteActionOutputReference | ComputeRegionUrlMapPathMatcherPathRuleRouteAction): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleRouteAction | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference;
    putTimeout(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRuleUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one
  that was supplied in the request. The value must be between 1 and 255
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#host_redirect ComputeRegionUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https.
  If set to false, the URL scheme of the redirected request will remain the
  same as that of the request. This must only be set for UrlMaps used in
  TargetHttpProxys. Setting this true for TargetHttpsProxy is not
  permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#https_redirect ComputeRegionUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one
  that was supplied in the request. pathRedirect cannot be supplied
  together with prefixRedirect. Supply one alone or neither. If neither is
  supplied, the path of the original request will be used for the redirect.
  The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#path_redirect ComputeRegionUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the
  HttpRouteRuleMatch, retaining the remaining portion of the URL before
  redirecting the request. prefixRedirect cannot be supplied together with
  pathRedirect. Supply one alone or neither. If neither is supplied, the
  path of the original request will be used for the redirect. The value
  must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#prefix_redirect ComputeRegionUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#redirect_response_code ComputeRegionUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed
  prior to redirecting the request. If set to false, the query portion of the
  original URL is retained.
   This field is required to ensure an empty block is not set. The normal default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#strip_query ComputeRegionUrlMap#strip_query}
    */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherPathRuleUrlRedirectToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRuleUrlRedirectOutputReference | ComputeRegionUrlMapPathMatcherPathRuleUrlRedirect): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRuleUrlRedirect | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRuleUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeRegionUrlMapPathMatcherPathRule {
    /**
    * The list of path patterns to match. Each must start with / and the only place a
  \* is allowed is at the end following a /. The string fed to the path matcher
  does not include any text after the first ? or #, and those chars are not
  allowed here.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#paths ComputeRegionUrlMap#paths}
    */
    readonly paths: string[];
    /**
    * The region backend service resource to which traffic is
  directed if this rule is matched. If routeAction is additionally specified,
  advanced routing actions like URL Rewrites, etc. take effect prior to sending
  the request to the backend. However, if service is specified, routeAction cannot
  contain any weightedBackendService s. Conversely, if routeAction specifies any
  weightedBackendServices, service must not be specified. Only one of urlRedirect,
  service or routeAction.weightedBackendService must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#service ComputeRegionUrlMap#service}
    */
    readonly service?: string;
    /**
    * route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#route_action ComputeRegionUrlMap#route_action}
    */
    readonly routeAction?: ComputeRegionUrlMapPathMatcherPathRuleRouteAction;
    /**
    * url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#url_redirect ComputeRegionUrlMap#url_redirect}
    */
    readonly urlRedirect?: ComputeRegionUrlMapPathMatcherPathRuleUrlRedirect;
}
export declare function computeRegionUrlMapPathMatcherPathRuleToTerraform(struct?: ComputeRegionUrlMapPathMatcherPathRule | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherPathRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherPathRule | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherPathRule | cdktf.IResolvable | undefined);
    private _paths?;
    get paths(): string[];
    set paths(value: string[]);
    get pathsInput(): string[] | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _routeAction;
    get routeAction(): ComputeRegionUrlMapPathMatcherPathRuleRouteActionOutputReference;
    putRouteAction(value: ComputeRegionUrlMapPathMatcherPathRuleRouteAction): void;
    resetRouteAction(): void;
    get routeActionInput(): ComputeRegionUrlMapPathMatcherPathRuleRouteAction | undefined;
    private _urlRedirect;
    get urlRedirect(): ComputeRegionUrlMapPathMatcherPathRuleUrlRedirectOutputReference;
    putUrlRedirect(value: ComputeRegionUrlMapPathMatcherPathRuleUrlRedirect): void;
    resetUrlRedirect(): void;
    get urlRedirectInput(): ComputeRegionUrlMapPathMatcherPathRuleUrlRedirect | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherPathRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherPathRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherPathRuleOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_name ComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_value ComputeRegionUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#replace ComputeRegionUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_name ComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_value ComputeRegionUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#replace ComputeRegionUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#request_headers_to_remove ComputeRegionUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#response_headers_to_remove ComputeRegionUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#request_headers_to_add ComputeRegionUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#response_headers_to_add ComputeRegionUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesHeaderActionToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesHeaderAction): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesHeaderAction | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch {
    /**
    * The end of the range (exclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#range_end ComputeRegionUrlMap#range_end}
    */
    readonly rangeEnd: number;
    /**
    * The start of the range (inclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#range_start ComputeRegionUrlMap#range_start}
    */
    readonly rangeStart: number;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch | undefined);
    private _rangeEnd?;
    get rangeEnd(): number;
    set rangeEnd(value: number);
    get rangeEndInput(): number | undefined;
    private _rangeStart?;
    get rangeStart(): number;
    set rangeStart(value: number);
    get rangeStartInput(): number | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches {
    /**
    * The value should exactly match contents of exactMatch. Only one of exactMatch,
  prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#exact_match ComputeRegionUrlMap#exact_match}
    */
    readonly exactMatch?: string;
    /**
    * The name of the HTTP header to match. For matching against the HTTP request's
  authority, use a headerMatch with the header name ":authority". For matching a
  request's method, use the headerName ":method".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_name ComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * If set to false, the headerMatch is considered a match if the match criteria
  above are met. If set to true, the headerMatch is considered a match if the
  match criteria above are NOT met. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#invert_match ComputeRegionUrlMap#invert_match}
    */
    readonly invertMatch?: boolean | cdktf.IResolvable;
    /**
    * The value of the header must start with the contents of prefixMatch. Only one of
  exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
  must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#prefix_match ComputeRegionUrlMap#prefix_match}
    */
    readonly prefixMatch?: string;
    /**
    * A header with the contents of headerName must exist. The match takes place
  whether or not the request's header has a value or not. Only one of exactMatch,
  prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#present_match ComputeRegionUrlMap#present_match}
    */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
    * The value of the header must match the regular expression specified in
  regexMatch. For regular expression grammar, please see:
  en.cppreference.com/w/cpp/regex/ecmascript  For matching against a port
  specified in the HTTP request, use a headerMatch with headerName set to PORT and
  a regular expression that satisfies the RFC2616 Host header's port specifier.
  Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or
  rangeMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#regex_match ComputeRegionUrlMap#regex_match}
    */
    readonly regexMatch?: string;
    /**
    * The value of the header must end with the contents of suffixMatch. Only one of
  exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
  must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#suffix_match ComputeRegionUrlMap#suffix_match}
    */
    readonly suffixMatch?: string;
    /**
    * range_match block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#range_match ComputeRegionUrlMap#range_match}
    */
    readonly rangeMatch?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches | cdktf.IResolvable | undefined);
    private _exactMatch?;
    get exactMatch(): string;
    set exactMatch(value: string);
    resetExactMatch(): void;
    get exactMatchInput(): string | undefined;
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _invertMatch?;
    get invertMatch(): boolean | cdktf.IResolvable;
    set invertMatch(value: boolean | cdktf.IResolvable);
    resetInvertMatch(): void;
    get invertMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    get prefixMatch(): string;
    set prefixMatch(value: string);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string | undefined;
    private _presentMatch?;
    get presentMatch(): boolean | cdktf.IResolvable;
    set presentMatch(value: boolean | cdktf.IResolvable);
    resetPresentMatch(): void;
    get presentMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
    private _suffixMatch?;
    get suffixMatch(): string;
    set suffixMatch(value: string);
    resetSuffixMatch(): void;
    get suffixMatchInput(): string | undefined;
    private _rangeMatch;
    get rangeMatch(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference;
    putRangeMatch(value: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch): void;
    resetRangeMatch(): void;
    get rangeMatchInput(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels {
    /**
    * Name of metadata label. The name can have a maximum length of 1024 characters
  and must be at least 1 character long.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#name ComputeRegionUrlMap#name}
    */
    readonly name: string;
    /**
    * The value of the label must match the specified value. value can have a maximum
  length of 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#value ComputeRegionUrlMap#value}
    */
    readonly value: string;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters {
    /**
    * Specifies how individual filterLabel matches within the list of filterLabels
  contribute towards the overall metadataFilter match. Supported values are:
  
  * MATCH_ANY: At least one of the filterLabels must have a matching label in the
  provided metadata.
  * MATCH_ALL: All filterLabels must have matching labels in
  the provided metadata. Possible values: ["MATCH_ALL", "MATCH_ANY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#filter_match_criteria ComputeRegionUrlMap#filter_match_criteria}
    */
    readonly filterMatchCriteria: string;
    /**
    * filter_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#filter_labels ComputeRegionUrlMap#filter_labels}
    */
    readonly filterLabels: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters | cdktf.IResolvable | undefined);
    private _filterMatchCriteria?;
    get filterMatchCriteria(): string;
    set filterMatchCriteria(value: string);
    get filterMatchCriteriaInput(): string | undefined;
    private _filterLabels;
    get filterLabels(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsList;
    putFilterLabels(value: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | cdktf.IResolvable): void;
    get filterLabelsInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches {
    /**
    * The queryParameterMatch matches if the value of the parameter exactly matches
  the contents of exactMatch. Only one of presentMatch, exactMatch and regexMatch
  must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#exact_match ComputeRegionUrlMap#exact_match}
    */
    readonly exactMatch?: string;
    /**
    * The name of the query parameter to match. The query parameter must exist in the
  request, in the absence of which the request match fails.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#name ComputeRegionUrlMap#name}
    */
    readonly name: string;
    /**
    * Specifies that the queryParameterMatch matches if the request contains the query
  parameter, irrespective of whether the parameter has a value or not. Only one of
  presentMatch, exactMatch and regexMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#present_match ComputeRegionUrlMap#present_match}
    */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
    * The queryParameterMatch matches if the value of the parameter matches the
  regular expression specified by regexMatch. For the regular expression grammar,
  please see en.cppreference.com/w/cpp/regex/ecmascript  Only one of presentMatch,
  exactMatch and regexMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#regex_match ComputeRegionUrlMap#regex_match}
    */
    readonly regexMatch?: string;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches | cdktf.IResolvable | undefined);
    private _exactMatch?;
    get exactMatch(): string;
    set exactMatch(value: string);
    resetExactMatch(): void;
    get exactMatchInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _presentMatch?;
    get presentMatch(): boolean | cdktf.IResolvable;
    set presentMatch(value: boolean | cdktf.IResolvable);
    resetPresentMatch(): void;
    get presentMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesMatchRules {
    /**
    * For satisfying the matchRule condition, the path of the request must exactly
  match the value specified in fullPathMatch after removing any query parameters
  and anchor that may be part of the original URL. FullPathMatch must be between 1
  and 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must
  be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#full_path_match ComputeRegionUrlMap#full_path_match}
    */
    readonly fullPathMatch?: string;
    /**
    * Specifies that prefixMatch and fullPathMatch matches are case sensitive.
  Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#ignore_case ComputeRegionUrlMap#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * For satisfying the matchRule condition, the request's path must begin with the
  specified prefixMatch. prefixMatch must begin with a /. The value must be
  between 1 and 1024 characters. Only one of prefixMatch, fullPathMatch or
  regexMatch must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#prefix_match ComputeRegionUrlMap#prefix_match}
    */
    readonly prefixMatch?: string;
    /**
    * For satisfying the matchRule condition, the path of the request must satisfy the
  regular expression specified in regexMatch after removing any query parameters
  and anchor supplied with the original URL. For regular expression grammar please
  see en.cppreference.com/w/cpp/regex/ecmascript  Only one of prefixMatch,
  fullPathMatch or regexMatch must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#regex_match ComputeRegionUrlMap#regex_match}
    */
    readonly regexMatch?: string;
    /**
    * header_matches block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_matches ComputeRegionUrlMap#header_matches}
    */
    readonly headerMatches?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | cdktf.IResolvable;
    /**
    * metadata_filters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#metadata_filters ComputeRegionUrlMap#metadata_filters}
    */
    readonly metadataFilters?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | cdktf.IResolvable;
    /**
    * query_parameter_matches block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#query_parameter_matches ComputeRegionUrlMap#query_parameter_matches}
    */
    readonly queryParameterMatches?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesMatchRulesToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRules | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRules | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesMatchRules | cdktf.IResolvable | undefined);
    private _fullPathMatch?;
    get fullPathMatch(): string;
    set fullPathMatch(value: string);
    resetFullPathMatch(): void;
    get fullPathMatchInput(): string | undefined;
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    get prefixMatch(): string;
    set prefixMatch(value: string);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
    private _headerMatches;
    get headerMatches(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesList;
    putHeaderMatches(value: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | cdktf.IResolvable): void;
    resetHeaderMatches(): void;
    get headerMatchesInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | undefined;
    private _metadataFilters;
    get metadataFilters(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersList;
    putMetadataFilters(value: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | cdktf.IResolvable): void;
    resetMetadataFilters(): void;
    get metadataFiltersInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | undefined;
    private _queryParameterMatches;
    get queryParameterMatches(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesList;
    putQueryParameterMatches(value: ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | cdktf.IResolvable): void;
    resetQueryParameterMatches(): void;
    get queryParameterMatchesInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the
  actual request can include user credentials. This translates to the Access-
  Control-Allow-Credentials header. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_credentials ComputeRegionUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_headers ComputeRegionUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_methods ComputeRegionUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins. For
  regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_origin_regexes ComputeRegionUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests. An
  origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#allow_origins ComputeRegionUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled.
  which indicates that the CORS policy is in effect. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#disabled ComputeRegionUrlMap#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#expose_headers ComputeRegionUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long the results of a preflight request can be cached. This
  translates to the content for the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#max_age ComputeRegionUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicyToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request. The value must be between 200
  and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#http_status ComputeRegionUrlMap#http_status}
    */
    readonly httpStatus?: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be
  aborted as part of fault injection. The value must be between 0.0 and 100.0
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#percentage ComputeRegionUrlMap#percentage}
    */
    readonly percentage?: number;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#nanos ComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#seconds ComputeRegionUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will
  be introduced as part of fault injection. The value must be between 0.0 and
  100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#percentage ComputeRegionUrlMap#percentage}
    */
    readonly percentage?: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#fixed_delay ComputeRegionUrlMap#fixed_delay}
    */
    readonly fixedDelay?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    resetFixedDelay(): void;
    get fixedDelayInput(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#abort ComputeRegionUrlMap#abort}
    */
    readonly abort?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#delay ComputeRegionUrlMap#delay}
    */
    readonly delay?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy {
    /**
    * The RegionBackendService resource being mirrored to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#backend_service ComputeRegionUrlMap#backend_service}
    */
    readonly backendService: string;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#nanos ComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#seconds ComputeRegionUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#num_retries ComputeRegionUrlMap#num_retries}
    */
    readonly numRetries: number;
    /**
    * Specifies one or more conditions when this retry rule applies. Valid values are:
  
  * 5xx: Loadbalancer will attempt a retry if the backend service responds with
    any 5xx response code, or if the backend service does not respond at all,
    example: disconnects, reset, read timeout, connection failure, and refused
    streams.
  * gateway-error: Similar to 5xx, but only applies to response codes
    502, 503 or 504.
  * connect-failure: Loadbalancer will retry on failures
    connecting to backend services, for example due to connection timeouts.
  * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
    Currently the only retriable error supported is 409.
  * refused-stream: Loadbalancer will retry if the backend service resets the stream with a
    REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
  * cancelled: Loadbalancer will retry if the gRPC status code in the response
    header is set to cancelled
  * deadline-exceeded: Loadbalancer will retry if the
    gRPC status code in the response header is set to deadline-exceeded
  * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
    header is set to resource-exhausted
  * unavailable: Loadbalancer will retry if the gRPC status code in
    the response header is set to unavailable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#retry_conditions ComputeRegionUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#per_try_timeout ComputeRegionUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#nanos ComputeRegionUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#seconds ComputeRegionUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionTimeoutToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected service, the request's host
  header is replaced with contents of hostRewrite. The value must be between 1 and
  255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#host_rewrite ComputeRegionUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected backend service, the matching
  portion of the request's path is replaced by pathPrefixRewrite. The value must
  be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#path_prefix_rewrite ComputeRegionUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewriteToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_name ComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_value ComputeRegionUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#replace ComputeRegionUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_name ComputeRegionUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_value ComputeRegionUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#replace ComputeRegionUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#request_headers_to_remove ComputeRegionUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#response_headers_to_remove ComputeRegionUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#request_headers_to_add ComputeRegionUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#response_headers_to_add ComputeRegionUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices {
    /**
    * The default RegionBackendService resource. Before
  forwarding the request to backendService, the loadbalancer applies any relevant
  headerActions specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#backend_service ComputeRegionUrlMap#backend_service}
    */
    readonly backendService: string;
    /**
    * Specifies the fraction of traffic sent to backendService, computed as weight /
  (sum of all weightedBackendService weights in routeAction) . The selection of a
  backend service is determined only for new traffic. Once a user's request has
  been directed to a backendService, subsequent requests will be sent to the same
  backendService as determined by the BackendService's session affinity policy.
  The value must be between 0 and 1000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#weight ComputeRegionUrlMap#weight}
    */
    readonly weight: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_action ComputeRegionUrlMap#header_action}
    */
    readonly headerAction?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesOutputReference;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#cors_policy ComputeRegionUrlMap#cors_policy}
    */
    readonly corsPolicy?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#fault_injection_policy ComputeRegionUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#request_mirror_policy ComputeRegionUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#retry_policy ComputeRegionUrlMap#retry_policy}
    */
    readonly retryPolicy?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#timeout ComputeRegionUrlMap#timeout}
    */
    readonly timeout?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#url_rewrite ComputeRegionUrlMap#url_rewrite}
    */
    readonly urlRewrite?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#weighted_backend_services ComputeRegionUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesRouteActionToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesRouteAction): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesRouteAction | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference;
    putTimeout(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one
  that was supplied in the request. The value must be between 1 and 255
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#host_redirect ComputeRegionUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https.
  If set to false, the URL scheme of the redirected request will remain the
  same as that of the request. This must only be set for UrlMaps used in
  TargetHttpProxys. Setting this true for TargetHttpsProxy is not
  permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#https_redirect ComputeRegionUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one
  that was supplied in the request. pathRedirect cannot be supplied
  together with prefixRedirect. Supply one alone or neither. If neither is
  supplied, the path of the original request will be used for the redirect.
  The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#path_redirect ComputeRegionUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the
  HttpRouteRuleMatch, retaining the remaining portion of the URL before
  redirecting the request. prefixRedirect cannot be supplied together with
  pathRedirect. Supply one alone or neither. If neither is supplied, the
  path of the original request will be used for the redirect. The value
  must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#prefix_redirect ComputeRegionUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#redirect_response_code ComputeRegionUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is
  removed prior to redirecting the request. If set to false, the query
  portion of the original URL is retained. The default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#strip_query ComputeRegionUrlMap#strip_query}
    */
    readonly stripQuery?: boolean | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesUrlRedirectToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRulesUrlRedirectOutputReference | ComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    resetStripQuery(): void;
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeRegionUrlMapPathMatcherRouteRules {
    /**
    * For routeRules within a given pathMatcher, priority determines the order
  in which load balancer will interpret routeRules. RouteRules are evaluated
  in order of priority, from the lowest to highest number. The priority of
  a rule decreases as its number increases (1, 2, 3, N+1). The first rule
  that matches the request is applied.
  
  You cannot configure two or more routeRules with the same priority.
  Priority for each rule must be set to a number between 0 and
  2147483647 inclusive.
  
  Priority numbers can have gaps, which enable you to add or remove rules
  in the future without affecting the rest of the rules. For example,
  1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which
  you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the
  future without any impact on existing rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#priority ComputeRegionUrlMap#priority}
    */
    readonly priority: number;
    /**
    * The region backend service resource to which traffic is
  directed if this rule is matched. If routeAction is additionally specified,
  advanced routing actions like URL Rewrites, etc. take effect prior to sending
  the request to the backend. However, if service is specified, routeAction cannot
  contain any weightedBackendService s. Conversely, if routeAction specifies any
  weightedBackendServices, service must not be specified. Only one of urlRedirect,
  service or routeAction.weightedBackendService must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#service ComputeRegionUrlMap#service}
    */
    readonly service?: string;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#header_action ComputeRegionUrlMap#header_action}
    */
    readonly headerAction?: ComputeRegionUrlMapPathMatcherRouteRulesHeaderAction;
    /**
    * match_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#match_rules ComputeRegionUrlMap#match_rules}
    */
    readonly matchRules?: ComputeRegionUrlMapPathMatcherRouteRulesMatchRules[] | cdktf.IResolvable;
    /**
    * route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#route_action ComputeRegionUrlMap#route_action}
    */
    readonly routeAction?: ComputeRegionUrlMapPathMatcherRouteRulesRouteAction;
    /**
    * url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#url_redirect ComputeRegionUrlMap#url_redirect}
    */
    readonly urlRedirect?: ComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect;
}
export declare function computeRegionUrlMapPathMatcherRouteRulesToTerraform(struct?: ComputeRegionUrlMapPathMatcherRouteRules | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherRouteRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcherRouteRules | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcherRouteRules | cdktf.IResolvable | undefined);
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _headerAction;
    get headerAction(): ComputeRegionUrlMapPathMatcherRouteRulesHeaderActionOutputReference;
    putHeaderAction(value: ComputeRegionUrlMapPathMatcherRouteRulesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): ComputeRegionUrlMapPathMatcherRouteRulesHeaderAction | undefined;
    private _matchRules;
    get matchRules(): ComputeRegionUrlMapPathMatcherRouteRulesMatchRulesList;
    putMatchRules(value: ComputeRegionUrlMapPathMatcherRouteRulesMatchRules[] | cdktf.IResolvable): void;
    resetMatchRules(): void;
    get matchRulesInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherRouteRulesMatchRules[] | undefined;
    private _routeAction;
    get routeAction(): ComputeRegionUrlMapPathMatcherRouteRulesRouteActionOutputReference;
    putRouteAction(value: ComputeRegionUrlMapPathMatcherRouteRulesRouteAction): void;
    resetRouteAction(): void;
    get routeActionInput(): ComputeRegionUrlMapPathMatcherRouteRulesRouteAction | undefined;
    private _urlRedirect;
    get urlRedirect(): ComputeRegionUrlMapPathMatcherRouteRulesUrlRedirectOutputReference;
    putUrlRedirect(value: ComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect): void;
    resetUrlRedirect(): void;
    get urlRedirectInput(): ComputeRegionUrlMapPathMatcherRouteRulesUrlRedirect | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherRouteRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcherRouteRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherRouteRulesOutputReference;
}
export interface ComputeRegionUrlMapPathMatcher {
    /**
    * A reference to a RegionBackendService resource. This will be used if
  none of the pathRules defined by this PathMatcher is matched by
  the URL's path portion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#default_service ComputeRegionUrlMap#default_service}
    */
    readonly defaultService?: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#description ComputeRegionUrlMap#description}
    */
    readonly description?: string;
    /**
    * The name to which this PathMatcher is referred by the HostRule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#name ComputeRegionUrlMap#name}
    */
    readonly name: string;
    /**
    * default_url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#default_url_redirect ComputeRegionUrlMap#default_url_redirect}
    */
    readonly defaultUrlRedirect?: ComputeRegionUrlMapPathMatcherDefaultUrlRedirect;
    /**
    * path_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#path_rule ComputeRegionUrlMap#path_rule}
    */
    readonly pathRule?: ComputeRegionUrlMapPathMatcherPathRule[] | cdktf.IResolvable;
    /**
    * route_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#route_rules ComputeRegionUrlMap#route_rules}
    */
    readonly routeRules?: ComputeRegionUrlMapPathMatcherRouteRules[] | cdktf.IResolvable;
}
export declare function computeRegionUrlMapPathMatcherToTerraform(struct?: ComputeRegionUrlMapPathMatcher | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapPathMatcherOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapPathMatcher | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapPathMatcher | cdktf.IResolvable | undefined);
    private _defaultService?;
    get defaultService(): string;
    set defaultService(value: string);
    resetDefaultService(): void;
    get defaultServiceInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _defaultUrlRedirect;
    get defaultUrlRedirect(): ComputeRegionUrlMapPathMatcherDefaultUrlRedirectOutputReference;
    putDefaultUrlRedirect(value: ComputeRegionUrlMapPathMatcherDefaultUrlRedirect): void;
    resetDefaultUrlRedirect(): void;
    get defaultUrlRedirectInput(): ComputeRegionUrlMapPathMatcherDefaultUrlRedirect | undefined;
    private _pathRule;
    get pathRule(): ComputeRegionUrlMapPathMatcherPathRuleList;
    putPathRule(value: ComputeRegionUrlMapPathMatcherPathRule[] | cdktf.IResolvable): void;
    resetPathRule(): void;
    get pathRuleInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherPathRule[] | undefined;
    private _routeRules;
    get routeRules(): ComputeRegionUrlMapPathMatcherRouteRulesList;
    putRouteRules(value: ComputeRegionUrlMapPathMatcherRouteRules[] | cdktf.IResolvable): void;
    resetRouteRules(): void;
    get routeRulesInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcherRouteRules[] | undefined;
}
export declare class ComputeRegionUrlMapPathMatcherList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapPathMatcher[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapPathMatcherOutputReference;
}
export interface ComputeRegionUrlMapTest {
    /**
    * Description of this test case.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#description ComputeRegionUrlMap#description}
    */
    readonly description?: string;
    /**
    * Host portion of the URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#host ComputeRegionUrlMap#host}
    */
    readonly host: string;
    /**
    * Path portion of the URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#path ComputeRegionUrlMap#path}
    */
    readonly path: string;
    /**
    * A reference to expected RegionBackendService resource the given URL should be mapped to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#service ComputeRegionUrlMap#service}
    */
    readonly service: string;
}
export declare function computeRegionUrlMapTestToTerraform(struct?: ComputeRegionUrlMapTest | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapTestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeRegionUrlMapTest | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapTest | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export declare class ComputeRegionUrlMapTestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeRegionUrlMapTest[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeRegionUrlMapTestOutputReference;
}
export interface ComputeRegionUrlMapTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#create ComputeRegionUrlMap#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#delete ComputeRegionUrlMap#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map#update ComputeRegionUrlMap#update}
    */
    readonly update?: string;
}
export declare function computeRegionUrlMapTimeoutsToTerraform(struct?: ComputeRegionUrlMapTimeoutsOutputReference | ComputeRegionUrlMapTimeouts | cdktf.IResolvable): any;
export declare class ComputeRegionUrlMapTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionUrlMapTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionUrlMapTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map google_compute_region_url_map}
*/
export declare class ComputeRegionUrlMap extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_url_map";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_url_map google_compute_region_url_map} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeRegionUrlMapConfig
    */
    constructor(scope: Construct, id: string, config: ComputeRegionUrlMapConfig);
    get creationTimestamp(): string;
    private _defaultService?;
    get defaultService(): string;
    set defaultService(value: string);
    resetDefaultService(): void;
    get defaultServiceInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get mapId(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _defaultRouteAction;
    get defaultRouteAction(): ComputeRegionUrlMapDefaultRouteActionOutputReference;
    putDefaultRouteAction(value: ComputeRegionUrlMapDefaultRouteAction): void;
    resetDefaultRouteAction(): void;
    get defaultRouteActionInput(): ComputeRegionUrlMapDefaultRouteAction | undefined;
    private _defaultUrlRedirect;
    get defaultUrlRedirect(): ComputeRegionUrlMapDefaultUrlRedirectOutputReference;
    putDefaultUrlRedirect(value: ComputeRegionUrlMapDefaultUrlRedirect): void;
    resetDefaultUrlRedirect(): void;
    get defaultUrlRedirectInput(): ComputeRegionUrlMapDefaultUrlRedirect | undefined;
    private _hostRule;
    get hostRule(): ComputeRegionUrlMapHostRuleList;
    putHostRule(value: ComputeRegionUrlMapHostRule[] | cdktf.IResolvable): void;
    resetHostRule(): void;
    get hostRuleInput(): cdktf.IResolvable | ComputeRegionUrlMapHostRule[] | undefined;
    private _pathMatcher;
    get pathMatcher(): ComputeRegionUrlMapPathMatcherList;
    putPathMatcher(value: ComputeRegionUrlMapPathMatcher[] | cdktf.IResolvable): void;
    resetPathMatcher(): void;
    get pathMatcherInput(): cdktf.IResolvable | ComputeRegionUrlMapPathMatcher[] | undefined;
    private _test;
    get test(): ComputeRegionUrlMapTestList;
    putTest(value: ComputeRegionUrlMapTest[] | cdktf.IResolvable): void;
    resetTest(): void;
    get testInput(): cdktf.IResolvable | ComputeRegionUrlMapTest[] | undefined;
    private _timeouts;
    get timeouts(): ComputeRegionUrlMapTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionUrlMapTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeRegionUrlMapTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
