import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeResourcePolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#description ComputeResourcePolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#id ComputeResourcePolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the resource, provided by the client when initially creating
  the resource. The resource name must be 1-63 characters long, and comply
  with RFC1035. Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])'? which means the
  first character must be a lowercase letter, and all following characters
  must be a dash, lowercase letter, or digit, except the last character,
  which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#name ComputeResourcePolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#project ComputeResourcePolicy#project}
    */
    readonly project?: string;
    /**
    * Region where resource policy resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#region ComputeResourcePolicy#region}
    */
    readonly region?: string;
    /**
    * group_placement_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#group_placement_policy ComputeResourcePolicy#group_placement_policy}
    */
    readonly groupPlacementPolicy?: ComputeResourcePolicyGroupPlacementPolicy;
    /**
    * instance_schedule_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#instance_schedule_policy ComputeResourcePolicy#instance_schedule_policy}
    */
    readonly instanceSchedulePolicy?: ComputeResourcePolicyInstanceSchedulePolicy;
    /**
    * snapshot_schedule_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#snapshot_schedule_policy ComputeResourcePolicy#snapshot_schedule_policy}
    */
    readonly snapshotSchedulePolicy?: ComputeResourcePolicySnapshotSchedulePolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#timeouts ComputeResourcePolicy#timeouts}
    */
    readonly timeouts?: ComputeResourcePolicyTimeouts;
}
export interface ComputeResourcePolicyGroupPlacementPolicy {
    /**
    * The number of availability domains instances will be spread across. If two instances are in different
  availability domain, they will not be put in the same low latency network
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#availability_domain_count ComputeResourcePolicy#availability_domain_count}
    */
    readonly availabilityDomainCount?: number;
    /**
    * Collocation specifies whether to place VMs inside the same availability domain on the same low-latency network.
  Specify 'COLLOCATED' to enable collocation. Can only be specified with 'vm_count'. If compute instances are created
  with a COLLOCATED policy, then exactly 'vm_count' instances must be created at the same time with the resource policy
  attached. Possible values: ["COLLOCATED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#collocation ComputeResourcePolicy#collocation}
    */
    readonly collocation?: string;
    /**
    * Number of VMs in this placement group. Google does not recommend that you use this field
  unless you use a compact policy and you want your policy to work only if it contains this
  exact number of VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#vm_count ComputeResourcePolicy#vm_count}
    */
    readonly vmCount?: number;
}
export declare function computeResourcePolicyGroupPlacementPolicyToTerraform(struct?: ComputeResourcePolicyGroupPlacementPolicyOutputReference | ComputeResourcePolicyGroupPlacementPolicy): any;
export declare class ComputeResourcePolicyGroupPlacementPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeResourcePolicyGroupPlacementPolicy | undefined;
    set internalValue(value: ComputeResourcePolicyGroupPlacementPolicy | undefined);
    private _availabilityDomainCount?;
    get availabilityDomainCount(): number;
    set availabilityDomainCount(value: number);
    resetAvailabilityDomainCount(): void;
    get availabilityDomainCountInput(): number | undefined;
    private _collocation?;
    get collocation(): string;
    set collocation(value: string);
    resetCollocation(): void;
    get collocationInput(): string | undefined;
    private _vmCount?;
    get vmCount(): number;
    set vmCount(value: number);
    resetVmCount(): void;
    get vmCountInput(): number | undefined;
}
export interface ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule {
    /**
    * Specifies the frequency for the operation, using the unix-cron format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#schedule ComputeResourcePolicy#schedule}
    */
    readonly schedule: string;
}
export declare function computeResourcePolicyInstanceSchedulePolicyVmStartScheduleToTerraform(struct?: ComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleOutputReference | ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule): any;
export declare class ComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule | undefined;
    set internalValue(value: ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule | undefined);
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    get scheduleInput(): string | undefined;
}
export interface ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule {
    /**
    * Specifies the frequency for the operation, using the unix-cron format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#schedule ComputeResourcePolicy#schedule}
    */
    readonly schedule: string;
}
export declare function computeResourcePolicyInstanceSchedulePolicyVmStopScheduleToTerraform(struct?: ComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleOutputReference | ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule): any;
export declare class ComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule | undefined;
    set internalValue(value: ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule | undefined);
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    get scheduleInput(): string | undefined;
}
export interface ComputeResourcePolicyInstanceSchedulePolicy {
    /**
    * The expiration time of the schedule. The timestamp is an RFC3339 string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#expiration_time ComputeResourcePolicy#expiration_time}
    */
    readonly expirationTime?: string;
    /**
    * The start time of the schedule. The timestamp is an RFC3339 string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#start_time ComputeResourcePolicy#start_time}
    */
    readonly startTime?: string;
    /**
    * Specifies the time zone to be used in interpreting the schedule. The value of this field must be a time zone name
  from the tz database: http://en.wikipedia.org/wiki/Tz_database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#time_zone ComputeResourcePolicy#time_zone}
    */
    readonly timeZone: string;
    /**
    * vm_start_schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#vm_start_schedule ComputeResourcePolicy#vm_start_schedule}
    */
    readonly vmStartSchedule?: ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule;
    /**
    * vm_stop_schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#vm_stop_schedule ComputeResourcePolicy#vm_stop_schedule}
    */
    readonly vmStopSchedule?: ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule;
}
export declare function computeResourcePolicyInstanceSchedulePolicyToTerraform(struct?: ComputeResourcePolicyInstanceSchedulePolicyOutputReference | ComputeResourcePolicyInstanceSchedulePolicy): any;
export declare class ComputeResourcePolicyInstanceSchedulePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeResourcePolicyInstanceSchedulePolicy | undefined;
    set internalValue(value: ComputeResourcePolicyInstanceSchedulePolicy | undefined);
    private _expirationTime?;
    get expirationTime(): string;
    set expirationTime(value: string);
    resetExpirationTime(): void;
    get expirationTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
    private _vmStartSchedule;
    get vmStartSchedule(): ComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleOutputReference;
    putVmStartSchedule(value: ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule): void;
    resetVmStartSchedule(): void;
    get vmStartScheduleInput(): ComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule | undefined;
    private _vmStopSchedule;
    get vmStopSchedule(): ComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleOutputReference;
    putVmStopSchedule(value: ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule): void;
    resetVmStopSchedule(): void;
    get vmStopScheduleInput(): ComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule | undefined;
}
export interface ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy {
    /**
    * Maximum age of the snapshot that is allowed to be kept.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#max_retention_days ComputeResourcePolicy#max_retention_days}
    */
    readonly maxRetentionDays: number;
    /**
    * Specifies the behavior to apply to scheduled snapshots when
  the source disk is deleted. Default value: "KEEP_AUTO_SNAPSHOTS" Possible values: ["KEEP_AUTO_SNAPSHOTS", "APPLY_RETENTION_POLICY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#on_source_disk_delete ComputeResourcePolicy#on_source_disk_delete}
    */
    readonly onSourceDiskDelete?: string;
}
export declare function computeResourcePolicySnapshotSchedulePolicyRetentionPolicyToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyOutputReference | ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy): any;
export declare class ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy | undefined;
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy | undefined);
    private _maxRetentionDays?;
    get maxRetentionDays(): number;
    set maxRetentionDays(value: number);
    get maxRetentionDaysInput(): number | undefined;
    private _onSourceDiskDelete?;
    get onSourceDiskDelete(): string;
    set onSourceDiskDelete(value: string);
    resetOnSourceDiskDelete(): void;
    get onSourceDiskDeleteInput(): string | undefined;
}
export interface ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule {
    /**
    * The number of days between snapshots.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#days_in_cycle ComputeResourcePolicy#days_in_cycle}
    */
    readonly daysInCycle: number;
    /**
    * This must be in UTC format that resolves to one of
  00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example,
  both 13:00-5 and 08:00 are valid.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#start_time ComputeResourcePolicy#start_time}
    */
    readonly startTime: string;
}
export declare function computeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleOutputReference | ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule): any;
export declare class ComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule | undefined;
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule | undefined);
    private _daysInCycle?;
    get daysInCycle(): number;
    set daysInCycle(value: number);
    get daysInCycleInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule {
    /**
    * The number of hours between snapshots.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#hours_in_cycle ComputeResourcePolicy#hours_in_cycle}
    */
    readonly hoursInCycle: number;
    /**
    * Time within the window to start the operations.
  It must be in an hourly format "HH:MM",
  where HH : [00-23] and MM : [00] GMT.
  eg: 21:00
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#start_time ComputeResourcePolicy#start_time}
    */
    readonly startTime: string;
}
export declare function computeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleOutputReference | ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule): any;
export declare class ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule | undefined;
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule | undefined);
    private _hoursInCycle?;
    get hoursInCycle(): number;
    set hoursInCycle(value: number);
    get hoursInCycleInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks {
    /**
    * The day of the week to create the snapshot. e.g. MONDAY Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#day ComputeResourcePolicy#day}
    */
    readonly day: string;
    /**
    * Time within the window to start the operations.
  It must be in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#start_time ComputeResourcePolicy#start_time}
    */
    readonly startTime: string;
}
export declare function computeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks | cdktf.IResolvable): any;
export declare class ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks | cdktf.IResolvable | undefined);
    private _day?;
    get day(): string;
    set day(value: string);
    get dayInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export declare class ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksOutputReference;
}
export interface ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule {
    /**
    * day_of_weeks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#day_of_weeks ComputeResourcePolicy#day_of_weeks}
    */
    readonly dayOfWeeks: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[] | cdktf.IResolvable;
}
export declare function computeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleOutputReference | ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule): any;
export declare class ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule | undefined;
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule | undefined);
    private _dayOfWeeks;
    get dayOfWeeks(): ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksList;
    putDayOfWeeks(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[] | cdktf.IResolvable): void;
    get dayOfWeeksInput(): cdktf.IResolvable | ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks[] | undefined;
}
export interface ComputeResourcePolicySnapshotSchedulePolicySchedule {
    /**
    * daily_schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#daily_schedule ComputeResourcePolicy#daily_schedule}
    */
    readonly dailySchedule?: ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule;
    /**
    * hourly_schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#hourly_schedule ComputeResourcePolicy#hourly_schedule}
    */
    readonly hourlySchedule?: ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule;
    /**
    * weekly_schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#weekly_schedule ComputeResourcePolicy#weekly_schedule}
    */
    readonly weeklySchedule?: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule;
}
export declare function computeResourcePolicySnapshotSchedulePolicyScheduleToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyScheduleOutputReference | ComputeResourcePolicySnapshotSchedulePolicySchedule): any;
export declare class ComputeResourcePolicySnapshotSchedulePolicyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicySchedule | undefined;
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicySchedule | undefined);
    private _dailySchedule;
    get dailySchedule(): ComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleOutputReference;
    putDailySchedule(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule): void;
    resetDailySchedule(): void;
    get dailyScheduleInput(): ComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule | undefined;
    private _hourlySchedule;
    get hourlySchedule(): ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleOutputReference;
    putHourlySchedule(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule): void;
    resetHourlySchedule(): void;
    get hourlyScheduleInput(): ComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule | undefined;
    private _weeklySchedule;
    get weeklySchedule(): ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleOutputReference;
    putWeeklySchedule(value: ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule): void;
    resetWeeklySchedule(): void;
    get weeklyScheduleInput(): ComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule | undefined;
}
export interface ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties {
    /**
    * Creates the new snapshot in the snapshot chain labeled with the
  specified name. The chain name must be 1-63 characters long and comply
  with RFC1035.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#chain_name ComputeResourcePolicy#chain_name}
    */
    readonly chainName?: string;
    /**
    * Whether to perform a 'guest aware' snapshot.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#guest_flush ComputeResourcePolicy#guest_flush}
    */
    readonly guestFlush?: boolean | cdktf.IResolvable;
    /**
    * A set of key-value pairs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#labels ComputeResourcePolicy#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Cloud Storage bucket location to store the auto snapshot
  (regional or multi-regional)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#storage_locations ComputeResourcePolicy#storage_locations}
    */
    readonly storageLocations?: string[];
}
export declare function computeResourcePolicySnapshotSchedulePolicySnapshotPropertiesToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesOutputReference | ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties): any;
export declare class ComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties | undefined;
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties | undefined);
    private _chainName?;
    get chainName(): string;
    set chainName(value: string);
    resetChainName(): void;
    get chainNameInput(): string | undefined;
    private _guestFlush?;
    get guestFlush(): boolean | cdktf.IResolvable;
    set guestFlush(value: boolean | cdktf.IResolvable);
    resetGuestFlush(): void;
    get guestFlushInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _storageLocations?;
    get storageLocations(): string[];
    set storageLocations(value: string[]);
    resetStorageLocations(): void;
    get storageLocationsInput(): string[] | undefined;
}
export interface ComputeResourcePolicySnapshotSchedulePolicy {
    /**
    * retention_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#retention_policy ComputeResourcePolicy#retention_policy}
    */
    readonly retentionPolicy?: ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#schedule ComputeResourcePolicy#schedule}
    */
    readonly schedule: ComputeResourcePolicySnapshotSchedulePolicySchedule;
    /**
    * snapshot_properties block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#snapshot_properties ComputeResourcePolicy#snapshot_properties}
    */
    readonly snapshotProperties?: ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties;
}
export declare function computeResourcePolicySnapshotSchedulePolicyToTerraform(struct?: ComputeResourcePolicySnapshotSchedulePolicyOutputReference | ComputeResourcePolicySnapshotSchedulePolicy): any;
export declare class ComputeResourcePolicySnapshotSchedulePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeResourcePolicySnapshotSchedulePolicy | undefined;
    set internalValue(value: ComputeResourcePolicySnapshotSchedulePolicy | undefined);
    private _retentionPolicy;
    get retentionPolicy(): ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyOutputReference;
    putRetentionPolicy(value: ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy): void;
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): ComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy | undefined;
    private _schedule;
    get schedule(): ComputeResourcePolicySnapshotSchedulePolicyScheduleOutputReference;
    putSchedule(value: ComputeResourcePolicySnapshotSchedulePolicySchedule): void;
    get scheduleInput(): ComputeResourcePolicySnapshotSchedulePolicySchedule | undefined;
    private _snapshotProperties;
    get snapshotProperties(): ComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesOutputReference;
    putSnapshotProperties(value: ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties): void;
    resetSnapshotProperties(): void;
    get snapshotPropertiesInput(): ComputeResourcePolicySnapshotSchedulePolicySnapshotProperties | undefined;
}
export interface ComputeResourcePolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#create ComputeResourcePolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy#delete ComputeResourcePolicy#delete}
    */
    readonly delete?: string;
}
export declare function computeResourcePolicyTimeoutsToTerraform(struct?: ComputeResourcePolicyTimeoutsOutputReference | ComputeResourcePolicyTimeouts | cdktf.IResolvable): any;
export declare class ComputeResourcePolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeResourcePolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeResourcePolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy google_compute_resource_policy}
*/
export declare class ComputeResourcePolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_resource_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_resource_policy google_compute_resource_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeResourcePolicyConfig
    */
    constructor(scope: Construct, id: string, config: ComputeResourcePolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _groupPlacementPolicy;
    get groupPlacementPolicy(): ComputeResourcePolicyGroupPlacementPolicyOutputReference;
    putGroupPlacementPolicy(value: ComputeResourcePolicyGroupPlacementPolicy): void;
    resetGroupPlacementPolicy(): void;
    get groupPlacementPolicyInput(): ComputeResourcePolicyGroupPlacementPolicy | undefined;
    private _instanceSchedulePolicy;
    get instanceSchedulePolicy(): ComputeResourcePolicyInstanceSchedulePolicyOutputReference;
    putInstanceSchedulePolicy(value: ComputeResourcePolicyInstanceSchedulePolicy): void;
    resetInstanceSchedulePolicy(): void;
    get instanceSchedulePolicyInput(): ComputeResourcePolicyInstanceSchedulePolicy | undefined;
    private _snapshotSchedulePolicy;
    get snapshotSchedulePolicy(): ComputeResourcePolicySnapshotSchedulePolicyOutputReference;
    putSnapshotSchedulePolicy(value: ComputeResourcePolicySnapshotSchedulePolicy): void;
    resetSnapshotSchedulePolicy(): void;
    get snapshotSchedulePolicyInput(): ComputeResourcePolicySnapshotSchedulePolicy | undefined;
    private _timeouts;
    get timeouts(): ComputeResourcePolicyTimeoutsOutputReference;
    putTimeouts(value: ComputeResourcePolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeResourcePolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
