import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeUrlMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * The backend service or backend bucket to use when none of the given rules match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#default_service ComputeUrlMap#default_service}
    */
    readonly defaultService?: string;
    /**
    * An optional description of this resource. Provide this property when you create
  the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#description ComputeUrlMap#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#id ComputeUrlMap#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is created. The
  name must be 1-63 characters long, and comply with RFC1035. Specifically, the
  name must be 1-63 characters long and match the regular expression
  '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first character must be a lowercase
  letter, and all following characters must be a dash, lowercase letter, or digit,
  except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#name ComputeUrlMap#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#project ComputeUrlMap#project}
    */
    readonly project?: string;
    /**
    * default_route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#default_route_action ComputeUrlMap#default_route_action}
    */
    readonly defaultRouteAction?: ComputeUrlMapDefaultRouteAction;
    /**
    * default_url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#default_url_redirect ComputeUrlMap#default_url_redirect}
    */
    readonly defaultUrlRedirect?: ComputeUrlMapDefaultUrlRedirect;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_action ComputeUrlMap#header_action}
    */
    readonly headerAction?: ComputeUrlMapHeaderAction;
    /**
    * host_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#host_rule ComputeUrlMap#host_rule}
    */
    readonly hostRule?: ComputeUrlMapHostRule[] | cdktf.IResolvable;
    /**
    * path_matcher block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#path_matcher ComputeUrlMap#path_matcher}
    */
    readonly pathMatcher?: ComputeUrlMapPathMatcher[] | cdktf.IResolvable;
    /**
    * test block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#test ComputeUrlMap#test}
    */
    readonly test?: ComputeUrlMapTest[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#timeouts ComputeUrlMap#timeouts}
    */
    readonly timeouts?: ComputeUrlMapTimeouts;
}
export interface ComputeUrlMapDefaultRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
  This translates to the Access-Control-Allow-Credentials header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_credentials ComputeUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_headers ComputeUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_methods ComputeUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins. For regular expression grammar
  please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_origin_regexes ComputeUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests.
  An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_origins ComputeUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#disabled ComputeUrlMap#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#expose_headers ComputeUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long results of a preflight request can be cached in seconds.
  This translates to the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#max_age ComputeUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function computeUrlMapDefaultRouteActionCorsPolicyToTerraform(struct?: ComputeUrlMapDefaultRouteActionCorsPolicyOutputReference | ComputeUrlMapDefaultRouteActionCorsPolicy): any;
export declare class ComputeUrlMapDefaultRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultRouteActionCorsPolicy | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request.
  The value must be between 200 and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#http_status ComputeUrlMap#http_status}
    */
    readonly httpStatus?: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
  The value must be between 0.0 and 100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#percentage ComputeUrlMap#percentage}
    */
    readonly percentage?: number;
}
export declare function computeUrlMapDefaultRouteActionFaultInjectionPolicyAbortToTerraform(struct?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbortOutputReference | ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort): any;
export declare class ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are
  represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#nanos ComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#seconds ComputeUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function computeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
  The value must be between 0.0 and 100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#percentage ComputeUrlMap#percentage}
    */
    readonly percentage?: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#fixed_delay ComputeUrlMap#fixed_delay}
    */
    readonly fixedDelay?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function computeUrlMapDefaultRouteActionFaultInjectionPolicyDelayToTerraform(struct?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayOutputReference | ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay): any;
export declare class ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    resetFixedDelay(): void;
    get fixedDelayInput(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface ComputeUrlMapDefaultRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#abort ComputeUrlMap#abort}
    */
    readonly abort?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#delay ComputeUrlMap#delay}
    */
    readonly delay?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay;
}
export declare function computeUrlMapDefaultRouteActionFaultInjectionPolicyToTerraform(struct?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyOutputReference | ComputeUrlMapDefaultRouteActionFaultInjectionPolicy): any;
export declare class ComputeUrlMapDefaultRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface ComputeUrlMapDefaultRouteActionRequestMirrorPolicy {
    /**
    * The full or partial URL to the BackendService resource being mirrored to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#backend_service ComputeUrlMap#backend_service}
    */
    readonly backendService: string;
}
export declare function computeUrlMapDefaultRouteActionRequestMirrorPolicyToTerraform(struct?: ComputeUrlMapDefaultRouteActionRequestMirrorPolicyOutputReference | ComputeUrlMapDefaultRouteActionRequestMirrorPolicy): any;
export declare class ComputeUrlMapDefaultRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are
  represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#nanos ComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#seconds ComputeUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function computeUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference | ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout): any;
export declare class ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapDefaultRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#num_retries ComputeUrlMap#num_retries}
    */
    readonly numRetries?: number;
    /**
    * Specfies one or more conditions when this retry rule applies. Valid values are:
  
  * 5xx: Loadbalancer will attempt a retry if the backend service responds with any 5xx response code,
    or if the backend service does not respond at all, example: disconnects, reset, read timeout,
  * connection failure, and refused streams.
  * gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504.
  * connect-failure: Loadbalancer will retry on failures connecting to backend services,
    for example due to connection timeouts.
  * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
    Currently the only retriable error supported is 409.
  * refused-stream:Loadbalancer will retry if the backend service resets the stream with a REFUSED_STREAM error code.
    This reset type indicates that it is safe to retry.
  * cancelled: Loadbalancer will retry if the gRPC status code in the response header is set to cancelled
  * deadline-exceeded: Loadbalancer will retry if the gRPC status code in the response header is set to deadline-exceeded
  * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response header is set to resource-exhausted
  * unavailable: Loadbalancer will retry if the gRPC status code in the response header is set to unavailable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#retry_conditions ComputeUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#per_try_timeout ComputeUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout;
}
export declare function computeUrlMapDefaultRouteActionRetryPolicyToTerraform(struct?: ComputeUrlMapDefaultRouteActionRetryPolicyOutputReference | ComputeUrlMapDefaultRouteActionRetryPolicy): any;
export declare class ComputeUrlMapDefaultRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultRouteActionRetryPolicy | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface ComputeUrlMapDefaultRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented
  with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#nanos ComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#seconds ComputeUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function computeUrlMapDefaultRouteActionTimeoutToTerraform(struct?: ComputeUrlMapDefaultRouteActionTimeoutOutputReference | ComputeUrlMapDefaultRouteActionTimeout): any;
export declare class ComputeUrlMapDefaultRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultRouteActionTimeout | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapDefaultRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected service, the request's host header is replaced
  with contents of hostRewrite.
  
  The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#host_rewrite ComputeUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected backend service, the matching portion of the
  request's path is replaced by pathPrefixRewrite.
  
  The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#path_prefix_rewrite ComputeUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function computeUrlMapDefaultRouteActionUrlRewriteToTerraform(struct?: ComputeUrlMapDefaultRouteActionUrlRewriteOutputReference | ComputeUrlMapDefaultRouteActionUrlRewrite): any;
export declare class ComputeUrlMapDefaultRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultRouteActionUrlRewrite | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName?: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue?: string;
    /**
    * If false, headerValue is appended to any values that already exist for the header.
  If true, headerValue is set for the header, discarding any values that were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    resetHeaderValue(): void;
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    resetReplace(): void;
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName?: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue?: string;
    /**
    * If false, headerValue is appended to any values that already exist for the header.
  If true, headerValue is set for the header, discarding any values that were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    resetHeaderValue(): void;
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    resetReplace(): void;
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request prior to
  forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response prior to sending the
  response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_add ComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_add ComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function computeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference | ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction): any;
export declare class ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapDefaultRouteActionWeightedBackendServices {
    /**
    * The full or partial URL to the default BackendService resource. Before forwarding the
  request to backendService, the loadbalancer applies any relevant headerActions
  specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#backend_service ComputeUrlMap#backend_service}
    */
    readonly backendService?: string;
    /**
    * Specifies the fraction of traffic sent to backendService, computed as
  weight / (sum of all weightedBackendService weights in routeAction) .
  
  The selection of a backend service is determined only for new traffic. Once a user's request
  has been directed to a backendService, subsequent requests will be sent to the same backendService
  as determined by the BackendService's session affinity policy.
  
  The value must be between 0 and 1000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#weight ComputeUrlMap#weight}
    */
    readonly weight?: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_action ComputeUrlMap#header_action}
    */
    readonly headerAction?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction;
}
export declare function computeUrlMapDefaultRouteActionWeightedBackendServicesToTerraform(struct?: ComputeUrlMapDefaultRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class ComputeUrlMapDefaultRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapDefaultRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    resetBackendService(): void;
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class ComputeUrlMapDefaultRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapDefaultRouteActionWeightedBackendServicesOutputReference;
}
export interface ComputeUrlMapDefaultRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#cors_policy ComputeUrlMap#cors_policy}
    */
    readonly corsPolicy?: ComputeUrlMapDefaultRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#fault_injection_policy ComputeUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_mirror_policy ComputeUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: ComputeUrlMapDefaultRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#retry_policy ComputeUrlMap#retry_policy}
    */
    readonly retryPolicy?: ComputeUrlMapDefaultRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#timeout ComputeUrlMap#timeout}
    */
    readonly timeout?: ComputeUrlMapDefaultRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#url_rewrite ComputeUrlMap#url_rewrite}
    */
    readonly urlRewrite?: ComputeUrlMapDefaultRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#weighted_backend_services ComputeUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: ComputeUrlMapDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function computeUrlMapDefaultRouteActionToTerraform(struct?: ComputeUrlMapDefaultRouteActionOutputReference | ComputeUrlMapDefaultRouteAction): any;
export declare class ComputeUrlMapDefaultRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultRouteAction | undefined;
    set internalValue(value: ComputeUrlMapDefaultRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): ComputeUrlMapDefaultRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: ComputeUrlMapDefaultRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): ComputeUrlMapDefaultRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: ComputeUrlMapDefaultRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): ComputeUrlMapDefaultRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: ComputeUrlMapDefaultRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): ComputeUrlMapDefaultRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): ComputeUrlMapDefaultRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: ComputeUrlMapDefaultRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): ComputeUrlMapDefaultRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): ComputeUrlMapDefaultRouteActionTimeoutOutputReference;
    putTimeout(value: ComputeUrlMapDefaultRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): ComputeUrlMapDefaultRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): ComputeUrlMapDefaultRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: ComputeUrlMapDefaultRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): ComputeUrlMapDefaultRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): ComputeUrlMapDefaultRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: ComputeUrlMapDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | ComputeUrlMapDefaultRouteActionWeightedBackendServices[] | undefined;
}
export interface ComputeUrlMapDefaultUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one that was
  supplied in the request. The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#host_redirect ComputeUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https. If set to
  false, the URL scheme of the redirected request will remain the same as that of the
  request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
  true for TargetHttpsProxy is not permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#https_redirect ComputeUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one that was
  supplied in the request. pathRedirect cannot be supplied together with
  prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
  original request will be used for the redirect. The value must be between 1 and 1024
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#path_redirect ComputeUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch,
  retaining the remaining portion of the URL before redirecting the request.
  prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
  neither. If neither is supplied, the path of the original request will be used for
  the redirect. The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#prefix_redirect ComputeUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#redirect_response_code ComputeUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed prior
  to redirecting the request. If set to false, the query portion of the original URL is
  retained. The default is set to false.
   This field is required to ensure an empty block is not set. The normal default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#strip_query ComputeUrlMap#strip_query}
    */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapDefaultUrlRedirectToTerraform(struct?: ComputeUrlMapDefaultUrlRedirectOutputReference | ComputeUrlMapDefaultUrlRedirect): any;
export declare class ComputeUrlMapDefaultUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapDefaultUrlRedirect | undefined;
    set internalValue(value: ComputeUrlMapDefaultUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeUrlMapHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapHeaderActionRequestHeadersToAddToTerraform(struct?: ComputeUrlMapHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapHeaderActionRequestHeadersToAddOutputReference;
}
export interface ComputeUrlMapHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapHeaderActionResponseHeadersToAddToTerraform(struct?: ComputeUrlMapHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapHeaderActionResponseHeadersToAddOutputReference;
}
export interface ComputeUrlMapHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_add ComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: ComputeUrlMapHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_add ComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: ComputeUrlMapHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function computeUrlMapHeaderActionToTerraform(struct?: ComputeUrlMapHeaderActionOutputReference | ComputeUrlMapHeaderAction): any;
export declare class ComputeUrlMapHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapHeaderAction | undefined;
    set internalValue(value: ComputeUrlMapHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): ComputeUrlMapHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: ComputeUrlMapHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): ComputeUrlMapHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: ComputeUrlMapHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapHostRule {
    /**
    * An optional description of this resource. Provide this property when you create
  the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#description ComputeUrlMap#description}
    */
    readonly description?: string;
    /**
    * The list of host patterns to match. They must be valid hostnames, except * will
  match any string of ([a-z0-9-.]*). In that case, * must be the first character
  and must be followed in the pattern by either - or ..
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#hosts ComputeUrlMap#hosts}
    */
    readonly hosts: string[];
    /**
    * The name of the PathMatcher to use to match the path portion of the URL if the
  hostRule matches the URL's host portion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#path_matcher ComputeUrlMap#path_matcher}
    */
    readonly pathMatcher: string;
}
export declare function computeUrlMapHostRuleToTerraform(struct?: ComputeUrlMapHostRule | cdktf.IResolvable): any;
export declare class ComputeUrlMapHostRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapHostRule | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapHostRule | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    get hostsInput(): string[] | undefined;
    private _pathMatcher?;
    get pathMatcher(): string;
    set pathMatcher(value: string);
    get pathMatcherInput(): string | undefined;
}
export declare class ComputeUrlMapHostRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapHostRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapHostRuleOutputReference;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
  This translates to the Access-Control-Allow-Credentials header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_credentials ComputeUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_headers ComputeUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_methods ComputeUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins. For regular expression grammar
  please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_origin_regexes ComputeUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests.
  An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_origins ComputeUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#disabled ComputeUrlMap#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#expose_headers ComputeUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long results of a preflight request can be cached in seconds.
  This translates to the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#max_age ComputeUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionCorsPolicyToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicyOutputReference | ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request.
  The value must be between 200 and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#http_status ComputeUrlMap#http_status}
    */
    readonly httpStatus?: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
  The value must be between 0.0 and 100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#percentage ComputeUrlMap#percentage}
    */
    readonly percentage?: number;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbortToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbortOutputReference | ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are
  represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#nanos ComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#seconds ComputeUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
  The value must be between 0.0 and 100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#percentage ComputeUrlMap#percentage}
    */
    readonly percentage?: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#fixed_delay ComputeUrlMap#fixed_delay}
    */
    readonly fixedDelay?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayOutputReference | ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    resetFixedDelay(): void;
    get fixedDelayInput(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#abort ComputeUrlMap#abort}
    */
    readonly abort?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#delay ComputeUrlMap#delay}
    */
    readonly delay?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyOutputReference | ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy {
    /**
    * The full or partial URL to the BackendService resource being mirrored to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#backend_service ComputeUrlMap#backend_service}
    */
    readonly backendService: string;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicyToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicyOutputReference | ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are
  represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#nanos ComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#seconds ComputeUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference | ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#num_retries ComputeUrlMap#num_retries}
    */
    readonly numRetries?: number;
    /**
    * Specfies one or more conditions when this retry rule applies. Valid values are:
  
  * 5xx: Loadbalancer will attempt a retry if the backend service responds with any 5xx response code,
    or if the backend service does not respond at all, example: disconnects, reset, read timeout,
  * connection failure, and refused streams.
  * gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504.
  * connect-failure: Loadbalancer will retry on failures connecting to backend services,
    for example due to connection timeouts.
  * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
    Currently the only retriable error supported is 409.
  * refused-stream:Loadbalancer will retry if the backend service resets the stream with a REFUSED_STREAM error code.
    This reset type indicates that it is safe to retry.
  * cancelled: Loadbalancer will retry if the gRPC status code in the response header is set to cancelled
  * deadline-exceeded: Loadbalancer will retry if the gRPC status code in the response header is set to deadline-exceeded
  * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response header is set to resource-exhausted
  * unavailable: Loadbalancer will retry if the gRPC status code in the response header is set to unavailable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#retry_conditions ComputeUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#per_try_timeout ComputeUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionRetryPolicyToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyOutputReference | ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented
  with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#nanos ComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
  Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#seconds ComputeUrlMap#seconds}
    */
    readonly seconds?: string;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionTimeoutToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionTimeoutOutputReference | ComputeUrlMapPathMatcherDefaultRouteActionTimeout): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionTimeout | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected service, the request's host header is replaced
  with contents of hostRewrite.
  
  The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#host_rewrite ComputeUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected backend service, the matching portion of the
  request's path is replaced by pathPrefixRewrite.
  
  The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#path_prefix_rewrite ComputeUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionUrlRewriteToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionUrlRewriteOutputReference | ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName?: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue?: string;
    /**
    * If false, headerValue is appended to any values that already exist for the header.
  If true, headerValue is set for the header, discarding any values that were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    resetHeaderValue(): void;
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    resetReplace(): void;
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName?: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue?: string;
    /**
    * If false, headerValue is appended to any values that already exist for the header.
  If true, headerValue is set for the header, discarding any values that were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    resetHeaderValue(): void;
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    resetReplace(): void;
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request prior to
  forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response prior to sending the
  response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_add ComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_add ComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference | ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices {
    /**
    * The full or partial URL to the default BackendService resource. Before forwarding the
  request to backendService, the loadbalancer applies any relevant headerActions
  specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#backend_service ComputeUrlMap#backend_service}
    */
    readonly backendService?: string;
    /**
    * Specifies the fraction of traffic sent to backendService, computed as
  weight / (sum of all weightedBackendService weights in routeAction) .
  
  The selection of a backend service is determined only for new traffic. Once a user's request
  has been directed to a backendService, subsequent requests will be sent to the same backendService
  as determined by the BackendService's session affinity policy.
  
  The value must be between 0 and 1000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#weight ComputeUrlMap#weight}
    */
    readonly weight?: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_action ComputeUrlMap#header_action}
    */
    readonly headerAction?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    resetBackendService(): void;
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesOutputReference;
}
export interface ComputeUrlMapPathMatcherDefaultRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#cors_policy ComputeUrlMap#cors_policy}
    */
    readonly corsPolicy?: ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#fault_injection_policy ComputeUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_mirror_policy ComputeUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#retry_policy ComputeUrlMap#retry_policy}
    */
    readonly retryPolicy?: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#timeout ComputeUrlMap#timeout}
    */
    readonly timeout?: ComputeUrlMapPathMatcherDefaultRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#url_rewrite ComputeUrlMap#url_rewrite}
    */
    readonly urlRewrite?: ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#weighted_backend_services ComputeUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherDefaultRouteActionToTerraform(struct?: ComputeUrlMapPathMatcherDefaultRouteActionOutputReference | ComputeUrlMapPathMatcherDefaultRouteAction): any;
export declare class ComputeUrlMapPathMatcherDefaultRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultRouteAction | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): ComputeUrlMapPathMatcherDefaultRouteActionTimeoutOutputReference;
    putTimeout(value: ComputeUrlMapPathMatcherDefaultRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): ComputeUrlMapPathMatcherDefaultRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): ComputeUrlMapPathMatcherDefaultRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[] | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one that was
  supplied in the request. The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#host_redirect ComputeUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https. If set to
  false, the URL scheme of the redirected request will remain the same as that of the
  request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
  true for TargetHttpsProxy is not permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#https_redirect ComputeUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one that was
  supplied in the request. pathRedirect cannot be supplied together with
  prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
  original request will be used for the redirect. The value must be between 1 and 1024
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#path_redirect ComputeUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch,
  retaining the remaining portion of the URL before redirecting the request.
  prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
  neither. If neither is supplied, the path of the original request will be used for
  the redirect. The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#prefix_redirect ComputeUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#redirect_response_code ComputeUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed prior
  to redirecting the request. If set to false, the query portion of the original URL is
  retained.
   This field is required to ensure an empty block is not set. The normal default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#strip_query ComputeUrlMap#strip_query}
    */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherDefaultUrlRedirectToTerraform(struct?: ComputeUrlMapPathMatcherDefaultUrlRedirectOutputReference | ComputeUrlMapPathMatcherDefaultUrlRedirect): any;
export declare class ComputeUrlMapPathMatcherDefaultUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherDefaultUrlRedirect | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherDefaultUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherHeaderActionRequestHeadersToAddToTerraform(struct?: ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAddOutputReference;
}
export interface ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherHeaderActionResponseHeadersToAddToTerraform(struct?: ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAddOutputReference;
}
export interface ComputeUrlMapPathMatcherHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_add ComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_add ComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherHeaderActionToTerraform(struct?: ComputeUrlMapPathMatcherHeaderActionOutputReference | ComputeUrlMapPathMatcherHeaderAction): any;
export declare class ComputeUrlMapPathMatcherHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherHeaderAction | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the
  actual request can include user credentials. This translates to the Access-
  Control-Allow-Credentials header. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_credentials ComputeUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_headers ComputeUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_methods ComputeUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins. For
  regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_origin_regexes ComputeUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests. An
  origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_origins ComputeUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#disabled ComputeUrlMap#disabled}
    */
    readonly disabled: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#expose_headers ComputeUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long the results of a preflight request can be cached. This
  translates to the content for the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#max_age ComputeUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionCorsPolicyToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference | ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request. The value must be between 200
  and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#http_status ComputeUrlMap#http_status}
    */
    readonly httpStatus: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be
  aborted as part of fault injection. The value must be between 0.0 and 100.0
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#percentage ComputeUrlMap#percentage}
    */
    readonly percentage: number;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference | ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#nanos ComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#seconds ComputeUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will
  be introduced as part of fault injection. The value must be between 0.0 and
  100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#percentage ComputeUrlMap#percentage}
    */
    readonly percentage: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#fixed_delay ComputeUrlMap#fixed_delay}
    */
    readonly fixedDelay: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference | ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    get fixedDelayInput(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#abort ComputeUrlMap#abort}
    */
    readonly abort?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#delay ComputeUrlMap#delay}
    */
    readonly delay?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference | ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy {
    /**
    * The BackendService resource being mirrored to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#backend_service ComputeUrlMap#backend_service}
    */
    readonly backendService: string;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference | ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#nanos ComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#seconds ComputeUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference | ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#num_retries ComputeUrlMap#num_retries}
    */
    readonly numRetries?: number;
    /**
    * Specifies one or more conditions when this retry rule applies. Valid values are:
  
  * 5xx: Loadbalancer will attempt a retry if the backend service responds with
  any 5xx response code, or if the backend service does not respond at all,
  example: disconnects, reset, read timeout, connection failure, and refused
  streams.
  * gateway-error: Similar to 5xx, but only applies to response codes
  502, 503 or 504.
  * connect-failure: Loadbalancer will retry on failures
  connecting to backend services, for example due to connection timeouts.
  * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
  Currently the only retriable error supported is 409.
  * refused-stream: Loadbalancer will retry if the backend service resets the stream with a
  REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
  * cancelled: Loadbalancer will retry if the gRPC status code in the response
  header is set to cancelled
  * deadline-exceeded: Loadbalancer will retry if the
  gRPC status code in the response header is set to deadline-exceeded
  * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
  header is set to resource-exhausted
  * unavailable: Loadbalancer will retry if
  the gRPC status code in the response header is set to unavailable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#retry_conditions ComputeUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#per_try_timeout ComputeUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionRetryPolicyToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference | ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#nanos ComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#seconds ComputeUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionTimeoutToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference | ComputeUrlMapPathMatcherPathRuleRouteActionTimeout): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionTimeout | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected service, the request's host
  header is replaced with contents of hostRewrite. The value must be between 1 and
  255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#host_rewrite ComputeUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected backend service, the matching
  portion of the request's path is replaced by pathPrefixRewrite. The value must
  be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#path_prefix_rewrite ComputeUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionUrlRewriteToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference | ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_add ComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_add ComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference | ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices {
    /**
    * The default BackendService resource. Before
  forwarding the request to backendService, the loadbalancer applies any relevant
  headerActions specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#backend_service ComputeUrlMap#backend_service}
    */
    readonly backendService: string;
    /**
    * Specifies the fraction of traffic sent to backendService, computed as weight /
  (sum of all weightedBackendService weights in routeAction) . The selection of a
  backend service is determined only for new traffic. Once a user's request has
  been directed to a backendService, subsequent requests will be sent to the same
  backendService as determined by the BackendService's session affinity policy.
  The value must be between 0 and 1000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#weight ComputeUrlMap#weight}
    */
    readonly weight: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_action ComputeUrlMap#header_action}
    */
    readonly headerAction?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesOutputReference;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#cors_policy ComputeUrlMap#cors_policy}
    */
    readonly corsPolicy?: ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#fault_injection_policy ComputeUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_mirror_policy ComputeUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#retry_policy ComputeUrlMap#retry_policy}
    */
    readonly retryPolicy?: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#timeout ComputeUrlMap#timeout}
    */
    readonly timeout?: ComputeUrlMapPathMatcherPathRuleRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#url_rewrite ComputeUrlMap#url_rewrite}
    */
    readonly urlRewrite?: ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#weighted_backend_services ComputeUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherPathRuleRouteActionToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleRouteActionOutputReference | ComputeUrlMapPathMatcherPathRuleRouteAction): any;
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleRouteAction | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): ComputeUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference;
    putTimeout(value: ComputeUrlMapPathMatcherPathRuleRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): ComputeUrlMapPathMatcherPathRuleRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one
  that was supplied in the request. The value must be between 1 and 255
  characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#host_redirect ComputeUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https.
  If set to false, the URL scheme of the redirected request will remain the
  same as that of the request. This must only be set for UrlMaps used in
  TargetHttpProxys. Setting this true for TargetHttpsProxy is not
  permitted. The default is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#https_redirect ComputeUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one
  that was supplied in the request. pathRedirect cannot be supplied
  together with prefixRedirect. Supply one alone or neither. If neither is
  supplied, the path of the original request will be used for the redirect.
  The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#path_redirect ComputeUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the
  HttpRouteRuleMatch, retaining the remaining portion of the URL before
  redirecting the request. prefixRedirect cannot be supplied together with
  pathRedirect. Supply one alone or neither. If neither is supplied, the
  path of the original request will be used for the redirect. The value
  must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#prefix_redirect ComputeUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
  will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case,
  the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#redirect_response_code ComputeUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is
  removed prior to redirecting the request. If set to false, the query
  portion of the original URL is retained.
   This field is required to ensure an empty block is not set. The normal default value is false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#strip_query ComputeUrlMap#strip_query}
    */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherPathRuleUrlRedirectToTerraform(struct?: ComputeUrlMapPathMatcherPathRuleUrlRedirectOutputReference | ComputeUrlMapPathMatcherPathRuleUrlRedirect): any;
export declare class ComputeUrlMapPathMatcherPathRuleUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherPathRuleUrlRedirect | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRuleUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeUrlMapPathMatcherPathRule {
    /**
    * The list of path patterns to match. Each must start with / and the only place a
  \* is allowed is at the end following a /. The string fed to the path matcher
  does not include any text after the first ? or #, and those chars are not
  allowed here.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#paths ComputeUrlMap#paths}
    */
    readonly paths: string[];
    /**
    * The backend service or backend bucket to use if any of the given paths match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#service ComputeUrlMap#service}
    */
    readonly service?: string;
    /**
    * route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#route_action ComputeUrlMap#route_action}
    */
    readonly routeAction?: ComputeUrlMapPathMatcherPathRuleRouteAction;
    /**
    * url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#url_redirect ComputeUrlMap#url_redirect}
    */
    readonly urlRedirect?: ComputeUrlMapPathMatcherPathRuleUrlRedirect;
}
export declare function computeUrlMapPathMatcherPathRuleToTerraform(struct?: ComputeUrlMapPathMatcherPathRule | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherPathRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherPathRule | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherPathRule | cdktf.IResolvable | undefined);
    private _paths?;
    get paths(): string[];
    set paths(value: string[]);
    get pathsInput(): string[] | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _routeAction;
    get routeAction(): ComputeUrlMapPathMatcherPathRuleRouteActionOutputReference;
    putRouteAction(value: ComputeUrlMapPathMatcherPathRuleRouteAction): void;
    resetRouteAction(): void;
    get routeActionInput(): ComputeUrlMapPathMatcherPathRuleRouteAction | undefined;
    private _urlRedirect;
    get urlRedirect(): ComputeUrlMapPathMatcherPathRuleUrlRedirectOutputReference;
    putUrlRedirect(value: ComputeUrlMapPathMatcherPathRuleUrlRedirect): void;
    resetUrlRedirect(): void;
    get urlRedirectInput(): ComputeUrlMapPathMatcherPathRuleUrlRedirect | undefined;
}
export declare class ComputeUrlMapPathMatcherPathRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherPathRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherPathRuleOutputReference;
}
export interface ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddOutputReference;
}
export interface ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddOutputReference;
}
export interface ComputeUrlMapPathMatcherRouteRulesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_add ComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_add ComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherRouteRulesHeaderActionToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesHeaderActionOutputReference | ComputeUrlMapPathMatcherRouteRulesHeaderAction): any;
export declare class ComputeUrlMapPathMatcherRouteRulesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesHeaderAction | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch {
    /**
    * The end of the range (exclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#range_end ComputeUrlMap#range_end}
    */
    readonly rangeEnd: number;
    /**
    * The start of the range (inclusive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#range_start ComputeUrlMap#range_start}
    */
    readonly rangeStart: number;
}
export declare function computeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference | ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch): any;
export declare class ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch | undefined);
    private _rangeEnd?;
    get rangeEnd(): number;
    set rangeEnd(value: number);
    get rangeEndInput(): number | undefined;
    private _rangeStart?;
    get rangeStart(): number;
    set rangeStart(value: number);
    get rangeStartInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches {
    /**
    * The value should exactly match contents of exactMatch. Only one of exactMatch,
  prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#exact_match ComputeUrlMap#exact_match}
    */
    readonly exactMatch?: string;
    /**
    * The name of the HTTP header to match. For matching against the HTTP request's
  authority, use a headerMatch with the header name ":authority". For matching a
  request's method, use the headerName ":method".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * If set to false, the headerMatch is considered a match if the match criteria
  above are met. If set to true, the headerMatch is considered a match if the
  match criteria above are NOT met. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#invert_match ComputeUrlMap#invert_match}
    */
    readonly invertMatch?: boolean | cdktf.IResolvable;
    /**
    * The value of the header must start with the contents of prefixMatch. Only one of
  exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
  must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#prefix_match ComputeUrlMap#prefix_match}
    */
    readonly prefixMatch?: string;
    /**
    * A header with the contents of headerName must exist. The match takes place
  whether or not the request's header has a value or not. Only one of exactMatch,
  prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#present_match ComputeUrlMap#present_match}
    */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
    * The value of the header must match the regular expression specified in
  regexMatch. For regular expression grammar, please see:
  en.cppreference.com/w/cpp/regex/ecmascript  For matching against a port
  specified in the HTTP request, use a headerMatch with headerName set to PORT and
  a regular expression that satisfies the RFC2616 Host header's port specifier.
  Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or
  rangeMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#regex_match ComputeUrlMap#regex_match}
    */
    readonly regexMatch?: string;
    /**
    * The value of the header must end with the contents of suffixMatch. Only one of
  exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
  must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#suffix_match ComputeUrlMap#suffix_match}
    */
    readonly suffixMatch?: string;
    /**
    * range_match block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#range_match ComputeUrlMap#range_match}
    */
    readonly rangeMatch?: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch;
}
export declare function computeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches | cdktf.IResolvable | undefined);
    private _exactMatch?;
    get exactMatch(): string;
    set exactMatch(value: string);
    resetExactMatch(): void;
    get exactMatchInput(): string | undefined;
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _invertMatch?;
    get invertMatch(): boolean | cdktf.IResolvable;
    set invertMatch(value: boolean | cdktf.IResolvable);
    resetInvertMatch(): void;
    get invertMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    get prefixMatch(): string;
    set prefixMatch(value: string);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string | undefined;
    private _presentMatch?;
    get presentMatch(): boolean | cdktf.IResolvable;
    set presentMatch(value: boolean | cdktf.IResolvable);
    resetPresentMatch(): void;
    get presentMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
    private _suffixMatch?;
    get suffixMatch(): string;
    set suffixMatch(value: string);
    resetSuffixMatch(): void;
    get suffixMatchInput(): string | undefined;
    private _rangeMatch;
    get rangeMatch(): ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference;
    putRangeMatch(value: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch): void;
    resetRangeMatch(): void;
    get rangeMatchInput(): ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch | undefined;
}
export declare class ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesOutputReference;
}
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels {
    /**
    * Name of metadata label. The name can have a maximum length of 1024 characters
  and must be at least 1 character long.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#name ComputeUrlMap#name}
    */
    readonly name: string;
    /**
    * The value of the label must match the specified value. value can have a maximum
  length of 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#value ComputeUrlMap#value}
    */
    readonly value: string;
}
export declare function computeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsOutputReference;
}
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters {
    /**
    * Specifies how individual filterLabel matches within the list of filterLabels
  contribute towards the overall metadataFilter match. Supported values are:
    - MATCH_ANY: At least one of the filterLabels must have a matching label in the
  provided metadata.
    - MATCH_ALL: All filterLabels must have matching labels in
  the provided metadata. Possible values: ["MATCH_ALL", "MATCH_ANY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#filter_match_criteria ComputeUrlMap#filter_match_criteria}
    */
    readonly filterMatchCriteria: string;
    /**
    * filter_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#filter_labels ComputeUrlMap#filter_labels}
    */
    readonly filterLabels: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters | cdktf.IResolvable | undefined);
    private _filterMatchCriteria?;
    get filterMatchCriteria(): string;
    set filterMatchCriteria(value: string);
    get filterMatchCriteriaInput(): string | undefined;
    private _filterLabels;
    get filterLabels(): ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabelsList;
    putFilterLabels(value: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | cdktf.IResolvable): void;
    get filterLabelsInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[] | undefined;
}
export declare class ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersOutputReference;
}
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches {
    /**
    * The queryParameterMatch matches if the value of the parameter exactly matches
  the contents of exactMatch. Only one of presentMatch, exactMatch and regexMatch
  must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#exact_match ComputeUrlMap#exact_match}
    */
    readonly exactMatch?: string;
    /**
    * The name of the query parameter to match. The query parameter must exist in the
  request, in the absence of which the request match fails.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#name ComputeUrlMap#name}
    */
    readonly name: string;
    /**
    * Specifies that the queryParameterMatch matches if the request contains the query
  parameter, irrespective of whether the parameter has a value or not. Only one of
  presentMatch, exactMatch and regexMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#present_match ComputeUrlMap#present_match}
    */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
    * The queryParameterMatch matches if the value of the parameter matches the
  regular expression specified by regexMatch. For the regular expression grammar,
  please see en.cppreference.com/w/cpp/regex/ecmascript  Only one of presentMatch,
  exactMatch and regexMatch must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#regex_match ComputeUrlMap#regex_match}
    */
    readonly regexMatch?: string;
}
export declare function computeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches | cdktf.IResolvable | undefined);
    private _exactMatch?;
    get exactMatch(): string;
    set exactMatch(value: string);
    resetExactMatch(): void;
    get exactMatchInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _presentMatch?;
    get presentMatch(): boolean | cdktf.IResolvable;
    set presentMatch(value: boolean | cdktf.IResolvable);
    resetPresentMatch(): void;
    get presentMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
}
export declare class ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesOutputReference;
}
export interface ComputeUrlMapPathMatcherRouteRulesMatchRules {
    /**
    * For satisfying the matchRule condition, the path of the request must exactly
  match the value specified in fullPathMatch after removing any query parameters
  and anchor that may be part of the original URL. FullPathMatch must be between 1
  and 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must
  be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#full_path_match ComputeUrlMap#full_path_match}
    */
    readonly fullPathMatch?: string;
    /**
    * Specifies that prefixMatch and fullPathMatch matches are case sensitive.
  Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#ignore_case ComputeUrlMap#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * For satisfying the matchRule condition, the request's path must begin with the
  specified prefixMatch. prefixMatch must begin with a /. The value must be
  between 1 and 1024 characters. Only one of prefixMatch, fullPathMatch or
  regexMatch must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#prefix_match ComputeUrlMap#prefix_match}
    */
    readonly prefixMatch?: string;
    /**
    * For satisfying the matchRule condition, the path of the request must satisfy the
  regular expression specified in regexMatch after removing any query parameters
  and anchor supplied with the original URL. For regular expression grammar please
  see en.cppreference.com/w/cpp/regex/ecmascript  Only one of prefixMatch,
  fullPathMatch or regexMatch must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#regex_match ComputeUrlMap#regex_match}
    */
    readonly regexMatch?: string;
    /**
    * header_matches block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_matches ComputeUrlMap#header_matches}
    */
    readonly headerMatches?: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | cdktf.IResolvable;
    /**
    * metadata_filters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#metadata_filters ComputeUrlMap#metadata_filters}
    */
    readonly metadataFilters?: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | cdktf.IResolvable;
    /**
    * query_parameter_matches block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#query_parameter_matches ComputeUrlMap#query_parameter_matches}
    */
    readonly queryParameterMatches?: ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherRouteRulesMatchRulesToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesMatchRules | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherRouteRulesMatchRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesMatchRules | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesMatchRules | cdktf.IResolvable | undefined);
    private _fullPathMatch?;
    get fullPathMatch(): string;
    set fullPathMatch(value: string);
    resetFullPathMatch(): void;
    get fullPathMatchInput(): string | undefined;
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _prefixMatch?;
    get prefixMatch(): string;
    set prefixMatch(value: string);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string | undefined;
    private _regexMatch?;
    get regexMatch(): string;
    set regexMatch(value: string);
    resetRegexMatch(): void;
    get regexMatchInput(): string | undefined;
    private _headerMatches;
    get headerMatches(): ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesList;
    putHeaderMatches(value: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | cdktf.IResolvable): void;
    resetHeaderMatches(): void;
    get headerMatchesInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[] | undefined;
    private _metadataFilters;
    get metadataFilters(): ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersList;
    putMetadataFilters(value: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | cdktf.IResolvable): void;
    resetMetadataFilters(): void;
    get metadataFiltersInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[] | undefined;
    private _queryParameterMatches;
    get queryParameterMatches(): ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatchesList;
    putQueryParameterMatches(value: ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | cdktf.IResolvable): void;
    resetQueryParameterMatches(): void;
    get queryParameterMatchesInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[] | undefined;
}
export declare class ComputeUrlMapPathMatcherRouteRulesMatchRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherRouteRulesMatchRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherRouteRulesMatchRulesOutputReference;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the
  actual request can include user credentials. This translates to the Access-
  Control-Allow-Credentials header. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_credentials ComputeUrlMap#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_headers ComputeUrlMap#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_methods ComputeUrlMap#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the regular expression patterns that match allowed origins. For
  regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
  An origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_origin_regexes ComputeUrlMap#allow_origin_regexes}
    */
    readonly allowOriginRegexes?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests. An
  origin is allowed if it matches either allow_origins or allow_origin_regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#allow_origins ComputeUrlMap#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled.
  which indicates that the CORS policy is in effect. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#disabled ComputeUrlMap#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Expose-Headers header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#expose_headers ComputeUrlMap#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long the results of a preflight request can be cached. This
  translates to the content for the Access-Control-Max-Age header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#max_age ComputeUrlMap#max_age}
    */
    readonly maxAge?: number;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionCorsPolicyToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference | ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[];
    set allowOriginRegexes(value: string[]);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort {
    /**
    * The HTTP status code used to abort the request. The value must be between 200
  and 599 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#http_status ComputeUrlMap#http_status}
    */
    readonly httpStatus?: number;
    /**
    * The percentage of traffic (connections/operations/requests) which will be
  aborted as part of fault injection. The value must be between 0.0 and 100.0
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#percentage ComputeUrlMap#percentage}
    */
    readonly percentage?: number;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference | ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#nanos ComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#seconds ComputeUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference | ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay {
    /**
    * The percentage of traffic (connections/operations/requests) on which delay will
  be introduced as part of fault injection. The value must be between 0.0 and
  100.0 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#percentage ComputeUrlMap#percentage}
    */
    readonly percentage?: number;
    /**
    * fixed_delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#fixed_delay ComputeUrlMap#fixed_delay}
    */
    readonly fixedDelay?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference | ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _fixedDelay;
    get fixedDelay(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    resetFixedDelay(): void;
    get fixedDelayInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy {
    /**
    * abort block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#abort ComputeUrlMap#abort}
    */
    readonly abort?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort;
    /**
    * delay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#delay ComputeUrlMap#delay}
    */
    readonly delay?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference | ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined);
    private _abort;
    get abort(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort): void;
    resetAbort(): void;
    get abortInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay;
    get delay(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay): void;
    resetDelay(): void;
    get delayInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy {
    /**
    * The BackendService resource being mirrored to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#backend_service ComputeUrlMap#backend_service}
    */
    readonly backendService: string;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference | ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#nanos ComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#seconds ComputeUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference | ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy {
    /**
    * Specifies the allowed number retries. This number must be > 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#num_retries ComputeUrlMap#num_retries}
    */
    readonly numRetries: number;
    /**
    * Specfies one or more conditions when this retry rule applies. Valid values are:
  
  * 5xx: Loadbalancer will attempt a retry if the backend service responds with
    any 5xx response code, or if the backend service does not respond at all,
    example: disconnects, reset, read timeout, connection failure, and refused
    streams.
  * gateway-error: Similar to 5xx, but only applies to response codes
    502, 503 or 504.
  * connect-failure: Loadbalancer will retry on failures
    connecting to backend services, for example due to connection timeouts.
  * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
    Currently the only retriable error supported is 409.
  * refused-stream: Loadbalancer will retry if the backend service resets the stream with a
    REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
  * cancelled: Loadbalancer will retry if the gRPC status code in the response
    header is set to cancelled
  * deadline-exceeded: Loadbalancer will retry if the
    gRPC status code in the response header is set to deadline-exceeded
  * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
    header is set to resource-exhausted
  * unavailable: Loadbalancer will retry if the gRPC status code in
    the response header is set to unavailable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#retry_conditions ComputeUrlMap#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * per_try_timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#per_try_timeout ComputeUrlMap#per_try_timeout}
    */
    readonly perTryTimeout?: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference | ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout;
    get perTryTimeout(): ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout {
    /**
    * Span of time that's a fraction of a second at nanosecond resolution. Durations
  less than one second are represented with a 0 'seconds' field and a positive
  'nanos' field. Must be from 0 to 999,999,999 inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#nanos ComputeUrlMap#nanos}
    */
    readonly nanos?: number;
    /**
    * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000
  inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#seconds ComputeUrlMap#seconds}
    */
    readonly seconds: string;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionTimeoutToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference | ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined);
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected service, the request's host
  header is replaced with contents of hostRewrite. The value must be between 1 and
  255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#host_rewrite ComputeUrlMap#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected backend service, the matching
  portion of the request's path is replaced by pathPrefixRewrite. The value must
  be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#path_prefix_rewrite ComputeUrlMap#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionUrlRewriteToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference | ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddOutputReference;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
    * The name of the header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_name ComputeUrlMap#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_value ComputeUrlMap#header_value}
    */
    readonly headerValue: string;
    /**
    * If false, headerValue is appended to any values that already exist for the
  header. If true, headerValue is set for the header, discarding any values that
  were set for that header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#replace ComputeUrlMap#replace}
    */
    readonly replace: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddOutputReference;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction {
    /**
    * A list of header names for headers that need to be removed from the request
  prior to forwarding the request to the backendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
    */
    readonly requestHeadersToRemove?: string[];
    /**
    * A list of header names for headers that need to be removed from the response
  prior to sending the response back to the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
    */
    readonly responseHeadersToRemove?: string[];
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_headers_to_add ComputeUrlMap#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * response_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#response_headers_to_add ComputeUrlMap#response_headers_to_add}
    */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference | ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction | undefined);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[];
    set requestHeadersToRemove(value: string[]);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[];
    set responseHeadersToRemove(value: string[]);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd;
    get responseHeadersToAdd(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAddList;
    putResponseHeadersToAdd(value: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | cdktf.IResolvable): void;
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices {
    /**
    * The default BackendService resource. Before
  forwarding the request to backendService, the loadbalancer applies any relevant
  headerActions specified as part of this backendServiceWeight.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#backend_service ComputeUrlMap#backend_service}
    */
    readonly backendService: string;
    /**
    * Specifies the fraction of traffic sent to backendService, computed as weight /
  (sum of all weightedBackendService weights in routeAction) . The selection of a
  backend service is determined only for new traffic. Once a user's request has
  been directed to a backendService, subsequent requests will be sent to the same
  backendService as determined by the BackendService's session affinity policy.
  The value must be between 0 and 1000
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#weight ComputeUrlMap#weight}
    */
    readonly weight: number;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_action ComputeUrlMap#header_action}
    */
    readonly headerAction?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices | cdktf.IResolvable | undefined);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _headerAction;
    get headerAction(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference;
    putHeaderAction(value: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction | undefined;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesOutputReference;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteAction {
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#cors_policy ComputeUrlMap#cors_policy}
    */
    readonly corsPolicy?: ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy;
    /**
    * fault_injection_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#fault_injection_policy ComputeUrlMap#fault_injection_policy}
    */
    readonly faultInjectionPolicy?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy;
    /**
    * request_mirror_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#request_mirror_policy ComputeUrlMap#request_mirror_policy}
    */
    readonly requestMirrorPolicy?: ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#retry_policy ComputeUrlMap#retry_policy}
    */
    readonly retryPolicy?: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#timeout ComputeUrlMap#timeout}
    */
    readonly timeout?: ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#url_rewrite ComputeUrlMap#url_rewrite}
    */
    readonly urlRewrite?: ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite;
    /**
    * weighted_backend_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#weighted_backend_services ComputeUrlMap#weighted_backend_services}
    */
    readonly weightedBackendServices?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherRouteRulesRouteActionToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesRouteActionOutputReference | ComputeUrlMapPathMatcherRouteRulesRouteAction): any;
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesRouteAction | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesRouteAction | undefined);
    private _corsPolicy;
    get corsPolicy(): ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy;
    get faultInjectionPolicy(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy;
    get requestMirrorPolicy(): ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy;
    get retryPolicy(): ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined;
    private _timeout;
    get timeout(): ComputeUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference;
    putTimeout(value: ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined;
    private _urlRewrite;
    get urlRewrite(): ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined;
    private _weightedBackendServices;
    get weightedBackendServices(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesList;
    putWeightedBackendServices(value: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | cdktf.IResolvable): void;
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one that was
  supplied in the request. The value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#host_redirect ComputeUrlMap#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https. If set
  to false, the URL scheme of the redirected request will remain the same as that
  of the request. This must only be set for UrlMaps used in TargetHttpProxys.
  Setting this true for TargetHttpsProxy is not permitted. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#https_redirect ComputeUrlMap#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one that was
  supplied in the request. Only one of pathRedirect or prefixRedirect must be
  specified. The value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#path_redirect ComputeUrlMap#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch,
  retaining the remaining portion of the URL before redirecting the request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#prefix_redirect ComputeUrlMap#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction. Supported values are:
  
  * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
  
  * FOUND, which corresponds to 302.
  
  * SEE_OTHER which corresponds to 303.
  
  * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method will be retained.
  
  * PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#redirect_response_code ComputeUrlMap#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed
  prior to redirecting the request. If set to false, the query portion of the
  original URL is retained. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#strip_query ComputeUrlMap#strip_query}
    */
    readonly stripQuery?: boolean | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherRouteRulesUrlRedirectToTerraform(struct?: ComputeUrlMapPathMatcherRouteRulesUrlRedirectOutputReference | ComputeUrlMapPathMatcherRouteRulesUrlRedirect): any;
export declare class ComputeUrlMapPathMatcherRouteRulesUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapPathMatcherRouteRulesUrlRedirect | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRulesUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    resetStripQuery(): void;
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRules {
    /**
    * For routeRules within a given pathMatcher, priority determines the order
  in which load balancer will interpret routeRules. RouteRules are evaluated
  in order of priority, from the lowest to highest number. The priority of
  a rule decreases as its number increases (1, 2, 3, N+1). The first rule
  that matches the request is applied.
  
  You cannot configure two or more routeRules with the same priority.
  Priority for each rule must be set to a number between 0 and
  2147483647 inclusive.
  
  Priority numbers can have gaps, which enable you to add or remove rules
  in the future without affecting the rest of the rules. For example,
  1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which
  you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the
  future without any impact on existing rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#priority ComputeUrlMap#priority}
    */
    readonly priority: number;
    /**
    * The backend service resource to which traffic is
  directed if this rule is matched. If routeAction is additionally specified,
  advanced routing actions like URL Rewrites, etc. take effect prior to sending
  the request to the backend. However, if service is specified, routeAction cannot
  contain any weightedBackendService s. Conversely, if routeAction specifies any
  weightedBackendServices, service must not be specified. Only one of urlRedirect,
  service or routeAction.weightedBackendService must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#service ComputeUrlMap#service}
    */
    readonly service?: string;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_action ComputeUrlMap#header_action}
    */
    readonly headerAction?: ComputeUrlMapPathMatcherRouteRulesHeaderAction;
    /**
    * match_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#match_rules ComputeUrlMap#match_rules}
    */
    readonly matchRules?: ComputeUrlMapPathMatcherRouteRulesMatchRules[] | cdktf.IResolvable;
    /**
    * route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#route_action ComputeUrlMap#route_action}
    */
    readonly routeAction?: ComputeUrlMapPathMatcherRouteRulesRouteAction;
    /**
    * url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#url_redirect ComputeUrlMap#url_redirect}
    */
    readonly urlRedirect?: ComputeUrlMapPathMatcherRouteRulesUrlRedirect;
}
export declare function computeUrlMapPathMatcherRouteRulesToTerraform(struct?: ComputeUrlMapPathMatcherRouteRules | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherRouteRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcherRouteRules | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcherRouteRules | cdktf.IResolvable | undefined);
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _headerAction;
    get headerAction(): ComputeUrlMapPathMatcherRouteRulesHeaderActionOutputReference;
    putHeaderAction(value: ComputeUrlMapPathMatcherRouteRulesHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): ComputeUrlMapPathMatcherRouteRulesHeaderAction | undefined;
    private _matchRules;
    get matchRules(): ComputeUrlMapPathMatcherRouteRulesMatchRulesList;
    putMatchRules(value: ComputeUrlMapPathMatcherRouteRulesMatchRules[] | cdktf.IResolvable): void;
    resetMatchRules(): void;
    get matchRulesInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherRouteRulesMatchRules[] | undefined;
    private _routeAction;
    get routeAction(): ComputeUrlMapPathMatcherRouteRulesRouteActionOutputReference;
    putRouteAction(value: ComputeUrlMapPathMatcherRouteRulesRouteAction): void;
    resetRouteAction(): void;
    get routeActionInput(): ComputeUrlMapPathMatcherRouteRulesRouteAction | undefined;
    private _urlRedirect;
    get urlRedirect(): ComputeUrlMapPathMatcherRouteRulesUrlRedirectOutputReference;
    putUrlRedirect(value: ComputeUrlMapPathMatcherRouteRulesUrlRedirect): void;
    resetUrlRedirect(): void;
    get urlRedirectInput(): ComputeUrlMapPathMatcherRouteRulesUrlRedirect | undefined;
}
export declare class ComputeUrlMapPathMatcherRouteRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcherRouteRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherRouteRulesOutputReference;
}
export interface ComputeUrlMapPathMatcher {
    /**
    * The backend service or backend bucket to use when none of the given paths match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#default_service ComputeUrlMap#default_service}
    */
    readonly defaultService?: string;
    /**
    * An optional description of this resource. Provide this property when you create
  the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#description ComputeUrlMap#description}
    */
    readonly description?: string;
    /**
    * The name to which this PathMatcher is referred by the HostRule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#name ComputeUrlMap#name}
    */
    readonly name: string;
    /**
    * default_route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#default_route_action ComputeUrlMap#default_route_action}
    */
    readonly defaultRouteAction?: ComputeUrlMapPathMatcherDefaultRouteAction;
    /**
    * default_url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#default_url_redirect ComputeUrlMap#default_url_redirect}
    */
    readonly defaultUrlRedirect?: ComputeUrlMapPathMatcherDefaultUrlRedirect;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#header_action ComputeUrlMap#header_action}
    */
    readonly headerAction?: ComputeUrlMapPathMatcherHeaderAction;
    /**
    * path_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#path_rule ComputeUrlMap#path_rule}
    */
    readonly pathRule?: ComputeUrlMapPathMatcherPathRule[] | cdktf.IResolvable;
    /**
    * route_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#route_rules ComputeUrlMap#route_rules}
    */
    readonly routeRules?: ComputeUrlMapPathMatcherRouteRules[] | cdktf.IResolvable;
}
export declare function computeUrlMapPathMatcherToTerraform(struct?: ComputeUrlMapPathMatcher | cdktf.IResolvable): any;
export declare class ComputeUrlMapPathMatcherOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapPathMatcher | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapPathMatcher | cdktf.IResolvable | undefined);
    private _defaultService?;
    get defaultService(): string;
    set defaultService(value: string);
    resetDefaultService(): void;
    get defaultServiceInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _defaultRouteAction;
    get defaultRouteAction(): ComputeUrlMapPathMatcherDefaultRouteActionOutputReference;
    putDefaultRouteAction(value: ComputeUrlMapPathMatcherDefaultRouteAction): void;
    resetDefaultRouteAction(): void;
    get defaultRouteActionInput(): ComputeUrlMapPathMatcherDefaultRouteAction | undefined;
    private _defaultUrlRedirect;
    get defaultUrlRedirect(): ComputeUrlMapPathMatcherDefaultUrlRedirectOutputReference;
    putDefaultUrlRedirect(value: ComputeUrlMapPathMatcherDefaultUrlRedirect): void;
    resetDefaultUrlRedirect(): void;
    get defaultUrlRedirectInput(): ComputeUrlMapPathMatcherDefaultUrlRedirect | undefined;
    private _headerAction;
    get headerAction(): ComputeUrlMapPathMatcherHeaderActionOutputReference;
    putHeaderAction(value: ComputeUrlMapPathMatcherHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): ComputeUrlMapPathMatcherHeaderAction | undefined;
    private _pathRule;
    get pathRule(): ComputeUrlMapPathMatcherPathRuleList;
    putPathRule(value: ComputeUrlMapPathMatcherPathRule[] | cdktf.IResolvable): void;
    resetPathRule(): void;
    get pathRuleInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherPathRule[] | undefined;
    private _routeRules;
    get routeRules(): ComputeUrlMapPathMatcherRouteRulesList;
    putRouteRules(value: ComputeUrlMapPathMatcherRouteRules[] | cdktf.IResolvable): void;
    resetRouteRules(): void;
    get routeRulesInput(): cdktf.IResolvable | ComputeUrlMapPathMatcherRouteRules[] | undefined;
}
export declare class ComputeUrlMapPathMatcherList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapPathMatcher[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapPathMatcherOutputReference;
}
export interface ComputeUrlMapTest {
    /**
    * Description of this test case.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#description ComputeUrlMap#description}
    */
    readonly description?: string;
    /**
    * Host portion of the URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#host ComputeUrlMap#host}
    */
    readonly host: string;
    /**
    * Path portion of the URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#path ComputeUrlMap#path}
    */
    readonly path: string;
    /**
    * The backend service or backend bucket link that should be matched by this test.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#service ComputeUrlMap#service}
    */
    readonly service: string;
}
export declare function computeUrlMapTestToTerraform(struct?: ComputeUrlMapTest | cdktf.IResolvable): any;
export declare class ComputeUrlMapTestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeUrlMapTest | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapTest | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export declare class ComputeUrlMapTestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeUrlMapTest[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeUrlMapTestOutputReference;
}
export interface ComputeUrlMapTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#create ComputeUrlMap#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#delete ComputeUrlMap#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map#update ComputeUrlMap#update}
    */
    readonly update?: string;
}
export declare function computeUrlMapTimeoutsToTerraform(struct?: ComputeUrlMapTimeoutsOutputReference | ComputeUrlMapTimeouts | cdktf.IResolvable): any;
export declare class ComputeUrlMapTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeUrlMapTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeUrlMapTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_url_map google_compute_url_map}
*/
export declare class ComputeUrlMap extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_url_map";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_url_map google_compute_url_map} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeUrlMapConfig
    */
    constructor(scope: Construct, id: string, config: ComputeUrlMapConfig);
    get creationTimestamp(): string;
    private _defaultService?;
    get defaultService(): string;
    set defaultService(value: string);
    resetDefaultService(): void;
    get defaultServiceInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get mapId(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _defaultRouteAction;
    get defaultRouteAction(): ComputeUrlMapDefaultRouteActionOutputReference;
    putDefaultRouteAction(value: ComputeUrlMapDefaultRouteAction): void;
    resetDefaultRouteAction(): void;
    get defaultRouteActionInput(): ComputeUrlMapDefaultRouteAction | undefined;
    private _defaultUrlRedirect;
    get defaultUrlRedirect(): ComputeUrlMapDefaultUrlRedirectOutputReference;
    putDefaultUrlRedirect(value: ComputeUrlMapDefaultUrlRedirect): void;
    resetDefaultUrlRedirect(): void;
    get defaultUrlRedirectInput(): ComputeUrlMapDefaultUrlRedirect | undefined;
    private _headerAction;
    get headerAction(): ComputeUrlMapHeaderActionOutputReference;
    putHeaderAction(value: ComputeUrlMapHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): ComputeUrlMapHeaderAction | undefined;
    private _hostRule;
    get hostRule(): ComputeUrlMapHostRuleList;
    putHostRule(value: ComputeUrlMapHostRule[] | cdktf.IResolvable): void;
    resetHostRule(): void;
    get hostRuleInput(): cdktf.IResolvable | ComputeUrlMapHostRule[] | undefined;
    private _pathMatcher;
    get pathMatcher(): ComputeUrlMapPathMatcherList;
    putPathMatcher(value: ComputeUrlMapPathMatcher[] | cdktf.IResolvable): void;
    resetPathMatcher(): void;
    get pathMatcherInput(): cdktf.IResolvable | ComputeUrlMapPathMatcher[] | undefined;
    private _test;
    get test(): ComputeUrlMapTestList;
    putTest(value: ComputeUrlMapTest[] | cdktf.IResolvable): void;
    resetTest(): void;
    get testInput(): cdktf.IResolvable | ComputeUrlMapTest[] | undefined;
    private _timeouts;
    get timeouts(): ComputeUrlMapTimeoutsOutputReference;
    putTimeouts(value: ComputeUrlMapTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeUrlMapTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
