import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAttachedClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Annotations on the cluster. This field has the same
  restrictions as Kubernetes annotations. The total size of all keys and
  values combined is limited to 256k. Key can have 2 segments: prefix (optional)
  and name (required), separated by a slash (/). Prefix must be a DNS subdomain.
  Name must be 63 characters or less, begin and end with alphanumerics,
  with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#annotations ContainerAttachedCluster#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Policy to determine what flags to send on delete.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#deletion_policy ContainerAttachedCluster#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * A human readable description of this attached cluster. Cannot be longer
  than 255 UTF-8 encoded bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#description ContainerAttachedCluster#description}
    */
    readonly description?: string;
    /**
    * The Kubernetes distribution of the underlying attached cluster. Supported values:
  "eks", "aks".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#distribution ContainerAttachedCluster#distribution}
    */
    readonly distribution: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#id ContainerAttachedCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#location ContainerAttachedCluster#location}
    */
    readonly location: string;
    /**
    * The name of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#name ContainerAttachedCluster#name}
    */
    readonly name: string;
    /**
    * The platform version for the cluster (e.g. '1.23.0-gke.1').
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#platform_version ContainerAttachedCluster#platform_version}
    */
    readonly platformVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#project ContainerAttachedCluster#project}
    */
    readonly project?: string;
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#authorization ContainerAttachedCluster#authorization}
    */
    readonly authorization?: ContainerAttachedClusterAuthorization;
    /**
    * fleet block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#fleet ContainerAttachedCluster#fleet}
    */
    readonly fleet: ContainerAttachedClusterFleet;
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#logging_config ContainerAttachedCluster#logging_config}
    */
    readonly loggingConfig?: ContainerAttachedClusterLoggingConfig;
    /**
    * monitoring_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#monitoring_config ContainerAttachedCluster#monitoring_config}
    */
    readonly monitoringConfig?: ContainerAttachedClusterMonitoringConfig;
    /**
    * oidc_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#oidc_config ContainerAttachedCluster#oidc_config}
    */
    readonly oidcConfig: ContainerAttachedClusterOidcConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#timeouts ContainerAttachedCluster#timeouts}
    */
    readonly timeouts?: ContainerAttachedClusterTimeouts;
}
export interface ContainerAttachedClusterErrors {
}
export declare function containerAttachedClusterErrorsToTerraform(struct?: ContainerAttachedClusterErrors): any;
export declare class ContainerAttachedClusterErrorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAttachedClusterErrors | undefined;
    set internalValue(value: ContainerAttachedClusterErrors | undefined);
    get message(): string;
}
export declare class ContainerAttachedClusterErrorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAttachedClusterErrorsOutputReference;
}
export interface ContainerAttachedClusterWorkloadIdentityConfig {
}
export declare function containerAttachedClusterWorkloadIdentityConfigToTerraform(struct?: ContainerAttachedClusterWorkloadIdentityConfig): any;
export declare class ContainerAttachedClusterWorkloadIdentityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAttachedClusterWorkloadIdentityConfig | undefined;
    set internalValue(value: ContainerAttachedClusterWorkloadIdentityConfig | undefined);
    get identityProvider(): string;
    get issuerUri(): string;
    get workloadPool(): string;
}
export declare class ContainerAttachedClusterWorkloadIdentityConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAttachedClusterWorkloadIdentityConfigOutputReference;
}
export interface ContainerAttachedClusterAuthorization {
    /**
    * Users that can perform operations as a cluster admin. A managed
  ClusterRoleBinding will be created to grant the 'cluster-admin' ClusterRole
  to the users. Up to ten admin users can be provided.
  
  For more info on RBAC, see
  https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#admin_users ContainerAttachedCluster#admin_users}
    */
    readonly adminUsers?: string[];
}
export declare function containerAttachedClusterAuthorizationToTerraform(struct?: ContainerAttachedClusterAuthorizationOutputReference | ContainerAttachedClusterAuthorization): any;
export declare class ContainerAttachedClusterAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAttachedClusterAuthorization | undefined;
    set internalValue(value: ContainerAttachedClusterAuthorization | undefined);
    private _adminUsers?;
    get adminUsers(): string[];
    set adminUsers(value: string[]);
    resetAdminUsers(): void;
    get adminUsersInput(): string[] | undefined;
}
export interface ContainerAttachedClusterFleet {
    /**
    * The number of the Fleet host project where this cluster will be registered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#project ContainerAttachedCluster#project}
    */
    readonly project: string;
}
export declare function containerAttachedClusterFleetToTerraform(struct?: ContainerAttachedClusterFleetOutputReference | ContainerAttachedClusterFleet): any;
export declare class ContainerAttachedClusterFleetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAttachedClusterFleet | undefined;
    set internalValue(value: ContainerAttachedClusterFleet | undefined);
    get membership(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
}
export interface ContainerAttachedClusterLoggingConfigComponentConfig {
    /**
    * The components to be enabled. Possible values: ["SYSTEM_COMPONENTS", "WORKLOADS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#enable_components ContainerAttachedCluster#enable_components}
    */
    readonly enableComponents?: string[];
}
export declare function containerAttachedClusterLoggingConfigComponentConfigToTerraform(struct?: ContainerAttachedClusterLoggingConfigComponentConfigOutputReference | ContainerAttachedClusterLoggingConfigComponentConfig): any;
export declare class ContainerAttachedClusterLoggingConfigComponentConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAttachedClusterLoggingConfigComponentConfig | undefined;
    set internalValue(value: ContainerAttachedClusterLoggingConfigComponentConfig | undefined);
    private _enableComponents?;
    get enableComponents(): string[];
    set enableComponents(value: string[]);
    resetEnableComponents(): void;
    get enableComponentsInput(): string[] | undefined;
}
export interface ContainerAttachedClusterLoggingConfig {
    /**
    * component_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#component_config ContainerAttachedCluster#component_config}
    */
    readonly componentConfig?: ContainerAttachedClusterLoggingConfigComponentConfig;
}
export declare function containerAttachedClusterLoggingConfigToTerraform(struct?: ContainerAttachedClusterLoggingConfigOutputReference | ContainerAttachedClusterLoggingConfig): any;
export declare class ContainerAttachedClusterLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAttachedClusterLoggingConfig | undefined;
    set internalValue(value: ContainerAttachedClusterLoggingConfig | undefined);
    private _componentConfig;
    get componentConfig(): ContainerAttachedClusterLoggingConfigComponentConfigOutputReference;
    putComponentConfig(value: ContainerAttachedClusterLoggingConfigComponentConfig): void;
    resetComponentConfig(): void;
    get componentConfigInput(): ContainerAttachedClusterLoggingConfigComponentConfig | undefined;
}
export interface ContainerAttachedClusterMonitoringConfigManagedPrometheusConfig {
    /**
    * Enable Managed Collection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#enabled ContainerAttachedCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function containerAttachedClusterMonitoringConfigManagedPrometheusConfigToTerraform(struct?: ContainerAttachedClusterMonitoringConfigManagedPrometheusConfigOutputReference | ContainerAttachedClusterMonitoringConfigManagedPrometheusConfig): any;
export declare class ContainerAttachedClusterMonitoringConfigManagedPrometheusConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAttachedClusterMonitoringConfigManagedPrometheusConfig | undefined;
    set internalValue(value: ContainerAttachedClusterMonitoringConfigManagedPrometheusConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerAttachedClusterMonitoringConfig {
    /**
    * managed_prometheus_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#managed_prometheus_config ContainerAttachedCluster#managed_prometheus_config}
    */
    readonly managedPrometheusConfig?: ContainerAttachedClusterMonitoringConfigManagedPrometheusConfig;
}
export declare function containerAttachedClusterMonitoringConfigToTerraform(struct?: ContainerAttachedClusterMonitoringConfigOutputReference | ContainerAttachedClusterMonitoringConfig): any;
export declare class ContainerAttachedClusterMonitoringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAttachedClusterMonitoringConfig | undefined;
    set internalValue(value: ContainerAttachedClusterMonitoringConfig | undefined);
    private _managedPrometheusConfig;
    get managedPrometheusConfig(): ContainerAttachedClusterMonitoringConfigManagedPrometheusConfigOutputReference;
    putManagedPrometheusConfig(value: ContainerAttachedClusterMonitoringConfigManagedPrometheusConfig): void;
    resetManagedPrometheusConfig(): void;
    get managedPrometheusConfigInput(): ContainerAttachedClusterMonitoringConfigManagedPrometheusConfig | undefined;
}
export interface ContainerAttachedClusterOidcConfig {
    /**
    * A JSON Web Token (JWT) issuer URI. 'issuer' must start with 'https://'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#issuer_url ContainerAttachedCluster#issuer_url}
    */
    readonly issuerUrl: string;
    /**
    * OIDC verification keys in JWKS format (RFC 7517).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#jwks ContainerAttachedCluster#jwks}
    */
    readonly jwks?: string;
}
export declare function containerAttachedClusterOidcConfigToTerraform(struct?: ContainerAttachedClusterOidcConfigOutputReference | ContainerAttachedClusterOidcConfig): any;
export declare class ContainerAttachedClusterOidcConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAttachedClusterOidcConfig | undefined;
    set internalValue(value: ContainerAttachedClusterOidcConfig | undefined);
    private _issuerUrl?;
    get issuerUrl(): string;
    set issuerUrl(value: string);
    get issuerUrlInput(): string | undefined;
    private _jwks?;
    get jwks(): string;
    set jwks(value: string);
    resetJwks(): void;
    get jwksInput(): string | undefined;
}
export interface ContainerAttachedClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#create ContainerAttachedCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#delete ContainerAttachedCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster#update ContainerAttachedCluster#update}
    */
    readonly update?: string;
}
export declare function containerAttachedClusterTimeoutsToTerraform(struct?: ContainerAttachedClusterTimeoutsOutputReference | ContainerAttachedClusterTimeouts | cdktf.IResolvable): any;
export declare class ContainerAttachedClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAttachedClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAttachedClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster google_container_attached_cluster}
*/
export declare class ContainerAttachedCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_attached_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_attached_cluster google_container_attached_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAttachedClusterConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAttachedClusterConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get clusterRegion(): string;
    get createTime(): string;
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _distribution?;
    get distribution(): string;
    set distribution(value: string);
    get distributionInput(): string | undefined;
    private _errors;
    get errors(): ContainerAttachedClusterErrorsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kubernetesVersion(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _platformVersion?;
    get platformVersion(): string;
    set platformVersion(value: string);
    get platformVersionInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _workloadIdentityConfig;
    get workloadIdentityConfig(): ContainerAttachedClusterWorkloadIdentityConfigList;
    private _authorization;
    get authorization(): ContainerAttachedClusterAuthorizationOutputReference;
    putAuthorization(value: ContainerAttachedClusterAuthorization): void;
    resetAuthorization(): void;
    get authorizationInput(): ContainerAttachedClusterAuthorization | undefined;
    private _fleet;
    get fleet(): ContainerAttachedClusterFleetOutputReference;
    putFleet(value: ContainerAttachedClusterFleet): void;
    get fleetInput(): ContainerAttachedClusterFleet | undefined;
    private _loggingConfig;
    get loggingConfig(): ContainerAttachedClusterLoggingConfigOutputReference;
    putLoggingConfig(value: ContainerAttachedClusterLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): ContainerAttachedClusterLoggingConfig | undefined;
    private _monitoringConfig;
    get monitoringConfig(): ContainerAttachedClusterMonitoringConfigOutputReference;
    putMonitoringConfig(value: ContainerAttachedClusterMonitoringConfig): void;
    resetMonitoringConfig(): void;
    get monitoringConfigInput(): ContainerAttachedClusterMonitoringConfig | undefined;
    private _oidcConfig;
    get oidcConfig(): ContainerAttachedClusterOidcConfigOutputReference;
    putOidcConfig(value: ContainerAttachedClusterOidcConfig): void;
    get oidcConfigInput(): ContainerAttachedClusterOidcConfig | undefined;
    private _timeouts;
    get timeouts(): ContainerAttachedClusterTimeoutsOutputReference;
    putTimeouts(value: ContainerAttachedClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerAttachedClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
