import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAzureClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#annotations ContainerAzureCluster#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The Azure region where the cluster runs. Each Google Cloud region supports a subset of nearby Azure regions. You can call to list all supported Azure regions within a given Google Cloud region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#azure_region ContainerAzureCluster#azure_region}
    */
    readonly azureRegion: string;
    /**
    * Name of the AzureClient. The `AzureClient` resource must reside on the same GCP project and region as the `AzureCluster`. `AzureClient` names are formatted as `projects/<project-number>/locations/<region>/azureClients/<client-id>`. See Resource Names (https:cloud.google.com/apis/design/resource_names) for more details on Google Cloud resource names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#client ContainerAzureCluster#client}
    */
    readonly client?: string;
    /**
    * Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#description ContainerAzureCluster#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#id ContainerAzureCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#location ContainerAzureCluster#location}
    */
    readonly location: string;
    /**
    * The name of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#name ContainerAzureCluster#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#project ContainerAzureCluster#project}
    */
    readonly project?: string;
    /**
    * The ARM ID of the resource group where the cluster resources are deployed. For example: `/subscriptions/*\/resourceGroups/*`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#resource_group_id ContainerAzureCluster#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#authorization ContainerAzureCluster#authorization}
    */
    readonly authorization: ContainerAzureClusterAuthorization;
    /**
    * azure_services_authentication block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#azure_services_authentication ContainerAzureCluster#azure_services_authentication}
    */
    readonly azureServicesAuthentication?: ContainerAzureClusterAzureServicesAuthentication;
    /**
    * control_plane block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#control_plane ContainerAzureCluster#control_plane}
    */
    readonly controlPlane: ContainerAzureClusterControlPlane;
    /**
    * fleet block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#fleet ContainerAzureCluster#fleet}
    */
    readonly fleet: ContainerAzureClusterFleet;
    /**
    * networking block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#networking ContainerAzureCluster#networking}
    */
    readonly networking: ContainerAzureClusterNetworking;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#timeouts ContainerAzureCluster#timeouts}
    */
    readonly timeouts?: ContainerAzureClusterTimeouts;
}
export interface ContainerAzureClusterWorkloadIdentityConfig {
}
export declare function containerAzureClusterWorkloadIdentityConfigToTerraform(struct?: ContainerAzureClusterWorkloadIdentityConfig): any;
export declare class ContainerAzureClusterWorkloadIdentityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAzureClusterWorkloadIdentityConfig | undefined;
    set internalValue(value: ContainerAzureClusterWorkloadIdentityConfig | undefined);
    get identityProvider(): string;
    get issuerUri(): string;
    get workloadPool(): string;
}
export declare class ContainerAzureClusterWorkloadIdentityConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAzureClusterWorkloadIdentityConfigOutputReference;
}
export interface ContainerAzureClusterAuthorizationAdminUsers {
    /**
    * The name of the user, e.g. `my-gcp-id@gmail.com`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#username ContainerAzureCluster#username}
    */
    readonly username: string;
}
export declare function containerAzureClusterAuthorizationAdminUsersToTerraform(struct?: ContainerAzureClusterAuthorizationAdminUsers | cdktf.IResolvable): any;
export declare class ContainerAzureClusterAuthorizationAdminUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAzureClusterAuthorizationAdminUsers | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAzureClusterAuthorizationAdminUsers | cdktf.IResolvable | undefined);
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export declare class ContainerAzureClusterAuthorizationAdminUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAzureClusterAuthorizationAdminUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAzureClusterAuthorizationAdminUsersOutputReference;
}
export interface ContainerAzureClusterAuthorization {
    /**
    * admin_users block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#admin_users ContainerAzureCluster#admin_users}
    */
    readonly adminUsers: ContainerAzureClusterAuthorizationAdminUsers[] | cdktf.IResolvable;
}
export declare function containerAzureClusterAuthorizationToTerraform(struct?: ContainerAzureClusterAuthorizationOutputReference | ContainerAzureClusterAuthorization): any;
export declare class ContainerAzureClusterAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureClusterAuthorization | undefined;
    set internalValue(value: ContainerAzureClusterAuthorization | undefined);
    private _adminUsers;
    get adminUsers(): ContainerAzureClusterAuthorizationAdminUsersList;
    putAdminUsers(value: ContainerAzureClusterAuthorizationAdminUsers[] | cdktf.IResolvable): void;
    get adminUsersInput(): cdktf.IResolvable | ContainerAzureClusterAuthorizationAdminUsers[] | undefined;
}
export interface ContainerAzureClusterAzureServicesAuthentication {
    /**
    * The Azure Active Directory Application ID for Authentication configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#application_id ContainerAzureCluster#application_id}
    */
    readonly applicationId: string;
    /**
    * The Azure Active Directory Tenant ID for Authentication configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#tenant_id ContainerAzureCluster#tenant_id}
    */
    readonly tenantId: string;
}
export declare function containerAzureClusterAzureServicesAuthenticationToTerraform(struct?: ContainerAzureClusterAzureServicesAuthenticationOutputReference | ContainerAzureClusterAzureServicesAuthentication): any;
export declare class ContainerAzureClusterAzureServicesAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureClusterAzureServicesAuthentication | undefined;
    set internalValue(value: ContainerAzureClusterAzureServicesAuthentication | undefined);
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    get applicationIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
}
export interface ContainerAzureClusterControlPlaneDatabaseEncryption {
    /**
    * The ARM ID of the Azure Key Vault key to encrypt / decrypt data. For example: `/subscriptions/<subscription-id>/resourceGroups/<resource-group-id>/providers/Microsoft.KeyVault/vaults/<key-vault-id>/keys/<key-name>` Encryption will always take the latest version of the key and hence specific version is not supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#key_id ContainerAzureCluster#key_id}
    */
    readonly keyId: string;
}
export declare function containerAzureClusterControlPlaneDatabaseEncryptionToTerraform(struct?: ContainerAzureClusterControlPlaneDatabaseEncryptionOutputReference | ContainerAzureClusterControlPlaneDatabaseEncryption): any;
export declare class ContainerAzureClusterControlPlaneDatabaseEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureClusterControlPlaneDatabaseEncryption | undefined;
    set internalValue(value: ContainerAzureClusterControlPlaneDatabaseEncryption | undefined);
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    get keyIdInput(): string | undefined;
}
export interface ContainerAzureClusterControlPlaneMainVolume {
    /**
    * Optional. The size of the disk, in GiBs. When unspecified, a default value is provided. See the specific reference in the parent resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#size_gib ContainerAzureCluster#size_gib}
    */
    readonly sizeGib?: number;
}
export declare function containerAzureClusterControlPlaneMainVolumeToTerraform(struct?: ContainerAzureClusterControlPlaneMainVolumeOutputReference | ContainerAzureClusterControlPlaneMainVolume): any;
export declare class ContainerAzureClusterControlPlaneMainVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureClusterControlPlaneMainVolume | undefined;
    set internalValue(value: ContainerAzureClusterControlPlaneMainVolume | undefined);
    private _sizeGib?;
    get sizeGib(): number;
    set sizeGib(value: number);
    resetSizeGib(): void;
    get sizeGibInput(): number | undefined;
}
export interface ContainerAzureClusterControlPlaneProxyConfig {
    /**
    * The ARM ID the of the resource group containing proxy keyvault. Resource group ids are formatted as `/subscriptions/<subscription-id>/resourceGroups/<resource-group-name>`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#resource_group_id ContainerAzureCluster#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * The URL the of the proxy setting secret with its version. Secret ids are formatted as `https:<key-vault-name>.vault.azure.net/secrets/<secret-name>/<secret-version>`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#secret_id ContainerAzureCluster#secret_id}
    */
    readonly secretId: string;
}
export declare function containerAzureClusterControlPlaneProxyConfigToTerraform(struct?: ContainerAzureClusterControlPlaneProxyConfigOutputReference | ContainerAzureClusterControlPlaneProxyConfig): any;
export declare class ContainerAzureClusterControlPlaneProxyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureClusterControlPlaneProxyConfig | undefined;
    set internalValue(value: ContainerAzureClusterControlPlaneProxyConfig | undefined);
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
}
export interface ContainerAzureClusterControlPlaneReplicaPlacements {
    /**
    * For a given replica, the Azure availability zone where to provision the control plane VM and the ETCD disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#azure_availability_zone ContainerAzureCluster#azure_availability_zone}
    */
    readonly azureAvailabilityZone: string;
    /**
    * For a given replica, the ARM ID of the subnet where the control plane VM is deployed. Make sure it's a subnet under the virtual network in the cluster configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#subnet_id ContainerAzureCluster#subnet_id}
    */
    readonly subnetId: string;
}
export declare function containerAzureClusterControlPlaneReplicaPlacementsToTerraform(struct?: ContainerAzureClusterControlPlaneReplicaPlacements | cdktf.IResolvable): any;
export declare class ContainerAzureClusterControlPlaneReplicaPlacementsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAzureClusterControlPlaneReplicaPlacements | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAzureClusterControlPlaneReplicaPlacements | cdktf.IResolvable | undefined);
    private _azureAvailabilityZone?;
    get azureAvailabilityZone(): string;
    set azureAvailabilityZone(value: string);
    get azureAvailabilityZoneInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class ContainerAzureClusterControlPlaneReplicaPlacementsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAzureClusterControlPlaneReplicaPlacements[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAzureClusterControlPlaneReplicaPlacementsOutputReference;
}
export interface ContainerAzureClusterControlPlaneRootVolume {
    /**
    * Optional. The size of the disk, in GiBs. When unspecified, a default value is provided. See the specific reference in the parent resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#size_gib ContainerAzureCluster#size_gib}
    */
    readonly sizeGib?: number;
}
export declare function containerAzureClusterControlPlaneRootVolumeToTerraform(struct?: ContainerAzureClusterControlPlaneRootVolumeOutputReference | ContainerAzureClusterControlPlaneRootVolume): any;
export declare class ContainerAzureClusterControlPlaneRootVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureClusterControlPlaneRootVolume | undefined;
    set internalValue(value: ContainerAzureClusterControlPlaneRootVolume | undefined);
    private _sizeGib?;
    get sizeGib(): number;
    set sizeGib(value: number);
    resetSizeGib(): void;
    get sizeGibInput(): number | undefined;
}
export interface ContainerAzureClusterControlPlaneSshConfig {
    /**
    * The SSH public key data for VMs managed by Anthos. This accepts the authorized_keys file format used in OpenSSH according to the sshd(8) manual page.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#authorized_key ContainerAzureCluster#authorized_key}
    */
    readonly authorizedKey: string;
}
export declare function containerAzureClusterControlPlaneSshConfigToTerraform(struct?: ContainerAzureClusterControlPlaneSshConfigOutputReference | ContainerAzureClusterControlPlaneSshConfig): any;
export declare class ContainerAzureClusterControlPlaneSshConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureClusterControlPlaneSshConfig | undefined;
    set internalValue(value: ContainerAzureClusterControlPlaneSshConfig | undefined);
    private _authorizedKey?;
    get authorizedKey(): string;
    set authorizedKey(value: string);
    get authorizedKeyInput(): string | undefined;
}
export interface ContainerAzureClusterControlPlane {
    /**
    * The ARM ID of the subnet where the control plane VMs are deployed. Example: `/subscriptions//resourceGroups//providers/Microsoft.Network/virtualNetworks//subnets/default`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#subnet_id ContainerAzureCluster#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Optional. A set of tags to apply to all underlying control plane Azure resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#tags ContainerAzureCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * The Kubernetes version to run on control plane replicas (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling GetAzureServerConfig.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#version ContainerAzureCluster#version}
    */
    readonly version: string;
    /**
    * Optional. The Azure VM size name. Example: `Standard_DS2_v2`. For available VM sizes, see https://docs.microsoft.com/en-us/azure/virtual-machines/vm-naming-conventions. When unspecified, it defaults to `Standard_DS2_v2`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#vm_size ContainerAzureCluster#vm_size}
    */
    readonly vmSize?: string;
    /**
    * database_encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#database_encryption ContainerAzureCluster#database_encryption}
    */
    readonly databaseEncryption?: ContainerAzureClusterControlPlaneDatabaseEncryption;
    /**
    * main_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#main_volume ContainerAzureCluster#main_volume}
    */
    readonly mainVolume?: ContainerAzureClusterControlPlaneMainVolume;
    /**
    * proxy_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#proxy_config ContainerAzureCluster#proxy_config}
    */
    readonly proxyConfig?: ContainerAzureClusterControlPlaneProxyConfig;
    /**
    * replica_placements block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#replica_placements ContainerAzureCluster#replica_placements}
    */
    readonly replicaPlacements?: ContainerAzureClusterControlPlaneReplicaPlacements[] | cdktf.IResolvable;
    /**
    * root_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#root_volume ContainerAzureCluster#root_volume}
    */
    readonly rootVolume?: ContainerAzureClusterControlPlaneRootVolume;
    /**
    * ssh_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#ssh_config ContainerAzureCluster#ssh_config}
    */
    readonly sshConfig: ContainerAzureClusterControlPlaneSshConfig;
}
export declare function containerAzureClusterControlPlaneToTerraform(struct?: ContainerAzureClusterControlPlaneOutputReference | ContainerAzureClusterControlPlane): any;
export declare class ContainerAzureClusterControlPlaneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureClusterControlPlane | undefined;
    set internalValue(value: ContainerAzureClusterControlPlane | undefined);
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    resetVmSize(): void;
    get vmSizeInput(): string | undefined;
    private _databaseEncryption;
    get databaseEncryption(): ContainerAzureClusterControlPlaneDatabaseEncryptionOutputReference;
    putDatabaseEncryption(value: ContainerAzureClusterControlPlaneDatabaseEncryption): void;
    resetDatabaseEncryption(): void;
    get databaseEncryptionInput(): ContainerAzureClusterControlPlaneDatabaseEncryption | undefined;
    private _mainVolume;
    get mainVolume(): ContainerAzureClusterControlPlaneMainVolumeOutputReference;
    putMainVolume(value: ContainerAzureClusterControlPlaneMainVolume): void;
    resetMainVolume(): void;
    get mainVolumeInput(): ContainerAzureClusterControlPlaneMainVolume | undefined;
    private _proxyConfig;
    get proxyConfig(): ContainerAzureClusterControlPlaneProxyConfigOutputReference;
    putProxyConfig(value: ContainerAzureClusterControlPlaneProxyConfig): void;
    resetProxyConfig(): void;
    get proxyConfigInput(): ContainerAzureClusterControlPlaneProxyConfig | undefined;
    private _replicaPlacements;
    get replicaPlacements(): ContainerAzureClusterControlPlaneReplicaPlacementsList;
    putReplicaPlacements(value: ContainerAzureClusterControlPlaneReplicaPlacements[] | cdktf.IResolvable): void;
    resetReplicaPlacements(): void;
    get replicaPlacementsInput(): cdktf.IResolvable | ContainerAzureClusterControlPlaneReplicaPlacements[] | undefined;
    private _rootVolume;
    get rootVolume(): ContainerAzureClusterControlPlaneRootVolumeOutputReference;
    putRootVolume(value: ContainerAzureClusterControlPlaneRootVolume): void;
    resetRootVolume(): void;
    get rootVolumeInput(): ContainerAzureClusterControlPlaneRootVolume | undefined;
    private _sshConfig;
    get sshConfig(): ContainerAzureClusterControlPlaneSshConfigOutputReference;
    putSshConfig(value: ContainerAzureClusterControlPlaneSshConfig): void;
    get sshConfigInput(): ContainerAzureClusterControlPlaneSshConfig | undefined;
}
export interface ContainerAzureClusterFleet {
    /**
    * The number of the Fleet host project where this cluster will be registered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#project ContainerAzureCluster#project}
    */
    readonly project?: string;
}
export declare function containerAzureClusterFleetToTerraform(struct?: ContainerAzureClusterFleetOutputReference | ContainerAzureClusterFleet): any;
export declare class ContainerAzureClusterFleetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureClusterFleet | undefined;
    set internalValue(value: ContainerAzureClusterFleet | undefined);
    get membership(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
}
export interface ContainerAzureClusterNetworking {
    /**
    * The IP address range of the pods in this cluster, in CIDR notation (e.g. `10.96.0.0/14`). All pods in the cluster get assigned a unique RFC1918 IPv4 address from these ranges. Only a single range is supported. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#pod_address_cidr_blocks ContainerAzureCluster#pod_address_cidr_blocks}
    */
    readonly podAddressCidrBlocks: string[];
    /**
    * The IP address range for services in this cluster, in CIDR notation (e.g. `10.96.0.0/14`). All services in the cluster get assigned a unique RFC1918 IPv4 address from these ranges. Only a single range is supported. This field cannot be changed after creating a cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#service_address_cidr_blocks ContainerAzureCluster#service_address_cidr_blocks}
    */
    readonly serviceAddressCidrBlocks: string[];
    /**
    * The Azure Resource Manager (ARM) ID of the VNet associated with your cluster. All components in the cluster (i.e. control plane and node pools) run on a single VNet. Example: `/subscriptions/*\/resourceGroups/*\/providers/Microsoft.Network/virtualNetworks/*` This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#virtual_network_id ContainerAzureCluster#virtual_network_id}
    */
    readonly virtualNetworkId: string;
}
export declare function containerAzureClusterNetworkingToTerraform(struct?: ContainerAzureClusterNetworkingOutputReference | ContainerAzureClusterNetworking): any;
export declare class ContainerAzureClusterNetworkingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureClusterNetworking | undefined;
    set internalValue(value: ContainerAzureClusterNetworking | undefined);
    private _podAddressCidrBlocks?;
    get podAddressCidrBlocks(): string[];
    set podAddressCidrBlocks(value: string[]);
    get podAddressCidrBlocksInput(): string[] | undefined;
    private _serviceAddressCidrBlocks?;
    get serviceAddressCidrBlocks(): string[];
    set serviceAddressCidrBlocks(value: string[]);
    get serviceAddressCidrBlocksInput(): string[] | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    get virtualNetworkIdInput(): string | undefined;
}
export interface ContainerAzureClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#create ContainerAzureCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#delete ContainerAzureCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster#update ContainerAzureCluster#update}
    */
    readonly update?: string;
}
export declare function containerAzureClusterTimeoutsToTerraform(struct?: ContainerAzureClusterTimeoutsOutputReference | ContainerAzureClusterTimeouts | cdktf.IResolvable): any;
export declare class ContainerAzureClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAzureClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster google_container_azure_cluster}
*/
export declare class ContainerAzureCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_azure_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_azure_cluster google_container_azure_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAzureClusterConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAzureClusterConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _azureRegion?;
    get azureRegion(): string;
    set azureRegion(value: string);
    get azureRegionInput(): string | undefined;
    private _client?;
    get client(): string;
    set client(value: string);
    resetClient(): void;
    get clientInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get endpoint(): string;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _workloadIdentityConfig;
    get workloadIdentityConfig(): ContainerAzureClusterWorkloadIdentityConfigList;
    private _authorization;
    get authorization(): ContainerAzureClusterAuthorizationOutputReference;
    putAuthorization(value: ContainerAzureClusterAuthorization): void;
    get authorizationInput(): ContainerAzureClusterAuthorization | undefined;
    private _azureServicesAuthentication;
    get azureServicesAuthentication(): ContainerAzureClusterAzureServicesAuthenticationOutputReference;
    putAzureServicesAuthentication(value: ContainerAzureClusterAzureServicesAuthentication): void;
    resetAzureServicesAuthentication(): void;
    get azureServicesAuthenticationInput(): ContainerAzureClusterAzureServicesAuthentication | undefined;
    private _controlPlane;
    get controlPlane(): ContainerAzureClusterControlPlaneOutputReference;
    putControlPlane(value: ContainerAzureClusterControlPlane): void;
    get controlPlaneInput(): ContainerAzureClusterControlPlane | undefined;
    private _fleet;
    get fleet(): ContainerAzureClusterFleetOutputReference;
    putFleet(value: ContainerAzureClusterFleet): void;
    get fleetInput(): ContainerAzureClusterFleet | undefined;
    private _networking;
    get networking(): ContainerAzureClusterNetworkingOutputReference;
    putNetworking(value: ContainerAzureClusterNetworking): void;
    get networkingInput(): ContainerAzureClusterNetworking | undefined;
    private _timeouts;
    get timeouts(): ContainerAzureClusterTimeoutsOutputReference;
    putTimeouts(value: ContainerAzureClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerAzureClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
