import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogPolicyTagIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag_iam_member#id DataCatalogPolicyTagIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag_iam_member#member DataCatalogPolicyTagIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag_iam_member#policy_tag DataCatalogPolicyTagIamMember#policy_tag}
    */
    readonly policyTag: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag_iam_member#role DataCatalogPolicyTagIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag_iam_member#condition DataCatalogPolicyTagIamMember#condition}
    */
    readonly condition?: DataCatalogPolicyTagIamMemberCondition;
}
export interface DataCatalogPolicyTagIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag_iam_member#description DataCatalogPolicyTagIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag_iam_member#expression DataCatalogPolicyTagIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag_iam_member#title DataCatalogPolicyTagIamMember#title}
    */
    readonly title: string;
}
export declare function dataCatalogPolicyTagIamMemberConditionToTerraform(struct?: DataCatalogPolicyTagIamMemberConditionOutputReference | DataCatalogPolicyTagIamMemberCondition): any;
export declare class DataCatalogPolicyTagIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataCatalogPolicyTagIamMemberCondition | undefined;
    set internalValue(value: DataCatalogPolicyTagIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag_iam_member google_data_catalog_policy_tag_iam_member}
*/
export declare class DataCatalogPolicyTagIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_policy_tag_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag_iam_member google_data_catalog_policy_tag_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataCatalogPolicyTagIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: DataCatalogPolicyTagIamMemberConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _policyTag?;
    get policyTag(): string;
    set policyTag(value: string);
    get policyTagInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): DataCatalogPolicyTagIamMemberConditionOutputReference;
    putCondition(value: DataCatalogPolicyTagIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): DataCatalogPolicyTagIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
