import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogPolicyTagConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of this policy tag. It must: contain only unicode characters, tabs,
  newlines, carriage returns and page breaks; and be at most 2000 bytes long when
  encoded in UTF-8. If not set, defaults to an empty description.
  If not set, defaults to an empty description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag#description DataCatalogPolicyTag#description}
    */
    readonly description?: string;
    /**
    * User defined name of this policy tag. It must: be unique within the parent
  taxonomy; contain only unicode letters, numbers, underscores, dashes and spaces;
  not start or end with spaces; and be at most 200 bytes long when encoded in UTF-8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag#display_name DataCatalogPolicyTag#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag#id DataCatalogPolicyTag#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource name of this policy tag's parent policy tag.
  If empty, it means this policy tag is a top level policy tag.
  If not set, defaults to an empty string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag#parent_policy_tag DataCatalogPolicyTag#parent_policy_tag}
    */
    readonly parentPolicyTag?: string;
    /**
    * Taxonomy the policy tag is associated with
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag#taxonomy DataCatalogPolicyTag#taxonomy}
    */
    readonly taxonomy: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag#timeouts DataCatalogPolicyTag#timeouts}
    */
    readonly timeouts?: DataCatalogPolicyTagTimeouts;
}
export interface DataCatalogPolicyTagTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag#create DataCatalogPolicyTag#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag#delete DataCatalogPolicyTag#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag#update DataCatalogPolicyTag#update}
    */
    readonly update?: string;
}
export declare function dataCatalogPolicyTagTimeoutsToTerraform(struct?: DataCatalogPolicyTagTimeoutsOutputReference | DataCatalogPolicyTagTimeouts | cdktf.IResolvable): any;
export declare class DataCatalogPolicyTagTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataCatalogPolicyTagTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataCatalogPolicyTagTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag google_data_catalog_policy_tag}
*/
export declare class DataCatalogPolicyTag extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_policy_tag";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_policy_tag google_data_catalog_policy_tag} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataCatalogPolicyTagConfig
    */
    constructor(scope: Construct, id: string, config: DataCatalogPolicyTagConfig);
    get childPolicyTags(): string[];
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _parentPolicyTag?;
    get parentPolicyTag(): string;
    set parentPolicyTag(value: string);
    resetParentPolicyTag(): void;
    get parentPolicyTagInput(): string | undefined;
    private _taxonomy?;
    get taxonomy(): string;
    set taxonomy(value: string);
    get taxonomyInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataCatalogPolicyTagTimeoutsOutputReference;
    putTimeouts(value: DataCatalogPolicyTagTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataCatalogPolicyTagTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
