import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogTagTemplateIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_binding#id DataCatalogTagTemplateIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_binding#members DataCatalogTagTemplateIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_binding#project DataCatalogTagTemplateIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_binding#region DataCatalogTagTemplateIamBinding#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_binding#role DataCatalogTagTemplateIamBinding#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_binding#tag_template DataCatalogTagTemplateIamBinding#tag_template}
    */
    readonly tagTemplate: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_binding#condition DataCatalogTagTemplateIamBinding#condition}
    */
    readonly condition?: DataCatalogTagTemplateIamBindingCondition;
}
export interface DataCatalogTagTemplateIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_binding#description DataCatalogTagTemplateIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_binding#expression DataCatalogTagTemplateIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_binding#title DataCatalogTagTemplateIamBinding#title}
    */
    readonly title: string;
}
export declare function dataCatalogTagTemplateIamBindingConditionToTerraform(struct?: DataCatalogTagTemplateIamBindingConditionOutputReference | DataCatalogTagTemplateIamBindingCondition): any;
export declare class DataCatalogTagTemplateIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataCatalogTagTemplateIamBindingCondition | undefined;
    set internalValue(value: DataCatalogTagTemplateIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_binding google_data_catalog_tag_template_iam_binding}
*/
export declare class DataCatalogTagTemplateIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_tag_template_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_binding google_data_catalog_tag_template_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataCatalogTagTemplateIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: DataCatalogTagTemplateIamBindingConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _tagTemplate?;
    get tagTemplate(): string;
    set tagTemplate(value: string);
    get tagTemplateInput(): string | undefined;
    private _condition;
    get condition(): DataCatalogTagTemplateIamBindingConditionOutputReference;
    putCondition(value: DataCatalogTagTemplateIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): DataCatalogTagTemplateIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
