import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogTaxonomyIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_taxonomy_iam_member#id DataCatalogTaxonomyIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_taxonomy_iam_member#member DataCatalogTaxonomyIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_taxonomy_iam_member#project DataCatalogTaxonomyIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_taxonomy_iam_member#region DataCatalogTaxonomyIamMember#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_taxonomy_iam_member#role DataCatalogTaxonomyIamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_taxonomy_iam_member#taxonomy DataCatalogTaxonomyIamMember#taxonomy}
    */
    readonly taxonomy: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_taxonomy_iam_member#condition DataCatalogTaxonomyIamMember#condition}
    */
    readonly condition?: DataCatalogTaxonomyIamMemberCondition;
}
export interface DataCatalogTaxonomyIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_taxonomy_iam_member#description DataCatalogTaxonomyIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_taxonomy_iam_member#expression DataCatalogTaxonomyIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_taxonomy_iam_member#title DataCatalogTaxonomyIamMember#title}
    */
    readonly title: string;
}
export declare function dataCatalogTaxonomyIamMemberConditionToTerraform(struct?: DataCatalogTaxonomyIamMemberConditionOutputReference | DataCatalogTaxonomyIamMemberCondition): any;
export declare class DataCatalogTaxonomyIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataCatalogTaxonomyIamMemberCondition | undefined;
    set internalValue(value: DataCatalogTaxonomyIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_taxonomy_iam_member google_data_catalog_taxonomy_iam_member}
*/
export declare class DataCatalogTaxonomyIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_taxonomy_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_taxonomy_iam_member google_data_catalog_taxonomy_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataCatalogTaxonomyIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: DataCatalogTaxonomyIamMemberConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _taxonomy?;
    get taxonomy(): string;
    set taxonomy(value: string);
    get taxonomyInput(): string | undefined;
    private _condition;
    get condition(): DataCatalogTaxonomyIamMemberConditionOutputReference;
    putCondition(value: DataCatalogTaxonomyIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): DataCatalogTaxonomyIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
