import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleBeyondcorpAppConnectorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/beyondcorp_app_connector#id DataGoogleBeyondcorpAppConnector#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the AppConnector.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/beyondcorp_app_connector#name DataGoogleBeyondcorpAppConnector#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/beyondcorp_app_connector#project DataGoogleBeyondcorpAppConnector#project}
    */
    readonly project?: string;
    /**
    * The region of the AppConnector.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/beyondcorp_app_connector#region DataGoogleBeyondcorpAppConnector#region}
    */
    readonly region?: string;
}
export interface DataGoogleBeyondcorpAppConnectorPrincipalInfoServiceAccount {
}
export declare function dataGoogleBeyondcorpAppConnectorPrincipalInfoServiceAccountToTerraform(struct?: DataGoogleBeyondcorpAppConnectorPrincipalInfoServiceAccount): any;
export declare class DataGoogleBeyondcorpAppConnectorPrincipalInfoServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBeyondcorpAppConnectorPrincipalInfoServiceAccount | undefined;
    set internalValue(value: DataGoogleBeyondcorpAppConnectorPrincipalInfoServiceAccount | undefined);
    get email(): string;
}
export declare class DataGoogleBeyondcorpAppConnectorPrincipalInfoServiceAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBeyondcorpAppConnectorPrincipalInfoServiceAccountOutputReference;
}
export interface DataGoogleBeyondcorpAppConnectorPrincipalInfo {
}
export declare function dataGoogleBeyondcorpAppConnectorPrincipalInfoToTerraform(struct?: DataGoogleBeyondcorpAppConnectorPrincipalInfo): any;
export declare class DataGoogleBeyondcorpAppConnectorPrincipalInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBeyondcorpAppConnectorPrincipalInfo | undefined;
    set internalValue(value: DataGoogleBeyondcorpAppConnectorPrincipalInfo | undefined);
    private _serviceAccount;
    get serviceAccount(): DataGoogleBeyondcorpAppConnectorPrincipalInfoServiceAccountList;
}
export declare class DataGoogleBeyondcorpAppConnectorPrincipalInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBeyondcorpAppConnectorPrincipalInfoOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/beyondcorp_app_connector google_beyondcorp_app_connector}
*/
export declare class DataGoogleBeyondcorpAppConnector extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_beyondcorp_app_connector";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/beyondcorp_app_connector google_beyondcorp_app_connector} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleBeyondcorpAppConnectorConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleBeyondcorpAppConnectorConfig);
    get displayName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _principalInfo;
    get principalInfo(): DataGoogleBeyondcorpAppConnectorPrincipalInfoList;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get state(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
