import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudbuildTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudbuild_trigger#id DataGoogleCloudbuildTrigger#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The [Cloud Build location](https://cloud.google.com/build/docs/locations) for the trigger.
  If not specified, "global" is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudbuild_trigger#location DataGoogleCloudbuildTrigger#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudbuild_trigger#project DataGoogleCloudbuildTrigger#project}
    */
    readonly project?: string;
    /**
    * The unique identifier for the trigger.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloudbuild_trigger#trigger_id DataGoogleCloudbuildTrigger#trigger_id}
    */
    readonly triggerId: string;
}
export interface DataGoogleCloudbuildTriggerApprovalConfig {
}
export declare function dataGoogleCloudbuildTriggerApprovalConfigToTerraform(struct?: DataGoogleCloudbuildTriggerApprovalConfig): any;
export declare class DataGoogleCloudbuildTriggerApprovalConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerApprovalConfig | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerApprovalConfig | undefined);
    get approvalRequired(): cdktf.IResolvable;
}
export declare class DataGoogleCloudbuildTriggerApprovalConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerApprovalConfigOutputReference;
}
export interface DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPullRequest {
}
export declare function dataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPullRequestToTerraform(struct?: DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPullRequest): any;
export declare class DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPullRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPullRequest | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPullRequest | undefined);
    get branch(): string;
    get commentControl(): string;
    get invertRegex(): cdktf.IResolvable;
}
export declare class DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPullRequestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPullRequestOutputReference;
}
export interface DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPush {
}
export declare function dataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPushToTerraform(struct?: DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPush): any;
export declare class DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPushOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPush | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPush | undefined);
    get branch(): string;
    get invertRegex(): cdktf.IResolvable;
    get tag(): string;
}
export declare class DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPushList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPushOutputReference;
}
export interface DataGoogleCloudbuildTriggerBitbucketServerTriggerConfig {
}
export declare function dataGoogleCloudbuildTriggerBitbucketServerTriggerConfigToTerraform(struct?: DataGoogleCloudbuildTriggerBitbucketServerTriggerConfig): any;
export declare class DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBitbucketServerTriggerConfig | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBitbucketServerTriggerConfig | undefined);
    get bitbucketServerConfigResource(): string;
    get projectKey(): string;
    private _pullRequest;
    get pullRequest(): DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPullRequestList;
    private _push;
    get push(): DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigPushList;
    get repoSlug(): string;
}
export declare class DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildArtifactsObjectsTiming {
}
export declare function dataGoogleCloudbuildTriggerBuildArtifactsObjectsTimingToTerraform(struct?: DataGoogleCloudbuildTriggerBuildArtifactsObjectsTiming): any;
export declare class DataGoogleCloudbuildTriggerBuildArtifactsObjectsTimingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildArtifactsObjectsTiming | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildArtifactsObjectsTiming | undefined);
    get endTime(): string;
    get startTime(): string;
}
export declare class DataGoogleCloudbuildTriggerBuildArtifactsObjectsTimingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildArtifactsObjectsTimingOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildArtifactsObjects {
}
export declare function dataGoogleCloudbuildTriggerBuildArtifactsObjectsToTerraform(struct?: DataGoogleCloudbuildTriggerBuildArtifactsObjects): any;
export declare class DataGoogleCloudbuildTriggerBuildArtifactsObjectsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildArtifactsObjects | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildArtifactsObjects | undefined);
    get location(): string;
    get paths(): string[];
    private _timing;
    get timing(): DataGoogleCloudbuildTriggerBuildArtifactsObjectsTimingList;
}
export declare class DataGoogleCloudbuildTriggerBuildArtifactsObjectsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildArtifactsObjectsOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildArtifacts {
}
export declare function dataGoogleCloudbuildTriggerBuildArtifactsToTerraform(struct?: DataGoogleCloudbuildTriggerBuildArtifacts): any;
export declare class DataGoogleCloudbuildTriggerBuildArtifactsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildArtifacts | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildArtifacts | undefined);
    get images(): string[];
    private _objects;
    get objects(): DataGoogleCloudbuildTriggerBuildArtifactsObjectsList;
}
export declare class DataGoogleCloudbuildTriggerBuildArtifactsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildArtifactsOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildAvailableSecretsSecretManager {
}
export declare function dataGoogleCloudbuildTriggerBuildAvailableSecretsSecretManagerToTerraform(struct?: DataGoogleCloudbuildTriggerBuildAvailableSecretsSecretManager): any;
export declare class DataGoogleCloudbuildTriggerBuildAvailableSecretsSecretManagerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildAvailableSecretsSecretManager | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildAvailableSecretsSecretManager | undefined);
    get env(): string;
    get versionName(): string;
}
export declare class DataGoogleCloudbuildTriggerBuildAvailableSecretsSecretManagerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildAvailableSecretsSecretManagerOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildAvailableSecrets {
}
export declare function dataGoogleCloudbuildTriggerBuildAvailableSecretsToTerraform(struct?: DataGoogleCloudbuildTriggerBuildAvailableSecrets): any;
export declare class DataGoogleCloudbuildTriggerBuildAvailableSecretsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildAvailableSecrets | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildAvailableSecrets | undefined);
    private _secretManager;
    get secretManager(): DataGoogleCloudbuildTriggerBuildAvailableSecretsSecretManagerList;
}
export declare class DataGoogleCloudbuildTriggerBuildAvailableSecretsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildAvailableSecretsOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildOptionsVolumes {
}
export declare function dataGoogleCloudbuildTriggerBuildOptionsVolumesToTerraform(struct?: DataGoogleCloudbuildTriggerBuildOptionsVolumes): any;
export declare class DataGoogleCloudbuildTriggerBuildOptionsVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildOptionsVolumes | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildOptionsVolumes | undefined);
    get name(): string;
    get path(): string;
}
export declare class DataGoogleCloudbuildTriggerBuildOptionsVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildOptionsVolumesOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildOptions {
}
export declare function dataGoogleCloudbuildTriggerBuildOptionsToTerraform(struct?: DataGoogleCloudbuildTriggerBuildOptions): any;
export declare class DataGoogleCloudbuildTriggerBuildOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildOptions | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildOptions | undefined);
    get diskSizeGb(): number;
    get dynamicSubstitutions(): cdktf.IResolvable;
    get env(): string[];
    get logStreamingOption(): string;
    get logging(): string;
    get machineType(): string;
    get requestedVerifyOption(): string;
    get secretEnv(): string[];
    get sourceProvenanceHash(): string[];
    get substitutionOption(): string;
    private _volumes;
    get volumes(): DataGoogleCloudbuildTriggerBuildOptionsVolumesList;
    get workerPool(): string;
}
export declare class DataGoogleCloudbuildTriggerBuildOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildOptionsOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildSecret {
}
export declare function dataGoogleCloudbuildTriggerBuildSecretToTerraform(struct?: DataGoogleCloudbuildTriggerBuildSecret): any;
export declare class DataGoogleCloudbuildTriggerBuildSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildSecret | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildSecret | undefined);
    get kmsKeyName(): string;
    private _secretEnv;
    get secretEnv(): cdktf.StringMap;
}
export declare class DataGoogleCloudbuildTriggerBuildSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildSecretOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildSourceRepoSource {
}
export declare function dataGoogleCloudbuildTriggerBuildSourceRepoSourceToTerraform(struct?: DataGoogleCloudbuildTriggerBuildSourceRepoSource): any;
export declare class DataGoogleCloudbuildTriggerBuildSourceRepoSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildSourceRepoSource | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildSourceRepoSource | undefined);
    get branchName(): string;
    get commitSha(): string;
    get dir(): string;
    get invertRegex(): cdktf.IResolvable;
    get projectId(): string;
    get repoName(): string;
    private _substitutions;
    get substitutions(): cdktf.StringMap;
    get tagName(): string;
}
export declare class DataGoogleCloudbuildTriggerBuildSourceRepoSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildSourceRepoSourceOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildSourceStorageSource {
}
export declare function dataGoogleCloudbuildTriggerBuildSourceStorageSourceToTerraform(struct?: DataGoogleCloudbuildTriggerBuildSourceStorageSource): any;
export declare class DataGoogleCloudbuildTriggerBuildSourceStorageSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildSourceStorageSource | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildSourceStorageSource | undefined);
    get bucket(): string;
    get generation(): string;
    get object(): string;
}
export declare class DataGoogleCloudbuildTriggerBuildSourceStorageSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildSourceStorageSourceOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildSource {
}
export declare function dataGoogleCloudbuildTriggerBuildSourceToTerraform(struct?: DataGoogleCloudbuildTriggerBuildSource): any;
export declare class DataGoogleCloudbuildTriggerBuildSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildSource | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildSource | undefined);
    private _repoSource;
    get repoSource(): DataGoogleCloudbuildTriggerBuildSourceRepoSourceList;
    private _storageSource;
    get storageSource(): DataGoogleCloudbuildTriggerBuildSourceStorageSourceList;
}
export declare class DataGoogleCloudbuildTriggerBuildSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildSourceOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildStepVolumes {
}
export declare function dataGoogleCloudbuildTriggerBuildStepVolumesToTerraform(struct?: DataGoogleCloudbuildTriggerBuildStepVolumes): any;
export declare class DataGoogleCloudbuildTriggerBuildStepVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildStepVolumes | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildStepVolumes | undefined);
    get name(): string;
    get path(): string;
}
export declare class DataGoogleCloudbuildTriggerBuildStepVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildStepVolumesOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuildStep {
}
export declare function dataGoogleCloudbuildTriggerBuildStepToTerraform(struct?: DataGoogleCloudbuildTriggerBuildStep): any;
export declare class DataGoogleCloudbuildTriggerBuildStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuildStep | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuildStep | undefined);
    get args(): string[];
    get dir(): string;
    get entrypoint(): string;
    get env(): string[];
    get id(): string;
    get name(): string;
    get script(): string;
    get secretEnv(): string[];
    get timeout(): string;
    get timing(): string;
    private _volumes;
    get volumes(): DataGoogleCloudbuildTriggerBuildStepVolumesList;
    get waitFor(): string[];
}
export declare class DataGoogleCloudbuildTriggerBuildStepList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildStepOutputReference;
}
export interface DataGoogleCloudbuildTriggerBuild {
}
export declare function dataGoogleCloudbuildTriggerBuildToTerraform(struct?: DataGoogleCloudbuildTriggerBuild): any;
export declare class DataGoogleCloudbuildTriggerBuildOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerBuild | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerBuild | undefined);
    private _artifacts;
    get artifacts(): DataGoogleCloudbuildTriggerBuildArtifactsList;
    private _availableSecrets;
    get availableSecrets(): DataGoogleCloudbuildTriggerBuildAvailableSecretsList;
    get images(): string[];
    get logsBucket(): string;
    private _options;
    get options(): DataGoogleCloudbuildTriggerBuildOptionsList;
    get queueTtl(): string;
    private _secret;
    get secret(): DataGoogleCloudbuildTriggerBuildSecretList;
    private _source;
    get source(): DataGoogleCloudbuildTriggerBuildSourceList;
    private _step;
    get step(): DataGoogleCloudbuildTriggerBuildStepList;
    private _substitutions;
    get substitutions(): cdktf.StringMap;
    get tags(): string[];
    get timeout(): string;
}
export declare class DataGoogleCloudbuildTriggerBuildList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerBuildOutputReference;
}
export interface DataGoogleCloudbuildTriggerGitFileSource {
}
export declare function dataGoogleCloudbuildTriggerGitFileSourceToTerraform(struct?: DataGoogleCloudbuildTriggerGitFileSource): any;
export declare class DataGoogleCloudbuildTriggerGitFileSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerGitFileSource | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerGitFileSource | undefined);
    get githubEnterpriseConfig(): string;
    get path(): string;
    get repoType(): string;
    get revision(): string;
    get uri(): string;
}
export declare class DataGoogleCloudbuildTriggerGitFileSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerGitFileSourceOutputReference;
}
export interface DataGoogleCloudbuildTriggerGithubPullRequest {
}
export declare function dataGoogleCloudbuildTriggerGithubPullRequestToTerraform(struct?: DataGoogleCloudbuildTriggerGithubPullRequest): any;
export declare class DataGoogleCloudbuildTriggerGithubPullRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerGithubPullRequest | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerGithubPullRequest | undefined);
    get branch(): string;
    get commentControl(): string;
    get invertRegex(): cdktf.IResolvable;
}
export declare class DataGoogleCloudbuildTriggerGithubPullRequestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerGithubPullRequestOutputReference;
}
export interface DataGoogleCloudbuildTriggerGithubPush {
}
export declare function dataGoogleCloudbuildTriggerGithubPushToTerraform(struct?: DataGoogleCloudbuildTriggerGithubPush): any;
export declare class DataGoogleCloudbuildTriggerGithubPushOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerGithubPush | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerGithubPush | undefined);
    get branch(): string;
    get invertRegex(): cdktf.IResolvable;
    get tag(): string;
}
export declare class DataGoogleCloudbuildTriggerGithubPushList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerGithubPushOutputReference;
}
export interface DataGoogleCloudbuildTriggerGithub {
}
export declare function dataGoogleCloudbuildTriggerGithubToTerraform(struct?: DataGoogleCloudbuildTriggerGithub): any;
export declare class DataGoogleCloudbuildTriggerGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerGithub | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerGithub | undefined);
    get enterpriseConfigResourceName(): string;
    get name(): string;
    get owner(): string;
    private _pullRequest;
    get pullRequest(): DataGoogleCloudbuildTriggerGithubPullRequestList;
    private _push;
    get push(): DataGoogleCloudbuildTriggerGithubPushList;
}
export declare class DataGoogleCloudbuildTriggerGithubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerGithubOutputReference;
}
export interface DataGoogleCloudbuildTriggerPubsubConfig {
}
export declare function dataGoogleCloudbuildTriggerPubsubConfigToTerraform(struct?: DataGoogleCloudbuildTriggerPubsubConfig): any;
export declare class DataGoogleCloudbuildTriggerPubsubConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerPubsubConfig | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerPubsubConfig | undefined);
    get serviceAccountEmail(): string;
    get state(): string;
    get subscription(): string;
    get topic(): string;
}
export declare class DataGoogleCloudbuildTriggerPubsubConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerPubsubConfigOutputReference;
}
export interface DataGoogleCloudbuildTriggerSourceToBuild {
}
export declare function dataGoogleCloudbuildTriggerSourceToBuildToTerraform(struct?: DataGoogleCloudbuildTriggerSourceToBuild): any;
export declare class DataGoogleCloudbuildTriggerSourceToBuildOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerSourceToBuild | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerSourceToBuild | undefined);
    get githubEnterpriseConfig(): string;
    get ref(): string;
    get repoType(): string;
    get uri(): string;
}
export declare class DataGoogleCloudbuildTriggerSourceToBuildList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerSourceToBuildOutputReference;
}
export interface DataGoogleCloudbuildTriggerTriggerTemplate {
}
export declare function dataGoogleCloudbuildTriggerTriggerTemplateToTerraform(struct?: DataGoogleCloudbuildTriggerTriggerTemplate): any;
export declare class DataGoogleCloudbuildTriggerTriggerTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerTriggerTemplate | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerTriggerTemplate | undefined);
    get branchName(): string;
    get commitSha(): string;
    get dir(): string;
    get invertRegex(): cdktf.IResolvable;
    get projectId(): string;
    get repoName(): string;
    get tagName(): string;
}
export declare class DataGoogleCloudbuildTriggerTriggerTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerTriggerTemplateOutputReference;
}
export interface DataGoogleCloudbuildTriggerWebhookConfig {
}
export declare function dataGoogleCloudbuildTriggerWebhookConfigToTerraform(struct?: DataGoogleCloudbuildTriggerWebhookConfig): any;
export declare class DataGoogleCloudbuildTriggerWebhookConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudbuildTriggerWebhookConfig | undefined;
    set internalValue(value: DataGoogleCloudbuildTriggerWebhookConfig | undefined);
    get secret(): string;
    get state(): string;
}
export declare class DataGoogleCloudbuildTriggerWebhookConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudbuildTriggerWebhookConfigOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/cloudbuild_trigger google_cloudbuild_trigger}
*/
export declare class DataGoogleCloudbuildTrigger extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloudbuild_trigger";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloudbuild_trigger google_cloudbuild_trigger} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudbuildTriggerConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudbuildTriggerConfig);
    private _approvalConfig;
    get approvalConfig(): DataGoogleCloudbuildTriggerApprovalConfigList;
    private _bitbucketServerTriggerConfig;
    get bitbucketServerTriggerConfig(): DataGoogleCloudbuildTriggerBitbucketServerTriggerConfigList;
    private _build;
    get buildAttribute(): DataGoogleCloudbuildTriggerBuildList;
    get createTime(): string;
    get description(): string;
    get disabled(): cdktf.IResolvable;
    get filename(): string;
    get filter(): string;
    private _gitFileSource;
    get gitFileSource(): DataGoogleCloudbuildTriggerGitFileSourceList;
    private _github;
    get github(): DataGoogleCloudbuildTriggerGithubList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ignoredFiles(): string[];
    get includeBuildLogs(): string;
    get includedFiles(): string[];
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _pubsubConfig;
    get pubsubConfig(): DataGoogleCloudbuildTriggerPubsubConfigList;
    get serviceAccount(): string;
    private _sourceToBuild;
    get sourceToBuild(): DataGoogleCloudbuildTriggerSourceToBuildList;
    private _substitutions;
    get substitutions(): cdktf.StringMap;
    get tags(): string[];
    private _triggerId?;
    get triggerId(): string;
    set triggerId(value: string);
    get triggerIdInput(): string | undefined;
    private _triggerTemplate;
    get triggerTemplate(): DataGoogleCloudbuildTriggerTriggerTemplateList;
    private _webhookConfig;
    get webhookConfig(): DataGoogleCloudbuildTriggerWebhookConfigList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
