import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleContainerRegistryRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_registry_repository#id DataGoogleContainerRegistryRepository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_registry_repository#project DataGoogleContainerRegistryRepository#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_registry_repository#region DataGoogleContainerRegistryRepository#region}
    */
    readonly region?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/container_registry_repository google_container_registry_repository}
*/
export declare class DataGoogleContainerRegistryRepository extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_container_registry_repository";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/container_registry_repository google_container_registry_repository} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleContainerRegistryRepositoryConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleContainerRegistryRepositoryConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get repositoryUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
