import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleDnsKeysConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Name of the zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/dns_keys#managed_zone DataGoogleDnsKeys#managed_zone}
    */
    readonly managedZone: string;
    /**
    * The ID of the project for the Google Cloud.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/dns_keys#project DataGoogleDnsKeys#project}
    */
    readonly project?: string;
    /**
    * key_signing_keys block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/dns_keys#key_signing_keys DataGoogleDnsKeys#key_signing_keys}
    */
    readonly keySigningKeys?: DataGoogleDnsKeysKeySigningKeys[] | cdktf.IResolvable;
    /**
    * zone_signing_keys block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/dns_keys#zone_signing_keys DataGoogleDnsKeys#zone_signing_keys}
    */
    readonly zoneSigningKeys?: DataGoogleDnsKeysZoneSigningKeys[] | cdktf.IResolvable;
}
export interface DataGoogleDnsKeysKeySigningKeysDigests {
}
export declare function dataGoogleDnsKeysKeySigningKeysDigestsToTerraform(struct?: DataGoogleDnsKeysKeySigningKeysDigests | cdktf.IResolvable): any;
export declare class DataGoogleDnsKeysKeySigningKeysDigestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDnsKeysKeySigningKeysDigests | cdktf.IResolvable | undefined;
    set internalValue(value: DataGoogleDnsKeysKeySigningKeysDigests | cdktf.IResolvable | undefined);
    get digest(): string;
    get type(): string;
}
export declare class DataGoogleDnsKeysKeySigningKeysDigestsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataGoogleDnsKeysKeySigningKeysDigests[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDnsKeysKeySigningKeysDigestsOutputReference;
}
export interface DataGoogleDnsKeysKeySigningKeys {
    /**
    * digests block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/dns_keys#digests DataGoogleDnsKeys#digests}
    */
    readonly digests?: DataGoogleDnsKeysKeySigningKeysDigests[] | cdktf.IResolvable;
}
export declare function dataGoogleDnsKeysKeySigningKeysToTerraform(struct?: DataGoogleDnsKeysKeySigningKeys | cdktf.IResolvable): any;
export declare class DataGoogleDnsKeysKeySigningKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDnsKeysKeySigningKeys | cdktf.IResolvable | undefined;
    set internalValue(value: DataGoogleDnsKeysKeySigningKeys | cdktf.IResolvable | undefined);
    get algorithm(): string;
    get creationTime(): string;
    get description(): string;
    get dsRecord(): string;
    get id(): string;
    get isActive(): cdktf.IResolvable;
    get keyLength(): number;
    get keyTag(): number;
    get publicKey(): string;
    private _digests;
    get digests(): DataGoogleDnsKeysKeySigningKeysDigestsList;
    putDigests(value: DataGoogleDnsKeysKeySigningKeysDigests[] | cdktf.IResolvable): void;
    resetDigests(): void;
    get digestsInput(): cdktf.IResolvable | DataGoogleDnsKeysKeySigningKeysDigests[] | undefined;
}
export declare class DataGoogleDnsKeysKeySigningKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataGoogleDnsKeysKeySigningKeys[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDnsKeysKeySigningKeysOutputReference;
}
export interface DataGoogleDnsKeysZoneSigningKeysDigests {
}
export declare function dataGoogleDnsKeysZoneSigningKeysDigestsToTerraform(struct?: DataGoogleDnsKeysZoneSigningKeysDigests | cdktf.IResolvable): any;
export declare class DataGoogleDnsKeysZoneSigningKeysDigestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDnsKeysZoneSigningKeysDigests | cdktf.IResolvable | undefined;
    set internalValue(value: DataGoogleDnsKeysZoneSigningKeysDigests | cdktf.IResolvable | undefined);
    get digest(): string;
    get type(): string;
}
export declare class DataGoogleDnsKeysZoneSigningKeysDigestsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataGoogleDnsKeysZoneSigningKeysDigests[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDnsKeysZoneSigningKeysDigestsOutputReference;
}
export interface DataGoogleDnsKeysZoneSigningKeys {
    /**
    * digests block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/dns_keys#digests DataGoogleDnsKeys#digests}
    */
    readonly digests?: DataGoogleDnsKeysZoneSigningKeysDigests[] | cdktf.IResolvable;
}
export declare function dataGoogleDnsKeysZoneSigningKeysToTerraform(struct?: DataGoogleDnsKeysZoneSigningKeys | cdktf.IResolvable): any;
export declare class DataGoogleDnsKeysZoneSigningKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleDnsKeysZoneSigningKeys | cdktf.IResolvable | undefined;
    set internalValue(value: DataGoogleDnsKeysZoneSigningKeys | cdktf.IResolvable | undefined);
    get algorithm(): string;
    get creationTime(): string;
    get description(): string;
    get id(): string;
    get isActive(): cdktf.IResolvable;
    get keyLength(): number;
    get keyTag(): number;
    get publicKey(): string;
    private _digests;
    get digests(): DataGoogleDnsKeysZoneSigningKeysDigestsList;
    putDigests(value: DataGoogleDnsKeysZoneSigningKeysDigests[] | cdktf.IResolvable): void;
    resetDigests(): void;
    get digestsInput(): cdktf.IResolvable | DataGoogleDnsKeysZoneSigningKeysDigests[] | undefined;
}
export declare class DataGoogleDnsKeysZoneSigningKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataGoogleDnsKeysZoneSigningKeys[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleDnsKeysZoneSigningKeysOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/dns_keys google_dns_keys}
*/
export declare class DataGoogleDnsKeys extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_dns_keys";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/dns_keys google_dns_keys} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleDnsKeysConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleDnsKeysConfig);
    get id(): string;
    private _managedZone?;
    get managedZone(): string;
    set managedZone(value: string);
    get managedZoneInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _keySigningKeys;
    get keySigningKeys(): DataGoogleDnsKeysKeySigningKeysList;
    putKeySigningKeys(value: DataGoogleDnsKeysKeySigningKeys[] | cdktf.IResolvable): void;
    resetKeySigningKeys(): void;
    get keySigningKeysInput(): cdktf.IResolvable | DataGoogleDnsKeysKeySigningKeys[] | undefined;
    private _zoneSigningKeys;
    get zoneSigningKeys(): DataGoogleDnsKeysZoneSigningKeysList;
    putZoneSigningKeys(value: DataGoogleDnsKeysZoneSigningKeys[] | cdktf.IResolvable): void;
    resetZoneSigningKeys(): void;
    get zoneSigningKeysInput(): cdktf.IResolvable | DataGoogleDnsKeysZoneSigningKeys[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
