import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleFolderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folder#folder DataGoogleFolder#folder}
    */
    readonly folder: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folder#id DataGoogleFolder#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/folder#lookup_organization DataGoogleFolder#lookup_organization}
    */
    readonly lookupOrganization?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/folder google_folder}
*/
export declare class DataGoogleFolder extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_folder";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/folder google_folder} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleFolderConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleFolderConfig);
    get createTime(): string;
    get displayName(): string;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    get folderId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lifecycleState(): string;
    private _lookupOrganization?;
    get lookupOrganization(): boolean | cdktf.IResolvable;
    set lookupOrganization(value: boolean | cdktf.IResolvable);
    resetLookupOrganization(): void;
    get lookupOrganizationInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    get organization(): string;
    get parent(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
