import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGooglePrivatecaCertificateAuthorityConfig extends cdktf.TerraformMetaArguments {
    /**
    * The user provided Resource ID for this Certificate Authority.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/privateca_certificate_authority#certificate_authority_id DataGooglePrivatecaCertificateAuthority#certificate_authority_id}
    */
    readonly certificateAuthorityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/privateca_certificate_authority#id DataGooglePrivatecaCertificateAuthority#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Location of the CertificateAuthority. A full list of valid locations can be found by
  running 'gcloud privateca locations list'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/privateca_certificate_authority#location DataGooglePrivatecaCertificateAuthority#location}
    */
    readonly location?: string;
    /**
    * The name of the CaPool this Certificate Authority belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/privateca_certificate_authority#pool DataGooglePrivatecaCertificateAuthority#pool}
    */
    readonly pool?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/privateca_certificate_authority#project DataGooglePrivatecaCertificateAuthority#project}
    */
    readonly project?: string;
}
export interface DataGooglePrivatecaCertificateAuthorityAccessUrls {
}
export declare function dataGooglePrivatecaCertificateAuthorityAccessUrlsToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityAccessUrls): any;
export declare class DataGooglePrivatecaCertificateAuthorityAccessUrlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityAccessUrls | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityAccessUrls | undefined);
    get caCertificateAccessUrl(): string;
    get crlAccessUrls(): string[];
}
export declare class DataGooglePrivatecaCertificateAuthorityAccessUrlsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityAccessUrlsOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubject {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubject): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubject | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubject | undefined);
    get commonName(): string;
    get countryCode(): string;
    get locality(): string;
    get organization(): string;
    get organizationalUnit(): string;
    get postalCode(): string;
    get province(): string;
    get streetAddress(): string;
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined);
    get dnsNames(): string[];
    get emailAddresses(): string[];
    get ipAddresses(): string[];
    get uris(): string[];
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigSubjectConfig {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigSubjectConfigToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigSubjectConfig): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigSubjectConfig | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigSubjectConfig | undefined);
    private _subject;
    get subject(): DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectList;
    private _subjectAltName;
    get subjectAltName(): DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameList;
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId | undefined);
    get objectIdPath(): number[];
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions | undefined);
    get critical(): cdktf.IResolvable;
    private _objectId;
    get objectId(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdList;
    get value(): string;
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptions {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptionsToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptions): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptions | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptions | undefined);
    get isCa(): cdktf.IResolvable;
    get maxIssuerPathLength(): number;
    get nonCa(): cdktf.IResolvable;
    get zeroMaxIssuerPathLength(): cdktf.IResolvable;
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage | undefined);
    get certSign(): cdktf.IResolvable;
    get contentCommitment(): cdktf.IResolvable;
    get crlSign(): cdktf.IResolvable;
    get dataEncipherment(): cdktf.IResolvable;
    get decipherOnly(): cdktf.IResolvable;
    get digitalSignature(): cdktf.IResolvable;
    get encipherOnly(): cdktf.IResolvable;
    get keyAgreement(): cdktf.IResolvable;
    get keyEncipherment(): cdktf.IResolvable;
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage | undefined);
    get clientAuth(): cdktf.IResolvable;
    get codeSigning(): cdktf.IResolvable;
    get emailProtection(): cdktf.IResolvable;
    get ocspSigning(): cdktf.IResolvable;
    get serverAuth(): cdktf.IResolvable;
    get timeStamping(): cdktf.IResolvable;
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages | undefined);
    get objectIdPath(): number[];
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsage {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsage): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsage | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsage | undefined);
    private _baseKeyUsage;
    get baseKeyUsage(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageList;
    private _extendedKeyUsage;
    get extendedKeyUsage(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageList;
    private _unknownExtendedKeyUsages;
    get unknownExtendedKeyUsages(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesList;
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraints {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraintsToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraints): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraints | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraints | undefined);
    get critical(): cdktf.IResolvable;
    get excludedDnsNames(): string[];
    get excludedEmailAddresses(): string[];
    get excludedIpRanges(): string[];
    get excludedUris(): string[];
    get permittedDnsNames(): string[];
    get permittedEmailAddresses(): string[];
    get permittedIpRanges(): string[];
    get permittedUris(): string[];
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraintsOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIds {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIds): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIds | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIds | undefined);
    get objectIdPath(): number[];
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigX509Config {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigX509ConfigToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigX509Config): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigX509Config | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigX509Config | undefined);
    private _additionalExtensions;
    get additionalExtensions(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsList;
    get aiaOcspServers(): string[];
    private _caOptions;
    get caOptions(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptionsList;
    private _keyUsage;
    get keyUsage(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageList;
    private _nameConstraints;
    get nameConstraints(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraintsList;
    private _policyIds;
    get policyIds(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsList;
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigX509ConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityConfigA {
}
export declare function dataGooglePrivatecaCertificateAuthorityConfigAToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityConfigA): any;
export declare class DataGooglePrivatecaCertificateAuthorityConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityConfigA | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityConfigA | undefined);
    private _subjectConfig;
    get subjectConfig(): DataGooglePrivatecaCertificateAuthorityConfigSubjectConfigList;
    private _x509Config;
    get x509Config(): DataGooglePrivatecaCertificateAuthorityConfigX509ConfigList;
}
export declare class DataGooglePrivatecaCertificateAuthorityConfigAList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityConfigAOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthorityKeySpec {
}
export declare function dataGooglePrivatecaCertificateAuthorityKeySpecToTerraform(struct?: DataGooglePrivatecaCertificateAuthorityKeySpec): any;
export declare class DataGooglePrivatecaCertificateAuthorityKeySpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthorityKeySpec | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthorityKeySpec | undefined);
    get algorithm(): string;
    get cloudKmsKeyVersion(): string;
}
export declare class DataGooglePrivatecaCertificateAuthorityKeySpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthorityKeySpecOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain {
}
export declare function dataGooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainToTerraform(struct?: DataGooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain): any;
export declare class DataGooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain | undefined);
    get pemCertificates(): string[];
}
export declare class DataGooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainOutputReference;
}
export interface DataGooglePrivatecaCertificateAuthoritySubordinateConfig {
}
export declare function dataGooglePrivatecaCertificateAuthoritySubordinateConfigToTerraform(struct?: DataGooglePrivatecaCertificateAuthoritySubordinateConfig): any;
export declare class DataGooglePrivatecaCertificateAuthoritySubordinateConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePrivatecaCertificateAuthoritySubordinateConfig | undefined;
    set internalValue(value: DataGooglePrivatecaCertificateAuthoritySubordinateConfig | undefined);
    get certificateAuthority(): string;
    private _pemIssuerChain;
    get pemIssuerChain(): DataGooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainList;
}
export declare class DataGooglePrivatecaCertificateAuthoritySubordinateConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePrivatecaCertificateAuthoritySubordinateConfigOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/privateca_certificate_authority google_privateca_certificate_authority}
*/
export declare class DataGooglePrivatecaCertificateAuthority extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_privateca_certificate_authority";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/privateca_certificate_authority google_privateca_certificate_authority} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGooglePrivatecaCertificateAuthorityConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGooglePrivatecaCertificateAuthorityConfig);
    private _accessUrls;
    get accessUrls(): DataGooglePrivatecaCertificateAuthorityAccessUrlsList;
    private _certificateAuthorityId?;
    get certificateAuthorityId(): string;
    set certificateAuthorityId(value: string);
    resetCertificateAuthorityId(): void;
    get certificateAuthorityIdInput(): string | undefined;
    private _config;
    get config(): DataGooglePrivatecaCertificateAuthorityConfigAList;
    get createTime(): string;
    get deletionProtection(): cdktf.IResolvable;
    get desiredState(): string;
    get gcsBucket(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ignoreActiveCertificatesOnDeletion(): cdktf.IResolvable;
    private _keySpec;
    get keySpec(): DataGooglePrivatecaCertificateAuthorityKeySpecList;
    private _labels;
    get labels(): cdktf.StringMap;
    get lifetime(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    get pemCaCertificate(): string;
    get pemCaCertificates(): string[];
    get pemCsr(): string;
    private _pool?;
    get pool(): string;
    set pool(value: string);
    resetPool(): void;
    get poolInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get skipGracePeriod(): cdktf.IResolvable;
    get state(): string;
    private _subordinateConfig;
    get subordinateConfig(): DataGooglePrivatecaCertificateAuthoritySubordinateConfigList;
    get type(): string;
    get updateTime(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
