import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleProjectServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/project_service#id DataGoogleProjectService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/project_service#project DataGoogleProjectService#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/project_service#service DataGoogleProjectService#service}
    */
    readonly service: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/project_service google_project_service}
*/
export declare class DataGoogleProjectService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_project_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/project_service google_project_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleProjectServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleProjectServiceConfig);
    get disableDependentServices(): cdktf.IResolvable;
    get disableOnDestroy(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
