import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGooglePubsubTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic#id DataGooglePubsubTopic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic#name DataGooglePubsubTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic#project DataGooglePubsubTopic#project}
    */
    readonly project?: string;
}
export interface DataGooglePubsubTopicMessageStoragePolicy {
}
export declare function dataGooglePubsubTopicMessageStoragePolicyToTerraform(struct?: DataGooglePubsubTopicMessageStoragePolicy): any;
export declare class DataGooglePubsubTopicMessageStoragePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePubsubTopicMessageStoragePolicy | undefined;
    set internalValue(value: DataGooglePubsubTopicMessageStoragePolicy | undefined);
    get allowedPersistenceRegions(): string[];
}
export declare class DataGooglePubsubTopicMessageStoragePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePubsubTopicMessageStoragePolicyOutputReference;
}
export interface DataGooglePubsubTopicSchemaSettings {
}
export declare function dataGooglePubsubTopicSchemaSettingsToTerraform(struct?: DataGooglePubsubTopicSchemaSettings): any;
export declare class DataGooglePubsubTopicSchemaSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGooglePubsubTopicSchemaSettings | undefined;
    set internalValue(value: DataGooglePubsubTopicSchemaSettings | undefined);
    get encoding(): string;
    get schema(): string;
}
export declare class DataGooglePubsubTopicSchemaSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGooglePubsubTopicSchemaSettingsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic google_pubsub_topic}
*/
export declare class DataGooglePubsubTopic extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_pubsub_topic";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic google_pubsub_topic} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGooglePubsubTopicConfig
    */
    constructor(scope: Construct, id: string, config: DataGooglePubsubTopicConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kmsKeyName(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get messageRetentionDuration(): string;
    private _messageStoragePolicy;
    get messageStoragePolicy(): DataGooglePubsubTopicMessageStoragePolicyList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _schemaSettings;
    get schemaSettings(): DataGooglePubsubTopicSchemaSettingsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
