import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSqlBackupRunConfig extends cdktf.TerraformMetaArguments {
    /**
    * The identifier for this backup run. Unique only for a specific Cloud SQL instance. If left empty and multiple backups exist for the instance, most_recent must be set to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run#backup_id DataGoogleSqlBackupRun#backup_id}
    */
    readonly backupId?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run#id DataGoogleSqlBackupRun#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the database instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run#instance DataGoogleSqlBackupRun#instance}
    */
    readonly instance: string;
    /**
    * Toggles use of the most recent backup run if multiple backups exist for a Cloud SQL instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run#most_recent DataGoogleSqlBackupRun#most_recent}
    */
    readonly mostRecent?: boolean | cdktf.IResolvable;
    /**
    * Project ID of the project that contains the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run#project DataGoogleSqlBackupRun#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run google_sql_backup_run}
*/
export declare class DataGoogleSqlBackupRun extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_sql_backup_run";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/sql_backup_run google_sql_backup_run} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSqlBackupRunConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSqlBackupRunConfig);
    private _backupId?;
    get backupId(): number;
    set backupId(value: number);
    resetBackupId(): void;
    get backupIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    get location(): string;
    private _mostRecent?;
    get mostRecent(): boolean | cdktf.IResolvable;
    set mostRecent(value: boolean | cdktf.IResolvable);
    resetMostRecent(): void;
    get mostRecentInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get startTime(): string;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
