import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSqlDatabasesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_databases#id DataGoogleSqlDatabases#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Cloud SQL database instance in which the database belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_databases#instance DataGoogleSqlDatabases#instance}
    */
    readonly instance: string;
    /**
    * Project ID of the project that contains the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_databases#project DataGoogleSqlDatabases#project}
    */
    readonly project?: string;
}
export interface DataGoogleSqlDatabasesDatabases {
}
export declare function dataGoogleSqlDatabasesDatabasesToTerraform(struct?: DataGoogleSqlDatabasesDatabases): any;
export declare class DataGoogleSqlDatabasesDatabasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabasesDatabases | undefined;
    set internalValue(value: DataGoogleSqlDatabasesDatabases | undefined);
    get charset(): string;
    get collation(): string;
    get deletionPolicy(): string;
    get instance(): string;
    get name(): string;
    get project(): string;
    get selfLink(): string;
}
export declare class DataGoogleSqlDatabasesDatabasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabasesDatabasesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/sql_databases google_sql_databases}
*/
export declare class DataGoogleSqlDatabases extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_sql_databases";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/sql_databases google_sql_databases} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSqlDatabasesConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSqlDatabasesConfig);
    private _databases;
    get databases(): DataGoogleSqlDatabasesDatabasesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
