import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleStorageBucketObjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the containing bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object#bucket DataGoogleStorageBucketObject#bucket}
    */
    readonly bucket?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object#id DataGoogleStorageBucketObject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the object. If you're interpolating the name of this object, see output_name instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object#name DataGoogleStorageBucketObject#name}
    */
    readonly name?: string;
}
export interface DataGoogleStorageBucketObjectCustomerEncryption {
}
export declare function dataGoogleStorageBucketObjectCustomerEncryptionToTerraform(struct?: DataGoogleStorageBucketObjectCustomerEncryption): any;
export declare class DataGoogleStorageBucketObjectCustomerEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleStorageBucketObjectCustomerEncryption | undefined;
    set internalValue(value: DataGoogleStorageBucketObjectCustomerEncryption | undefined);
    get encryptionAlgorithm(): string;
    get encryptionKey(): string;
}
export declare class DataGoogleStorageBucketObjectCustomerEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleStorageBucketObjectCustomerEncryptionOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object google_storage_bucket_object}
*/
export declare class DataGoogleStorageBucketObject extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_storage_bucket_object";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object google_storage_bucket_object} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleStorageBucketObjectConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleStorageBucketObjectConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    resetBucket(): void;
    get bucketInput(): string | undefined;
    get cacheControl(): string;
    get content(): string;
    get contentDisposition(): string;
    get contentEncoding(): string;
    get contentLanguage(): string;
    get contentType(): string;
    get crc32C(): string;
    private _customerEncryption;
    get customerEncryption(): DataGoogleStorageBucketObjectCustomerEncryptionList;
    get detectMd5Hash(): string;
    get eventBasedHold(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kmsKeyName(): string;
    get md5Hash(): string;
    get mediaLink(): string;
    private _metadata;
    get metadata(): cdktf.StringMap;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get outputName(): string;
    get selfLink(): string;
    get source(): string;
    get storageClass(): string;
    get temporaryHold(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
