import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleTagsTagKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/tags_tag_key#parent DataGoogleTagsTagKey#parent}
    */
    readonly parent: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/tags_tag_key#short_name DataGoogleTagsTagKey#short_name}
    */
    readonly shortName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/tags_tag_key google_tags_tag_key}
*/
export declare class DataGoogleTagsTagKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_tags_tag_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/tags_tag_key google_tags_tag_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleTagsTagKeyConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleTagsTagKeyConfig);
    get createTime(): string;
    get description(): string;
    get id(): string;
    get name(): string;
    get namespacedName(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _shortName?;
    get shortName(): string;
    set shortName(value: string);
    get shortNameInput(): string | undefined;
    get updateTime(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
