import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataplexAssetIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding#asset DataplexAssetIamBinding#asset}
    */
    readonly asset: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding#dataplex_zone DataplexAssetIamBinding#dataplex_zone}
    */
    readonly dataplexZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding#id DataplexAssetIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding#lake DataplexAssetIamBinding#lake}
    */
    readonly lake: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding#location DataplexAssetIamBinding#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding#members DataplexAssetIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding#project DataplexAssetIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding#role DataplexAssetIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding#condition DataplexAssetIamBinding#condition}
    */
    readonly condition?: DataplexAssetIamBindingCondition;
}
export interface DataplexAssetIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding#description DataplexAssetIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding#expression DataplexAssetIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding#title DataplexAssetIamBinding#title}
    */
    readonly title: string;
}
export declare function dataplexAssetIamBindingConditionToTerraform(struct?: DataplexAssetIamBindingConditionOutputReference | DataplexAssetIamBindingCondition): any;
export declare class DataplexAssetIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplexAssetIamBindingCondition | undefined;
    set internalValue(value: DataplexAssetIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding google_dataplex_asset_iam_binding}
*/
export declare class DataplexAssetIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataplex_asset_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_binding google_dataplex_asset_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataplexAssetIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: DataplexAssetIamBindingConfig);
    private _asset?;
    get asset(): string;
    set asset(value: string);
    get assetInput(): string | undefined;
    private _dataplexZone?;
    get dataplexZone(): string;
    set dataplexZone(value: string);
    get dataplexZoneInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lake?;
    get lake(): string;
    set lake(value: string);
    get lakeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): DataplexAssetIamBindingConditionOutputReference;
    putCondition(value: DataplexAssetIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): DataplexAssetIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
