import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataplexAssetIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member#asset DataplexAssetIamMember#asset}
    */
    readonly asset: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member#dataplex_zone DataplexAssetIamMember#dataplex_zone}
    */
    readonly dataplexZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member#id DataplexAssetIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member#lake DataplexAssetIamMember#lake}
    */
    readonly lake: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member#location DataplexAssetIamMember#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member#member DataplexAssetIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member#project DataplexAssetIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member#role DataplexAssetIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member#condition DataplexAssetIamMember#condition}
    */
    readonly condition?: DataplexAssetIamMemberCondition;
}
export interface DataplexAssetIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member#description DataplexAssetIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member#expression DataplexAssetIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member#title DataplexAssetIamMember#title}
    */
    readonly title: string;
}
export declare function dataplexAssetIamMemberConditionToTerraform(struct?: DataplexAssetIamMemberConditionOutputReference | DataplexAssetIamMemberCondition): any;
export declare class DataplexAssetIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplexAssetIamMemberCondition | undefined;
    set internalValue(value: DataplexAssetIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member google_dataplex_asset_iam_member}
*/
export declare class DataplexAssetIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataplex_asset_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset_iam_member google_dataplex_asset_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataplexAssetIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: DataplexAssetIamMemberConfig);
    private _asset?;
    get asset(): string;
    set asset(value: string);
    get assetInput(): string | undefined;
    private _dataplexZone?;
    get dataplexZone(): string;
    set dataplexZone(value: string);
    get dataplexZoneInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lake?;
    get lake(): string;
    set lake(value: string);
    get lakeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): DataplexAssetIamMemberConditionOutputReference;
    putCondition(value: DataplexAssetIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): DataplexAssetIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
