import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowCxFlowConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#description DialogflowCxFlow#description}
    */
    readonly description?: string;
    /**
    * The human-readable name of the flow.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#display_name DialogflowCxFlow#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#id DialogflowCxFlow#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The language of the following fields in flow:
  Flow.event_handlers.trigger_fulfillment.messages
  Flow.event_handlers.trigger_fulfillment.conditional_cases
  Flow.transition_routes.trigger_fulfillment.messages
  Flow.transition_routes.trigger_fulfillment.conditional_cases
  If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#language_code DialogflowCxFlow#language_code}
    */
    readonly languageCode?: string;
    /**
    * The agent to create a flow for.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#parent DialogflowCxFlow#parent}
    */
    readonly parent?: string;
    /**
    * A flow's transition route group serve two purposes:
  They are responsible for matching the user's first utterances in the flow.
  They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
  Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#transition_route_groups DialogflowCxFlow#transition_route_groups}
    */
    readonly transitionRouteGroups?: string[];
    /**
    * event_handlers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#event_handlers DialogflowCxFlow#event_handlers}
    */
    readonly eventHandlers?: DialogflowCxFlowEventHandlers[] | cdktf.IResolvable;
    /**
    * nlu_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#nlu_settings DialogflowCxFlow#nlu_settings}
    */
    readonly nluSettings?: DialogflowCxFlowNluSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#timeouts DialogflowCxFlow#timeouts}
    */
    readonly timeouts?: DialogflowCxFlowTimeouts;
    /**
    * transition_routes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#transition_routes DialogflowCxFlow#transition_routes}
    */
    readonly transitionRoutes?: DialogflowCxFlowTransitionRoutes[] | cdktf.IResolvable;
}
export interface DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#text DialogflowCxFlow#text}
    */
    readonly text?: string[];
}
export declare function dialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextToTerraform(struct?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference | DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText): any;
export declare class DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface DialogflowCxFlowEventHandlersTriggerFulfillmentMessages {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#text DialogflowCxFlow#text}
    */
    readonly text?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText;
}
export declare function dialogflowCxFlowEventHandlersTriggerFulfillmentMessagesToTerraform(struct?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare class DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DialogflowCxFlowEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: DialogflowCxFlowEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable | undefined);
    private _text;
    get text(): DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference;
    putText(value: DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText | undefined;
}
export declare class DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesOutputReference;
}
export interface DialogflowCxFlowEventHandlersTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#return_partial_responses DialogflowCxFlow#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#tag DialogflowCxFlow#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#webhook DialogflowCxFlow#webhook}
    */
    readonly webhook?: string;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#messages DialogflowCxFlow#messages}
    */
    readonly messages?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function dialogflowCxFlowEventHandlersTriggerFulfillmentToTerraform(struct?: DialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference | DialogflowCxFlowEventHandlersTriggerFulfillment): any;
export declare class DialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowCxFlowEventHandlersTriggerFulfillment | undefined;
    set internalValue(value: DialogflowCxFlowEventHandlersTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages;
    get messages(): DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesList;
    putMessages(value: DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | undefined;
}
export interface DialogflowCxFlowEventHandlers {
    /**
    * The name of the event to handle.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#event DialogflowCxFlow#event}
    */
    readonly event?: string;
    /**
    * The target flow to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#target_flow DialogflowCxFlow#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#target_page DialogflowCxFlow#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#trigger_fulfillment DialogflowCxFlow#trigger_fulfillment}
    */
    readonly triggerFulfillment?: DialogflowCxFlowEventHandlersTriggerFulfillment;
}
export declare function dialogflowCxFlowEventHandlersToTerraform(struct?: DialogflowCxFlowEventHandlers | cdktf.IResolvable): any;
export declare class DialogflowCxFlowEventHandlersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DialogflowCxFlowEventHandlers | cdktf.IResolvable | undefined;
    set internalValue(value: DialogflowCxFlowEventHandlers | cdktf.IResolvable | undefined);
    private _event?;
    get event(): string;
    set event(value: string);
    resetEvent(): void;
    get eventInput(): string | undefined;
    get name(): string;
    private _targetFlow?;
    get targetFlow(): string;
    set targetFlow(value: string);
    resetTargetFlow(): void;
    get targetFlowInput(): string | undefined;
    private _targetPage?;
    get targetPage(): string;
    set targetPage(value: string);
    resetTargetPage(): void;
    get targetPageInput(): string | undefined;
    private _triggerFulfillment;
    get triggerFulfillment(): DialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference;
    putTriggerFulfillment(value: DialogflowCxFlowEventHandlersTriggerFulfillment): void;
    resetTriggerFulfillment(): void;
    get triggerFulfillmentInput(): DialogflowCxFlowEventHandlersTriggerFulfillment | undefined;
}
export declare class DialogflowCxFlowEventHandlersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DialogflowCxFlowEventHandlers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DialogflowCxFlowEventHandlersOutputReference;
}
export interface DialogflowCxFlowNluSettings {
    /**
    * To filter out false positive results and still get variety in matched natural language inputs for your agent, you can tune the machine learning classification threshold.
  If the returned score value is less than the threshold value, then a no-match event will be triggered. The score values range from 0.0 (completely uncertain) to 1.0 (completely certain). If set to 0.0, the default of 0.3 is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#classification_threshold DialogflowCxFlow#classification_threshold}
    */
    readonly classificationThreshold?: number;
    /**
    * Indicates NLU model training mode.
  * MODEL_TRAINING_MODE_AUTOMATIC: NLU model training is automatically triggered when a flow gets modified. User can also manually trigger model training in this mode.
  * MODEL_TRAINING_MODE_MANUAL: User needs to manually trigger NLU model training. Best for large flows whose models take long time to train. Possible values: ["MODEL_TRAINING_MODE_AUTOMATIC", "MODEL_TRAINING_MODE_MANUAL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#model_training_mode DialogflowCxFlow#model_training_mode}
    */
    readonly modelTrainingMode?: string;
    /**
    * Indicates the type of NLU model.
  * MODEL_TYPE_STANDARD: Use standard NLU model.
  * MODEL_TYPE_ADVANCED: Use advanced NLU model. Possible values: ["MODEL_TYPE_STANDARD", "MODEL_TYPE_ADVANCED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#model_type DialogflowCxFlow#model_type}
    */
    readonly modelType?: string;
}
export declare function dialogflowCxFlowNluSettingsToTerraform(struct?: DialogflowCxFlowNluSettingsOutputReference | DialogflowCxFlowNluSettings): any;
export declare class DialogflowCxFlowNluSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowCxFlowNluSettings | undefined;
    set internalValue(value: DialogflowCxFlowNluSettings | undefined);
    private _classificationThreshold?;
    get classificationThreshold(): number;
    set classificationThreshold(value: number);
    resetClassificationThreshold(): void;
    get classificationThresholdInput(): number | undefined;
    private _modelTrainingMode?;
    get modelTrainingMode(): string;
    set modelTrainingMode(value: string);
    resetModelTrainingMode(): void;
    get modelTrainingModeInput(): string | undefined;
    private _modelType?;
    get modelType(): string;
    set modelType(value: string);
    resetModelType(): void;
    get modelTypeInput(): string | undefined;
}
export interface DialogflowCxFlowTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#create DialogflowCxFlow#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#delete DialogflowCxFlow#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#update DialogflowCxFlow#update}
    */
    readonly update?: string;
}
export declare function dialogflowCxFlowTimeoutsToTerraform(struct?: DialogflowCxFlowTimeoutsOutputReference | DialogflowCxFlowTimeouts | cdktf.IResolvable): any;
export declare class DialogflowCxFlowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowCxFlowTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DialogflowCxFlowTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText {
    /**
    * A collection of text responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#text DialogflowCxFlow#text}
    */
    readonly text?: string[];
}
export declare function dialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextToTerraform(struct?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference | DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText): any;
export declare class DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText | undefined;
    set internalValue(value: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText | undefined);
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    get text(): string[];
    set text(value: string[]);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages {
    /**
    * text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#text DialogflowCxFlow#text}
    */
    readonly text?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText;
}
export declare function dialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesToTerraform(struct?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable): any;
export declare class DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable | undefined;
    set internalValue(value: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable | undefined);
    private _text;
    get text(): DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference;
    putText(value: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText): void;
    resetText(): void;
    get textInput(): DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText | undefined;
}
export declare class DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesOutputReference;
}
export interface DialogflowCxFlowTransitionRoutesTriggerFulfillment {
    /**
    * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs. If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#return_partial_responses DialogflowCxFlow#return_partial_responses}
    */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
    * The tag used by the webhook to identify which fulfillment is being called. This field is required if webhook is specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#tag DialogflowCxFlow#tag}
    */
    readonly tag?: string;
    /**
    * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#webhook DialogflowCxFlow#webhook}
    */
    readonly webhook?: string;
    /**
    * messages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#messages DialogflowCxFlow#messages}
    */
    readonly messages?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function dialogflowCxFlowTransitionRoutesTriggerFulfillmentToTerraform(struct?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference | DialogflowCxFlowTransitionRoutesTriggerFulfillment): any;
export declare class DialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowCxFlowTransitionRoutesTriggerFulfillment | undefined;
    set internalValue(value: DialogflowCxFlowTransitionRoutesTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string;
    set webhook(value: string);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages;
    get messages(): DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesList;
    putMessages(value: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable): void;
    resetMessages(): void;
    get messagesInput(): cdktf.IResolvable | DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | undefined;
}
export interface DialogflowCxFlowTransitionRoutes {
    /**
    * The condition to evaluate against form parameters or session parameters.
  At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#condition DialogflowCxFlow#condition}
    */
    readonly condition?: string;
    /**
    * The unique identifier of an Intent.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>. Indicates that the transition can only happen when the given intent is matched. At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#intent DialogflowCxFlow#intent}
    */
    readonly intent?: string;
    /**
    * The target flow to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#target_flow DialogflowCxFlow#target_flow}
    */
    readonly targetFlow?: string;
    /**
    * The target page to transition to.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#target_page DialogflowCxFlow#target_page}
    */
    readonly targetPage?: string;
    /**
    * trigger_fulfillment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#trigger_fulfillment DialogflowCxFlow#trigger_fulfillment}
    */
    readonly triggerFulfillment?: DialogflowCxFlowTransitionRoutesTriggerFulfillment;
}
export declare function dialogflowCxFlowTransitionRoutesToTerraform(struct?: DialogflowCxFlowTransitionRoutes | cdktf.IResolvable): any;
export declare class DialogflowCxFlowTransitionRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DialogflowCxFlowTransitionRoutes | cdktf.IResolvable | undefined;
    set internalValue(value: DialogflowCxFlowTransitionRoutes | cdktf.IResolvable | undefined);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _intent?;
    get intent(): string;
    set intent(value: string);
    resetIntent(): void;
    get intentInput(): string | undefined;
    get name(): string;
    private _targetFlow?;
    get targetFlow(): string;
    set targetFlow(value: string);
    resetTargetFlow(): void;
    get targetFlowInput(): string | undefined;
    private _targetPage?;
    get targetPage(): string;
    set targetPage(value: string);
    resetTargetPage(): void;
    get targetPageInput(): string | undefined;
    private _triggerFulfillment;
    get triggerFulfillment(): DialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference;
    putTriggerFulfillment(value: DialogflowCxFlowTransitionRoutesTriggerFulfillment): void;
    resetTriggerFulfillment(): void;
    get triggerFulfillmentInput(): DialogflowCxFlowTransitionRoutesTriggerFulfillment | undefined;
}
export declare class DialogflowCxFlowTransitionRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DialogflowCxFlowTransitionRoutes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DialogflowCxFlowTransitionRoutesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow google_dialogflow_cx_flow}
*/
export declare class DialogflowCxFlow extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_flow";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow google_dialogflow_cx_flow} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DialogflowCxFlowConfig
    */
    constructor(scope: Construct, id: string, config: DialogflowCxFlowConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _languageCode?;
    get languageCode(): string;
    set languageCode(value: string);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _transitionRouteGroups?;
    get transitionRouteGroups(): string[];
    set transitionRouteGroups(value: string[]);
    resetTransitionRouteGroups(): void;
    get transitionRouteGroupsInput(): string[] | undefined;
    private _eventHandlers;
    get eventHandlers(): DialogflowCxFlowEventHandlersList;
    putEventHandlers(value: DialogflowCxFlowEventHandlers[] | cdktf.IResolvable): void;
    resetEventHandlers(): void;
    get eventHandlersInput(): cdktf.IResolvable | DialogflowCxFlowEventHandlers[] | undefined;
    private _nluSettings;
    get nluSettings(): DialogflowCxFlowNluSettingsOutputReference;
    putNluSettings(value: DialogflowCxFlowNluSettings): void;
    resetNluSettings(): void;
    get nluSettingsInput(): DialogflowCxFlowNluSettings | undefined;
    private _timeouts;
    get timeouts(): DialogflowCxFlowTimeoutsOutputReference;
    putTimeouts(value: DialogflowCxFlowTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DialogflowCxFlowTimeouts | undefined;
    private _transitionRoutes;
    get transitionRoutes(): DialogflowCxFlowTransitionRoutesList;
    putTransitionRoutes(value: DialogflowCxFlowTransitionRoutes[] | cdktf.IResolvable): void;
    resetTransitionRoutes(): void;
    get transitionRoutesInput(): cdktf.IResolvable | DialogflowCxFlowTransitionRoutes[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
