import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowCxWebhookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Indicates whether the webhook is disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#disabled DialogflowCxWebhook#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The human-readable name of the webhook, unique within the agent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#display_name DialogflowCxWebhook#display_name}
    */
    readonly displayName: string;
    /**
    * Indicates if automatic spell correction is enabled in detect intent requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#enable_spell_correction DialogflowCxWebhook#enable_spell_correction}
    */
    readonly enableSpellCorrection?: boolean | cdktf.IResolvable;
    /**
    * Determines whether this agent should log conversation queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#enable_stackdriver_logging DialogflowCxWebhook#enable_stackdriver_logging}
    */
    readonly enableStackdriverLogging?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#id DialogflowCxWebhook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The agent to create a webhook for.
  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#parent DialogflowCxWebhook#parent}
    */
    readonly parent?: string;
    /**
    * Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#security_settings DialogflowCxWebhook#security_settings}
    */
    readonly securitySettings?: string;
    /**
    * Webhook execution timeout.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#timeout DialogflowCxWebhook#timeout}
    */
    readonly timeout?: string;
    /**
    * generic_web_service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#generic_web_service DialogflowCxWebhook#generic_web_service}
    */
    readonly genericWebService?: DialogflowCxWebhookGenericWebService;
    /**
    * service_directory block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#service_directory DialogflowCxWebhook#service_directory}
    */
    readonly serviceDirectory?: DialogflowCxWebhookServiceDirectory;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#timeouts DialogflowCxWebhook#timeouts}
    */
    readonly timeouts?: DialogflowCxWebhookTimeouts;
}
export interface DialogflowCxWebhookGenericWebService {
    /**
    * Specifies a list of allowed custom CA certificates (in DER format) for HTTPS verification.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#allowed_ca_certs DialogflowCxWebhook#allowed_ca_certs}
    */
    readonly allowedCaCerts?: string[];
    /**
    * The HTTP request headers to send together with webhook requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#request_headers DialogflowCxWebhook#request_headers}
    */
    readonly requestHeaders?: {
        [key: string]: string;
    };
    /**
    * Whether to use speech adaptation for speech recognition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#uri DialogflowCxWebhook#uri}
    */
    readonly uri: string;
}
export declare function dialogflowCxWebhookGenericWebServiceToTerraform(struct?: DialogflowCxWebhookGenericWebServiceOutputReference | DialogflowCxWebhookGenericWebService): any;
export declare class DialogflowCxWebhookGenericWebServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowCxWebhookGenericWebService | undefined;
    set internalValue(value: DialogflowCxWebhookGenericWebService | undefined);
    private _allowedCaCerts?;
    get allowedCaCerts(): string[];
    set allowedCaCerts(value: string[]);
    resetAllowedCaCerts(): void;
    get allowedCaCertsInput(): string[] | undefined;
    private _requestHeaders?;
    get requestHeaders(): {
        [key: string]: string;
    };
    set requestHeaders(value: {
        [key: string]: string;
    });
    resetRequestHeaders(): void;
    get requestHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface DialogflowCxWebhookServiceDirectoryGenericWebService {
    /**
    * Specifies a list of allowed custom CA certificates (in DER format) for HTTPS verification.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#allowed_ca_certs DialogflowCxWebhook#allowed_ca_certs}
    */
    readonly allowedCaCerts?: string[];
    /**
    * The HTTP request headers to send together with webhook requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#request_headers DialogflowCxWebhook#request_headers}
    */
    readonly requestHeaders?: {
        [key: string]: string;
    };
    /**
    * Whether to use speech adaptation for speech recognition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#uri DialogflowCxWebhook#uri}
    */
    readonly uri: string;
}
export declare function dialogflowCxWebhookServiceDirectoryGenericWebServiceToTerraform(struct?: DialogflowCxWebhookServiceDirectoryGenericWebServiceOutputReference | DialogflowCxWebhookServiceDirectoryGenericWebService): any;
export declare class DialogflowCxWebhookServiceDirectoryGenericWebServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowCxWebhookServiceDirectoryGenericWebService | undefined;
    set internalValue(value: DialogflowCxWebhookServiceDirectoryGenericWebService | undefined);
    private _allowedCaCerts?;
    get allowedCaCerts(): string[];
    set allowedCaCerts(value: string[]);
    resetAllowedCaCerts(): void;
    get allowedCaCertsInput(): string[] | undefined;
    private _requestHeaders?;
    get requestHeaders(): {
        [key: string]: string;
    };
    set requestHeaders(value: {
        [key: string]: string;
    });
    resetRequestHeaders(): void;
    get requestHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface DialogflowCxWebhookServiceDirectory {
    /**
    * The name of Service Directory service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#service DialogflowCxWebhook#service}
    */
    readonly service: string;
    /**
    * generic_web_service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#generic_web_service DialogflowCxWebhook#generic_web_service}
    */
    readonly genericWebService: DialogflowCxWebhookServiceDirectoryGenericWebService;
}
export declare function dialogflowCxWebhookServiceDirectoryToTerraform(struct?: DialogflowCxWebhookServiceDirectoryOutputReference | DialogflowCxWebhookServiceDirectory): any;
export declare class DialogflowCxWebhookServiceDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowCxWebhookServiceDirectory | undefined;
    set internalValue(value: DialogflowCxWebhookServiceDirectory | undefined);
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _genericWebService;
    get genericWebService(): DialogflowCxWebhookServiceDirectoryGenericWebServiceOutputReference;
    putGenericWebService(value: DialogflowCxWebhookServiceDirectoryGenericWebService): void;
    get genericWebServiceInput(): DialogflowCxWebhookServiceDirectoryGenericWebService | undefined;
}
export interface DialogflowCxWebhookTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#create DialogflowCxWebhook#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#delete DialogflowCxWebhook#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook#update DialogflowCxWebhook#update}
    */
    readonly update?: string;
}
export declare function dialogflowCxWebhookTimeoutsToTerraform(struct?: DialogflowCxWebhookTimeoutsOutputReference | DialogflowCxWebhookTimeouts | cdktf.IResolvable): any;
export declare class DialogflowCxWebhookTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowCxWebhookTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DialogflowCxWebhookTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook google_dialogflow_cx_webhook}
*/
export declare class DialogflowCxWebhook extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_cx_webhook";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_webhook google_dialogflow_cx_webhook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DialogflowCxWebhookConfig
    */
    constructor(scope: Construct, id: string, config: DialogflowCxWebhookConfig);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableSpellCorrection?;
    get enableSpellCorrection(): boolean | cdktf.IResolvable;
    set enableSpellCorrection(value: boolean | cdktf.IResolvable);
    resetEnableSpellCorrection(): void;
    get enableSpellCorrectionInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStackdriverLogging?;
    get enableStackdriverLogging(): boolean | cdktf.IResolvable;
    set enableStackdriverLogging(value: boolean | cdktf.IResolvable);
    resetEnableStackdriverLogging(): void;
    get enableStackdriverLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _securitySettings?;
    get securitySettings(): string;
    set securitySettings(value: string);
    resetSecuritySettings(): void;
    get securitySettingsInput(): string | undefined;
    get startFlow(): string;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _genericWebService;
    get genericWebService(): DialogflowCxWebhookGenericWebServiceOutputReference;
    putGenericWebService(value: DialogflowCxWebhookGenericWebService): void;
    resetGenericWebService(): void;
    get genericWebServiceInput(): DialogflowCxWebhookGenericWebService | undefined;
    private _serviceDirectory;
    get serviceDirectory(): DialogflowCxWebhookServiceDirectoryOutputReference;
    putServiceDirectory(value: DialogflowCxWebhookServiceDirectory): void;
    resetServiceDirectory(): void;
    get serviceDirectoryInput(): DialogflowCxWebhookServiceDirectory | undefined;
    private _timeouts;
    get timeouts(): DialogflowCxWebhookTimeoutsOutputReference;
    putTimeouts(value: DialogflowCxWebhookTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DialogflowCxWebhookTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
