import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsManagedZoneIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone_iam_member#id DnsManagedZoneIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone_iam_member#managed_zone DnsManagedZoneIamMember#managed_zone}
    */
    readonly managedZone: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone_iam_member#member DnsManagedZoneIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone_iam_member#project DnsManagedZoneIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone_iam_member#role DnsManagedZoneIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone_iam_member#condition DnsManagedZoneIamMember#condition}
    */
    readonly condition?: DnsManagedZoneIamMemberCondition;
}
export interface DnsManagedZoneIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone_iam_member#description DnsManagedZoneIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone_iam_member#expression DnsManagedZoneIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone_iam_member#title DnsManagedZoneIamMember#title}
    */
    readonly title: string;
}
export declare function dnsManagedZoneIamMemberConditionToTerraform(struct?: DnsManagedZoneIamMemberConditionOutputReference | DnsManagedZoneIamMemberCondition): any;
export declare class DnsManagedZoneIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsManagedZoneIamMemberCondition | undefined;
    set internalValue(value: DnsManagedZoneIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone_iam_member google_dns_managed_zone_iam_member}
*/
export declare class DnsManagedZoneIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dns_managed_zone_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone_iam_member google_dns_managed_zone_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsManagedZoneIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: DnsManagedZoneIamMemberConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managedZone?;
    get managedZone(): string;
    set managedZone(value: string);
    get managedZoneInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): DnsManagedZoneIamMemberConditionOutputReference;
    putCondition(value: DnsManagedZoneIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): DnsManagedZoneIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
