import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#id DnsRecordSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the zone in which this record set will reside.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#managed_zone DnsRecordSet#managed_zone}
    */
    readonly managedZone: string;
    /**
    * The DNS name this record set will apply to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#name DnsRecordSet#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#project DnsRecordSet#project}
    */
    readonly project?: string;
    /**
    * The string data for the records in this record set whose meaning depends on the DNS type. For TXT record, if the string data contains spaces, add surrounding \" if you don't want your string to get split on spaces. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add \"\" inside the Terraform configuration string (e.g. "first255characters\"\"morecharacters").
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#rrdatas DnsRecordSet#rrdatas}
    */
    readonly rrdatas?: string[];
    /**
    * The time-to-live of this record set (seconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#ttl DnsRecordSet#ttl}
    */
    readonly ttl?: number;
    /**
    * The DNS record set type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#type DnsRecordSet#type}
    */
    readonly type: string;
    /**
    * routing_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#routing_policy DnsRecordSet#routing_policy}
    */
    readonly routingPolicy?: DnsRecordSetRoutingPolicy;
}
export interface DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancers {
    /**
    * The frontend IP address of the load balancer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#ip_address DnsRecordSet#ip_address}
    */
    readonly ipAddress: string;
    /**
    * The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#ip_protocol DnsRecordSet#ip_protocol}
    */
    readonly ipProtocol: string;
    /**
    * The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#load_balancer_type DnsRecordSet#load_balancer_type}
    */
    readonly loadBalancerType: string;
    /**
    * The fully qualified url of the network in which the load balancer belongs. This should be formatted like `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#network_url DnsRecordSet#network_url}
    */
    readonly networkUrl: string;
    /**
    * The configured port of the load balancer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#port DnsRecordSet#port}
    */
    readonly port: string;
    /**
    * The ID of the project in which the load balancer belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#project DnsRecordSet#project}
    */
    readonly project: string;
    /**
    * The region of the load balancer. Only needed for regional load balancers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#region DnsRecordSet#region}
    */
    readonly region?: string;
}
export declare function dnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancersToTerraform(struct?: DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancers | cdktf.IResolvable): any;
export declare class DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancers | cdktf.IResolvable | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancers | cdktf.IResolvable | undefined);
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    get ipProtocolInput(): string | undefined;
    private _loadBalancerType?;
    get loadBalancerType(): string;
    set loadBalancerType(value: string);
    get loadBalancerTypeInput(): string | undefined;
    private _networkUrl?;
    get networkUrl(): string;
    set networkUrl(value: string);
    get networkUrlInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export declare class DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancersOutputReference;
}
export interface DnsRecordSetRoutingPolicyGeoHealthCheckedTargets {
    /**
    * internal_load_balancers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#internal_load_balancers DnsRecordSet#internal_load_balancers}
    */
    readonly internalLoadBalancers: DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancers[] | cdktf.IResolvable;
}
export declare function dnsRecordSetRoutingPolicyGeoHealthCheckedTargetsToTerraform(struct?: DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsOutputReference | DnsRecordSetRoutingPolicyGeoHealthCheckedTargets): any;
export declare class DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsRecordSetRoutingPolicyGeoHealthCheckedTargets | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyGeoHealthCheckedTargets | undefined);
    private _internalLoadBalancers;
    get internalLoadBalancers(): DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancersList;
    putInternalLoadBalancers(value: DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancers[] | cdktf.IResolvable): void;
    get internalLoadBalancersInput(): cdktf.IResolvable | DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsInternalLoadBalancers[] | undefined;
}
export interface DnsRecordSetRoutingPolicyGeo {
    /**
    * The location name defined in Google Cloud.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#location DnsRecordSet#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#rrdatas DnsRecordSet#rrdatas}
    */
    readonly rrdatas?: string[];
    /**
    * health_checked_targets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#health_checked_targets DnsRecordSet#health_checked_targets}
    */
    readonly healthCheckedTargets?: DnsRecordSetRoutingPolicyGeoHealthCheckedTargets;
}
export declare function dnsRecordSetRoutingPolicyGeoToTerraform(struct?: DnsRecordSetRoutingPolicyGeo | cdktf.IResolvable): any;
export declare class DnsRecordSetRoutingPolicyGeoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsRecordSetRoutingPolicyGeo | cdktf.IResolvable | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyGeo | cdktf.IResolvable | undefined);
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _rrdatas?;
    get rrdatas(): string[];
    set rrdatas(value: string[]);
    resetRrdatas(): void;
    get rrdatasInput(): string[] | undefined;
    private _healthCheckedTargets;
    get healthCheckedTargets(): DnsRecordSetRoutingPolicyGeoHealthCheckedTargetsOutputReference;
    putHealthCheckedTargets(value: DnsRecordSetRoutingPolicyGeoHealthCheckedTargets): void;
    resetHealthCheckedTargets(): void;
    get healthCheckedTargetsInput(): DnsRecordSetRoutingPolicyGeoHealthCheckedTargets | undefined;
}
export declare class DnsRecordSetRoutingPolicyGeoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsRecordSetRoutingPolicyGeo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsRecordSetRoutingPolicyGeoOutputReference;
}
export interface DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancers {
    /**
    * The frontend IP address of the load balancer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#ip_address DnsRecordSet#ip_address}
    */
    readonly ipAddress: string;
    /**
    * The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#ip_protocol DnsRecordSet#ip_protocol}
    */
    readonly ipProtocol: string;
    /**
    * The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#load_balancer_type DnsRecordSet#load_balancer_type}
    */
    readonly loadBalancerType: string;
    /**
    * The fully qualified url of the network in which the load balancer belongs. This should be formatted like `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#network_url DnsRecordSet#network_url}
    */
    readonly networkUrl: string;
    /**
    * The configured port of the load balancer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#port DnsRecordSet#port}
    */
    readonly port: string;
    /**
    * The ID of the project in which the load balancer belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#project DnsRecordSet#project}
    */
    readonly project: string;
    /**
    * The region of the load balancer. Only needed for regional load balancers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#region DnsRecordSet#region}
    */
    readonly region?: string;
}
export declare function dnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancersToTerraform(struct?: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancers | cdktf.IResolvable): any;
export declare class DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancers | cdktf.IResolvable | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancers | cdktf.IResolvable | undefined);
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    get ipProtocolInput(): string | undefined;
    private _loadBalancerType?;
    get loadBalancerType(): string;
    set loadBalancerType(value: string);
    get loadBalancerTypeInput(): string | undefined;
    private _networkUrl?;
    get networkUrl(): string;
    set networkUrl(value: string);
    get networkUrlInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export declare class DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancersOutputReference;
}
export interface DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets {
    /**
    * internal_load_balancers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#internal_load_balancers DnsRecordSet#internal_load_balancers}
    */
    readonly internalLoadBalancers: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancers[] | cdktf.IResolvable;
}
export declare function dnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsToTerraform(struct?: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsOutputReference | DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets): any;
export declare class DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets | undefined);
    private _internalLoadBalancers;
    get internalLoadBalancers(): DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancersList;
    putInternalLoadBalancers(value: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancers[] | cdktf.IResolvable): void;
    get internalLoadBalancersInput(): cdktf.IResolvable | DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsInternalLoadBalancers[] | undefined;
}
export interface DnsRecordSetRoutingPolicyPrimaryBackupBackupGeo {
    /**
    * The location name defined in Google Cloud.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#location DnsRecordSet#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#rrdatas DnsRecordSet#rrdatas}
    */
    readonly rrdatas?: string[];
    /**
    * health_checked_targets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#health_checked_targets DnsRecordSet#health_checked_targets}
    */
    readonly healthCheckedTargets?: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets;
}
export declare function dnsRecordSetRoutingPolicyPrimaryBackupBackupGeoToTerraform(struct?: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeo | cdktf.IResolvable): any;
export declare class DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsRecordSetRoutingPolicyPrimaryBackupBackupGeo | cdktf.IResolvable | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeo | cdktf.IResolvable | undefined);
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _rrdatas?;
    get rrdatas(): string[];
    set rrdatas(value: string[]);
    resetRrdatas(): void;
    get rrdatasInput(): string[] | undefined;
    private _healthCheckedTargets;
    get healthCheckedTargets(): DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargetsOutputReference;
    putHealthCheckedTargets(value: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets): void;
    resetHealthCheckedTargets(): void;
    get healthCheckedTargetsInput(): DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoHealthCheckedTargets | undefined;
}
export declare class DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoOutputReference;
}
export interface DnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancers {
    /**
    * The frontend IP address of the load balancer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#ip_address DnsRecordSet#ip_address}
    */
    readonly ipAddress: string;
    /**
    * The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#ip_protocol DnsRecordSet#ip_protocol}
    */
    readonly ipProtocol: string;
    /**
    * The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#load_balancer_type DnsRecordSet#load_balancer_type}
    */
    readonly loadBalancerType: string;
    /**
    * The fully qualified url of the network in which the load balancer belongs. This should be formatted like `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#network_url DnsRecordSet#network_url}
    */
    readonly networkUrl: string;
    /**
    * The configured port of the load balancer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#port DnsRecordSet#port}
    */
    readonly port: string;
    /**
    * The ID of the project in which the load balancer belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#project DnsRecordSet#project}
    */
    readonly project: string;
    /**
    * The region of the load balancer. Only needed for regional load balancers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#region DnsRecordSet#region}
    */
    readonly region?: string;
}
export declare function dnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancersToTerraform(struct?: DnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancers | cdktf.IResolvable): any;
export declare class DnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancers | cdktf.IResolvable | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancers | cdktf.IResolvable | undefined);
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    get ipProtocolInput(): string | undefined;
    private _loadBalancerType?;
    get loadBalancerType(): string;
    set loadBalancerType(value: string);
    get loadBalancerTypeInput(): string | undefined;
    private _networkUrl?;
    get networkUrl(): string;
    set networkUrl(value: string);
    get networkUrlInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export declare class DnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancersOutputReference;
}
export interface DnsRecordSetRoutingPolicyPrimaryBackupPrimary {
    /**
    * internal_load_balancers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#internal_load_balancers DnsRecordSet#internal_load_balancers}
    */
    readonly internalLoadBalancers: DnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancers[] | cdktf.IResolvable;
}
export declare function dnsRecordSetRoutingPolicyPrimaryBackupPrimaryToTerraform(struct?: DnsRecordSetRoutingPolicyPrimaryBackupPrimaryOutputReference | DnsRecordSetRoutingPolicyPrimaryBackupPrimary): any;
export declare class DnsRecordSetRoutingPolicyPrimaryBackupPrimaryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsRecordSetRoutingPolicyPrimaryBackupPrimary | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyPrimaryBackupPrimary | undefined);
    private _internalLoadBalancers;
    get internalLoadBalancers(): DnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancersList;
    putInternalLoadBalancers(value: DnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancers[] | cdktf.IResolvable): void;
    get internalLoadBalancersInput(): cdktf.IResolvable | DnsRecordSetRoutingPolicyPrimaryBackupPrimaryInternalLoadBalancers[] | undefined;
}
export interface DnsRecordSetRoutingPolicyPrimaryBackup {
    /**
    * Specifies whether to enable fencing for backup geo queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#enable_geo_fencing_for_backups DnsRecordSet#enable_geo_fencing_for_backups}
    */
    readonly enableGeoFencingForBackups?: boolean | cdktf.IResolvable;
    /**
    * Specifies the percentage of traffic to send to the backup targets even when the primary targets are healthy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#trickle_ratio DnsRecordSet#trickle_ratio}
    */
    readonly trickleRatio?: number;
    /**
    * backup_geo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#backup_geo DnsRecordSet#backup_geo}
    */
    readonly backupGeo: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeo[] | cdktf.IResolvable;
    /**
    * primary block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#primary DnsRecordSet#primary}
    */
    readonly primary: DnsRecordSetRoutingPolicyPrimaryBackupPrimary;
}
export declare function dnsRecordSetRoutingPolicyPrimaryBackupToTerraform(struct?: DnsRecordSetRoutingPolicyPrimaryBackupOutputReference | DnsRecordSetRoutingPolicyPrimaryBackup): any;
export declare class DnsRecordSetRoutingPolicyPrimaryBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsRecordSetRoutingPolicyPrimaryBackup | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyPrimaryBackup | undefined);
    private _enableGeoFencingForBackups?;
    get enableGeoFencingForBackups(): boolean | cdktf.IResolvable;
    set enableGeoFencingForBackups(value: boolean | cdktf.IResolvable);
    resetEnableGeoFencingForBackups(): void;
    get enableGeoFencingForBackupsInput(): boolean | cdktf.IResolvable | undefined;
    private _trickleRatio?;
    get trickleRatio(): number;
    set trickleRatio(value: number);
    resetTrickleRatio(): void;
    get trickleRatioInput(): number | undefined;
    private _backupGeo;
    get backupGeo(): DnsRecordSetRoutingPolicyPrimaryBackupBackupGeoList;
    putBackupGeo(value: DnsRecordSetRoutingPolicyPrimaryBackupBackupGeo[] | cdktf.IResolvable): void;
    get backupGeoInput(): cdktf.IResolvable | DnsRecordSetRoutingPolicyPrimaryBackupBackupGeo[] | undefined;
    private _primary;
    get primary(): DnsRecordSetRoutingPolicyPrimaryBackupPrimaryOutputReference;
    putPrimary(value: DnsRecordSetRoutingPolicyPrimaryBackupPrimary): void;
    get primaryInput(): DnsRecordSetRoutingPolicyPrimaryBackupPrimary | undefined;
}
export interface DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancers {
    /**
    * The frontend IP address of the load balancer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#ip_address DnsRecordSet#ip_address}
    */
    readonly ipAddress: string;
    /**
    * The configured IP protocol of the load balancer. This value is case-sensitive. Possible values: ["tcp", "udp"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#ip_protocol DnsRecordSet#ip_protocol}
    */
    readonly ipProtocol: string;
    /**
    * The type of load balancer. This value is case-sensitive. Possible values: ["regionalL4ilb"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#load_balancer_type DnsRecordSet#load_balancer_type}
    */
    readonly loadBalancerType: string;
    /**
    * The fully qualified url of the network in which the load balancer belongs. This should be formatted like `https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#network_url DnsRecordSet#network_url}
    */
    readonly networkUrl: string;
    /**
    * The configured port of the load balancer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#port DnsRecordSet#port}
    */
    readonly port: string;
    /**
    * The ID of the project in which the load balancer belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#project DnsRecordSet#project}
    */
    readonly project: string;
    /**
    * The region of the load balancer. Only needed for regional load balancers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#region DnsRecordSet#region}
    */
    readonly region?: string;
}
export declare function dnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancersToTerraform(struct?: DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancers | cdktf.IResolvable): any;
export declare class DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancers | cdktf.IResolvable | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancers | cdktf.IResolvable | undefined);
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    get ipProtocolInput(): string | undefined;
    private _loadBalancerType?;
    get loadBalancerType(): string;
    set loadBalancerType(value: string);
    get loadBalancerTypeInput(): string | undefined;
    private _networkUrl?;
    get networkUrl(): string;
    set networkUrl(value: string);
    get networkUrlInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export declare class DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancersOutputReference;
}
export interface DnsRecordSetRoutingPolicyWrrHealthCheckedTargets {
    /**
    * internal_load_balancers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#internal_load_balancers DnsRecordSet#internal_load_balancers}
    */
    readonly internalLoadBalancers: DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancers[] | cdktf.IResolvable;
}
export declare function dnsRecordSetRoutingPolicyWrrHealthCheckedTargetsToTerraform(struct?: DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsOutputReference | DnsRecordSetRoutingPolicyWrrHealthCheckedTargets): any;
export declare class DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsRecordSetRoutingPolicyWrrHealthCheckedTargets | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyWrrHealthCheckedTargets | undefined);
    private _internalLoadBalancers;
    get internalLoadBalancers(): DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancersList;
    putInternalLoadBalancers(value: DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancers[] | cdktf.IResolvable): void;
    get internalLoadBalancersInput(): cdktf.IResolvable | DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsInternalLoadBalancers[] | undefined;
}
export interface DnsRecordSetRoutingPolicyWrr {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#rrdatas DnsRecordSet#rrdatas}
    */
    readonly rrdatas?: string[];
    /**
    * The ratio of traffic routed to the target.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#weight DnsRecordSet#weight}
    */
    readonly weight: number;
    /**
    * health_checked_targets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#health_checked_targets DnsRecordSet#health_checked_targets}
    */
    readonly healthCheckedTargets?: DnsRecordSetRoutingPolicyWrrHealthCheckedTargets;
}
export declare function dnsRecordSetRoutingPolicyWrrToTerraform(struct?: DnsRecordSetRoutingPolicyWrr | cdktf.IResolvable): any;
export declare class DnsRecordSetRoutingPolicyWrrOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsRecordSetRoutingPolicyWrr | cdktf.IResolvable | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyWrr | cdktf.IResolvable | undefined);
    private _rrdatas?;
    get rrdatas(): string[];
    set rrdatas(value: string[]);
    resetRrdatas(): void;
    get rrdatasInput(): string[] | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _healthCheckedTargets;
    get healthCheckedTargets(): DnsRecordSetRoutingPolicyWrrHealthCheckedTargetsOutputReference;
    putHealthCheckedTargets(value: DnsRecordSetRoutingPolicyWrrHealthCheckedTargets): void;
    resetHealthCheckedTargets(): void;
    get healthCheckedTargetsInput(): DnsRecordSetRoutingPolicyWrrHealthCheckedTargets | undefined;
}
export declare class DnsRecordSetRoutingPolicyWrrList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsRecordSetRoutingPolicyWrr[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsRecordSetRoutingPolicyWrrOutputReference;
}
export interface DnsRecordSetRoutingPolicy {
    /**
    * Specifies whether to enable fencing for geo queries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#enable_geo_fencing DnsRecordSet#enable_geo_fencing}
    */
    readonly enableGeoFencing?: boolean | cdktf.IResolvable;
    /**
    * geo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#geo DnsRecordSet#geo}
    */
    readonly geo?: DnsRecordSetRoutingPolicyGeo[] | cdktf.IResolvable;
    /**
    * primary_backup block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#primary_backup DnsRecordSet#primary_backup}
    */
    readonly primaryBackup?: DnsRecordSetRoutingPolicyPrimaryBackup;
    /**
    * wrr block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#wrr DnsRecordSet#wrr}
    */
    readonly wrr?: DnsRecordSetRoutingPolicyWrr[] | cdktf.IResolvable;
}
export declare function dnsRecordSetRoutingPolicyToTerraform(struct?: DnsRecordSetRoutingPolicyOutputReference | DnsRecordSetRoutingPolicy): any;
export declare class DnsRecordSetRoutingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsRecordSetRoutingPolicy | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicy | undefined);
    private _enableGeoFencing?;
    get enableGeoFencing(): boolean | cdktf.IResolvable;
    set enableGeoFencing(value: boolean | cdktf.IResolvable);
    resetEnableGeoFencing(): void;
    get enableGeoFencingInput(): boolean | cdktf.IResolvable | undefined;
    private _geo;
    get geo(): DnsRecordSetRoutingPolicyGeoList;
    putGeo(value: DnsRecordSetRoutingPolicyGeo[] | cdktf.IResolvable): void;
    resetGeo(): void;
    get geoInput(): cdktf.IResolvable | DnsRecordSetRoutingPolicyGeo[] | undefined;
    private _primaryBackup;
    get primaryBackup(): DnsRecordSetRoutingPolicyPrimaryBackupOutputReference;
    putPrimaryBackup(value: DnsRecordSetRoutingPolicyPrimaryBackup): void;
    resetPrimaryBackup(): void;
    get primaryBackupInput(): DnsRecordSetRoutingPolicyPrimaryBackup | undefined;
    private _wrr;
    get wrr(): DnsRecordSetRoutingPolicyWrrList;
    putWrr(value: DnsRecordSetRoutingPolicyWrr[] | cdktf.IResolvable): void;
    resetWrr(): void;
    get wrrInput(): cdktf.IResolvable | DnsRecordSetRoutingPolicyWrr[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_record_set google_dns_record_set}
*/
export declare class DnsRecordSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dns_record_set";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_record_set google_dns_record_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsRecordSetConfig
    */
    constructor(scope: Construct, id: string, config: DnsRecordSetConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managedZone?;
    get managedZone(): string;
    set managedZone(value: string);
    get managedZoneInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _rrdatas?;
    get rrdatas(): string[];
    set rrdatas(value: string[]);
    resetRrdatas(): void;
    get rrdatasInput(): string[] | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _routingPolicy;
    get routingPolicy(): DnsRecordSetRoutingPolicyOutputReference;
    putRoutingPolicy(value: DnsRecordSetRoutingPolicy): void;
    resetRoutingPolicy(): void;
    get routingPolicyInput(): DnsRecordSetRoutingPolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
