import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventarcGoogleChannelConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*\/locations/*\/keyRings/*\/cryptoKeys/*`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_google_channel_config#crypto_key_name EventarcGoogleChannelConfig#crypto_key_name}
    */
    readonly cryptoKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_google_channel_config#id EventarcGoogleChannelConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_google_channel_config#location EventarcGoogleChannelConfig#location}
    */
    readonly location: string;
    /**
    * Required. The resource name of the config. Must be in the format of, `projects/{project}/locations/{location}/googleChannelConfig`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_google_channel_config#name EventarcGoogleChannelConfig#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_google_channel_config#project EventarcGoogleChannelConfig#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_google_channel_config#timeouts EventarcGoogleChannelConfig#timeouts}
    */
    readonly timeouts?: EventarcGoogleChannelConfigTimeouts;
}
export interface EventarcGoogleChannelConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_google_channel_config#create EventarcGoogleChannelConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_google_channel_config#delete EventarcGoogleChannelConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_google_channel_config#update EventarcGoogleChannelConfig#update}
    */
    readonly update?: string;
}
export declare function eventarcGoogleChannelConfigTimeoutsToTerraform(struct?: EventarcGoogleChannelConfigTimeoutsOutputReference | EventarcGoogleChannelConfigTimeouts | cdktf.IResolvable): any;
export declare class EventarcGoogleChannelConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventarcGoogleChannelConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EventarcGoogleChannelConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/eventarc_google_channel_config google_eventarc_google_channel_config}
*/
export declare class EventarcGoogleChannelConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_eventarc_google_channel_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/eventarc_google_channel_config google_eventarc_google_channel_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventarcGoogleChannelConfigConfig
    */
    constructor(scope: Construct, id: string, config: EventarcGoogleChannelConfigConfig);
    private _cryptoKeyName?;
    get cryptoKeyName(): string;
    set cryptoKeyName(value: string);
    resetCryptoKeyName(): void;
    get cryptoKeyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): EventarcGoogleChannelConfigTimeoutsOutputReference;
    putTimeouts(value: EventarcGoogleChannelConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EventarcGoogleChannelConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
