import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirestoreIndexConfig extends cdktf.TerraformMetaArguments {
    /**
    * The collection being indexed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#collection FirestoreIndex#collection}
    */
    readonly collection: string;
    /**
    * The Firestore database id. Defaults to '"(default)"'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#database FirestoreIndex#database}
    */
    readonly database?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#id FirestoreIndex#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#project FirestoreIndex#project}
    */
    readonly project?: string;
    /**
    * The scope at which a query is run. Default value: "COLLECTION" Possible values: ["COLLECTION", "COLLECTION_GROUP"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#query_scope FirestoreIndex#query_scope}
    */
    readonly queryScope?: string;
    /**
    * fields block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#fields FirestoreIndex#fields}
    */
    readonly fields: FirestoreIndexFields[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#timeouts FirestoreIndex#timeouts}
    */
    readonly timeouts?: FirestoreIndexTimeouts;
}
export interface FirestoreIndexFields {
    /**
    * Indicates that this field supports operations on arrayValues. Only one of 'order' and 'arrayConfig' can
  be specified. Possible values: ["CONTAINS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#array_config FirestoreIndex#array_config}
    */
    readonly arrayConfig?: string;
    /**
    * Name of the field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#field_path FirestoreIndex#field_path}
    */
    readonly fieldPath?: string;
    /**
    * Indicates that this field supports ordering by the specified order or comparing using =, <, <=, >, >=.
  Only one of 'order' and 'arrayConfig' can be specified. Possible values: ["ASCENDING", "DESCENDING"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#order FirestoreIndex#order}
    */
    readonly order?: string;
}
export declare function firestoreIndexFieldsToTerraform(struct?: FirestoreIndexFields | cdktf.IResolvable): any;
export declare class FirestoreIndexFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirestoreIndexFields | cdktf.IResolvable | undefined;
    set internalValue(value: FirestoreIndexFields | cdktf.IResolvable | undefined);
    private _arrayConfig?;
    get arrayConfig(): string;
    set arrayConfig(value: string);
    resetArrayConfig(): void;
    get arrayConfigInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
}
export declare class FirestoreIndexFieldsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FirestoreIndexFields[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirestoreIndexFieldsOutputReference;
}
export interface FirestoreIndexTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#create FirestoreIndex#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index#delete FirestoreIndex#delete}
    */
    readonly delete?: string;
}
export declare function firestoreIndexTimeoutsToTerraform(struct?: FirestoreIndexTimeoutsOutputReference | FirestoreIndexTimeouts | cdktf.IResolvable): any;
export declare class FirestoreIndexTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirestoreIndexTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FirestoreIndexTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/firestore_index google_firestore_index}
*/
export declare class FirestoreIndex extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firestore_index";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/firestore_index google_firestore_index} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirestoreIndexConfig
    */
    constructor(scope: Construct, id: string, config: FirestoreIndexConfig);
    private _collection?;
    get collection(): string;
    set collection(value: string);
    get collectionInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _queryScope?;
    get queryScope(): string;
    set queryScope(value: string);
    resetQueryScope(): void;
    get queryScopeInput(): string | undefined;
    private _fields;
    get fields(): FirestoreIndexFieldsList;
    putFields(value: FirestoreIndexFields[] | cdktf.IResolvable): void;
    get fieldsInput(): cdktf.IResolvable | FirestoreIndexFields[] | undefined;
    private _timeouts;
    get timeouts(): FirestoreIndexTimeoutsOutputReference;
    putTimeouts(value: FirestoreIndexTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FirestoreIndexTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
