import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareDatasetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset#id HealthcareDataset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the Dataset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset#location HealthcareDataset#location}
    */
    readonly location: string;
    /**
    * The resource name for the Dataset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset#name HealthcareDataset#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset#project HealthcareDataset#project}
    */
    readonly project?: string;
    /**
    * The default timezone used by this dataset. Must be a either a valid IANA time zone name such as
  "America/New_York" or empty, which defaults to UTC. This is used for parsing times in resources
  (e.g., HL7 messages) where no explicit timezone is specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset#time_zone HealthcareDataset#time_zone}
    */
    readonly timeZone?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset#timeouts HealthcareDataset#timeouts}
    */
    readonly timeouts?: HealthcareDatasetTimeouts;
}
export interface HealthcareDatasetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset#create HealthcareDataset#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset#delete HealthcareDataset#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset#update HealthcareDataset#update}
    */
    readonly update?: string;
}
export declare function healthcareDatasetTimeoutsToTerraform(struct?: HealthcareDatasetTimeoutsOutputReference | HealthcareDatasetTimeouts | cdktf.IResolvable): any;
export declare class HealthcareDatasetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HealthcareDatasetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: HealthcareDatasetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset google_healthcare_dataset}
*/
export declare class HealthcareDataset extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_dataset";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset google_healthcare_dataset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HealthcareDatasetConfig
    */
    constructor(scope: Construct, id: string, config: HealthcareDatasetConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _timeouts;
    get timeouts(): HealthcareDatasetTimeoutsOutputReference;
    putTimeouts(value: HealthcareDatasetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | HealthcareDatasetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
