import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IamAccessBoundaryPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name of the rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#display_name IamAccessBoundaryPolicy#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#id IamAccessBoundaryPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#name IamAccessBoundaryPolicy#name}
    */
    readonly name: string;
    /**
    * The attachment point is identified by its URL-encoded full resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#parent IamAccessBoundaryPolicy#parent}
    */
    readonly parent: string;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#rules IamAccessBoundaryPolicy#rules}
    */
    readonly rules: IamAccessBoundaryPolicyRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#timeouts IamAccessBoundaryPolicy#timeouts}
    */
    readonly timeouts?: IamAccessBoundaryPolicyTimeouts;
}
export interface IamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition {
    /**
    * Description of the expression. This is a longer text which describes the expression,
  e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#description IamAccessBoundaryPolicy#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#expression IamAccessBoundaryPolicy#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting,
  e.g. a file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#location IamAccessBoundaryPolicy#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
  This can be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#title IamAccessBoundaryPolicy#title}
    */
    readonly title?: string;
}
export declare function iamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityConditionToTerraform(struct?: IamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityConditionOutputReference | IamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition): any;
export declare class IamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition | undefined;
    set internalValue(value: IamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface IamAccessBoundaryPolicyRulesAccessBoundaryRule {
    /**
    * A list of permissions that may be allowed for use on the specified resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#available_permissions IamAccessBoundaryPolicy#available_permissions}
    */
    readonly availablePermissions?: string[];
    /**
    * The full resource name of a Google Cloud resource entity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#available_resource IamAccessBoundaryPolicy#available_resource}
    */
    readonly availableResource?: string;
    /**
    * availability_condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#availability_condition IamAccessBoundaryPolicy#availability_condition}
    */
    readonly availabilityCondition?: IamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition;
}
export declare function iamAccessBoundaryPolicyRulesAccessBoundaryRuleToTerraform(struct?: IamAccessBoundaryPolicyRulesAccessBoundaryRuleOutputReference | IamAccessBoundaryPolicyRulesAccessBoundaryRule): any;
export declare class IamAccessBoundaryPolicyRulesAccessBoundaryRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IamAccessBoundaryPolicyRulesAccessBoundaryRule | undefined;
    set internalValue(value: IamAccessBoundaryPolicyRulesAccessBoundaryRule | undefined);
    private _availablePermissions?;
    get availablePermissions(): string[];
    set availablePermissions(value: string[]);
    resetAvailablePermissions(): void;
    get availablePermissionsInput(): string[] | undefined;
    private _availableResource?;
    get availableResource(): string;
    set availableResource(value: string);
    resetAvailableResource(): void;
    get availableResourceInput(): string | undefined;
    private _availabilityCondition;
    get availabilityCondition(): IamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityConditionOutputReference;
    putAvailabilityCondition(value: IamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition): void;
    resetAvailabilityCondition(): void;
    get availabilityConditionInput(): IamAccessBoundaryPolicyRulesAccessBoundaryRuleAvailabilityCondition | undefined;
}
export interface IamAccessBoundaryPolicyRules {
    /**
    * The description of the rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#description IamAccessBoundaryPolicy#description}
    */
    readonly description?: string;
    /**
    * access_boundary_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#access_boundary_rule IamAccessBoundaryPolicy#access_boundary_rule}
    */
    readonly accessBoundaryRule?: IamAccessBoundaryPolicyRulesAccessBoundaryRule;
}
export declare function iamAccessBoundaryPolicyRulesToTerraform(struct?: IamAccessBoundaryPolicyRules | cdktf.IResolvable): any;
export declare class IamAccessBoundaryPolicyRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IamAccessBoundaryPolicyRules | cdktf.IResolvable | undefined;
    set internalValue(value: IamAccessBoundaryPolicyRules | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _accessBoundaryRule;
    get accessBoundaryRule(): IamAccessBoundaryPolicyRulesAccessBoundaryRuleOutputReference;
    putAccessBoundaryRule(value: IamAccessBoundaryPolicyRulesAccessBoundaryRule): void;
    resetAccessBoundaryRule(): void;
    get accessBoundaryRuleInput(): IamAccessBoundaryPolicyRulesAccessBoundaryRule | undefined;
}
export declare class IamAccessBoundaryPolicyRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: IamAccessBoundaryPolicyRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IamAccessBoundaryPolicyRulesOutputReference;
}
export interface IamAccessBoundaryPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#create IamAccessBoundaryPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#delete IamAccessBoundaryPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy#update IamAccessBoundaryPolicy#update}
    */
    readonly update?: string;
}
export declare function iamAccessBoundaryPolicyTimeoutsToTerraform(struct?: IamAccessBoundaryPolicyTimeoutsOutputReference | IamAccessBoundaryPolicyTimeouts | cdktf.IResolvable): any;
export declare class IamAccessBoundaryPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IamAccessBoundaryPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IamAccessBoundaryPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy google_iam_access_boundary_policy}
*/
export declare class IamAccessBoundaryPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iam_access_boundary_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iam_access_boundary_policy google_iam_access_boundary_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IamAccessBoundaryPolicyConfig
    */
    constructor(scope: Construct, id: string, config: IamAccessBoundaryPolicyConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _rules;
    get rules(): IamAccessBoundaryPolicyRulesList;
    putRules(value: IamAccessBoundaryPolicyRules[] | cdktf.IResolvable): void;
    get rulesInput(): cdktf.IResolvable | IamAccessBoundaryPolicyRules[] | undefined;
    private _timeouts;
    get timeouts(): IamAccessBoundaryPolicyTimeoutsOutputReference;
    putTimeouts(value: IamAccessBoundaryPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IamAccessBoundaryPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
