import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IamWorkforcePoolProviderConfig extends cdktf.TerraformMetaArguments {
    /**
    * A [Common Expression Language](https://opensource.google/projects/cel) expression, in
  plain text, to restrict what otherwise valid authentication credentials issued by the
  provider should not be accepted.
  
  The expression must output a boolean representing whether to allow the federation.
  
  The following keywords may be referenced in the expressions:
    * 'assertion': JSON representing the authentication credential issued by the provider.
    * 'google': The Google attributes mapped from the assertion in the 'attribute_mappings'.
      'google.profile_photo' and 'google.display_name' are not supported.
    * 'attribute': The custom attributes mapped from the assertion in the 'attribute_mappings'.
  
  The maximum length of the attribute condition expression is 4096 characters.
  If unspecified, all valid authentication credentials will be accepted.
  
  The following example shows how to only allow credentials with a mapped 'google.groups' value of 'admins':
  ```
  "'admins' in google.groups"
  ```
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#attribute_condition IamWorkforcePoolProvider#attribute_condition}
    */
    readonly attributeCondition?: string;
    /**
    * Maps attributes from the authentication credentials issued by an external identity provider
  to Google Cloud attributes, such as 'subject' and 'segment'.
  
  Each key must be a string specifying the Google Cloud IAM attribute to map to.
  
  The following keys are supported:
    * 'google.subject': The principal IAM is authenticating. You can reference this value in IAM bindings.
      This is also the subject that appears in Cloud Logging logs. This is a required field and
      the mapped subject cannot exceed 127 bytes.
    * 'google.groups': Groups the authenticating user belongs to. You can grant groups access to
      resources using an IAM 'principalSet' binding; access applies to all members of the group.
    * 'google.display_name': The name of the authenticated user. This is an optional field and
      the mapped display name cannot exceed 100 bytes. If not set, 'google.subject' will be displayed instead.
      This attribute cannot be referenced in IAM bindings.
    * 'google.profile_photo': The URL that specifies the authenticated user's thumbnail photo.
      This is an optional field. When set, the image will be visible as the user's profile picture.
      If not set, a generic user icon will be displayed instead.
      This attribute cannot be referenced in IAM bindings.
  
  You can also provide custom attributes by specifying 'attribute.{custom_attribute}', where {custom_attribute}
  is the name of the custom attribute to be mapped. You can define a maximum of 50 custom attributes.
  The maximum length of a mapped attribute key is 100 characters, and the key may only contain the characters [a-z0-9_].
  
  You can reference these attributes in IAM policies to define fine-grained access for a workforce pool
  to Google Cloud resources. For example:
    * 'google.subject':
      'principal://iam.googleapis.com/locations/{location}/workforcePools/{pool}/subject/{value}'
    * 'google.groups':
      'principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/group/{value}'
    * 'attribute.{custom_attribute}':
      'principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/attribute.{custom_attribute}/{value}'
  
  Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
  function that maps an identity provider credential to the normalized attribute specified
  by the corresponding map key.
  
  You can use the 'assertion' keyword in the expression to access a JSON representation of
  the authentication credential issued by the provider.
  
  The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
  the total size of all mapped attributes must not exceed 8KB.
  
  For OIDC providers, you must supply a custom mapping that includes the 'google.subject' attribute.
  For example, the following maps the sub claim of the incoming credential to the 'subject' attribute
  on a Google token:
  ```
  {"google.subject": "assertion.sub"}
  ```
  
  An object containing a list of '"key": value' pairs.
  Example: '{ "name": "wrench", "mass": "1.3kg", "count": "3" }'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#attribute_mapping IamWorkforcePoolProvider#attribute_mapping}
    */
    readonly attributeMapping?: {
        [key: string]: string;
    };
    /**
    * A user-specified description of the provider. Cannot exceed 256 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#description IamWorkforcePoolProvider#description}
    */
    readonly description?: string;
    /**
    * Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
  However, existing tokens still grant access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#disabled IamWorkforcePoolProvider#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * A user-specified display name for the provider. Cannot exceed 32 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#display_name IamWorkforcePoolProvider#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#id IamWorkforcePoolProvider#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#location IamWorkforcePoolProvider#location}
    */
    readonly location: string;
    /**
    * The ID for the provider, which becomes the final component of the resource name.
  This value must be 4-32 characters, and may contain the characters [a-z0-9-].
  The prefix 'gcp-' is reserved for use by Google, and may not be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#provider_id IamWorkforcePoolProvider#provider_id}
    */
    readonly providerId: string;
    /**
    * The ID to use for the pool, which becomes the final component of the resource name.
  The IDs must be a globally unique string of 6 to 63 lowercase letters, digits, or hyphens.
  It must start with a letter, and cannot have a trailing hyphen.
  The prefix 'gcp-' is reserved for use by Google, and may not be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#workforce_pool_id IamWorkforcePoolProvider#workforce_pool_id}
    */
    readonly workforcePoolId: string;
    /**
    * oidc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#oidc IamWorkforcePoolProvider#oidc}
    */
    readonly oidc?: IamWorkforcePoolProviderOidc;
    /**
    * saml block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#saml IamWorkforcePoolProvider#saml}
    */
    readonly saml?: IamWorkforcePoolProviderSaml;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#timeouts IamWorkforcePoolProvider#timeouts}
    */
    readonly timeouts?: IamWorkforcePoolProviderTimeouts;
}
export interface IamWorkforcePoolProviderOidc {
    /**
    * The client ID. Must match the audience claim of the JWT issued by the identity provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#client_id IamWorkforcePoolProvider#client_id}
    */
    readonly clientId: string;
    /**
    * The OIDC issuer URI. Must be a valid URI using the 'https' scheme.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#issuer_uri IamWorkforcePoolProvider#issuer_uri}
    */
    readonly issuerUri: string;
}
export declare function iamWorkforcePoolProviderOidcToTerraform(struct?: IamWorkforcePoolProviderOidcOutputReference | IamWorkforcePoolProviderOidc): any;
export declare class IamWorkforcePoolProviderOidcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IamWorkforcePoolProviderOidc | undefined;
    set internalValue(value: IamWorkforcePoolProviderOidc | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _issuerUri?;
    get issuerUri(): string;
    set issuerUri(value: string);
    get issuerUriInput(): string | undefined;
}
export interface IamWorkforcePoolProviderSaml {
    /**
    * SAML Identity provider configuration metadata xml doc.
  The xml document should comply with [SAML 2.0 specification](https://docs.oasis-open.org/security/saml/v2.0/saml-metadata-2.0-os.pdf).
  The max size of the acceptable xml document will be bounded to 128k characters.
  
  The metadata xml document should satisfy the following constraints:
  1) Must contain an Identity Provider Entity ID.
  2) Must contain at least one non-expired signing key certificate.
  3) For each signing key:
    a) Valid from should be no more than 7 days from now.
    b) Valid to should be no more than 10 years in the future.
  4) Up to 3 IdP signing keys are allowed in the metadata xml.
  
  When updating the provider's metadata xml, at least one non-expired signing key
  must overlap with the existing metadata. This requirement is skipped if there are
  no non-expired signing keys present in the existing metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#idp_metadata_xml IamWorkforcePoolProvider#idp_metadata_xml}
    */
    readonly idpMetadataXml: string;
}
export declare function iamWorkforcePoolProviderSamlToTerraform(struct?: IamWorkforcePoolProviderSamlOutputReference | IamWorkforcePoolProviderSaml): any;
export declare class IamWorkforcePoolProviderSamlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IamWorkforcePoolProviderSaml | undefined;
    set internalValue(value: IamWorkforcePoolProviderSaml | undefined);
    private _idpMetadataXml?;
    get idpMetadataXml(): string;
    set idpMetadataXml(value: string);
    get idpMetadataXmlInput(): string | undefined;
}
export interface IamWorkforcePoolProviderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#create IamWorkforcePoolProvider#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#delete IamWorkforcePoolProvider#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider#update IamWorkforcePoolProvider#update}
    */
    readonly update?: string;
}
export declare function iamWorkforcePoolProviderTimeoutsToTerraform(struct?: IamWorkforcePoolProviderTimeoutsOutputReference | IamWorkforcePoolProviderTimeouts | cdktf.IResolvable): any;
export declare class IamWorkforcePoolProviderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IamWorkforcePoolProviderTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IamWorkforcePoolProviderTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider google_iam_workforce_pool_provider}
*/
export declare class IamWorkforcePoolProvider extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iam_workforce_pool_provider";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider google_iam_workforce_pool_provider} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IamWorkforcePoolProviderConfig
    */
    constructor(scope: Construct, id: string, config: IamWorkforcePoolProviderConfig);
    private _attributeCondition?;
    get attributeCondition(): string;
    set attributeCondition(value: string);
    resetAttributeCondition(): void;
    get attributeConditionInput(): string | undefined;
    private _attributeMapping?;
    get attributeMapping(): {
        [key: string]: string;
    };
    set attributeMapping(value: {
        [key: string]: string;
    });
    resetAttributeMapping(): void;
    get attributeMappingInput(): {
        [key: string]: string;
    } | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _providerId?;
    get providerId(): string;
    set providerId(value: string);
    get providerIdInput(): string | undefined;
    get state(): string;
    private _workforcePoolId?;
    get workforcePoolId(): string;
    set workforcePoolId(value: string);
    get workforcePoolIdInput(): string | undefined;
    private _oidc;
    get oidc(): IamWorkforcePoolProviderOidcOutputReference;
    putOidc(value: IamWorkforcePoolProviderOidc): void;
    resetOidc(): void;
    get oidcInput(): IamWorkforcePoolProviderOidc | undefined;
    private _saml;
    get saml(): IamWorkforcePoolProviderSamlOutputReference;
    putSaml(value: IamWorkforcePoolProviderSaml): void;
    resetSaml(): void;
    get samlInput(): IamWorkforcePoolProviderSaml | undefined;
    private _timeouts;
    get timeouts(): IamWorkforcePoolProviderTimeoutsOutputReference;
    putTimeouts(value: IamWorkforcePoolProviderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IamWorkforcePoolProviderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
