import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IapBrandConfig extends cdktf.TerraformMetaArguments {
    /**
    * Application name displayed on OAuth consent screen.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand#application_title IapBrand#application_title}
    */
    readonly applicationTitle: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand#id IapBrand#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand#project IapBrand#project}
    */
    readonly project?: string;
    /**
    * Support email displayed on the OAuth consent screen. Can be either a
  user or group email. When a user email is specified, the caller must
  be the user with the associated email address. When a group email is
  specified, the caller can be either a user or a service account which
  is an owner of the specified group in Cloud Identity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand#support_email IapBrand#support_email}
    */
    readonly supportEmail: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand#timeouts IapBrand#timeouts}
    */
    readonly timeouts?: IapBrandTimeouts;
}
export interface IapBrandTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand#create IapBrand#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand#delete IapBrand#delete}
    */
    readonly delete?: string;
}
export declare function iapBrandTimeoutsToTerraform(struct?: IapBrandTimeoutsOutputReference | IapBrandTimeouts | cdktf.IResolvable): any;
export declare class IapBrandTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IapBrandTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IapBrandTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_brand google_iap_brand}
*/
export declare class IapBrand extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iap_brand";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_brand google_iap_brand} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IapBrandConfig
    */
    constructor(scope: Construct, id: string, config: IapBrandConfig);
    private _applicationTitle?;
    get applicationTitle(): string;
    set applicationTitle(value: string);
    get applicationTitleInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get orgInternalOnly(): cdktf.IResolvable;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _supportEmail?;
    get supportEmail(): string;
    set supportEmail(value: string);
    get supportEmailInput(): string | undefined;
    private _timeouts;
    get timeouts(): IapBrandTimeoutsOutputReference;
    putTimeouts(value: IapBrandTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IapBrandTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
