import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityPlatformConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether anonymous users will be auto-deleted after a period of 30 days
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_config#autodelete_anonymous_users IdentityPlatformConfig#autodelete_anonymous_users}
    */
    readonly autodeleteAnonymousUsers?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_config#id IdentityPlatformConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_config#project IdentityPlatformConfig#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_config#timeouts IdentityPlatformConfig#timeouts}
    */
    readonly timeouts?: IdentityPlatformConfigTimeouts;
}
export interface IdentityPlatformConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_config#create IdentityPlatformConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_config#delete IdentityPlatformConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_config#update IdentityPlatformConfig#update}
    */
    readonly update?: string;
}
export declare function identityPlatformConfigTimeoutsToTerraform(struct?: IdentityPlatformConfigTimeoutsOutputReference | IdentityPlatformConfigTimeouts | cdktf.IResolvable): any;
export declare class IdentityPlatformConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IdentityPlatformConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IdentityPlatformConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_config google_identity_platform_config}
*/
export declare class IdentityPlatformConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_identity_platform_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_config google_identity_platform_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityPlatformConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: IdentityPlatformConfigConfig);
    private _autodeleteAnonymousUsers?;
    get autodeleteAnonymousUsers(): boolean | cdktf.IResolvable;
    set autodeleteAnonymousUsers(value: boolean | cdktf.IResolvable);
    resetAutodeleteAnonymousUsers(): void;
    get autodeleteAnonymousUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): IdentityPlatformConfigTimeoutsOutputReference;
    putTimeouts(value: IdentityPlatformConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IdentityPlatformConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
