import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityPlatformProjectDefaultConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#id IdentityPlatformProjectDefaultConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#project IdentityPlatformProjectDefaultConfig#project}
    */
    readonly project?: string;
    /**
    * sign_in block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#sign_in IdentityPlatformProjectDefaultConfig#sign_in}
    */
    readonly signIn?: IdentityPlatformProjectDefaultConfigSignIn;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#timeouts IdentityPlatformProjectDefaultConfig#timeouts}
    */
    readonly timeouts?: IdentityPlatformProjectDefaultConfigTimeouts;
}
export interface IdentityPlatformProjectDefaultConfigSignInHashConfig {
}
export declare function identityPlatformProjectDefaultConfigSignInHashConfigToTerraform(struct?: IdentityPlatformProjectDefaultConfigSignInHashConfig): any;
export declare class IdentityPlatformProjectDefaultConfigSignInHashConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IdentityPlatformProjectDefaultConfigSignInHashConfig | undefined;
    set internalValue(value: IdentityPlatformProjectDefaultConfigSignInHashConfig | undefined);
    get algorithm(): string;
    get memoryCost(): number;
    get rounds(): number;
    get saltSeparator(): string;
    get signerKey(): string;
}
export declare class IdentityPlatformProjectDefaultConfigSignInHashConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IdentityPlatformProjectDefaultConfigSignInHashConfigOutputReference;
}
export interface IdentityPlatformProjectDefaultConfigSignInAnonymous {
    /**
    * Whether anonymous user auth is enabled for the project or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#enabled IdentityPlatformProjectDefaultConfig#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function identityPlatformProjectDefaultConfigSignInAnonymousToTerraform(struct?: IdentityPlatformProjectDefaultConfigSignInAnonymousOutputReference | IdentityPlatformProjectDefaultConfigSignInAnonymous): any;
export declare class IdentityPlatformProjectDefaultConfigSignInAnonymousOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IdentityPlatformProjectDefaultConfigSignInAnonymous | undefined;
    set internalValue(value: IdentityPlatformProjectDefaultConfigSignInAnonymous | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface IdentityPlatformProjectDefaultConfigSignInEmail {
    /**
    * Whether email auth is enabled for the project or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#enabled IdentityPlatformProjectDefaultConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Whether a password is required for email auth or not. If true, both an email and
  password must be provided to sign in. If false, a user may sign in via either
  email/password or email link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#password_required IdentityPlatformProjectDefaultConfig#password_required}
    */
    readonly passwordRequired?: boolean | cdktf.IResolvable;
}
export declare function identityPlatformProjectDefaultConfigSignInEmailToTerraform(struct?: IdentityPlatformProjectDefaultConfigSignInEmailOutputReference | IdentityPlatformProjectDefaultConfigSignInEmail): any;
export declare class IdentityPlatformProjectDefaultConfigSignInEmailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IdentityPlatformProjectDefaultConfigSignInEmail | undefined;
    set internalValue(value: IdentityPlatformProjectDefaultConfigSignInEmail | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordRequired?;
    get passwordRequired(): boolean | cdktf.IResolvable;
    set passwordRequired(value: boolean | cdktf.IResolvable);
    resetPasswordRequired(): void;
    get passwordRequiredInput(): boolean | cdktf.IResolvable | undefined;
}
export interface IdentityPlatformProjectDefaultConfigSignInPhoneNumber {
    /**
    * Whether phone number auth is enabled for the project or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#enabled IdentityPlatformProjectDefaultConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * A map of <test phone number, fake code> that can be used for phone auth testing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#test_phone_numbers IdentityPlatformProjectDefaultConfig#test_phone_numbers}
    */
    readonly testPhoneNumbers?: {
        [key: string]: string;
    };
}
export declare function identityPlatformProjectDefaultConfigSignInPhoneNumberToTerraform(struct?: IdentityPlatformProjectDefaultConfigSignInPhoneNumberOutputReference | IdentityPlatformProjectDefaultConfigSignInPhoneNumber): any;
export declare class IdentityPlatformProjectDefaultConfigSignInPhoneNumberOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IdentityPlatformProjectDefaultConfigSignInPhoneNumber | undefined;
    set internalValue(value: IdentityPlatformProjectDefaultConfigSignInPhoneNumber | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _testPhoneNumbers?;
    get testPhoneNumbers(): {
        [key: string]: string;
    };
    set testPhoneNumbers(value: {
        [key: string]: string;
    });
    resetTestPhoneNumbers(): void;
    get testPhoneNumbersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface IdentityPlatformProjectDefaultConfigSignIn {
    /**
    * Whether to allow more than one account to have the same email.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#allow_duplicate_emails IdentityPlatformProjectDefaultConfig#allow_duplicate_emails}
    */
    readonly allowDuplicateEmails?: boolean | cdktf.IResolvable;
    /**
    * anonymous block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#anonymous IdentityPlatformProjectDefaultConfig#anonymous}
    */
    readonly anonymous?: IdentityPlatformProjectDefaultConfigSignInAnonymous;
    /**
    * email block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#email IdentityPlatformProjectDefaultConfig#email}
    */
    readonly email?: IdentityPlatformProjectDefaultConfigSignInEmail;
    /**
    * phone_number block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#phone_number IdentityPlatformProjectDefaultConfig#phone_number}
    */
    readonly phoneNumber?: IdentityPlatformProjectDefaultConfigSignInPhoneNumber;
}
export declare function identityPlatformProjectDefaultConfigSignInToTerraform(struct?: IdentityPlatformProjectDefaultConfigSignInOutputReference | IdentityPlatformProjectDefaultConfigSignIn): any;
export declare class IdentityPlatformProjectDefaultConfigSignInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IdentityPlatformProjectDefaultConfigSignIn | undefined;
    set internalValue(value: IdentityPlatformProjectDefaultConfigSignIn | undefined);
    private _allowDuplicateEmails?;
    get allowDuplicateEmails(): boolean | cdktf.IResolvable;
    set allowDuplicateEmails(value: boolean | cdktf.IResolvable);
    resetAllowDuplicateEmails(): void;
    get allowDuplicateEmailsInput(): boolean | cdktf.IResolvable | undefined;
    private _hashConfig;
    get hashConfig(): IdentityPlatformProjectDefaultConfigSignInHashConfigList;
    private _anonymous;
    get anonymous(): IdentityPlatformProjectDefaultConfigSignInAnonymousOutputReference;
    putAnonymous(value: IdentityPlatformProjectDefaultConfigSignInAnonymous): void;
    resetAnonymous(): void;
    get anonymousInput(): IdentityPlatformProjectDefaultConfigSignInAnonymous | undefined;
    private _email;
    get email(): IdentityPlatformProjectDefaultConfigSignInEmailOutputReference;
    putEmail(value: IdentityPlatformProjectDefaultConfigSignInEmail): void;
    resetEmail(): void;
    get emailInput(): IdentityPlatformProjectDefaultConfigSignInEmail | undefined;
    private _phoneNumber;
    get phoneNumber(): IdentityPlatformProjectDefaultConfigSignInPhoneNumberOutputReference;
    putPhoneNumber(value: IdentityPlatformProjectDefaultConfigSignInPhoneNumber): void;
    resetPhoneNumber(): void;
    get phoneNumberInput(): IdentityPlatformProjectDefaultConfigSignInPhoneNumber | undefined;
}
export interface IdentityPlatformProjectDefaultConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#create IdentityPlatformProjectDefaultConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#delete IdentityPlatformProjectDefaultConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config#update IdentityPlatformProjectDefaultConfig#update}
    */
    readonly update?: string;
}
export declare function identityPlatformProjectDefaultConfigTimeoutsToTerraform(struct?: IdentityPlatformProjectDefaultConfigTimeoutsOutputReference | IdentityPlatformProjectDefaultConfigTimeouts | cdktf.IResolvable): any;
export declare class IdentityPlatformProjectDefaultConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IdentityPlatformProjectDefaultConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IdentityPlatformProjectDefaultConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config google_identity_platform_project_default_config}
*/
export declare class IdentityPlatformProjectDefaultConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_identity_platform_project_default_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_project_default_config google_identity_platform_project_default_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityPlatformProjectDefaultConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: IdentityPlatformProjectDefaultConfigConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _signIn;
    get signIn(): IdentityPlatformProjectDefaultConfigSignInOutputReference;
    putSignIn(value: IdentityPlatformProjectDefaultConfigSignIn): void;
    resetSignIn(): void;
    get signInInput(): IdentityPlatformProjectDefaultConfigSignIn | undefined;
    private _timeouts;
    get timeouts(): IdentityPlatformProjectDefaultConfigTimeoutsOutputReference;
    putTimeouts(value: IdentityPlatformProjectDefaultConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IdentityPlatformProjectDefaultConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
