import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoggingFolderBucketConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the logging bucket. Logging automatically creates two log buckets: _Required and _Default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config#bucket_id LoggingFolderBucketConfig#bucket_id}
    */
    readonly bucketId: string;
    /**
    * An optional description for this bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config#description LoggingFolderBucketConfig#description}
    */
    readonly description?: string;
    /**
    * The parent resource that contains the logging bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config#folder LoggingFolderBucketConfig#folder}
    */
    readonly folder: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config#id LoggingFolderBucketConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config#location LoggingFolderBucketConfig#location}
    */
    readonly location: string;
    /**
    * Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config#retention_days LoggingFolderBucketConfig#retention_days}
    */
    readonly retentionDays?: number;
    /**
    * cmek_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config#cmek_settings LoggingFolderBucketConfig#cmek_settings}
    */
    readonly cmekSettings?: LoggingFolderBucketConfigCmekSettings;
}
export interface LoggingFolderBucketConfigCmekSettings {
    /**
    * The resource name for the configured Cloud KMS key.
  KMS key name format:
  "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
  To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
  The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
  See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config#kms_key_name LoggingFolderBucketConfig#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function loggingFolderBucketConfigCmekSettingsToTerraform(struct?: LoggingFolderBucketConfigCmekSettingsOutputReference | LoggingFolderBucketConfigCmekSettings): any;
export declare class LoggingFolderBucketConfigCmekSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LoggingFolderBucketConfigCmekSettings | undefined;
    set internalValue(value: LoggingFolderBucketConfigCmekSettings | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
    get kmsKeyVersionName(): string;
    get name(): string;
    get serviceAccountId(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config google_logging_folder_bucket_config}
*/
export declare class LoggingFolderBucketConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_folder_bucket_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_folder_bucket_config google_logging_folder_bucket_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoggingFolderBucketConfigConfig
    */
    constructor(scope: Construct, id: string, config: LoggingFolderBucketConfigConfig);
    private _bucketId?;
    get bucketId(): string;
    set bucketId(value: string);
    get bucketIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lifecycleState(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _retentionDays?;
    get retentionDays(): number;
    set retentionDays(value: number);
    resetRetentionDays(): void;
    get retentionDaysInput(): number | undefined;
    private _cmekSettings;
    get cmekSettings(): LoggingFolderBucketConfigCmekSettingsOutputReference;
    putCmekSettings(value: LoggingFolderBucketConfigCmekSettings): void;
    resetCmekSettings(): void;
    get cmekSettingsInput(): LoggingFolderBucketConfigCmekSettings | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
