import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitoringCustomServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name used for UI elements listing this Service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#display_name MonitoringCustomService#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#id MonitoringCustomService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#project MonitoringCustomService#project}
    */
    readonly project?: string;
    /**
    * An optional service ID to use. If not given, the server will generate a
  service ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#service_id MonitoringCustomService#service_id}
    */
    readonly serviceId?: string;
    /**
    * Labels which have been used to annotate the service. Label keys must start
  with a letter. Label keys and values may contain lowercase letters,
  numbers, underscores, and dashes. Label keys and values have a maximum
  length of 63 characters, and must be less than 128 bytes in size. Up to 64
  label entries may be stored. For labels which do not have a semantic value,
  the empty string may be supplied for the label value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#user_labels MonitoringCustomService#user_labels}
    */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
    * telemetry block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#telemetry MonitoringCustomService#telemetry}
    */
    readonly telemetry?: MonitoringCustomServiceTelemetry;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#timeouts MonitoringCustomService#timeouts}
    */
    readonly timeouts?: MonitoringCustomServiceTimeouts;
}
export interface MonitoringCustomServiceTelemetry {
    /**
    * The full name of the resource that defines this service.
  Formatted as described in
  https://cloud.google.com/apis/design/resource_names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#resource_name MonitoringCustomService#resource_name}
    */
    readonly resourceName?: string;
}
export declare function monitoringCustomServiceTelemetryToTerraform(struct?: MonitoringCustomServiceTelemetryOutputReference | MonitoringCustomServiceTelemetry): any;
export declare class MonitoringCustomServiceTelemetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringCustomServiceTelemetry | undefined;
    set internalValue(value: MonitoringCustomServiceTelemetry | undefined);
    private _resourceName?;
    get resourceName(): string;
    set resourceName(value: string);
    resetResourceName(): void;
    get resourceNameInput(): string | undefined;
}
export interface MonitoringCustomServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#create MonitoringCustomService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#delete MonitoringCustomService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#update MonitoringCustomService#update}
    */
    readonly update?: string;
}
export declare function monitoringCustomServiceTimeoutsToTerraform(struct?: MonitoringCustomServiceTimeoutsOutputReference | MonitoringCustomServiceTimeouts | cdktf.IResolvable): any;
export declare class MonitoringCustomServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringCustomServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitoringCustomServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service google_monitoring_custom_service}
*/
export declare class MonitoringCustomService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_custom_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service google_monitoring_custom_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitoringCustomServiceConfig = {}
    */
    constructor(scope: Construct, id: string, config?: MonitoringCustomServiceConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    resetServiceId(): void;
    get serviceIdInput(): string | undefined;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    };
    set userLabels(value: {
        [key: string]: string;
    });
    resetUserLabels(): void;
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _telemetry;
    get telemetry(): MonitoringCustomServiceTelemetryOutputReference;
    putTelemetry(value: MonitoringCustomServiceTelemetry): void;
    resetTelemetry(): void;
    get telemetryInput(): MonitoringCustomServiceTelemetry | undefined;
    private _timeouts;
    get timeouts(): MonitoringCustomServiceTimeoutsOutputReference;
    putTimeouts(value: MonitoringCustomServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitoringCustomServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
