import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitoringServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name used for UI elements listing this Service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_service#display_name MonitoringService#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_service#id MonitoringService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_service#project MonitoringService#project}
    */
    readonly project?: string;
    /**
    * An optional service ID to use. If not given, the server will generate a
  service ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_service#service_id MonitoringService#service_id}
    */
    readonly serviceId: string;
    /**
    * Labels which have been used to annotate the service. Label keys must start
  with a letter. Label keys and values may contain lowercase letters,
  numbers, underscores, and dashes. Label keys and values have a maximum
  length of 63 characters, and must be less than 128 bytes in size. Up to 64
  label entries may be stored. For labels which do not have a semantic value,
  the empty string may be supplied for the label value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_service#user_labels MonitoringService#user_labels}
    */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
    * basic_service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_service#basic_service MonitoringService#basic_service}
    */
    readonly basicService?: MonitoringServiceBasicService;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_service#timeouts MonitoringService#timeouts}
    */
    readonly timeouts?: MonitoringServiceTimeouts;
}
export interface MonitoringServiceTelemetry {
}
export declare function monitoringServiceTelemetryToTerraform(struct?: MonitoringServiceTelemetry): any;
export declare class MonitoringServiceTelemetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitoringServiceTelemetry | undefined;
    set internalValue(value: MonitoringServiceTelemetry | undefined);
    get resourceName(): string;
}
export declare class MonitoringServiceTelemetryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitoringServiceTelemetryOutputReference;
}
export interface MonitoringServiceBasicService {
    /**
    * Labels that specify the resource that emits the monitoring data
  which is used for SLO reporting of this 'Service'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_service#service_labels MonitoringService#service_labels}
    */
    readonly serviceLabels?: {
        [key: string]: string;
    };
    /**
    * The type of service that this basic service defines, e.g.
  APP_ENGINE service type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_service#service_type MonitoringService#service_type}
    */
    readonly serviceType?: string;
}
export declare function monitoringServiceBasicServiceToTerraform(struct?: MonitoringServiceBasicServiceOutputReference | MonitoringServiceBasicService): any;
export declare class MonitoringServiceBasicServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringServiceBasicService | undefined;
    set internalValue(value: MonitoringServiceBasicService | undefined);
    private _serviceLabels?;
    get serviceLabels(): {
        [key: string]: string;
    };
    set serviceLabels(value: {
        [key: string]: string;
    });
    resetServiceLabels(): void;
    get serviceLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _serviceType?;
    get serviceType(): string;
    set serviceType(value: string);
    resetServiceType(): void;
    get serviceTypeInput(): string | undefined;
}
export interface MonitoringServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_service#create MonitoringService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_service#delete MonitoringService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_service#update MonitoringService#update}
    */
    readonly update?: string;
}
export declare function monitoringServiceTimeoutsToTerraform(struct?: MonitoringServiceTimeoutsOutputReference | MonitoringServiceTimeouts | cdktf.IResolvable): any;
export declare class MonitoringServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitoringServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_service google_monitoring_service}
*/
export declare class MonitoringService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_service google_monitoring_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitoringServiceConfig
    */
    constructor(scope: Construct, id: string, config: MonitoringServiceConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
    private _telemetry;
    get telemetry(): MonitoringServiceTelemetryList;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    };
    set userLabels(value: {
        [key: string]: string;
    });
    resetUserLabels(): void;
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _basicService;
    get basicService(): MonitoringServiceBasicServiceOutputReference;
    putBasicService(value: MonitoringServiceBasicService): void;
    resetBasicService(): void;
    get basicServiceInput(): MonitoringServiceBasicService | undefined;
    private _timeouts;
    get timeouts(): MonitoringServiceTimeoutsOutputReference;
    putTimeouts(value: MonitoringServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitoringServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
