"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleProvider = exports.googleProviderBatchingToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function googleProviderBatchingToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enable_batching: cdktf.booleanToTerraform(struct.enableBatching),
        send_after: cdktf.stringToTerraform(struct.sendAfter),
    };
}
exports.googleProviderBatchingToTerraform = googleProviderBatchingToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google google}
*/
class GoogleProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google google} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'google',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '4.61.0',
                providerVersionConstraint: '~> 4.0'
            },
            terraformProviderSource: 'google'
        });
        this._accessApprovalCustomEndpoint = config.accessApprovalCustomEndpoint;
        this._accessContextManagerCustomEndpoint = config.accessContextManagerCustomEndpoint;
        this._accessToken = config.accessToken;
        this._activeDirectoryCustomEndpoint = config.activeDirectoryCustomEndpoint;
        this._alloydbCustomEndpoint = config.alloydbCustomEndpoint;
        this._apigeeCustomEndpoint = config.apigeeCustomEndpoint;
        this._apikeysCustomEndpoint = config.apikeysCustomEndpoint;
        this._appEngineCustomEndpoint = config.appEngineCustomEndpoint;
        this._artifactRegistryCustomEndpoint = config.artifactRegistryCustomEndpoint;
        this._assuredWorkloadsCustomEndpoint = config.assuredWorkloadsCustomEndpoint;
        this._beyondcorpCustomEndpoint = config.beyondcorpCustomEndpoint;
        this._bigQueryCustomEndpoint = config.bigQueryCustomEndpoint;
        this._bigqueryAnalyticsHubCustomEndpoint = config.bigqueryAnalyticsHubCustomEndpoint;
        this._bigqueryConnectionCustomEndpoint = config.bigqueryConnectionCustomEndpoint;
        this._bigqueryDataTransferCustomEndpoint = config.bigqueryDataTransferCustomEndpoint;
        this._bigqueryDatapolicyCustomEndpoint = config.bigqueryDatapolicyCustomEndpoint;
        this._bigqueryReservationCustomEndpoint = config.bigqueryReservationCustomEndpoint;
        this._bigtableCustomEndpoint = config.bigtableCustomEndpoint;
        this._billingCustomEndpoint = config.billingCustomEndpoint;
        this._billingProject = config.billingProject;
        this._binaryAuthorizationCustomEndpoint = config.binaryAuthorizationCustomEndpoint;
        this._certificateManagerCustomEndpoint = config.certificateManagerCustomEndpoint;
        this._cloudAssetCustomEndpoint = config.cloudAssetCustomEndpoint;
        this._cloudBillingCustomEndpoint = config.cloudBillingCustomEndpoint;
        this._cloudBuildCustomEndpoint = config.cloudBuildCustomEndpoint;
        this._cloudBuildWorkerPoolCustomEndpoint = config.cloudBuildWorkerPoolCustomEndpoint;
        this._cloudFunctionsCustomEndpoint = config.cloudFunctionsCustomEndpoint;
        this._cloudIdentityCustomEndpoint = config.cloudIdentityCustomEndpoint;
        this._cloudIdsCustomEndpoint = config.cloudIdsCustomEndpoint;
        this._cloudIotCustomEndpoint = config.cloudIotCustomEndpoint;
        this._cloudResourceManagerCustomEndpoint = config.cloudResourceManagerCustomEndpoint;
        this._cloudRunCustomEndpoint = config.cloudRunCustomEndpoint;
        this._cloudRunV2CustomEndpoint = config.cloudRunV2CustomEndpoint;
        this._cloudSchedulerCustomEndpoint = config.cloudSchedulerCustomEndpoint;
        this._cloudTasksCustomEndpoint = config.cloudTasksCustomEndpoint;
        this._clouddeployCustomEndpoint = config.clouddeployCustomEndpoint;
        this._cloudfunctions2CustomEndpoint = config.cloudfunctions2CustomEndpoint;
        this._composerCustomEndpoint = config.composerCustomEndpoint;
        this._computeCustomEndpoint = config.computeCustomEndpoint;
        this._containerAnalysisCustomEndpoint = config.containerAnalysisCustomEndpoint;
        this._containerAttachedCustomEndpoint = config.containerAttachedCustomEndpoint;
        this._containerAwsCustomEndpoint = config.containerAwsCustomEndpoint;
        this._containerAzureCustomEndpoint = config.containerAzureCustomEndpoint;
        this._containerCustomEndpoint = config.containerCustomEndpoint;
        this._credentials = config.credentials;
        this._dataCatalogCustomEndpoint = config.dataCatalogCustomEndpoint;
        this._dataFusionCustomEndpoint = config.dataFusionCustomEndpoint;
        this._dataLossPreventionCustomEndpoint = config.dataLossPreventionCustomEndpoint;
        this._dataflowCustomEndpoint = config.dataflowCustomEndpoint;
        this._dataplexCustomEndpoint = config.dataplexCustomEndpoint;
        this._dataprocCustomEndpoint = config.dataprocCustomEndpoint;
        this._dataprocMetastoreCustomEndpoint = config.dataprocMetastoreCustomEndpoint;
        this._datastoreCustomEndpoint = config.datastoreCustomEndpoint;
        this._datastreamCustomEndpoint = config.datastreamCustomEndpoint;
        this._deploymentManagerCustomEndpoint = config.deploymentManagerCustomEndpoint;
        this._dialogflowCustomEndpoint = config.dialogflowCustomEndpoint;
        this._dialogflowCxCustomEndpoint = config.dialogflowCxCustomEndpoint;
        this._dnsCustomEndpoint = config.dnsCustomEndpoint;
        this._documentAiCustomEndpoint = config.documentAiCustomEndpoint;
        this._essentialContactsCustomEndpoint = config.essentialContactsCustomEndpoint;
        this._eventarcCustomEndpoint = config.eventarcCustomEndpoint;
        this._filestoreCustomEndpoint = config.filestoreCustomEndpoint;
        this._firebaserulesCustomEndpoint = config.firebaserulesCustomEndpoint;
        this._firestoreCustomEndpoint = config.firestoreCustomEndpoint;
        this._gameServicesCustomEndpoint = config.gameServicesCustomEndpoint;
        this._gkeBackupCustomEndpoint = config.gkeBackupCustomEndpoint;
        this._gkeHubCustomEndpoint = config.gkeHubCustomEndpoint;
        this._healthcareCustomEndpoint = config.healthcareCustomEndpoint;
        this._iam2CustomEndpoint = config.iam2CustomEndpoint;
        this._iamBetaCustomEndpoint = config.iamBetaCustomEndpoint;
        this._iamCredentialsCustomEndpoint = config.iamCredentialsCustomEndpoint;
        this._iamCustomEndpoint = config.iamCustomEndpoint;
        this._iamWorkforcePoolCustomEndpoint = config.iamWorkforcePoolCustomEndpoint;
        this._iapCustomEndpoint = config.iapCustomEndpoint;
        this._identityPlatformCustomEndpoint = config.identityPlatformCustomEndpoint;
        this._impersonateServiceAccount = config.impersonateServiceAccount;
        this._impersonateServiceAccountDelegates = config.impersonateServiceAccountDelegates;
        this._kmsCustomEndpoint = config.kmsCustomEndpoint;
        this._loggingCustomEndpoint = config.loggingCustomEndpoint;
        this._memcacheCustomEndpoint = config.memcacheCustomEndpoint;
        this._mlEngineCustomEndpoint = config.mlEngineCustomEndpoint;
        this._monitoringCustomEndpoint = config.monitoringCustomEndpoint;
        this._networkConnectivityCustomEndpoint = config.networkConnectivityCustomEndpoint;
        this._networkManagementCustomEndpoint = config.networkManagementCustomEndpoint;
        this._networkServicesCustomEndpoint = config.networkServicesCustomEndpoint;
        this._notebooksCustomEndpoint = config.notebooksCustomEndpoint;
        this._orgPolicyCustomEndpoint = config.orgPolicyCustomEndpoint;
        this._osConfigCustomEndpoint = config.osConfigCustomEndpoint;
        this._osLoginCustomEndpoint = config.osLoginCustomEndpoint;
        this._privatecaCustomEndpoint = config.privatecaCustomEndpoint;
        this._project = config.project;
        this._pubsubCustomEndpoint = config.pubsubCustomEndpoint;
        this._pubsubLiteCustomEndpoint = config.pubsubLiteCustomEndpoint;
        this._recaptchaEnterpriseCustomEndpoint = config.recaptchaEnterpriseCustomEndpoint;
        this._redisCustomEndpoint = config.redisCustomEndpoint;
        this._region = config.region;
        this._requestReason = config.requestReason;
        this._requestTimeout = config.requestTimeout;
        this._resourceManagerCustomEndpoint = config.resourceManagerCustomEndpoint;
        this._resourceManagerV3CustomEndpoint = config.resourceManagerV3CustomEndpoint;
        this._scopes = config.scopes;
        this._secretManagerCustomEndpoint = config.secretManagerCustomEndpoint;
        this._securityCenterCustomEndpoint = config.securityCenterCustomEndpoint;
        this._serviceManagementCustomEndpoint = config.serviceManagementCustomEndpoint;
        this._serviceNetworkingCustomEndpoint = config.serviceNetworkingCustomEndpoint;
        this._serviceUsageCustomEndpoint = config.serviceUsageCustomEndpoint;
        this._sourceRepoCustomEndpoint = config.sourceRepoCustomEndpoint;
        this._spannerCustomEndpoint = config.spannerCustomEndpoint;
        this._sqlCustomEndpoint = config.sqlCustomEndpoint;
        this._storageCustomEndpoint = config.storageCustomEndpoint;
        this._storageTransferCustomEndpoint = config.storageTransferCustomEndpoint;
        this._tagsCustomEndpoint = config.tagsCustomEndpoint;
        this._tagsLocationCustomEndpoint = config.tagsLocationCustomEndpoint;
        this._tpuCustomEndpoint = config.tpuCustomEndpoint;
        this._userProjectOverride = config.userProjectOverride;
        this._vertexAiCustomEndpoint = config.vertexAiCustomEndpoint;
        this._vpcAccessCustomEndpoint = config.vpcAccessCustomEndpoint;
        this._workflowsCustomEndpoint = config.workflowsCustomEndpoint;
        this._zone = config.zone;
        this._alias = config.alias;
        this._batching = config.batching;
    }
    get accessApprovalCustomEndpoint() {
        return this._accessApprovalCustomEndpoint;
    }
    set accessApprovalCustomEndpoint(value) {
        this._accessApprovalCustomEndpoint = value;
    }
    resetAccessApprovalCustomEndpoint() {
        this._accessApprovalCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessApprovalCustomEndpointInput() {
        return this._accessApprovalCustomEndpoint;
    }
    get accessContextManagerCustomEndpoint() {
        return this._accessContextManagerCustomEndpoint;
    }
    set accessContextManagerCustomEndpoint(value) {
        this._accessContextManagerCustomEndpoint = value;
    }
    resetAccessContextManagerCustomEndpoint() {
        this._accessContextManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessContextManagerCustomEndpointInput() {
        return this._accessContextManagerCustomEndpoint;
    }
    get accessToken() {
        return this._accessToken;
    }
    set accessToken(value) {
        this._accessToken = value;
    }
    resetAccessToken() {
        this._accessToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessTokenInput() {
        return this._accessToken;
    }
    get activeDirectoryCustomEndpoint() {
        return this._activeDirectoryCustomEndpoint;
    }
    set activeDirectoryCustomEndpoint(value) {
        this._activeDirectoryCustomEndpoint = value;
    }
    resetActiveDirectoryCustomEndpoint() {
        this._activeDirectoryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get activeDirectoryCustomEndpointInput() {
        return this._activeDirectoryCustomEndpoint;
    }
    get alloydbCustomEndpoint() {
        return this._alloydbCustomEndpoint;
    }
    set alloydbCustomEndpoint(value) {
        this._alloydbCustomEndpoint = value;
    }
    resetAlloydbCustomEndpoint() {
        this._alloydbCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get alloydbCustomEndpointInput() {
        return this._alloydbCustomEndpoint;
    }
    get apigeeCustomEndpoint() {
        return this._apigeeCustomEndpoint;
    }
    set apigeeCustomEndpoint(value) {
        this._apigeeCustomEndpoint = value;
    }
    resetApigeeCustomEndpoint() {
        this._apigeeCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apigeeCustomEndpointInput() {
        return this._apigeeCustomEndpoint;
    }
    get apikeysCustomEndpoint() {
        return this._apikeysCustomEndpoint;
    }
    set apikeysCustomEndpoint(value) {
        this._apikeysCustomEndpoint = value;
    }
    resetApikeysCustomEndpoint() {
        this._apikeysCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apikeysCustomEndpointInput() {
        return this._apikeysCustomEndpoint;
    }
    get appEngineCustomEndpoint() {
        return this._appEngineCustomEndpoint;
    }
    set appEngineCustomEndpoint(value) {
        this._appEngineCustomEndpoint = value;
    }
    resetAppEngineCustomEndpoint() {
        this._appEngineCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get appEngineCustomEndpointInput() {
        return this._appEngineCustomEndpoint;
    }
    get artifactRegistryCustomEndpoint() {
        return this._artifactRegistryCustomEndpoint;
    }
    set artifactRegistryCustomEndpoint(value) {
        this._artifactRegistryCustomEndpoint = value;
    }
    resetArtifactRegistryCustomEndpoint() {
        this._artifactRegistryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get artifactRegistryCustomEndpointInput() {
        return this._artifactRegistryCustomEndpoint;
    }
    get assuredWorkloadsCustomEndpoint() {
        return this._assuredWorkloadsCustomEndpoint;
    }
    set assuredWorkloadsCustomEndpoint(value) {
        this._assuredWorkloadsCustomEndpoint = value;
    }
    resetAssuredWorkloadsCustomEndpoint() {
        this._assuredWorkloadsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assuredWorkloadsCustomEndpointInput() {
        return this._assuredWorkloadsCustomEndpoint;
    }
    get beyondcorpCustomEndpoint() {
        return this._beyondcorpCustomEndpoint;
    }
    set beyondcorpCustomEndpoint(value) {
        this._beyondcorpCustomEndpoint = value;
    }
    resetBeyondcorpCustomEndpoint() {
        this._beyondcorpCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get beyondcorpCustomEndpointInput() {
        return this._beyondcorpCustomEndpoint;
    }
    get bigQueryCustomEndpoint() {
        return this._bigQueryCustomEndpoint;
    }
    set bigQueryCustomEndpoint(value) {
        this._bigQueryCustomEndpoint = value;
    }
    resetBigQueryCustomEndpoint() {
        this._bigQueryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigQueryCustomEndpointInput() {
        return this._bigQueryCustomEndpoint;
    }
    get bigqueryAnalyticsHubCustomEndpoint() {
        return this._bigqueryAnalyticsHubCustomEndpoint;
    }
    set bigqueryAnalyticsHubCustomEndpoint(value) {
        this._bigqueryAnalyticsHubCustomEndpoint = value;
    }
    resetBigqueryAnalyticsHubCustomEndpoint() {
        this._bigqueryAnalyticsHubCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryAnalyticsHubCustomEndpointInput() {
        return this._bigqueryAnalyticsHubCustomEndpoint;
    }
    get bigqueryConnectionCustomEndpoint() {
        return this._bigqueryConnectionCustomEndpoint;
    }
    set bigqueryConnectionCustomEndpoint(value) {
        this._bigqueryConnectionCustomEndpoint = value;
    }
    resetBigqueryConnectionCustomEndpoint() {
        this._bigqueryConnectionCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryConnectionCustomEndpointInput() {
        return this._bigqueryConnectionCustomEndpoint;
    }
    get bigqueryDataTransferCustomEndpoint() {
        return this._bigqueryDataTransferCustomEndpoint;
    }
    set bigqueryDataTransferCustomEndpoint(value) {
        this._bigqueryDataTransferCustomEndpoint = value;
    }
    resetBigqueryDataTransferCustomEndpoint() {
        this._bigqueryDataTransferCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryDataTransferCustomEndpointInput() {
        return this._bigqueryDataTransferCustomEndpoint;
    }
    get bigqueryDatapolicyCustomEndpoint() {
        return this._bigqueryDatapolicyCustomEndpoint;
    }
    set bigqueryDatapolicyCustomEndpoint(value) {
        this._bigqueryDatapolicyCustomEndpoint = value;
    }
    resetBigqueryDatapolicyCustomEndpoint() {
        this._bigqueryDatapolicyCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryDatapolicyCustomEndpointInput() {
        return this._bigqueryDatapolicyCustomEndpoint;
    }
    get bigqueryReservationCustomEndpoint() {
        return this._bigqueryReservationCustomEndpoint;
    }
    set bigqueryReservationCustomEndpoint(value) {
        this._bigqueryReservationCustomEndpoint = value;
    }
    resetBigqueryReservationCustomEndpoint() {
        this._bigqueryReservationCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryReservationCustomEndpointInput() {
        return this._bigqueryReservationCustomEndpoint;
    }
    get bigtableCustomEndpoint() {
        return this._bigtableCustomEndpoint;
    }
    set bigtableCustomEndpoint(value) {
        this._bigtableCustomEndpoint = value;
    }
    resetBigtableCustomEndpoint() {
        this._bigtableCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigtableCustomEndpointInput() {
        return this._bigtableCustomEndpoint;
    }
    get billingCustomEndpoint() {
        return this._billingCustomEndpoint;
    }
    set billingCustomEndpoint(value) {
        this._billingCustomEndpoint = value;
    }
    resetBillingCustomEndpoint() {
        this._billingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get billingCustomEndpointInput() {
        return this._billingCustomEndpoint;
    }
    get billingProject() {
        return this._billingProject;
    }
    set billingProject(value) {
        this._billingProject = value;
    }
    resetBillingProject() {
        this._billingProject = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get billingProjectInput() {
        return this._billingProject;
    }
    get binaryAuthorizationCustomEndpoint() {
        return this._binaryAuthorizationCustomEndpoint;
    }
    set binaryAuthorizationCustomEndpoint(value) {
        this._binaryAuthorizationCustomEndpoint = value;
    }
    resetBinaryAuthorizationCustomEndpoint() {
        this._binaryAuthorizationCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryAuthorizationCustomEndpointInput() {
        return this._binaryAuthorizationCustomEndpoint;
    }
    get certificateManagerCustomEndpoint() {
        return this._certificateManagerCustomEndpoint;
    }
    set certificateManagerCustomEndpoint(value) {
        this._certificateManagerCustomEndpoint = value;
    }
    resetCertificateManagerCustomEndpoint() {
        this._certificateManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certificateManagerCustomEndpointInput() {
        return this._certificateManagerCustomEndpoint;
    }
    get cloudAssetCustomEndpoint() {
        return this._cloudAssetCustomEndpoint;
    }
    set cloudAssetCustomEndpoint(value) {
        this._cloudAssetCustomEndpoint = value;
    }
    resetCloudAssetCustomEndpoint() {
        this._cloudAssetCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudAssetCustomEndpointInput() {
        return this._cloudAssetCustomEndpoint;
    }
    get cloudBillingCustomEndpoint() {
        return this._cloudBillingCustomEndpoint;
    }
    set cloudBillingCustomEndpoint(value) {
        this._cloudBillingCustomEndpoint = value;
    }
    resetCloudBillingCustomEndpoint() {
        this._cloudBillingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudBillingCustomEndpointInput() {
        return this._cloudBillingCustomEndpoint;
    }
    get cloudBuildCustomEndpoint() {
        return this._cloudBuildCustomEndpoint;
    }
    set cloudBuildCustomEndpoint(value) {
        this._cloudBuildCustomEndpoint = value;
    }
    resetCloudBuildCustomEndpoint() {
        this._cloudBuildCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudBuildCustomEndpointInput() {
        return this._cloudBuildCustomEndpoint;
    }
    get cloudBuildWorkerPoolCustomEndpoint() {
        return this._cloudBuildWorkerPoolCustomEndpoint;
    }
    set cloudBuildWorkerPoolCustomEndpoint(value) {
        this._cloudBuildWorkerPoolCustomEndpoint = value;
    }
    resetCloudBuildWorkerPoolCustomEndpoint() {
        this._cloudBuildWorkerPoolCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudBuildWorkerPoolCustomEndpointInput() {
        return this._cloudBuildWorkerPoolCustomEndpoint;
    }
    get cloudFunctionsCustomEndpoint() {
        return this._cloudFunctionsCustomEndpoint;
    }
    set cloudFunctionsCustomEndpoint(value) {
        this._cloudFunctionsCustomEndpoint = value;
    }
    resetCloudFunctionsCustomEndpoint() {
        this._cloudFunctionsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudFunctionsCustomEndpointInput() {
        return this._cloudFunctionsCustomEndpoint;
    }
    get cloudIdentityCustomEndpoint() {
        return this._cloudIdentityCustomEndpoint;
    }
    set cloudIdentityCustomEndpoint(value) {
        this._cloudIdentityCustomEndpoint = value;
    }
    resetCloudIdentityCustomEndpoint() {
        this._cloudIdentityCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudIdentityCustomEndpointInput() {
        return this._cloudIdentityCustomEndpoint;
    }
    get cloudIdsCustomEndpoint() {
        return this._cloudIdsCustomEndpoint;
    }
    set cloudIdsCustomEndpoint(value) {
        this._cloudIdsCustomEndpoint = value;
    }
    resetCloudIdsCustomEndpoint() {
        this._cloudIdsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudIdsCustomEndpointInput() {
        return this._cloudIdsCustomEndpoint;
    }
    get cloudIotCustomEndpoint() {
        return this._cloudIotCustomEndpoint;
    }
    set cloudIotCustomEndpoint(value) {
        this._cloudIotCustomEndpoint = value;
    }
    resetCloudIotCustomEndpoint() {
        this._cloudIotCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudIotCustomEndpointInput() {
        return this._cloudIotCustomEndpoint;
    }
    get cloudResourceManagerCustomEndpoint() {
        return this._cloudResourceManagerCustomEndpoint;
    }
    set cloudResourceManagerCustomEndpoint(value) {
        this._cloudResourceManagerCustomEndpoint = value;
    }
    resetCloudResourceManagerCustomEndpoint() {
        this._cloudResourceManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudResourceManagerCustomEndpointInput() {
        return this._cloudResourceManagerCustomEndpoint;
    }
    get cloudRunCustomEndpoint() {
        return this._cloudRunCustomEndpoint;
    }
    set cloudRunCustomEndpoint(value) {
        this._cloudRunCustomEndpoint = value;
    }
    resetCloudRunCustomEndpoint() {
        this._cloudRunCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudRunCustomEndpointInput() {
        return this._cloudRunCustomEndpoint;
    }
    get cloudRunV2CustomEndpoint() {
        return this._cloudRunV2CustomEndpoint;
    }
    set cloudRunV2CustomEndpoint(value) {
        this._cloudRunV2CustomEndpoint = value;
    }
    resetCloudRunV2CustomEndpoint() {
        this._cloudRunV2CustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudRunV2CustomEndpointInput() {
        return this._cloudRunV2CustomEndpoint;
    }
    get cloudSchedulerCustomEndpoint() {
        return this._cloudSchedulerCustomEndpoint;
    }
    set cloudSchedulerCustomEndpoint(value) {
        this._cloudSchedulerCustomEndpoint = value;
    }
    resetCloudSchedulerCustomEndpoint() {
        this._cloudSchedulerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudSchedulerCustomEndpointInput() {
        return this._cloudSchedulerCustomEndpoint;
    }
    get cloudTasksCustomEndpoint() {
        return this._cloudTasksCustomEndpoint;
    }
    set cloudTasksCustomEndpoint(value) {
        this._cloudTasksCustomEndpoint = value;
    }
    resetCloudTasksCustomEndpoint() {
        this._cloudTasksCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudTasksCustomEndpointInput() {
        return this._cloudTasksCustomEndpoint;
    }
    get clouddeployCustomEndpoint() {
        return this._clouddeployCustomEndpoint;
    }
    set clouddeployCustomEndpoint(value) {
        this._clouddeployCustomEndpoint = value;
    }
    resetClouddeployCustomEndpoint() {
        this._clouddeployCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clouddeployCustomEndpointInput() {
        return this._clouddeployCustomEndpoint;
    }
    get cloudfunctions2CustomEndpoint() {
        return this._cloudfunctions2CustomEndpoint;
    }
    set cloudfunctions2CustomEndpoint(value) {
        this._cloudfunctions2CustomEndpoint = value;
    }
    resetCloudfunctions2CustomEndpoint() {
        this._cloudfunctions2CustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudfunctions2CustomEndpointInput() {
        return this._cloudfunctions2CustomEndpoint;
    }
    get composerCustomEndpoint() {
        return this._composerCustomEndpoint;
    }
    set composerCustomEndpoint(value) {
        this._composerCustomEndpoint = value;
    }
    resetComposerCustomEndpoint() {
        this._composerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get composerCustomEndpointInput() {
        return this._composerCustomEndpoint;
    }
    get computeCustomEndpoint() {
        return this._computeCustomEndpoint;
    }
    set computeCustomEndpoint(value) {
        this._computeCustomEndpoint = value;
    }
    resetComputeCustomEndpoint() {
        this._computeCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get computeCustomEndpointInput() {
        return this._computeCustomEndpoint;
    }
    get containerAnalysisCustomEndpoint() {
        return this._containerAnalysisCustomEndpoint;
    }
    set containerAnalysisCustomEndpoint(value) {
        this._containerAnalysisCustomEndpoint = value;
    }
    resetContainerAnalysisCustomEndpoint() {
        this._containerAnalysisCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerAnalysisCustomEndpointInput() {
        return this._containerAnalysisCustomEndpoint;
    }
    get containerAttachedCustomEndpoint() {
        return this._containerAttachedCustomEndpoint;
    }
    set containerAttachedCustomEndpoint(value) {
        this._containerAttachedCustomEndpoint = value;
    }
    resetContainerAttachedCustomEndpoint() {
        this._containerAttachedCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerAttachedCustomEndpointInput() {
        return this._containerAttachedCustomEndpoint;
    }
    get containerAwsCustomEndpoint() {
        return this._containerAwsCustomEndpoint;
    }
    set containerAwsCustomEndpoint(value) {
        this._containerAwsCustomEndpoint = value;
    }
    resetContainerAwsCustomEndpoint() {
        this._containerAwsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerAwsCustomEndpointInput() {
        return this._containerAwsCustomEndpoint;
    }
    get containerAzureCustomEndpoint() {
        return this._containerAzureCustomEndpoint;
    }
    set containerAzureCustomEndpoint(value) {
        this._containerAzureCustomEndpoint = value;
    }
    resetContainerAzureCustomEndpoint() {
        this._containerAzureCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerAzureCustomEndpointInput() {
        return this._containerAzureCustomEndpoint;
    }
    get containerCustomEndpoint() {
        return this._containerCustomEndpoint;
    }
    set containerCustomEndpoint(value) {
        this._containerCustomEndpoint = value;
    }
    resetContainerCustomEndpoint() {
        this._containerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerCustomEndpointInput() {
        return this._containerCustomEndpoint;
    }
    get credentials() {
        return this._credentials;
    }
    set credentials(value) {
        this._credentials = value;
    }
    resetCredentials() {
        this._credentials = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get credentialsInput() {
        return this._credentials;
    }
    get dataCatalogCustomEndpoint() {
        return this._dataCatalogCustomEndpoint;
    }
    set dataCatalogCustomEndpoint(value) {
        this._dataCatalogCustomEndpoint = value;
    }
    resetDataCatalogCustomEndpoint() {
        this._dataCatalogCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataCatalogCustomEndpointInput() {
        return this._dataCatalogCustomEndpoint;
    }
    get dataFusionCustomEndpoint() {
        return this._dataFusionCustomEndpoint;
    }
    set dataFusionCustomEndpoint(value) {
        this._dataFusionCustomEndpoint = value;
    }
    resetDataFusionCustomEndpoint() {
        this._dataFusionCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataFusionCustomEndpointInput() {
        return this._dataFusionCustomEndpoint;
    }
    get dataLossPreventionCustomEndpoint() {
        return this._dataLossPreventionCustomEndpoint;
    }
    set dataLossPreventionCustomEndpoint(value) {
        this._dataLossPreventionCustomEndpoint = value;
    }
    resetDataLossPreventionCustomEndpoint() {
        this._dataLossPreventionCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataLossPreventionCustomEndpointInput() {
        return this._dataLossPreventionCustomEndpoint;
    }
    get dataflowCustomEndpoint() {
        return this._dataflowCustomEndpoint;
    }
    set dataflowCustomEndpoint(value) {
        this._dataflowCustomEndpoint = value;
    }
    resetDataflowCustomEndpoint() {
        this._dataflowCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataflowCustomEndpointInput() {
        return this._dataflowCustomEndpoint;
    }
    get dataplexCustomEndpoint() {
        return this._dataplexCustomEndpoint;
    }
    set dataplexCustomEndpoint(value) {
        this._dataplexCustomEndpoint = value;
    }
    resetDataplexCustomEndpoint() {
        this._dataplexCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataplexCustomEndpointInput() {
        return this._dataplexCustomEndpoint;
    }
    get dataprocCustomEndpoint() {
        return this._dataprocCustomEndpoint;
    }
    set dataprocCustomEndpoint(value) {
        this._dataprocCustomEndpoint = value;
    }
    resetDataprocCustomEndpoint() {
        this._dataprocCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataprocCustomEndpointInput() {
        return this._dataprocCustomEndpoint;
    }
    get dataprocMetastoreCustomEndpoint() {
        return this._dataprocMetastoreCustomEndpoint;
    }
    set dataprocMetastoreCustomEndpoint(value) {
        this._dataprocMetastoreCustomEndpoint = value;
    }
    resetDataprocMetastoreCustomEndpoint() {
        this._dataprocMetastoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataprocMetastoreCustomEndpointInput() {
        return this._dataprocMetastoreCustomEndpoint;
    }
    get datastoreCustomEndpoint() {
        return this._datastoreCustomEndpoint;
    }
    set datastoreCustomEndpoint(value) {
        this._datastoreCustomEndpoint = value;
    }
    resetDatastoreCustomEndpoint() {
        this._datastoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datastoreCustomEndpointInput() {
        return this._datastoreCustomEndpoint;
    }
    get datastreamCustomEndpoint() {
        return this._datastreamCustomEndpoint;
    }
    set datastreamCustomEndpoint(value) {
        this._datastreamCustomEndpoint = value;
    }
    resetDatastreamCustomEndpoint() {
        this._datastreamCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datastreamCustomEndpointInput() {
        return this._datastreamCustomEndpoint;
    }
    get deploymentManagerCustomEndpoint() {
        return this._deploymentManagerCustomEndpoint;
    }
    set deploymentManagerCustomEndpoint(value) {
        this._deploymentManagerCustomEndpoint = value;
    }
    resetDeploymentManagerCustomEndpoint() {
        this._deploymentManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deploymentManagerCustomEndpointInput() {
        return this._deploymentManagerCustomEndpoint;
    }
    get dialogflowCustomEndpoint() {
        return this._dialogflowCustomEndpoint;
    }
    set dialogflowCustomEndpoint(value) {
        this._dialogflowCustomEndpoint = value;
    }
    resetDialogflowCustomEndpoint() {
        this._dialogflowCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dialogflowCustomEndpointInput() {
        return this._dialogflowCustomEndpoint;
    }
    get dialogflowCxCustomEndpoint() {
        return this._dialogflowCxCustomEndpoint;
    }
    set dialogflowCxCustomEndpoint(value) {
        this._dialogflowCxCustomEndpoint = value;
    }
    resetDialogflowCxCustomEndpoint() {
        this._dialogflowCxCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dialogflowCxCustomEndpointInput() {
        return this._dialogflowCxCustomEndpoint;
    }
    get dnsCustomEndpoint() {
        return this._dnsCustomEndpoint;
    }
    set dnsCustomEndpoint(value) {
        this._dnsCustomEndpoint = value;
    }
    resetDnsCustomEndpoint() {
        this._dnsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dnsCustomEndpointInput() {
        return this._dnsCustomEndpoint;
    }
    get documentAiCustomEndpoint() {
        return this._documentAiCustomEndpoint;
    }
    set documentAiCustomEndpoint(value) {
        this._documentAiCustomEndpoint = value;
    }
    resetDocumentAiCustomEndpoint() {
        this._documentAiCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get documentAiCustomEndpointInput() {
        return this._documentAiCustomEndpoint;
    }
    get essentialContactsCustomEndpoint() {
        return this._essentialContactsCustomEndpoint;
    }
    set essentialContactsCustomEndpoint(value) {
        this._essentialContactsCustomEndpoint = value;
    }
    resetEssentialContactsCustomEndpoint() {
        this._essentialContactsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get essentialContactsCustomEndpointInput() {
        return this._essentialContactsCustomEndpoint;
    }
    get eventarcCustomEndpoint() {
        return this._eventarcCustomEndpoint;
    }
    set eventarcCustomEndpoint(value) {
        this._eventarcCustomEndpoint = value;
    }
    resetEventarcCustomEndpoint() {
        this._eventarcCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eventarcCustomEndpointInput() {
        return this._eventarcCustomEndpoint;
    }
    get filestoreCustomEndpoint() {
        return this._filestoreCustomEndpoint;
    }
    set filestoreCustomEndpoint(value) {
        this._filestoreCustomEndpoint = value;
    }
    resetFilestoreCustomEndpoint() {
        this._filestoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get filestoreCustomEndpointInput() {
        return this._filestoreCustomEndpoint;
    }
    get firebaserulesCustomEndpoint() {
        return this._firebaserulesCustomEndpoint;
    }
    set firebaserulesCustomEndpoint(value) {
        this._firebaserulesCustomEndpoint = value;
    }
    resetFirebaserulesCustomEndpoint() {
        this._firebaserulesCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firebaserulesCustomEndpointInput() {
        return this._firebaserulesCustomEndpoint;
    }
    get firestoreCustomEndpoint() {
        return this._firestoreCustomEndpoint;
    }
    set firestoreCustomEndpoint(value) {
        this._firestoreCustomEndpoint = value;
    }
    resetFirestoreCustomEndpoint() {
        this._firestoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firestoreCustomEndpointInput() {
        return this._firestoreCustomEndpoint;
    }
    get gameServicesCustomEndpoint() {
        return this._gameServicesCustomEndpoint;
    }
    set gameServicesCustomEndpoint(value) {
        this._gameServicesCustomEndpoint = value;
    }
    resetGameServicesCustomEndpoint() {
        this._gameServicesCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gameServicesCustomEndpointInput() {
        return this._gameServicesCustomEndpoint;
    }
    get gkeBackupCustomEndpoint() {
        return this._gkeBackupCustomEndpoint;
    }
    set gkeBackupCustomEndpoint(value) {
        this._gkeBackupCustomEndpoint = value;
    }
    resetGkeBackupCustomEndpoint() {
        this._gkeBackupCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gkeBackupCustomEndpointInput() {
        return this._gkeBackupCustomEndpoint;
    }
    get gkeHubCustomEndpoint() {
        return this._gkeHubCustomEndpoint;
    }
    set gkeHubCustomEndpoint(value) {
        this._gkeHubCustomEndpoint = value;
    }
    resetGkeHubCustomEndpoint() {
        this._gkeHubCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gkeHubCustomEndpointInput() {
        return this._gkeHubCustomEndpoint;
    }
    get healthcareCustomEndpoint() {
        return this._healthcareCustomEndpoint;
    }
    set healthcareCustomEndpoint(value) {
        this._healthcareCustomEndpoint = value;
    }
    resetHealthcareCustomEndpoint() {
        this._healthcareCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get healthcareCustomEndpointInput() {
        return this._healthcareCustomEndpoint;
    }
    get iam2CustomEndpoint() {
        return this._iam2CustomEndpoint;
    }
    set iam2CustomEndpoint(value) {
        this._iam2CustomEndpoint = value;
    }
    resetIam2CustomEndpoint() {
        this._iam2CustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iam2CustomEndpointInput() {
        return this._iam2CustomEndpoint;
    }
    get iamBetaCustomEndpoint() {
        return this._iamBetaCustomEndpoint;
    }
    set iamBetaCustomEndpoint(value) {
        this._iamBetaCustomEndpoint = value;
    }
    resetIamBetaCustomEndpoint() {
        this._iamBetaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamBetaCustomEndpointInput() {
        return this._iamBetaCustomEndpoint;
    }
    get iamCredentialsCustomEndpoint() {
        return this._iamCredentialsCustomEndpoint;
    }
    set iamCredentialsCustomEndpoint(value) {
        this._iamCredentialsCustomEndpoint = value;
    }
    resetIamCredentialsCustomEndpoint() {
        this._iamCredentialsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamCredentialsCustomEndpointInput() {
        return this._iamCredentialsCustomEndpoint;
    }
    get iamCustomEndpoint() {
        return this._iamCustomEndpoint;
    }
    set iamCustomEndpoint(value) {
        this._iamCustomEndpoint = value;
    }
    resetIamCustomEndpoint() {
        this._iamCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamCustomEndpointInput() {
        return this._iamCustomEndpoint;
    }
    get iamWorkforcePoolCustomEndpoint() {
        return this._iamWorkforcePoolCustomEndpoint;
    }
    set iamWorkforcePoolCustomEndpoint(value) {
        this._iamWorkforcePoolCustomEndpoint = value;
    }
    resetIamWorkforcePoolCustomEndpoint() {
        this._iamWorkforcePoolCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamWorkforcePoolCustomEndpointInput() {
        return this._iamWorkforcePoolCustomEndpoint;
    }
    get iapCustomEndpoint() {
        return this._iapCustomEndpoint;
    }
    set iapCustomEndpoint(value) {
        this._iapCustomEndpoint = value;
    }
    resetIapCustomEndpoint() {
        this._iapCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iapCustomEndpointInput() {
        return this._iapCustomEndpoint;
    }
    get identityPlatformCustomEndpoint() {
        return this._identityPlatformCustomEndpoint;
    }
    set identityPlatformCustomEndpoint(value) {
        this._identityPlatformCustomEndpoint = value;
    }
    resetIdentityPlatformCustomEndpoint() {
        this._identityPlatformCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get identityPlatformCustomEndpointInput() {
        return this._identityPlatformCustomEndpoint;
    }
    get impersonateServiceAccount() {
        return this._impersonateServiceAccount;
    }
    set impersonateServiceAccount(value) {
        this._impersonateServiceAccount = value;
    }
    resetImpersonateServiceAccount() {
        this._impersonateServiceAccount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get impersonateServiceAccountInput() {
        return this._impersonateServiceAccount;
    }
    get impersonateServiceAccountDelegates() {
        return this._impersonateServiceAccountDelegates;
    }
    set impersonateServiceAccountDelegates(value) {
        this._impersonateServiceAccountDelegates = value;
    }
    resetImpersonateServiceAccountDelegates() {
        this._impersonateServiceAccountDelegates = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get impersonateServiceAccountDelegatesInput() {
        return this._impersonateServiceAccountDelegates;
    }
    get kmsCustomEndpoint() {
        return this._kmsCustomEndpoint;
    }
    set kmsCustomEndpoint(value) {
        this._kmsCustomEndpoint = value;
    }
    resetKmsCustomEndpoint() {
        this._kmsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kmsCustomEndpointInput() {
        return this._kmsCustomEndpoint;
    }
    get loggingCustomEndpoint() {
        return this._loggingCustomEndpoint;
    }
    set loggingCustomEndpoint(value) {
        this._loggingCustomEndpoint = value;
    }
    resetLoggingCustomEndpoint() {
        this._loggingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get loggingCustomEndpointInput() {
        return this._loggingCustomEndpoint;
    }
    get memcacheCustomEndpoint() {
        return this._memcacheCustomEndpoint;
    }
    set memcacheCustomEndpoint(value) {
        this._memcacheCustomEndpoint = value;
    }
    resetMemcacheCustomEndpoint() {
        this._memcacheCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memcacheCustomEndpointInput() {
        return this._memcacheCustomEndpoint;
    }
    get mlEngineCustomEndpoint() {
        return this._mlEngineCustomEndpoint;
    }
    set mlEngineCustomEndpoint(value) {
        this._mlEngineCustomEndpoint = value;
    }
    resetMlEngineCustomEndpoint() {
        this._mlEngineCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mlEngineCustomEndpointInput() {
        return this._mlEngineCustomEndpoint;
    }
    get monitoringCustomEndpoint() {
        return this._monitoringCustomEndpoint;
    }
    set monitoringCustomEndpoint(value) {
        this._monitoringCustomEndpoint = value;
    }
    resetMonitoringCustomEndpoint() {
        this._monitoringCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get monitoringCustomEndpointInput() {
        return this._monitoringCustomEndpoint;
    }
    get networkConnectivityCustomEndpoint() {
        return this._networkConnectivityCustomEndpoint;
    }
    set networkConnectivityCustomEndpoint(value) {
        this._networkConnectivityCustomEndpoint = value;
    }
    resetNetworkConnectivityCustomEndpoint() {
        this._networkConnectivityCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkConnectivityCustomEndpointInput() {
        return this._networkConnectivityCustomEndpoint;
    }
    get networkManagementCustomEndpoint() {
        return this._networkManagementCustomEndpoint;
    }
    set networkManagementCustomEndpoint(value) {
        this._networkManagementCustomEndpoint = value;
    }
    resetNetworkManagementCustomEndpoint() {
        this._networkManagementCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkManagementCustomEndpointInput() {
        return this._networkManagementCustomEndpoint;
    }
    get networkServicesCustomEndpoint() {
        return this._networkServicesCustomEndpoint;
    }
    set networkServicesCustomEndpoint(value) {
        this._networkServicesCustomEndpoint = value;
    }
    resetNetworkServicesCustomEndpoint() {
        this._networkServicesCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkServicesCustomEndpointInput() {
        return this._networkServicesCustomEndpoint;
    }
    get notebooksCustomEndpoint() {
        return this._notebooksCustomEndpoint;
    }
    set notebooksCustomEndpoint(value) {
        this._notebooksCustomEndpoint = value;
    }
    resetNotebooksCustomEndpoint() {
        this._notebooksCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notebooksCustomEndpointInput() {
        return this._notebooksCustomEndpoint;
    }
    get orgPolicyCustomEndpoint() {
        return this._orgPolicyCustomEndpoint;
    }
    set orgPolicyCustomEndpoint(value) {
        this._orgPolicyCustomEndpoint = value;
    }
    resetOrgPolicyCustomEndpoint() {
        this._orgPolicyCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get orgPolicyCustomEndpointInput() {
        return this._orgPolicyCustomEndpoint;
    }
    get osConfigCustomEndpoint() {
        return this._osConfigCustomEndpoint;
    }
    set osConfigCustomEndpoint(value) {
        this._osConfigCustomEndpoint = value;
    }
    resetOsConfigCustomEndpoint() {
        this._osConfigCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osConfigCustomEndpointInput() {
        return this._osConfigCustomEndpoint;
    }
    get osLoginCustomEndpoint() {
        return this._osLoginCustomEndpoint;
    }
    set osLoginCustomEndpoint(value) {
        this._osLoginCustomEndpoint = value;
    }
    resetOsLoginCustomEndpoint() {
        this._osLoginCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osLoginCustomEndpointInput() {
        return this._osLoginCustomEndpoint;
    }
    get privatecaCustomEndpoint() {
        return this._privatecaCustomEndpoint;
    }
    set privatecaCustomEndpoint(value) {
        this._privatecaCustomEndpoint = value;
    }
    resetPrivatecaCustomEndpoint() {
        this._privatecaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privatecaCustomEndpointInput() {
        return this._privatecaCustomEndpoint;
    }
    get project() {
        return this._project;
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get pubsubCustomEndpoint() {
        return this._pubsubCustomEndpoint;
    }
    set pubsubCustomEndpoint(value) {
        this._pubsubCustomEndpoint = value;
    }
    resetPubsubCustomEndpoint() {
        this._pubsubCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pubsubCustomEndpointInput() {
        return this._pubsubCustomEndpoint;
    }
    get pubsubLiteCustomEndpoint() {
        return this._pubsubLiteCustomEndpoint;
    }
    set pubsubLiteCustomEndpoint(value) {
        this._pubsubLiteCustomEndpoint = value;
    }
    resetPubsubLiteCustomEndpoint() {
        this._pubsubLiteCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pubsubLiteCustomEndpointInput() {
        return this._pubsubLiteCustomEndpoint;
    }
    get recaptchaEnterpriseCustomEndpoint() {
        return this._recaptchaEnterpriseCustomEndpoint;
    }
    set recaptchaEnterpriseCustomEndpoint(value) {
        this._recaptchaEnterpriseCustomEndpoint = value;
    }
    resetRecaptchaEnterpriseCustomEndpoint() {
        this._recaptchaEnterpriseCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recaptchaEnterpriseCustomEndpointInput() {
        return this._recaptchaEnterpriseCustomEndpoint;
    }
    get redisCustomEndpoint() {
        return this._redisCustomEndpoint;
    }
    set redisCustomEndpoint(value) {
        this._redisCustomEndpoint = value;
    }
    resetRedisCustomEndpoint() {
        this._redisCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get redisCustomEndpointInput() {
        return this._redisCustomEndpoint;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get requestReason() {
        return this._requestReason;
    }
    set requestReason(value) {
        this._requestReason = value;
    }
    resetRequestReason() {
        this._requestReason = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestReasonInput() {
        return this._requestReason;
    }
    get requestTimeout() {
        return this._requestTimeout;
    }
    set requestTimeout(value) {
        this._requestTimeout = value;
    }
    resetRequestTimeout() {
        this._requestTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestTimeoutInput() {
        return this._requestTimeout;
    }
    get resourceManagerCustomEndpoint() {
        return this._resourceManagerCustomEndpoint;
    }
    set resourceManagerCustomEndpoint(value) {
        this._resourceManagerCustomEndpoint = value;
    }
    resetResourceManagerCustomEndpoint() {
        this._resourceManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceManagerCustomEndpointInput() {
        return this._resourceManagerCustomEndpoint;
    }
    get resourceManagerV3CustomEndpoint() {
        return this._resourceManagerV3CustomEndpoint;
    }
    set resourceManagerV3CustomEndpoint(value) {
        this._resourceManagerV3CustomEndpoint = value;
    }
    resetResourceManagerV3CustomEndpoint() {
        this._resourceManagerV3CustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceManagerV3CustomEndpointInput() {
        return this._resourceManagerV3CustomEndpoint;
    }
    get scopes() {
        return this._scopes;
    }
    set scopes(value) {
        this._scopes = value;
    }
    resetScopes() {
        this._scopes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scopesInput() {
        return this._scopes;
    }
    get secretManagerCustomEndpoint() {
        return this._secretManagerCustomEndpoint;
    }
    set secretManagerCustomEndpoint(value) {
        this._secretManagerCustomEndpoint = value;
    }
    resetSecretManagerCustomEndpoint() {
        this._secretManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretManagerCustomEndpointInput() {
        return this._secretManagerCustomEndpoint;
    }
    get securityCenterCustomEndpoint() {
        return this._securityCenterCustomEndpoint;
    }
    set securityCenterCustomEndpoint(value) {
        this._securityCenterCustomEndpoint = value;
    }
    resetSecurityCenterCustomEndpoint() {
        this._securityCenterCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityCenterCustomEndpointInput() {
        return this._securityCenterCustomEndpoint;
    }
    get serviceManagementCustomEndpoint() {
        return this._serviceManagementCustomEndpoint;
    }
    set serviceManagementCustomEndpoint(value) {
        this._serviceManagementCustomEndpoint = value;
    }
    resetServiceManagementCustomEndpoint() {
        this._serviceManagementCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceManagementCustomEndpointInput() {
        return this._serviceManagementCustomEndpoint;
    }
    get serviceNetworkingCustomEndpoint() {
        return this._serviceNetworkingCustomEndpoint;
    }
    set serviceNetworkingCustomEndpoint(value) {
        this._serviceNetworkingCustomEndpoint = value;
    }
    resetServiceNetworkingCustomEndpoint() {
        this._serviceNetworkingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceNetworkingCustomEndpointInput() {
        return this._serviceNetworkingCustomEndpoint;
    }
    get serviceUsageCustomEndpoint() {
        return this._serviceUsageCustomEndpoint;
    }
    set serviceUsageCustomEndpoint(value) {
        this._serviceUsageCustomEndpoint = value;
    }
    resetServiceUsageCustomEndpoint() {
        this._serviceUsageCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceUsageCustomEndpointInput() {
        return this._serviceUsageCustomEndpoint;
    }
    get sourceRepoCustomEndpoint() {
        return this._sourceRepoCustomEndpoint;
    }
    set sourceRepoCustomEndpoint(value) {
        this._sourceRepoCustomEndpoint = value;
    }
    resetSourceRepoCustomEndpoint() {
        this._sourceRepoCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourceRepoCustomEndpointInput() {
        return this._sourceRepoCustomEndpoint;
    }
    get spannerCustomEndpoint() {
        return this._spannerCustomEndpoint;
    }
    set spannerCustomEndpoint(value) {
        this._spannerCustomEndpoint = value;
    }
    resetSpannerCustomEndpoint() {
        this._spannerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spannerCustomEndpointInput() {
        return this._spannerCustomEndpoint;
    }
    get sqlCustomEndpoint() {
        return this._sqlCustomEndpoint;
    }
    set sqlCustomEndpoint(value) {
        this._sqlCustomEndpoint = value;
    }
    resetSqlCustomEndpoint() {
        this._sqlCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sqlCustomEndpointInput() {
        return this._sqlCustomEndpoint;
    }
    get storageCustomEndpoint() {
        return this._storageCustomEndpoint;
    }
    set storageCustomEndpoint(value) {
        this._storageCustomEndpoint = value;
    }
    resetStorageCustomEndpoint() {
        this._storageCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageCustomEndpointInput() {
        return this._storageCustomEndpoint;
    }
    get storageTransferCustomEndpoint() {
        return this._storageTransferCustomEndpoint;
    }
    set storageTransferCustomEndpoint(value) {
        this._storageTransferCustomEndpoint = value;
    }
    resetStorageTransferCustomEndpoint() {
        this._storageTransferCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageTransferCustomEndpointInput() {
        return this._storageTransferCustomEndpoint;
    }
    get tagsCustomEndpoint() {
        return this._tagsCustomEndpoint;
    }
    set tagsCustomEndpoint(value) {
        this._tagsCustomEndpoint = value;
    }
    resetTagsCustomEndpoint() {
        this._tagsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsCustomEndpointInput() {
        return this._tagsCustomEndpoint;
    }
    get tagsLocationCustomEndpoint() {
        return this._tagsLocationCustomEndpoint;
    }
    set tagsLocationCustomEndpoint(value) {
        this._tagsLocationCustomEndpoint = value;
    }
    resetTagsLocationCustomEndpoint() {
        this._tagsLocationCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsLocationCustomEndpointInput() {
        return this._tagsLocationCustomEndpoint;
    }
    get tpuCustomEndpoint() {
        return this._tpuCustomEndpoint;
    }
    set tpuCustomEndpoint(value) {
        this._tpuCustomEndpoint = value;
    }
    resetTpuCustomEndpoint() {
        this._tpuCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tpuCustomEndpointInput() {
        return this._tpuCustomEndpoint;
    }
    get userProjectOverride() {
        return this._userProjectOverride;
    }
    set userProjectOverride(value) {
        this._userProjectOverride = value;
    }
    resetUserProjectOverride() {
        this._userProjectOverride = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userProjectOverrideInput() {
        return this._userProjectOverride;
    }
    get vertexAiCustomEndpoint() {
        return this._vertexAiCustomEndpoint;
    }
    set vertexAiCustomEndpoint(value) {
        this._vertexAiCustomEndpoint = value;
    }
    resetVertexAiCustomEndpoint() {
        this._vertexAiCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vertexAiCustomEndpointInput() {
        return this._vertexAiCustomEndpoint;
    }
    get vpcAccessCustomEndpoint() {
        return this._vpcAccessCustomEndpoint;
    }
    set vpcAccessCustomEndpoint(value) {
        this._vpcAccessCustomEndpoint = value;
    }
    resetVpcAccessCustomEndpoint() {
        this._vpcAccessCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vpcAccessCustomEndpointInput() {
        return this._vpcAccessCustomEndpoint;
    }
    get workflowsCustomEndpoint() {
        return this._workflowsCustomEndpoint;
    }
    set workflowsCustomEndpoint(value) {
        this._workflowsCustomEndpoint = value;
    }
    resetWorkflowsCustomEndpoint() {
        this._workflowsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workflowsCustomEndpointInput() {
        return this._workflowsCustomEndpoint;
    }
    get zone() {
        return this._zone;
    }
    set zone(value) {
        this._zone = value;
    }
    resetZone() {
        this._zone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get zoneInput() {
        return this._zone;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get batching() {
        return this._batching;
    }
    set batching(value) {
        this._batching = value;
    }
    resetBatching() {
        this._batching = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get batchingInput() {
        return this._batching;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_approval_custom_endpoint: cdktf.stringToTerraform(this._accessApprovalCustomEndpoint),
            access_context_manager_custom_endpoint: cdktf.stringToTerraform(this._accessContextManagerCustomEndpoint),
            access_token: cdktf.stringToTerraform(this._accessToken),
            active_directory_custom_endpoint: cdktf.stringToTerraform(this._activeDirectoryCustomEndpoint),
            alloydb_custom_endpoint: cdktf.stringToTerraform(this._alloydbCustomEndpoint),
            apigee_custom_endpoint: cdktf.stringToTerraform(this._apigeeCustomEndpoint),
            apikeys_custom_endpoint: cdktf.stringToTerraform(this._apikeysCustomEndpoint),
            app_engine_custom_endpoint: cdktf.stringToTerraform(this._appEngineCustomEndpoint),
            artifact_registry_custom_endpoint: cdktf.stringToTerraform(this._artifactRegistryCustomEndpoint),
            assured_workloads_custom_endpoint: cdktf.stringToTerraform(this._assuredWorkloadsCustomEndpoint),
            beyondcorp_custom_endpoint: cdktf.stringToTerraform(this._beyondcorpCustomEndpoint),
            big_query_custom_endpoint: cdktf.stringToTerraform(this._bigQueryCustomEndpoint),
            bigquery_analytics_hub_custom_endpoint: cdktf.stringToTerraform(this._bigqueryAnalyticsHubCustomEndpoint),
            bigquery_connection_custom_endpoint: cdktf.stringToTerraform(this._bigqueryConnectionCustomEndpoint),
            bigquery_data_transfer_custom_endpoint: cdktf.stringToTerraform(this._bigqueryDataTransferCustomEndpoint),
            bigquery_datapolicy_custom_endpoint: cdktf.stringToTerraform(this._bigqueryDatapolicyCustomEndpoint),
            bigquery_reservation_custom_endpoint: cdktf.stringToTerraform(this._bigqueryReservationCustomEndpoint),
            bigtable_custom_endpoint: cdktf.stringToTerraform(this._bigtableCustomEndpoint),
            billing_custom_endpoint: cdktf.stringToTerraform(this._billingCustomEndpoint),
            billing_project: cdktf.stringToTerraform(this._billingProject),
            binary_authorization_custom_endpoint: cdktf.stringToTerraform(this._binaryAuthorizationCustomEndpoint),
            certificate_manager_custom_endpoint: cdktf.stringToTerraform(this._certificateManagerCustomEndpoint),
            cloud_asset_custom_endpoint: cdktf.stringToTerraform(this._cloudAssetCustomEndpoint),
            cloud_billing_custom_endpoint: cdktf.stringToTerraform(this._cloudBillingCustomEndpoint),
            cloud_build_custom_endpoint: cdktf.stringToTerraform(this._cloudBuildCustomEndpoint),
            cloud_build_worker_pool_custom_endpoint: cdktf.stringToTerraform(this._cloudBuildWorkerPoolCustomEndpoint),
            cloud_functions_custom_endpoint: cdktf.stringToTerraform(this._cloudFunctionsCustomEndpoint),
            cloud_identity_custom_endpoint: cdktf.stringToTerraform(this._cloudIdentityCustomEndpoint),
            cloud_ids_custom_endpoint: cdktf.stringToTerraform(this._cloudIdsCustomEndpoint),
            cloud_iot_custom_endpoint: cdktf.stringToTerraform(this._cloudIotCustomEndpoint),
            cloud_resource_manager_custom_endpoint: cdktf.stringToTerraform(this._cloudResourceManagerCustomEndpoint),
            cloud_run_custom_endpoint: cdktf.stringToTerraform(this._cloudRunCustomEndpoint),
            cloud_run_v2_custom_endpoint: cdktf.stringToTerraform(this._cloudRunV2CustomEndpoint),
            cloud_scheduler_custom_endpoint: cdktf.stringToTerraform(this._cloudSchedulerCustomEndpoint),
            cloud_tasks_custom_endpoint: cdktf.stringToTerraform(this._cloudTasksCustomEndpoint),
            clouddeploy_custom_endpoint: cdktf.stringToTerraform(this._clouddeployCustomEndpoint),
            cloudfunctions2_custom_endpoint: cdktf.stringToTerraform(this._cloudfunctions2CustomEndpoint),
            composer_custom_endpoint: cdktf.stringToTerraform(this._composerCustomEndpoint),
            compute_custom_endpoint: cdktf.stringToTerraform(this._computeCustomEndpoint),
            container_analysis_custom_endpoint: cdktf.stringToTerraform(this._containerAnalysisCustomEndpoint),
            container_attached_custom_endpoint: cdktf.stringToTerraform(this._containerAttachedCustomEndpoint),
            container_aws_custom_endpoint: cdktf.stringToTerraform(this._containerAwsCustomEndpoint),
            container_azure_custom_endpoint: cdktf.stringToTerraform(this._containerAzureCustomEndpoint),
            container_custom_endpoint: cdktf.stringToTerraform(this._containerCustomEndpoint),
            credentials: cdktf.stringToTerraform(this._credentials),
            data_catalog_custom_endpoint: cdktf.stringToTerraform(this._dataCatalogCustomEndpoint),
            data_fusion_custom_endpoint: cdktf.stringToTerraform(this._dataFusionCustomEndpoint),
            data_loss_prevention_custom_endpoint: cdktf.stringToTerraform(this._dataLossPreventionCustomEndpoint),
            dataflow_custom_endpoint: cdktf.stringToTerraform(this._dataflowCustomEndpoint),
            dataplex_custom_endpoint: cdktf.stringToTerraform(this._dataplexCustomEndpoint),
            dataproc_custom_endpoint: cdktf.stringToTerraform(this._dataprocCustomEndpoint),
            dataproc_metastore_custom_endpoint: cdktf.stringToTerraform(this._dataprocMetastoreCustomEndpoint),
            datastore_custom_endpoint: cdktf.stringToTerraform(this._datastoreCustomEndpoint),
            datastream_custom_endpoint: cdktf.stringToTerraform(this._datastreamCustomEndpoint),
            deployment_manager_custom_endpoint: cdktf.stringToTerraform(this._deploymentManagerCustomEndpoint),
            dialogflow_custom_endpoint: cdktf.stringToTerraform(this._dialogflowCustomEndpoint),
            dialogflow_cx_custom_endpoint: cdktf.stringToTerraform(this._dialogflowCxCustomEndpoint),
            dns_custom_endpoint: cdktf.stringToTerraform(this._dnsCustomEndpoint),
            document_ai_custom_endpoint: cdktf.stringToTerraform(this._documentAiCustomEndpoint),
            essential_contacts_custom_endpoint: cdktf.stringToTerraform(this._essentialContactsCustomEndpoint),
            eventarc_custom_endpoint: cdktf.stringToTerraform(this._eventarcCustomEndpoint),
            filestore_custom_endpoint: cdktf.stringToTerraform(this._filestoreCustomEndpoint),
            firebaserules_custom_endpoint: cdktf.stringToTerraform(this._firebaserulesCustomEndpoint),
            firestore_custom_endpoint: cdktf.stringToTerraform(this._firestoreCustomEndpoint),
            game_services_custom_endpoint: cdktf.stringToTerraform(this._gameServicesCustomEndpoint),
            gke_backup_custom_endpoint: cdktf.stringToTerraform(this._gkeBackupCustomEndpoint),
            gke_hub_custom_endpoint: cdktf.stringToTerraform(this._gkeHubCustomEndpoint),
            healthcare_custom_endpoint: cdktf.stringToTerraform(this._healthcareCustomEndpoint),
            iam2_custom_endpoint: cdktf.stringToTerraform(this._iam2CustomEndpoint),
            iam_beta_custom_endpoint: cdktf.stringToTerraform(this._iamBetaCustomEndpoint),
            iam_credentials_custom_endpoint: cdktf.stringToTerraform(this._iamCredentialsCustomEndpoint),
            iam_custom_endpoint: cdktf.stringToTerraform(this._iamCustomEndpoint),
            iam_workforce_pool_custom_endpoint: cdktf.stringToTerraform(this._iamWorkforcePoolCustomEndpoint),
            iap_custom_endpoint: cdktf.stringToTerraform(this._iapCustomEndpoint),
            identity_platform_custom_endpoint: cdktf.stringToTerraform(this._identityPlatformCustomEndpoint),
            impersonate_service_account: cdktf.stringToTerraform(this._impersonateServiceAccount),
            impersonate_service_account_delegates: cdktf.listMapper(cdktf.stringToTerraform, false)(this._impersonateServiceAccountDelegates),
            kms_custom_endpoint: cdktf.stringToTerraform(this._kmsCustomEndpoint),
            logging_custom_endpoint: cdktf.stringToTerraform(this._loggingCustomEndpoint),
            memcache_custom_endpoint: cdktf.stringToTerraform(this._memcacheCustomEndpoint),
            ml_engine_custom_endpoint: cdktf.stringToTerraform(this._mlEngineCustomEndpoint),
            monitoring_custom_endpoint: cdktf.stringToTerraform(this._monitoringCustomEndpoint),
            network_connectivity_custom_endpoint: cdktf.stringToTerraform(this._networkConnectivityCustomEndpoint),
            network_management_custom_endpoint: cdktf.stringToTerraform(this._networkManagementCustomEndpoint),
            network_services_custom_endpoint: cdktf.stringToTerraform(this._networkServicesCustomEndpoint),
            notebooks_custom_endpoint: cdktf.stringToTerraform(this._notebooksCustomEndpoint),
            org_policy_custom_endpoint: cdktf.stringToTerraform(this._orgPolicyCustomEndpoint),
            os_config_custom_endpoint: cdktf.stringToTerraform(this._osConfigCustomEndpoint),
            os_login_custom_endpoint: cdktf.stringToTerraform(this._osLoginCustomEndpoint),
            privateca_custom_endpoint: cdktf.stringToTerraform(this._privatecaCustomEndpoint),
            project: cdktf.stringToTerraform(this._project),
            pubsub_custom_endpoint: cdktf.stringToTerraform(this._pubsubCustomEndpoint),
            pubsub_lite_custom_endpoint: cdktf.stringToTerraform(this._pubsubLiteCustomEndpoint),
            recaptcha_enterprise_custom_endpoint: cdktf.stringToTerraform(this._recaptchaEnterpriseCustomEndpoint),
            redis_custom_endpoint: cdktf.stringToTerraform(this._redisCustomEndpoint),
            region: cdktf.stringToTerraform(this._region),
            request_reason: cdktf.stringToTerraform(this._requestReason),
            request_timeout: cdktf.stringToTerraform(this._requestTimeout),
            resource_manager_custom_endpoint: cdktf.stringToTerraform(this._resourceManagerCustomEndpoint),
            resource_manager_v3_custom_endpoint: cdktf.stringToTerraform(this._resourceManagerV3CustomEndpoint),
            scopes: cdktf.listMapper(cdktf.stringToTerraform, false)(this._scopes),
            secret_manager_custom_endpoint: cdktf.stringToTerraform(this._secretManagerCustomEndpoint),
            security_center_custom_endpoint: cdktf.stringToTerraform(this._securityCenterCustomEndpoint),
            service_management_custom_endpoint: cdktf.stringToTerraform(this._serviceManagementCustomEndpoint),
            service_networking_custom_endpoint: cdktf.stringToTerraform(this._serviceNetworkingCustomEndpoint),
            service_usage_custom_endpoint: cdktf.stringToTerraform(this._serviceUsageCustomEndpoint),
            source_repo_custom_endpoint: cdktf.stringToTerraform(this._sourceRepoCustomEndpoint),
            spanner_custom_endpoint: cdktf.stringToTerraform(this._spannerCustomEndpoint),
            sql_custom_endpoint: cdktf.stringToTerraform(this._sqlCustomEndpoint),
            storage_custom_endpoint: cdktf.stringToTerraform(this._storageCustomEndpoint),
            storage_transfer_custom_endpoint: cdktf.stringToTerraform(this._storageTransferCustomEndpoint),
            tags_custom_endpoint: cdktf.stringToTerraform(this._tagsCustomEndpoint),
            tags_location_custom_endpoint: cdktf.stringToTerraform(this._tagsLocationCustomEndpoint),
            tpu_custom_endpoint: cdktf.stringToTerraform(this._tpuCustomEndpoint),
            user_project_override: cdktf.booleanToTerraform(this._userProjectOverride),
            vertex_ai_custom_endpoint: cdktf.stringToTerraform(this._vertexAiCustomEndpoint),
            vpc_access_custom_endpoint: cdktf.stringToTerraform(this._vpcAccessCustomEndpoint),
            workflows_custom_endpoint: cdktf.stringToTerraform(this._workflowsCustomEndpoint),
            zone: cdktf.stringToTerraform(this._zone),
            alias: cdktf.stringToTerraform(this._alias),
            batching: googleProviderBatchingToTerraform(this._batching),
        };
    }
}
exports.GoogleProvider = GoogleProvider;
_a = JSII_RTTI_SYMBOL_1;
GoogleProvider[_a] = { fqn: "@cdktf/provider-google.provider.GoogleProvider", version: "5.0.15" };
// =================
// STATIC PROPERTIES
// =================
GoogleProvider.tfResourceType = "google";
//# sourceMappingURL=data:application/json;base64,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