import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PubsubSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * This value is the maximum time after a subscriber receives a message
  before the subscriber should acknowledge the message. After message
  delivery but before the ack deadline expires and before the message is
  acknowledged, it is an outstanding message and will not be delivered
  again during that time (on a best-effort basis).
  
  For pull subscriptions, this value is used as the initial value for
  the ack deadline. To override this value for a given message, call
  subscriptions.modifyAckDeadline with the corresponding ackId if using
  pull. The minimum custom deadline you can specify is 10 seconds. The
  maximum custom deadline you can specify is 600 seconds (10 minutes).
  If this parameter is 0, a default value of 10 seconds is used.
  
  For push delivery, this value is also used to set the request timeout
  for the call to the push endpoint.
  
  If the subscriber never acknowledges the message, the Pub/Sub system
  will eventually redeliver the message.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#ack_deadline_seconds PubsubSubscription#ack_deadline_seconds}
    */
    readonly ackDeadlineSeconds?: number;
    /**
    * If 'true', Pub/Sub provides the following guarantees for the delivery
  of a message with a given value of messageId on this Subscriptions':
  
  - The message sent to a subscriber is guaranteed not to be resent before the message's acknowledgement deadline expires.
  
  - An acknowledged message will not be resent to a subscriber.
  
  Note that subscribers may still receive multiple copies of a message when 'enable_exactly_once_delivery'
  is true if the message was published multiple times by a publisher client. These copies are considered distinct by Pub/Sub and have distinct messageId values
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#enable_exactly_once_delivery PubsubSubscription#enable_exactly_once_delivery}
    */
    readonly enableExactlyOnceDelivery?: boolean | cdktf.IResolvable;
    /**
    * If 'true', messages published with the same orderingKey in PubsubMessage will be delivered to
  the subscribers in the order in which they are received by the Pub/Sub system. Otherwise, they
  may be delivered in any order.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#enable_message_ordering PubsubSubscription#enable_message_ordering}
    */
    readonly enableMessageOrdering?: boolean | cdktf.IResolvable;
    /**
    * The subscription only delivers the messages that match the filter.
  Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
  by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
  you can't modify the filter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#filter PubsubSubscription#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#id PubsubSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to this Subscription.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#labels PubsubSubscription#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * How long to retain unacknowledged messages in the subscription's
  backlog, from the moment a message is published. If
  retain_acked_messages is true, then this also configures the retention
  of acknowledged messages, and thus configures how far back in time a
  subscriptions.seek can be done. Defaults to 7 days. Cannot be more
  than 7 days ('"604800s"') or less than 10 minutes ('"600s"').
  
  A duration in seconds with up to nine fractional digits, terminated
  by 's'. Example: '"600.5s"'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#message_retention_duration PubsubSubscription#message_retention_duration}
    */
    readonly messageRetentionDuration?: string;
    /**
    * Name of the subscription.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#name PubsubSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#project PubsubSubscription#project}
    */
    readonly project?: string;
    /**
    * Indicates whether to retain acknowledged messages. If 'true', then
  messages are not expunged from the subscription's backlog, even if
  they are acknowledged, until they fall out of the
  messageRetentionDuration window.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#retain_acked_messages PubsubSubscription#retain_acked_messages}
    */
    readonly retainAckedMessages?: boolean | cdktf.IResolvable;
    /**
    * A reference to a Topic resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#topic PubsubSubscription#topic}
    */
    readonly topic: string;
    /**
    * bigquery_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#bigquery_config PubsubSubscription#bigquery_config}
    */
    readonly bigqueryConfig?: PubsubSubscriptionBigqueryConfig;
    /**
    * dead_letter_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#dead_letter_policy PubsubSubscription#dead_letter_policy}
    */
    readonly deadLetterPolicy?: PubsubSubscriptionDeadLetterPolicy;
    /**
    * expiration_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#expiration_policy PubsubSubscription#expiration_policy}
    */
    readonly expirationPolicy?: PubsubSubscriptionExpirationPolicy;
    /**
    * push_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#push_config PubsubSubscription#push_config}
    */
    readonly pushConfig?: PubsubSubscriptionPushConfig;
    /**
    * retry_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#retry_policy PubsubSubscription#retry_policy}
    */
    readonly retryPolicy?: PubsubSubscriptionRetryPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#timeouts PubsubSubscription#timeouts}
    */
    readonly timeouts?: PubsubSubscriptionTimeouts;
}
export interface PubsubSubscriptionBigqueryConfig {
    /**
    * When true and useTopicSchema is true, any fields that are a part of the topic schema that are not part of the BigQuery table schema are dropped when writing to BigQuery.
  Otherwise, the schemas must be kept in sync and any messages with extra fields are not written and remain in the subscription's backlog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#drop_unknown_fields PubsubSubscription#drop_unknown_fields}
    */
    readonly dropUnknownFields?: boolean | cdktf.IResolvable;
    /**
    * The name of the table to which to write data, of the form {projectId}:{datasetId}.{tableId}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#table PubsubSubscription#table}
    */
    readonly table: string;
    /**
    * When true, use the topic's schema as the columns to write to in BigQuery, if it exists.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#use_topic_schema PubsubSubscription#use_topic_schema}
    */
    readonly useTopicSchema?: boolean | cdktf.IResolvable;
    /**
    * When true, write the subscription name, messageId, publishTime, attributes, and orderingKey to additional columns in the table.
  The subscription name, messageId, and publishTime fields are put in their own columns while all other message properties (other than data) are written to a JSON object in the attributes column.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#write_metadata PubsubSubscription#write_metadata}
    */
    readonly writeMetadata?: boolean | cdktf.IResolvable;
}
export declare function pubsubSubscriptionBigqueryConfigToTerraform(struct?: PubsubSubscriptionBigqueryConfigOutputReference | PubsubSubscriptionBigqueryConfig): any;
export declare class PubsubSubscriptionBigqueryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubSubscriptionBigqueryConfig | undefined;
    set internalValue(value: PubsubSubscriptionBigqueryConfig | undefined);
    private _dropUnknownFields?;
    get dropUnknownFields(): boolean | cdktf.IResolvable;
    set dropUnknownFields(value: boolean | cdktf.IResolvable);
    resetDropUnknownFields(): void;
    get dropUnknownFieldsInput(): boolean | cdktf.IResolvable | undefined;
    private _table?;
    get table(): string;
    set table(value: string);
    get tableInput(): string | undefined;
    private _useTopicSchema?;
    get useTopicSchema(): boolean | cdktf.IResolvable;
    set useTopicSchema(value: boolean | cdktf.IResolvable);
    resetUseTopicSchema(): void;
    get useTopicSchemaInput(): boolean | cdktf.IResolvable | undefined;
    private _writeMetadata?;
    get writeMetadata(): boolean | cdktf.IResolvable;
    set writeMetadata(value: boolean | cdktf.IResolvable);
    resetWriteMetadata(): void;
    get writeMetadataInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PubsubSubscriptionDeadLetterPolicy {
    /**
    * The name of the topic to which dead letter messages should be published.
  Format is 'projects/{project}/topics/{topic}'.
  
  The Cloud Pub/Sub service account associated with the enclosing subscription's
  parent project (i.e.,
  service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
  permission to Publish() to this topic.
  
  The operation will fail if the topic does not exist.
  Users should ensure that there is a subscription attached to this topic
  since messages published to a topic with no subscriptions are lost.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#dead_letter_topic PubsubSubscription#dead_letter_topic}
    */
    readonly deadLetterTopic?: string;
    /**
    * The maximum number of delivery attempts for any message. The value must be
  between 5 and 100.
  
  The number of delivery attempts is defined as 1 + (the sum of number of
  NACKs and number of times the acknowledgement deadline has been exceeded for the message).
  
  A NACK is any call to ModifyAckDeadline with a 0 deadline. Note that
  client libraries may automatically extend ack_deadlines.
  
  This field will be honored on a best effort basis.
  
  If this parameter is 0, a default value of 5 is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#max_delivery_attempts PubsubSubscription#max_delivery_attempts}
    */
    readonly maxDeliveryAttempts?: number;
}
export declare function pubsubSubscriptionDeadLetterPolicyToTerraform(struct?: PubsubSubscriptionDeadLetterPolicyOutputReference | PubsubSubscriptionDeadLetterPolicy): any;
export declare class PubsubSubscriptionDeadLetterPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubSubscriptionDeadLetterPolicy | undefined;
    set internalValue(value: PubsubSubscriptionDeadLetterPolicy | undefined);
    private _deadLetterTopic?;
    get deadLetterTopic(): string;
    set deadLetterTopic(value: string);
    resetDeadLetterTopic(): void;
    get deadLetterTopicInput(): string | undefined;
    private _maxDeliveryAttempts?;
    get maxDeliveryAttempts(): number;
    set maxDeliveryAttempts(value: number);
    resetMaxDeliveryAttempts(): void;
    get maxDeliveryAttemptsInput(): number | undefined;
}
export interface PubsubSubscriptionExpirationPolicy {
    /**
    * Specifies the "time-to-live" duration for an associated resource. The
  resource expires if it is not active for a period of ttl.
  If ttl is set to "", the associated resource never expires.
  A duration in seconds with up to nine fractional digits, terminated by 's'.
  Example - "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#ttl PubsubSubscription#ttl}
    */
    readonly ttl: string;
}
export declare function pubsubSubscriptionExpirationPolicyToTerraform(struct?: PubsubSubscriptionExpirationPolicyOutputReference | PubsubSubscriptionExpirationPolicy): any;
export declare class PubsubSubscriptionExpirationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubSubscriptionExpirationPolicy | undefined;
    set internalValue(value: PubsubSubscriptionExpirationPolicy | undefined);
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    get ttlInput(): string | undefined;
}
export interface PubsubSubscriptionPushConfigOidcToken {
    /**
    * Audience to be used when generating OIDC token. The audience claim
  identifies the recipients that the JWT is intended for. The audience
  value is a single case-sensitive string. Having multiple values (array)
  for the audience field is not supported. More info about the OIDC JWT
  token audience here: https://tools.ietf.org/html/rfc7519#section-4.1.3
  Note: if not specified, the Push endpoint URL will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#audience PubsubSubscription#audience}
    */
    readonly audience?: string;
    /**
    * Service account email to be used for generating the OIDC token.
  The caller (for subscriptions.create, subscriptions.patch, and
  subscriptions.modifyPushConfig RPCs) must have the
  iam.serviceAccounts.actAs permission for the service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#service_account_email PubsubSubscription#service_account_email}
    */
    readonly serviceAccountEmail: string;
}
export declare function pubsubSubscriptionPushConfigOidcTokenToTerraform(struct?: PubsubSubscriptionPushConfigOidcTokenOutputReference | PubsubSubscriptionPushConfigOidcToken): any;
export declare class PubsubSubscriptionPushConfigOidcTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubSubscriptionPushConfigOidcToken | undefined;
    set internalValue(value: PubsubSubscriptionPushConfigOidcToken | undefined);
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    get serviceAccountEmailInput(): string | undefined;
}
export interface PubsubSubscriptionPushConfig {
    /**
    * Endpoint configuration attributes.
  
  Every endpoint has a set of API supported attributes that can
  be used to control different aspects of the message delivery.
  
  The currently supported attribute is x-goog-version, which you
  can use to change the format of the pushed message. This
  attribute indicates the version of the data expected by
  the endpoint. This controls the shape of the pushed message
  (i.e., its fields and metadata). The endpoint version is
  based on the version of the Pub/Sub API.
  
  If not present during the subscriptions.create call,
  it will default to the version of the API used to make
  such call. If not present during a subscriptions.modifyPushConfig
  call, its value will not be changed. subscriptions.get
  calls will always return a valid version, even if the
  subscription was created without this attribute.
  
  The possible values for this attribute are:
  
  - v1beta1: uses the push format defined in the v1beta1 Pub/Sub API.
  - v1 or v1beta2: uses the push format defined in the v1 Pub/Sub API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#attributes PubsubSubscription#attributes}
    */
    readonly attributes?: {
        [key: string]: string;
    };
    /**
    * A URL locating the endpoint to which messages should be pushed.
  For example, a Webhook endpoint might use
  "https://example.com/push".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#push_endpoint PubsubSubscription#push_endpoint}
    */
    readonly pushEndpoint: string;
    /**
    * oidc_token block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#oidc_token PubsubSubscription#oidc_token}
    */
    readonly oidcToken?: PubsubSubscriptionPushConfigOidcToken;
}
export declare function pubsubSubscriptionPushConfigToTerraform(struct?: PubsubSubscriptionPushConfigOutputReference | PubsubSubscriptionPushConfig): any;
export declare class PubsubSubscriptionPushConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubSubscriptionPushConfig | undefined;
    set internalValue(value: PubsubSubscriptionPushConfig | undefined);
    private _attributes?;
    get attributes(): {
        [key: string]: string;
    };
    set attributes(value: {
        [key: string]: string;
    });
    resetAttributes(): void;
    get attributesInput(): {
        [key: string]: string;
    } | undefined;
    private _pushEndpoint?;
    get pushEndpoint(): string;
    set pushEndpoint(value: string);
    get pushEndpointInput(): string | undefined;
    private _oidcToken;
    get oidcToken(): PubsubSubscriptionPushConfigOidcTokenOutputReference;
    putOidcToken(value: PubsubSubscriptionPushConfigOidcToken): void;
    resetOidcToken(): void;
    get oidcTokenInput(): PubsubSubscriptionPushConfigOidcToken | undefined;
}
export interface PubsubSubscriptionRetryPolicy {
    /**
    * The maximum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 600 seconds.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#maximum_backoff PubsubSubscription#maximum_backoff}
    */
    readonly maximumBackoff?: string;
    /**
    * The minimum delay between consecutive deliveries of a given message. Value should be between 0 and 600 seconds. Defaults to 10 seconds.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#minimum_backoff PubsubSubscription#minimum_backoff}
    */
    readonly minimumBackoff?: string;
}
export declare function pubsubSubscriptionRetryPolicyToTerraform(struct?: PubsubSubscriptionRetryPolicyOutputReference | PubsubSubscriptionRetryPolicy): any;
export declare class PubsubSubscriptionRetryPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubSubscriptionRetryPolicy | undefined;
    set internalValue(value: PubsubSubscriptionRetryPolicy | undefined);
    private _maximumBackoff?;
    get maximumBackoff(): string;
    set maximumBackoff(value: string);
    resetMaximumBackoff(): void;
    get maximumBackoffInput(): string | undefined;
    private _minimumBackoff?;
    get minimumBackoff(): string;
    set minimumBackoff(value: string);
    resetMinimumBackoff(): void;
    get minimumBackoffInput(): string | undefined;
}
export interface PubsubSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#create PubsubSubscription#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#delete PubsubSubscription#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription#update PubsubSubscription#update}
    */
    readonly update?: string;
}
export declare function pubsubSubscriptionTimeoutsToTerraform(struct?: PubsubSubscriptionTimeoutsOutputReference | PubsubSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class PubsubSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PubsubSubscriptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PubsubSubscriptionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription google_pubsub_subscription}
*/
export declare class PubsubSubscription extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_pubsub_subscription";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription google_pubsub_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PubsubSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: PubsubSubscriptionConfig);
    private _ackDeadlineSeconds?;
    get ackDeadlineSeconds(): number;
    set ackDeadlineSeconds(value: number);
    resetAckDeadlineSeconds(): void;
    get ackDeadlineSecondsInput(): number | undefined;
    private _enableExactlyOnceDelivery?;
    get enableExactlyOnceDelivery(): boolean | cdktf.IResolvable;
    set enableExactlyOnceDelivery(value: boolean | cdktf.IResolvable);
    resetEnableExactlyOnceDelivery(): void;
    get enableExactlyOnceDeliveryInput(): boolean | cdktf.IResolvable | undefined;
    private _enableMessageOrdering?;
    get enableMessageOrdering(): boolean | cdktf.IResolvable;
    set enableMessageOrdering(value: boolean | cdktf.IResolvable);
    resetEnableMessageOrdering(): void;
    get enableMessageOrderingInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _messageRetentionDuration?;
    get messageRetentionDuration(): string;
    set messageRetentionDuration(value: string);
    resetMessageRetentionDuration(): void;
    get messageRetentionDurationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _retainAckedMessages?;
    get retainAckedMessages(): boolean | cdktf.IResolvable;
    set retainAckedMessages(value: boolean | cdktf.IResolvable);
    resetRetainAckedMessages(): void;
    get retainAckedMessagesInput(): boolean | cdktf.IResolvable | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
    private _bigqueryConfig;
    get bigqueryConfig(): PubsubSubscriptionBigqueryConfigOutputReference;
    putBigqueryConfig(value: PubsubSubscriptionBigqueryConfig): void;
    resetBigqueryConfig(): void;
    get bigqueryConfigInput(): PubsubSubscriptionBigqueryConfig | undefined;
    private _deadLetterPolicy;
    get deadLetterPolicy(): PubsubSubscriptionDeadLetterPolicyOutputReference;
    putDeadLetterPolicy(value: PubsubSubscriptionDeadLetterPolicy): void;
    resetDeadLetterPolicy(): void;
    get deadLetterPolicyInput(): PubsubSubscriptionDeadLetterPolicy | undefined;
    private _expirationPolicy;
    get expirationPolicy(): PubsubSubscriptionExpirationPolicyOutputReference;
    putExpirationPolicy(value: PubsubSubscriptionExpirationPolicy): void;
    resetExpirationPolicy(): void;
    get expirationPolicyInput(): PubsubSubscriptionExpirationPolicy | undefined;
    private _pushConfig;
    get pushConfig(): PubsubSubscriptionPushConfigOutputReference;
    putPushConfig(value: PubsubSubscriptionPushConfig): void;
    resetPushConfig(): void;
    get pushConfigInput(): PubsubSubscriptionPushConfig | undefined;
    private _retryPolicy;
    get retryPolicy(): PubsubSubscriptionRetryPolicyOutputReference;
    putRetryPolicy(value: PubsubSubscriptionRetryPolicy): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): PubsubSubscriptionRetryPolicy | undefined;
    private _timeouts;
    get timeouts(): PubsubSubscriptionTimeoutsOutputReference;
    putTimeouts(value: PubsubSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PubsubSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
